/*
 * sys/fcntl.h
 */


#ifndef sys_fcntl_h
#define sys_fcntl_h


#ifndef ASM_FILE


	/* File access modes used for open() and fcntl(). */
#define	O_RDONLY	0x1		/* Open for reading only. */
#define	O_WRONLY	0x2		/* Open for writing only. */
#define	O_RDWR		0x3		/* Open for reading and writing. */
	/* Flags and are used in the oflag value to open(). They shall be bitwise-distinct. */
#define	O_EXCL		1<<2	/* Exclusive use flag. */
#define	O_CREAT		1<<3	/* Create file if it does not exist. */
#define	O_NOCTTY	1<<4	/* Do not assign controlling terminal. */
#define	O_TRUNC		1<<5	/* Truncate flag. */
	/* File status flags used for open() and fcntl(). */
#define	O_APPEND	1<<6 	/* Set append mode. */
#define	O_NONBLOCK	1<<7 	/* Non-blocking mode. */

#define	O_DEL		1<<8	/* exit˾õ롣 */
#define	O_FIFO		1<<9	/* FIFOեȤƳ */

#define	O_SHLOCK	1<<10	/* open with shared file lock */
#define	O_EXLOCK	1<<11	/* open with exclusive file lock */

#define	O_ACCMODE	3		/* Mask for file access modes. */

	/* File descriptor flags used for fcntl(). */
#define	FD_CLOEXEC	1		/* Close the file descriptor upon execution of an exec family function. */

	/* Values for cmd used by fcntl() (the following values are unique). */
#define	F_DUPFD		1		/* Duplicate file descriptor. */
#define	F_GETFD		2		/* Get file descriptor flags. */
#define	F_SETFD		3		/* Set file descriptor flags. */
#define	F_GETFL		4		/* Get file status flags and file access modes. */
#define	F_SETFL		5		/* Set file status flags. */
#define	F_GETLK		6		/* Get record locking information. */
#define	F_SETLK		7		/* Set record locking information. */
#define	F_SETLKW	8		/* Set record locking information; wait if blocked. */
#define	F_GETOWN	9		/* Get process or process group ID to receive SIGURG signals. */
#define	F_SETOWN	10		/* Set process or process group ID to receive SIGURG signals. */


#endif


#endif
