/*
 * stdlib.h
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef stdlib_h
#define stdlib_h


#include<sys/types.h>
#include<alloca.h>


enum{
	EXIT_SUCCESS=0,
	EXIT_FAILURE,

	RAND_MAX,
	MB_CUR_MAX,
};


/* Returned by the div() function.  */
typedef struct{
	int quot;			/* Quotient.  */
	int rem;			/* Remainder.  */
}div_t;

/* Returned by the ldiv() function.  */
typedef struct{
    long int quot;
    long int rem;
}ldiv_t;

/* Returned by the lldiv() function.  */
typedef struct{
    long long int quot;
    long long int rem;
}lldiv_t;


extern int __mb_cur_max;
#define MB_CUR_MAX  __mb_cur_max

/* Function declarations. */
extern void          abort(void);
extern int           abs(int);
extern int           atexit(void (*)(void));
extern int           atoi(const char *);
extern double        atof(const char *);
extern long          atol(const char *);
extern void          bcopy(const void *, void *, size_t);
extern void         *bsearch(const void *, const void *, size_t, size_t,int (*)(const void *, const void *));
extern void         *calloc(size_t, size_t);
extern div_t         div(int, int);
extern void          exit(int) __attribute__ ((__noreturn__));
extern void          free(void *);
extern char         *getenv(const char *);
extern long          labs(long);
extern ldiv_t        ldiv(long, long);
extern void         *malloc(size_t);
extern char         *mktemp(char *template);
extern void          qsort(void *, size_t, size_t, int (*)(const void *,const void *));
extern int           rand(void);
extern void         *realloc(void *, size_t);
extern int           setenv(const char *name, const char *value, int overwrite);
extern void          unsetenv(const char *name);
extern double        strtod(const char *, char **);
extern long          strtol(const char *, char **, int);
extern unsigned long strtoul(const char *, char **, int);
extern void          srand(unsigned);
extern u_int32_t     arc4random(void);
extern long long     strtoq (const char *, char **, int);
extern unsigned long long strtouq (const char *, char **, int);
extern char			*cgetcap (char *, char *, int);
extern int			 cgetclose (void);
extern int			 cgetent (char **, char **, char *);
extern int			 cgetfirst (char **, char **);
extern int			 cgetmatch (char *, char *);
extern int			 cgetnext (char **, char **);
extern int			 cgetnum (char *, char *, long *);
extern int			 cgetset (char *);
extern int			 cgetstr (char *, char *, char **);
extern int			 cgetustr (char *, char *, char **);
extern int			 putenv(const char *);
extern char			*getbsize(int *, long *);
extern char			*group_from_gid(unsigned long, int);
extern char			*user_from_uid(unsigned long, int);


/* ̤ */
extern int           system(const char *);
extern char         *mktemp(char *);


#endif
