/*
 * fcntl.h
 */


#ifndef fcntl_h
#define fcntl_h


#include<sys/types.h>
#include<sys/fcntl.h>


enum{
	/* Values for l_type used for record locking with fcntl() (the following values are unique). */
	F_RDLCK,		/* Shared or read lock. */
	F_UNLCK,		/* Unlock. */
	F_WRLCK,		/* Exclusive or write lock. */
	F_FREESP,		/* Free file space */
};


/* The structure flock describes a file lock. It shall include the following members. */
short  l_type;		/* Type of lock; F_RDLCK, F_WRLCK, F_UNLCK. */
short  l_whence;	/* Flag for starting offset. */
off_t  l_start;		/* Relative offset in bytes. */
off_t  l_len;		/* Size; if 0 then until EOF. */
pid_t  l_pid;		/* Process ID of the process holding the lock; returned with F_GETLK. */

/* regular version, for both small and large file compilation environment */
typedef struct flock {
	short	l_type;
	short	l_whence;
	off_t	l_start;
	off_t	l_len;		/* len == 0 means until end of file */
	int	l_sysid;
	pid_t	l_pid;
	long	l_pad[4];		/* reserve area */
} flock_t;


/* Function declarations. */
extern int  open(const char *, int, ...);
extern int  creat(const char *, mode_t);
extern int  fcntl(int, int, ...);


#endif
