/*
 * term.h
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef term_h
#define term_h


#include<sys/types.h>
#include<proc.h>
#include<share/stropts.h>
#include<sys/termios.h>
#include<sys/time.h>


#ifndef ASM_FILE


enum{
	LINE_BUF_SIZE=90,	/* Line buffer size. */
	TERM_EOF=0xff,		/* EOF character. */

	/* ޥåץɡ */
	MIN_MAPKEY	= 0x7f,		/* ղåǾ͡ */
	TRM_UP,					/*  */
	TRM_LFT,				/*  */
	TRM_RHT,				/*  */
	TRM_DWN,				/*  */
};


typedef struct{
	uchar crt;					/* ȥݥ */
	uchar last;					/* 饹ȥݥ */
	uchar lineTop;				/* 饤ȥåץݥ */
	uchar pastCrt;				/* ľΥȥݥ */
	uchar pastLast;				/* ľΥ饹ȥݥ */
	char buf[LINE_BUF_SIZE];	/* 󥽡Хåե */
}LINE_BUF;

typedef struct{
	PROC *ctlProc;				/* üץ */
	gid_t foregrnd;				/* ե饦ɥץ롼ס */
	void (*leftCursor)(int);
	void (*rightCursor)(int);
	void (*inputStr)();
	void (*newLine)();
	void (*carriageRetun)();
	void (*eraseLine)();
	void (*delete)();
	void (*backSpace)();
	void (*tab)();
}TERM_CTL;


extern int isForeground(PROC*);
extern int isCtlproc(PROC*);
extern void releaseTerm(PROC*);
extern int handlTermChr(uchar,struct termios*,TERM_CTL*,LINE_BUF*);
extern int readTermBuf(uchar*,size_t,struct termios*,LINE_BUF*);
extern int isExistTermBuf(struct termios*,LINE_BUF*);


#endif


#endif
