/*
 * reboot2.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<apm.h>
#include<proc.h>
#include<device.h>
#include<fs.h>
#include<signal.h>
#include<interrupt.h>
#include<errno.h>
#include<reboot.h>


/*************************************************************************************
 *
 * reboot
 *
 *************************************************************************************/

static void shutdownAll()
{
/*******************************************/
printk("1 ");
/*******************************************/
	/* ץtermʥ롣 */
	sendSignalAllProc(SIGTERM);

	/* 󥹥塼Ԥ */
	wait_task();
	wait_task();
	wait_task();
	wait_task();
/*******************************************/
printk("2 ");
/*******************************************/
	/* ץkill롣 */
	sendSignalAllProc(SIGKILL);

	/* 󥹥塼Ԥ */
	wait_task();
	wait_task();
/*******************************************/
printk("3 ");
/*******************************************/
	/* ե륷ƥ򥢥ޥȤ롣 */
	sys_umount_root();
/*******************************************/
printk("4 ");
/*******************************************/
	sys_sync();
/*******************************************/
printk("end");
/*******************************************/
}

/*************************************************************************************
 *
 * system calls
 *
 *************************************************************************************/

int sys_reboot(int flag)
{
	/* uidǧ롣 */
	if (get_current_task()->uid != 0)
		return -EACCES;

	switch(flag)
	{
		case REBOOT_REBOOT:
			shutdownAll();
			
			/* Ƶư */
			reboot();

			break;
		case REBOOT_POWEROFF:
			shutdownAll();
			
			/* Power off. */
			setPowerState(APM_PWRFLG_OFF);

			break;
		default:
			return -EINVAL;
	}

	return 0;
}
