/*
 * proc.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ץطإåե
 */


#ifndef proc_h
#define proc_h


#include<types.h>
#include<segment.h>
#include<time.h>
#include<except_i386.h>
#include<share/wait.h>


#ifndef ASM_FILE


enum{
	MAX_CHILD=8,		/* Max number of child processes */

	/* ץξ֡ */
	TASK_RUNNING			= 1 << 0,
	TASK_WAIT				= 1 << 1,
	TASK_DEVICE_WAIT		= 1 << 2,	/* ǥХԤ */
	TASK_SIGNAL_WAIT		= 1 << 3,	/* ʥԤ */
	TASK_SEND_SIGNAL_WAIT	= 1 << 4,	/* 줿ʥˤԤ */
	TASK_TRACE				= 1 << 5,	/* ȥ졼档 */
	TASK_EXIT				= 1 << 6,	/* Exit. */
	TASK_CHILD_WAIT			= 1 << 7,	/* wait callԤ */
	
	// 塼ե饰
	PROC_SCHEDULE_DEL = 0,	// ɬ˥塼뤫ڤΥ
	PROC_SCHEDULE_NOT_DEL,	// 塼뤫ڤΥʤ
};


typedef struct{
	
}USER_HANDL;

/* ץ¤ */
typedef struct PROC{
	struct PROC	*next;				// Schedule linkμΥץ
	struct PROC	*prev;				// Schedule linkΥץ
	struct PROC	*wait_next;			// next link for wait
	struct PROC	*wait_prev;			// prev link for wait
	struct PROC	*proc_next;			// Process list link next.
	struct PROC	*proc_prev;			// Process list link prev.
	uint		 esp;				// ֤ƥȤΥåȥåesp
	struct PROC	*parent;			// Parent process.
	struct PROC	*brother;			// Brother process
	struct PROC	*child;				// Child process
	char		 nestCount;			// ߥͥȥȡ
#define PROC_ZERO_TOP child			// 0λϤǡ
	uchar		 count_child;		// Number of child processes
	uchar		 exit_state;		// Exit state.
	uchar		 signum;			// Exit signal number.
	FPU_SAVE	 fpu;				// FPUֹ¤
	uint64		 cpu_time[2];		// CPU time,0:system 1:user.
	uint		 ctime[2];			// Children clock tick,0:system 1:user.
#define PROC_ZERO_END cpu			// 0κǸμǡ
	uchar		 cpu;				// running cpu number ƯƤʤ-1ʲ
	uchar		 state;				// ץξ֡
	pid_t		 pid;				// process ID.
	pid_t		 pgid;				// process groupe ID.
	uid_t		 uid;				// user ID.
	gid_t		 gid;				// user groupe ID.
	pid_t		 sid;				// session ID.
	uint		 espBack;			// ¸桼ϥɥ¹ԻθΥͥESP͡
	TIMER		 timer[TIMER_MAX];	// ޡ¤Ρ
	ITIMER		 itimer[ITIMER_MAX];// itimer
	void		*ctlterm;			// ߥʥ湽¤Ρ
	void		*signal_struct;		// ʥ¤Ρ
	void		*mm_struct;			// ꡼¤Υɥ쥹
	void		*file_struct;		// ե빽¤Υɥ쥹
	int			 gate;				// ԥå
}PROC;

/* ץꥹȹ¤Ρ */
typedef struct PROC_LIST{
	struct PROC_LIST *next;
	struct PROC_LIST *prev;
	int lockGate;
}PROC_LIST;

/* cpuȤΥ¤ */
typedef struct CPU{
	int cpu;				/* number of cpu */
	PROC *current_task;		/* ߤβƯprocess */
	uint proc_num;			/* ưץ */
	int gate;				/* Lock gate */
}CPU;


extern CPU cputask[];
extern PROC_LIST procHash[];


#define getProcAddr(address,member) (PROC*)((uint)address-(uint)&((PROC*)0)->member)


/*
 * Get current cpu number
 * returns : current cpu number
 */
extern inline int get_current_cpu()
{
	int result;


	asm volatile(
		"xorl	%%eax,%%eax\n"\
		"str	%%ax\n"\
		"subl	%1,%%eax\n"\
		"shrl	$3,%%eax"
		:"=a"(result):"i"(TSS_DES)
	);

	return result;
}

/*
 * Get current task
 * return : Current process
 */
extern inline PROC *get_current_task()
{
	return cputask[get_current_cpu()].current_task;
}


extern void add_to_schedule(PROC*, int, int*);
extern void del_from_schedule(const int, int);
extern PROC *searchProcList(int);
extern void waitProc1();
extern void incrementNest();
extern void decrementNest();
extern int isNest();
extern int isSingleNest();
extern int forkKernelThread();
extern int initProc1();
extern int init_cputask(int);
extern int set_idle_proc(int);
extern void set_tss(int);
extern void start_tasking();
extern PROC *getNextProc(PROC*,int);
extern void sendSignalAllProc(int);
extern void exit(int,int);
extern int sys_fork();
extern int sys_exit();
extern int sys_exec();
extern int sys_wait();
extern int sys_getpid();
extern int sys_getgid();
extern int sys_getpgid();
extern int sys_getppid();
extern int sys_getuid();
extern int sys_getsid();
extern int sys_setgid();
extern int sys_setpgid();
extern int sys_setuid();
extern int sys_setsid();

extern int sys_times();


#endif


#endif
