/*
 * netlib.h
 *
 * Copyright 2006, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef netlib_h
#define netlib_h


#include <types.h>
#include <mm.h>
#include <sys/ip.h>
#include <sys/select.h>
#include <net/net.h>
#include <net/ip.h>
#include <net/tcp.h>


#ifndef ASM_FILE


typedef struct IP_BUFFER{
	struct IP_BUFFER	*next;
	struct IP_BUFFER	*prev;
	uchar				 use;		/* ե饰 */
	uchar				 access;	/* ѥե饰 */
	ushort				 offset;	/* ߥ */
	struct timeval		 timeval;	/*  */
	SOCKET				*sock;		// å
	IP_HEADER			 ip;
}IP_BUFFER;


// TCPХȿ֤
extern inline int getIpSize(IP_HEADER *ip)
{
	return swapWord(ip->len);
}

extern ushort calcSum(uint*,int);
extern ushort calcSumM(uint*,uint*,int,int);
extern int allocIpBuf(IP_HEADER *ip,IP_BUFFER **pip_buf);
extern void freeRecvBuf(SOCKET*);
extern void releaseIpBuf(IP_BUFFER*);
extern void freeIpBuf(IP_BUFFER*);
extern void attachRecvBuf(IP_BUFFER*, IP_BUFFER**, int*);
extern void attachRecvBufTcp(IP_BUFFER*, IP_BUFFER**, int*);
extern void detachRecvBuf(IP_BUFFER*, IP_BUFFER**, int*);
extern IP_BUFFER *getRecvBuf(IP_BUFFER**, int*);
extern IP_BUFFER *refIpBuf(IP_BUFFER*);
extern int isIpBufFree();
extern void initIpBuf();
extern int allocRingBuf(const size_t, const size_t, void**);
extern void freeRingBuf(void*);
extern size_t getStartRingBuf(void*);
extern size_t getLastRingBuf(void*);
#define getCurrentRingBuf getLastRingBuf
extern void setStartRingBuf(void*, size_t);
extern int getSizeRingBuf(void*);
extern int getAvailableSizeRingBuf(void*);
extern void readRingBuf(void*, const size_t, const size_t, void*);
extern void writeRingBuf(void*, const size_t, void*);
extern int getOpt(SOCKET*,int,int,int*,int*);
extern int setOpt(SOCKET*,int,int,const int*,int);
extern int doSockOpt(SOCKET*,IP_BUFFER*,caddr_t,u_int);


#endif


#endif
