/*
 * net.h
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ͥåȥ̥إå
 */


#ifndef net_h
#define net_h


#include<types.h>
#include<proc.h>
#include<fs.h>
#include<mm.h>
#include<sys/ip.h>
#include<sys/socket.h>
#include<netinet/in.h>


#ifndef ASM_FILE


enum{
	/* ͥ֡ */
	SOCK_CNCT_ON			= 1<<0,	/* ͥѤߡ */
	SOCK_CNCT_TRANS_FIN		= 1<<1,	/* ͥλ */
	SOCK_CNCT_RECV_FINACK	= 1<<2,	/* ͥλ */
	SOCK_CNCT_RECV_FIN		= 1<<3,	/* ͥλ */
	SOCK_LISTEN				= 1<<4,	/* åԤϡ */
	SOCK_DISCON_RECV		= 1<<5,	/* ͥǡ */
	SOCK_DISCON_SEND		= 1<<6,	/* ͥǡ */
	SOCK_LINK_ON			= 1<<7,	/* åȥ󥯺Ѥߡ */
};


typedef struct mbuf{
	char  *data[3];		/* ե졼ॢɥ쥹 */
	int    size[3];		/* ǡե졼ॵ */
	ushort type;		/* ե졼ॿס */
	uchar  ipType;		/* IPץȥ륿ס */
}TRANS_BUF_INFO;

// åȥץ
typedef struct{
	int	name;
}SOCK_OPT;

// IPץ
typedef struct{
	int name;
	int value;
}IP_OPT;

// Хåե
// ХåեϥͥȺ祵Ʊ
typedef struct{
	int curLen;	// ߤ¸
	char *buf;	// 
}SEND_BUF;

/*
 * Note!
 *  fsscΰ֤ϲۥե빽¤Τΰ֤ȥ󥯤ƤΤա
 */
typedef struct SOCKET{
	F_DSC			 fd;			// եǥץ¤Ρ
	FS				*fs;			// FS¤Υɥ쥹
	struct SOCKET	*sc;			// åȥɥ쥹VENTRY¤Τinodeб롣
	uint16_t		 sockType;		// åȥס
	uint16_t		 stat;			// ͥ֡
	void			*sinf;			// SOCKET_INFO.
	in_port_t		 srcport;		// Source port number.
	in_port_t		 dstport;		// Connection port number.
	in_addr_t		 dstip;			// Connection IP address.
	in_addr_t		 srcip;			// Local host IP address.
	void			*recvBuf;		// Receive buffer address.
	PROC			*waitProc;		// Interrupt wait queue.
	uint32_t		 seqnum;		// Sequence number.
	uint32_t		 acknum;		// Ack number.
	uint32_t		 prevAck;		// send()ǥǡȤֹ򵭲Ƥ
	struct SOCKET	*next;			// ͥ󥯡
	struct SOCKET	*prev;			// 
	struct SOCKET	*waitNext;		// ͥǽԤ󥯡
	uint			 waitTime;		// ǽԤϻms
	uint16_t		 mss;			// ͥȺ祵
	uint16_t		 window;		// ͥ襦ɥ
	SEND_BUF		 sendBuf;		// Хåե¤
	void			*ringBuf;		// ǡ¸ѥ󥰥Хåե
	PROC			*listenThread;	// å󥹥å
	struct SOCKET	*newsc_next;	// å󥳥ͥѥåȥ
	int				 lockGate;		// ԥå
	SOCK_OPT		 sockOpt;		// åȥץ
	IP_OPT			 ipOpt;			// IPץ
}SOCKET;

typedef struct{
	int (*send)(SOCKET*, void*, size_t, int, struct sockaddr*);
	int (*recv)(SOCKET*, struct msghdr*);
	int (*connect)(SOCKET*);
	int (*shutdown)(SOCKET*, int);
	int (*listen)(SOCKET*, int);
	int (*accept)(SOCKET*, SOCKET**, uint32_t*);
	int (*poll)(SOCKET*);
}SOCKET_INFO;


extern inline uint16_t swapWord(ushort value)
{
	return (value>>8)+(value<<8);
}

extern inline uint32_t swapInt32(uint32_t value)
{
	return (value>>24)+((value>>8)&0xff00)+((value<<8)&0xff0000)+(value<<24);
}

extern ushort getEphemeralPort();
extern void closeSocket(SOCKET*);
extern int makeSocket(int,int,SOCKET**);
extern int sys_socket();
extern int sys_send();
extern int sys_sendmsg();
extern int sys_recv();
extern int sys_recvmsg();
extern int sys_connect();
extern int sys_shutdown();
extern int sys_bind();
extern int sys_listen();
extern int sys_accept();
extern int sys_getsockname();
extern int sys_getpeername();
extern int sys_getsockopt();
extern int sys_setsockopt();
extern int registSocket(SOCKET_INFO*,int);
extern int initNet();


#endif


#endif
