/*
 * ip.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * Internet Protocol.
 */


#include<types.h>
#include<lib.h>
#include<proc.h>
#include<lock.h>
#include<mm.h>
#include<time.h>
#include<errno.h>
#include<net/net.h>
#include<net/netlib.h>
#include<net/ether.h>
#include<net/arp.h>
#include<net/icmp.h>
#include<net/udp.h>
#include<net/tcp.h>
#include<net/ip.h>


/**************************************************************************
 *
 * IPإå
 *
 **************************************************************************/


//================================== ѥ֥å ======================================


/*
 * IPǡΥ
 */
static inline int getDataSize(IP_HEADER *ip)
{
	return swapWord(ip->len) - sizeof(IP_HEADER);
}


/*
 * IPǡΥե饰ȥեåȤ
 */
static inline uint16_t getFragOffset(IP_HEADER *ip)
{
	return swapWord(ip->fragOffset) & FRAG_OFFSET_MASK;
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


enum{
	IP_HEAD_VERSION=4<<4,

	IP_HEAD_FRAG_ON= 0x2000,	/* ե饰ȥǡե饰 */
	IP_HEAD_FRAG_NOT=0x4000,	/* ե饰Բĥե饰 */
};


typedef struct{
	int    lock;
	ushort id;
}HEAD_ID;


//================================== ץ饤١ ======================================


#define GET_ID(a)	enter_spinlock(&headId.lock);\
			 		a = swapWord(headId.id++);\
					exit_spinlock(&headId.lock)


static HEAD_ID headId;
/************************************************************************************************
static void viewHead(IP_HEADER *head)
{
	printk("TRANS IP version=%x,head length=%x,TOS=%x,total length=%x,id=%x,fragment=%x\n"
	       "TTL=%x,protocol=%x,sourceIP=%x,destIP=%x\n",
	       head->verhead>>4,head->verhead&0xf,head->tos,swapWord(head->len),head->id,head->frag,
	       head->ttl,head->prot,head->srcip,head->dstip);
}
*************************************************************************************************/


//================================== Х ======================================


/*
 *ահ"sock""NULL"
 * Transfer IP datagram.
 * return : 0 or error number
 */
int transIp(SOCKET *sock, TRANS_BUF_INFO *tbi, uint dstip, uint16_t frag)
{
	char dstmac[6];
	uchar tos;
	uint transip;
	int num;
	int rest;
	IP_HEADER head;
	int max,total,trans;

	/* Get device number. */
	num = searchDevnum(dstip, &transip);

	/*  MACμ */
	if ((rest = getMac(num, transip, dstmac)) < 0){
		return rest;
	}

	// IPץ
	tos = 0;
	if (sock != NULL){
		if (sock->ipOpt.name == IP_TOS){
			tos = sock->ipOpt.value;
		}
	}

	/* Set IP head. */
	head.verhead = IP_HEAD_VERSION | (sizeof(IP_HEADER) / 4);
	head.tos = tos;
	GET_ID(head.id);
	head.ttl = 255;
	head.prot = tbi->ipType;
	head.srcip = ethDev[num].ip;
	head.dstip = dstip;
	head.chksum = 0;

	tbi->type = DIX_TYPE_IP;
	tbi->data[0] = (char*)&head;
	tbi->size[0] = sizeof(IP_HEADER);			/* IP header size. */
	max = ethDev[num].mtu - sizeof(IP_HEADER);	/* ǡ */
	total = tbi->size[1] + tbi->size[2];		/* ǡȡ륵 */

	if (total <= max){
		head.len = swapWord(tbi->size[0] + total);
		head.fragOffset = swapWord(frag);
		head.chksum = calcSum((uint*)&head, tbi->size[0]);
/**********************************************
viewHead(&head);
**********************************************/
		startEmu(ethDev[num].ifnet, tbi, dstmac);
	}
	else{
		head.len = swapWord(tbi->size[0] + max);
		head.fragOffset = swapWord(IP_HEAD_FRAG_ON);
		tbi->size[2] = max-tbi->size[1];
		head.chksum = calcSum((uint*)&head, tbi->size[0]);
/**********************************************
viewHead(&head);
**********************************************/
		startEmu(ethDev[num].ifnet, tbi, dstmac);

		trans = max;						/* ѥ */
		tbi->data[2] += max-tbi->size[1];
		tbi->size[1] = 0;

		for(;;){
			head.chksum = 0;

			if(total - trans <= max){
				head.len = swapWord(tbi->size[0] + total - trans);
				head.fragOffset = swapWord(trans);
				GET_ID(head.id);
				head.chksum = calcSum((uint*)&head, tbi->size[0]);
				tbi->size[2] = total - trans;
/**********************************************
viewHead(&head);
**********************************************/
				startEmu(ethDev[num].ifnet, tbi, dstmac);
				break;
			}
			else{
				head.len = swapWord(tbi->size[0] + max);
				head.fragOffset = swapWord(trans | IP_HEAD_FRAG_ON);
				GET_ID(head.id);
				head.chksum = calcSum((uint*)&head, tbi->size[0]);
				tbi->size[2] = max;
/**********************************************
viewHead(&head);
**********************************************/
				startEmu(ethDev[num].ifnet, tbi, dstmac);
			}

			trans += max;
			tbi->data[2] += max;
		}
	}

	return 0;
}


/**************************************************************************
 *
 * ե饰ơǡη
 *
 **************************************************************************/


/* ե饰ȴإå */
enum{
	DATA_LEN_MAX		= 0x10000,	// IPǡ祵
	FRAG_HEAD_USE		= 1,		// ե饰ȥإå
	FRAG_HEAD_NOT_USE	= 0,		// ե饰ȥإå̤
	REASSENBLED			= 1,		// ƹ۴λ
	FRAG_LIVE_TIME		= 5,		// ե饰ȥǡ¸֡á
	FRAG_HEAD_NUM		= 1,		// ե饰ȥإå
};

typedef struct FRAG_HEAD{
	int 	 use;		// ѺѤߥե饰
	int		 curLen;	// ߤǡĹ
	uint 	 creatTime; // 
	char	*data;		// ǡǼХåե
}FRAG_HEAD;


//================================== ץ饤١ ======================================


static char fragData[DATA_LEN_MAX];

static FRAG_HEAD fragHead[FRAG_HEAD_NUM] = {
	{FRAG_HEAD_NOT_USE,
	0,
	0,
	fragData}
};


/*
 * IPɥ쥹
 */
static inline uint32_t getDstIp(FRAG_HEAD *fragHead)
{
	return ((IP_HEADER*)fragHead->data)->dstip;
}


/*
 * IPֹ
 */
static inline uint16_t getId(FRAG_HEAD *fragHead)
{
	return ((IP_HEADER*)fragHead->data)->id;
}


/*
 * ե饰ȥإåγ
 */
static void releaseFragHead(FRAG_HEAD *fragHead)
{
	fragHead->use = FRAG_HEAD_NOT_USE;
	fragHead->curLen = 0;
	fragHead->creatTime = 0;
}


/*
 * αΥե饰ȥǡθ
 * ե饰ȥإåɥ쥹 or NULL
 */
static FRAG_HEAD *searchFragHead(IP_HEADER *ip)
{
	int i;

	for (i = 0; i < FRAG_HEAD_NUM; ++i){
		/* IPȼֹ椬 */
		if ((ip->dstip == getDstIp(&fragHead[i])) && (ip->id == getId(&fragHead[i]))){
			return &fragHead[i];
		}
	}

	return NULL;
}


/*
 * ե饰ȥإåν
 * return : NOERR or ERR
 */
static int initFragHead(IP_HEADER *ip)
{
	uint curTime = sys_time(NULL);
	int freeNum;
	IP_HEADER *fragIp;
	
	// ̤ѤΥإåõ
	for (freeNum = 0; freeNum < FRAG_HEAD_NUM; ++freeNum){
		if (FRAG_HEAD_NUM <= freeNum){
			return ERR;
		}
		if (fragHead[freeNum].use == FRAG_HEAD_NOT_USE){
			break;
		}
		else if (FRAG_LIVE_TIME < (curTime - fragHead[freeNum].creatTime)){
			/* ¸֤᤮إå */
			break;
		}
	}

	/* IPإå򥳥ԡ */
	fragIp = (IP_HEADER*)&fragHead[freeNum].data;
	memcpy(fragIp, ip, sizeof(IP_HEADER));
	if (swapWord(ip->fragOffset) & FRAG_MORE){
		fragIp->len = 0;
	}
	else{
		fragIp->len = swapWord(getFragOffset(ip) + getDataSize(ip) + sizeof(IP_HEADER));
	}
	
	// IPǡ򥳥ԡ
	memcpy(fragIp->data + getFragOffset(ip), ip->data, getDataSize(ip));

	fragHead->curLen = getDataSize(ip);		// ߤǡĹ
	fragHead->creatTime = curTime;			// 
	fragHead[freeNum].use = FRAG_HEAD_USE;
	
	return NOERR;
}


/*
 * ե饰Ȥκƹ
 * return : NOERR or REASSENBLED or error number
 */
static int reassemble(IP_HEADER *ip, FRAG_HEAD *fragHead)
{
	IP_HEADER *fragIp = (IP_HEADER*)fragHead->data;

	/* IPǡ򥳥ԡ */
	memcpy(fragIp->data + getFragOffset(ip), ip->data, getDataSize(ip));
	fragHead->curLen += getDataSize(ip);

	/* IPȡĹ */
	if ((swapWord(ip->fragOffset) & FRAG_MORE) == 0){
		fragIp->len = swapWord(getFragOffset(ip) + getDataSize(ip) + sizeof(IP_HEADER));
	}

	/* ٤Ʒ礷 */
	if (getDataSize(fragIp) == fragHead->curLen){
		return REASSENBLED;
	}
	
	return NOERR;
}


//================================== ѥ֥å ======================================


/*
 * ե饰ȥǡå
 * return : NOERR or ERR
 */
static int checkFragSize(IP_HEADER *ip)
{
	/* 祵Υå */
	if (DATA_LEN_MAX < getFragOffset(ip) + getDataSize(ip) + sizeof(IP_HEADER)){
		return  ERR;
	}
	return NOERR;
}


/*
 * ե饰ȥǡκƹ
 * return : NOERR or REASSENBLED or error number
 */
static int reassembleFragment(IP_HEADER *ip,void **o_fragHead)
{
	FRAG_HEAD *fragHead;
	
	/* αΥե饰ȥǡθ */
	fragHead = searchFragHead(ip);
	if (fragHead == NULL){
		/* ե饰ȥإåο */
		return initFragHead(ip);
	}
	else{
		/* ե饰ȥǡη */
		if (reassemble(ip, fragHead) == REASSENBLED){
			*o_fragHead = fragHead;
			return REASSENBLED;
		}
	}
	
	return NOERR;
}


/*
 * ե饰ȥǡγ
 */
static void freeFragment(FRAG_HEAD *fragHead)
{
	releaseFragHead(fragHead);
}


/*
 * IPǡ
 */
static IP_HEADER *getIpFromFragment(FRAG_HEAD *fragHead)
{
	return (IP_HEADER*)fragHead->data;
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


//=================================== Х =======================================


/*
 * Receive IP datagram.
 * parameters : IP header
 * return : 0 or task switch=1
 */
int receiveIp(IP_HEADER *ip)
{
	int (*receive)(IP_HEADER*);

/*****************************************************************************************
TCP_HEADER *tcp = (TCP_HEADER*)ip->data;

printk("IP version=%x,ip length=%x,TOS=%x,total length=%x,id=%x,fragment=%x "
       "TTL=%x,protocol=%x,sourceIP=%x,destIP=%x\n",
       ip->verhead >> 4,ip->verhead & 0xf,ip->tos,swapWord(ip->len),ip->id,
       swapWord(ip->fragOffset),ip->ttl,ip->prot,ip->srcip,ip->dstip);
*******************************************************************************************/
	// åγǧ
	if (calcSum((uint*)ip,(ip->verhead&0xf) * 4)){
		return 0;
	}

	// ̥ץȥؿ򥻥å
	switch(ip->prot){
		case IPPROTO_TCP:
			receive = receiveTcp;
			break;
		case IPPROTO_UDP:
			receive = receiveUdp;
			break;
		case IPPROTO_ICMP:
			receive = receiveIcmp;
			break;
		default:
			return 0;
	}

	// ե饰IPǡν
	if ((swapWord(ip->fragOffset) & FRAG_MORE) || (0 < getFragOffset(ip))){
		void *fragment;
		int rest;

		// Υå
		if (checkFragSize(ip) == ERR){
			return 0;
		}
		
		// ե饰Ȥη
		if (reassembleFragment(ip,&fragment) != REASSENBLED){
			return 0;
		}

		rest = receive(getIpFromFragment(fragment));
		freeFragment(fragment);
		return rest;
	}

	return receive(ip);
}


/**************************************************************************
 *
 * IPå
 *
 **************************************************************************/


//================================== ץ饤١ ========================================


static PROC *ipTask;
static IP_BUFFER *recvBuf;
static int recvLock;


/*
 * IPå
 */
static inline void IpTask()
{
	IP_BUFFER *ipBuf;

	ipBuf = getRecvBuf(&recvBuf, &recvLock);
	if (ipBuf == NULL){
		sys_sleep(-1);
	}
	else{
		switch (ipBuf->ip.prot){
			case IPPROTO_TCP:
				doTcpService(ipBuf->sock, &ipBuf->ip);
				break;
			case IPPROTO_UDP:
				doUdpService(ipBuf->sock, &ipBuf->ip);
				break;
			case IPPROTO_ICMP:
				// ̤б
				break;
			default:
				break;
		}
		freeIpBuf(ipBuf);
	}
}


//================================== ѥ֥å ========================================


/*
 * IPåɤεư
 */
static void startIpTask()
{
	switch(sys_fork())
    {
		case -1:
			printk("Faild startIpTask()\n");
			break;
		case 0:
			ipTask = get_current_task();
			del_from_schedule(TASK_WAIT, PROC_SCHEDULE_DEL);
			for (;;){
				IpTask();
			}
			break;
	}
}


//================================== Х ========================================


/*
 * ! ա߻Τߤ˻Ѥ뤳
 * IPåɤε
 */
void setIpTask(SOCKET *sock, IP_HEADER *ip)
{
	IP_BUFFER *ipBuf;

	if (allocIpBuf(ip, &ipBuf) == ERR){
		return;
	}
	ipBuf->sock = sock;
	attachRecvBuf(ipBuf, &recvBuf, &recvLock);
	sys_wake(ipTask);
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


//================================== Х ========================================


int initIp()
{
	startIpTask();
	
	return 0;
}
