/*
 * Copyright (c) 1982, 1986, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	From: @(#)if.h	8.1 (Berkeley) 6/10/93
 * $FreeBSD: src/sys/net/if_var.h,v 1.18.2.16 2003/04/15 18:11:19 fjoe Exp $
 */

#ifndef	_NET_IF_VAR_H_
#define	_NET_IF_VAR_H_

/*
 * Structures defining a network interface, providing a packet
 * transport mechanism (ala level 0 of the PUP protocols).
 *
 * Each interface accepts output datagrams of a specified maximum
 * length, and provides higher level routines with input datagrams
 * received from its medium.
 *
 * Output occurs when the routine if_output is called, with three parameters:
 *	(*ifp->if_output)(ifp, m, dst, rt)
 * Here m is the mbuf chain to be sent and dst is the destination address.
 * The output routine encapsulates the supplied datagram if necessary,
 * and then transmits it on its medium.
 *
 * On input, each interface unwraps the data received by it, and either
 * places it on the input queue of a internetwork datagram routine
 * and posts the associated software interrupt, or passes the datagram to a raw
 * packet input routine.
 *
 * Routines exist for locating interfaces by their addresses
 * or for locating a interface on a certain network, as well as more general
 * routing and gateway routines maintaining information used to locate
 * interfaces.  These routines live in the files if.c and route.c
 */


#include <sys/queue.h>		/* get TAILQ macros */
//#include <sys/systm.h>		/* XXX */
#include <net/net.h>
#include <net/if.h>
#include <net/route.h>


struct ifnet;


/*
 * Structure defining a queue for a network interface.
 */
//struct ifqueue {
//	struct	mbuf *ifq_head;
//	struct	mbuf *ifq_tail;
//	int	ifq_len;
//	int	ifq_maxlen;
//	int	ifq_drops;
//};
// VXeɍ킹邽ߐݒ肵 060801
struct ifqueue {
	struct mbuf	*ifq_head;
	char		*dstmac;
};

/*
 * The ifaddr structure contains information about one address
 * of an interface.  They are maintained by the different address families,
 * are allocated and attached when an address is set, and are linked
 * together so all addresses for an interface can be located.
 */
struct ifaddr {
	struct sockaddr		*ifa_addr;		/* address of interface */
	struct sockaddr		*ifa_dstaddr;	/* other end of p-to-p link */
#define	ifa_broadaddr	ifa_dstaddr		/* broadcast address interface */
	struct sockaddr		*ifa_netmask;	/* used to determine subnet */
	struct if_data		if_data;		/* not all members are meaningful */
	struct ifnet		*ifa_ifp;		/* back-pointer to interface */
	TAILQ_ENTRY(ifaddr)	ifa_link;		/* queue macro glue */
	void	(*ifa_rtrequest)			/* check or clean routes (+ or -)'d */
		(int, struct rtentry *, struct rt_addrinfo *);
	u_short				ifa_flags;		/* mostly rt_flags for cloning */
	u_int				ifa_refcnt;		/* references to this structure */
	int					ifa_metric;		/* cost of going out this interface */
#ifdef notdef
	struct rtentry		*ifa_rt;		/* XXXX for ROUTETOIF ????? */
#endif
	int (*ifa_claim_addr)				/* check if an addr goes to this if */
		(struct ifaddr *, struct sockaddr *);

};

/*
 * The prefix structure contains information about one prefix
 * of an interface.  They are maintained by the different address families,
 * are allocated and attached when an prefix or an address is set,
 * and are linked together so all prefixes for an interface can be located.
 */
struct ifprefix {
	struct sockaddr			*ifpr_prefix;	/* prefix of interface */
	struct ifnet			*ifpr_ifp;		/* back-pointer to interface */
	TAILQ_ENTRY(ifprefix)	ifpr_list;		/* queue macro glue */
	u_char					ifpr_plen;		/* prefix length in bits */
	u_char					ifpr_type;		/* protocol dependent prefix type */
};

/*
 * Multicast address structure.  This is analogous to the ifaddr
 * structure except that it keeps track of multicast addresses.
 * Also, the reference count here is a count of requests for this
 * address, not a count of pointers to this structure.
 */
struct ifmultiaddr {
	LIST_ENTRY(ifmultiaddr) ifma_link; /* queue macro glue */
	struct	sockaddr *ifma_addr; 	/* address this membership is for */
	struct	sockaddr *ifma_lladdr;	/* link-layer translation, if any */
	struct	ifnet *ifma_ifp;	/* back-pointer to interface */
	u_int	ifma_refcount;		/* reference count */
	void	*ifma_protospec;	/* protocol-specific state, if any */
};

TAILQ_HEAD(ifnethead, ifnet);	/* we use TAILQs so that the order of */
TAILQ_HEAD(ifaddrhead, ifaddr);	/* instantiation is preserved in the list */
TAILQ_HEAD(ifprefixhead, ifprefix);
LIST_HEAD(ifmultihead, ifmultiaddr);

/*
 * Structure defining a network interface.
 *
 * (Would like to call this struct ``if'', but C isn't PL/1.)
 */

/*
 * NB: For FreeBSD, it is assumed that each NIC driver's softc starts with  
 * one of these structures, typically held within an arpcom structure.   
 * 
 *	struct <foo>_softc {
 *		struct arpcom {
 *			struct  ifnet ac_if;
 *			...
 *		} <arpcom> ;
 *		...   
 *	};
 *
 * The assumption is used in a number of places, including many
 * files in sys/net, device drivers, and sys/dev/mii.c:miibus_attach().
 * 
 * Unfortunately devices' softc are opaque, so we depend on this layout
 * to locate the struct ifnet from the softc in the generic code.
 *
 * Note that not all fields are used by drivers in the FreeBSD source
 * tree. However, who knows what third party software does with fields
 * marked as "unused", such as if_ipending, if_done, and if_poll*,
 * so any attemt to redefine their meaning might end up in binary
 * compatibility problems, even if the size of struct ifnet, and
 * the size and position of its fields do not change.
 * We just have to live with that.
 */
struct ifnet {
	void				*if_softc;			/* pointer to driver state */
	char				*if_name;			/* name, e.g. ``en'' or ``lo'' */
	TAILQ_ENTRY(ifnet)	if_link;			/* all struct ifnets are chained */
	struct ifaddrhead	if_addrhead;		/* linked list of addresses per if */
	int					if_pcount;			/* number of promiscuous listeners */
	struct bpf_if		*if_bpf;			/* packet filter structure */
	u_short				if_index;			/* numeric abbreviation for this if  */
	short				if_unit;			/* sub-unit for lower level driver */
	short				if_timer;			/* time 'til if_watchdog called */
	short				if_flags;			/* up/down, broadcast, etc. */
	int					if_ipending;		/* interrupts pending */
	void				*if_linkmib;		/* link-type-specific MIB data */
	size_t				if_linkmiblen;		/* length of above data */
	struct if_data		if_data;
	struct ifmultihead	if_multiaddrs;		/* multicast addresses configured */
	int					if_amcount;			/* number of all-multicast requests */
	/* procedure handles */
	int					(*if_output)(struct ifnet *, struct mbuf *, struct sockaddr *, struct rtentry *);	/* output routine (enqueue) */
	void				(*if_start)(struct ifnet *);	/* initiate output routine */
	union {
		int				(*if_done)(struct ifnet *);		/* output complete routine (XXX not used) */
		int				uif_capabilities;				/* interface capabilities */
	} _u1;
	int					(*if_ioctl)(struct ifnet *, u_long, caddr_t);	/* ioctl routine */
	void				(*if_watchdog)(struct ifnet *);	/* timer routine */
	union {
		int				(*if_poll_recv)(struct ifnet *, int *);	/* polled receive routine */
		int				uif_capenable;					/* enabled features */
	} _u2;
	int					(*if_poll_xmit)(struct ifnet *, int *);	/* polled transmit routine */
	void				(*if_poll_intren)(struct ifnet *);		/* polled interrupt reenable routine */
	void				(*if_poll_slowinput)(struct ifnet *, struct mbuf *);	/* input routine for slow devices */
	void				(*if_init)(void *);				/* Init routine */
	int					(*if_resolvemulti)(struct ifnet *, struct sockaddr **, struct sockaddr *);	/* validate/resolve multicast */
	struct ifqueue 		if_snd;					/* output queue */
	struct ifqueue 		*if_poll_slowq;			/* input queue for slow devices */
	struct ifprefixhead if_prefixhead;		/* list of prefixes per if */
};
typedef void if_init_f_t (void *);


/*
 * Bit values in if_ipending
 */
#define	IFI_RECV	1	/* I want to receive */
#define	IFI_XMIT	2	/* I want to transmit */


#define	IF_DEQUEUE(ifq, m) { \
	(m) = (ifq)->ifq_head; \
	if (m) { \
		if (((ifq)->ifq_head = (m)->m_nextpkt) == 0) \
			(ifq)->ifq_tail = 0; \
		(m)->m_nextpkt = 0; \
		(ifq)->ifq_len--; \
	} \
}

#define	IF_PREPEND(ifq, m) { \
	(m)->m_nextpkt = (ifq)->ifq_head; \
	if ((ifq)->ifq_tail == 0) \
		(ifq)->ifq_tail = (m); \
	(ifq)->ifq_head = (m); \
	(ifq)->ifq_len++; \
}


// ifnet\̊֌WG~[g[`B
extern inline void startEmu(struct ifnet *ifnet, TRANS_BUF_INFO *tbi, char *dstMac)
{
	ifnet->if_snd.ifq_head = tbi;
	ifnet->if_snd.dstmac = dstMac;
	ifnet->if_start(ifnet);
}


#endif /* !_NET_IF_VAR_H_ */
