/*
 * lock.c
 *
 * Copyright 2006, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include <lock.h>


/*
 * ߶ػ߽
 */
// eflags¸Ƴ߶ػߤˤ롣
void enterCli(int *eflag)
{
	asm volatile(
		"pushfl\n"
		"popl	%%eax\n"
		"movl	%%eax,(%%edx)\n"
		"cli"
		::"d"(eflag)
	);
}

// ¸Ƥeflags᤹
void exitCli(int *eflag)
{
	asm volatile(
		"movl	(%%edx),%%eax\n"
		"pushl	%%eax\n"
		"popfl"
		::"d"(eflag)
	);
}


/*
 * δ֤Ƚå뤷Ϲå롣
 */
// Υå
void lockModify(MODIFY_LOCK *modifyLock)
{
	enter_spinlock(&modifyLock->gate);
	{
		// 
		for (;;){
			if (modifyLock->count == 0){
				modifyLock->count = UINT_MAX;
				break;
			}
		}
	}
	exit_spinlock(&modifyLock->gate);
}

// Υå
void unlockModify(MODIFY_LOCK *modifyLock)
{
	modifyLock->count = 0;
}

// ȽΥȥå
void countUpModify(MODIFY_LOCK *modifyLock)
{
	enter_spinlock(&modifyLock->gate);
	{
		// ȥȥå
		for (;;){
			if (modifyLock->count != UINT_MAX){
				++modifyLock->count;
				break;
			}
		}
	}
	exit_spinlock(&modifyLock->gate);
}

// ȽΥȥ
void countDownModify(MODIFY_LOCK *modifyLock)
{
	--modifyLock->count;
}
