/**
 * @file AgilentSample.h
 * @brief interfaces of AgilentSample class
 *
 * @author S.Tanaka
 * @date 2009.05.27
 * 
 * Copyright(C) 2006-2014 Eisai Co., Ltd. All rights reserved.
 */


#ifndef __KOME_IO_AGILENT_SAMPLE_H__
#define __KOME_IO_AGILENT_SAMPLE_H__


namespace kome {
	namespace io {
		namespace agilent {

			// QƉ]Xx邽
			namespace AGMODE {
				typedef enum samplemode{
					MIX = 4,
					MRM = 8,
					SEGMENT = 16,
					DEF = 1,
					UNKNOWN = -1,
					ERRORTYPE = -2,
				};
			}

			ref class AgilentSampleSet;
			ref class AgilentSpectrum;
			ref class AgilentChromatogram;
			/**
			 * @class AgilentSample
			 * @brief sample of Agilent data
			 */
			public ref class AgilentSample : public kome::clr::ClrSampleBase {

			public:
				/**
				 * @brief constructor
				 * @param sampleSet sample set object
				 * @param reader data reader object
				 */
				AgilentSample(
					AgilentSampleSet^ sampleSet,
					System::String^ fpath,
					const int mode,
					const double moi
					);

				/**
				 * @brief destructor
				 */
				virtual ~AgilentSample();

			protected:
				// Class Datas-------------------------------------------------

				// sample set
				AgilentSampleSet^ m_sampleSet;

				// reader object
				Agilent::MassSpectrometry::DataAnalysis::IMsdrDataReader^ m_reader_;

				System::String^ fpath_;

				// Open폈Ȃ True
				// CloseŉĂ False
				bool isopend_;

				bool mistake_;

				int mymode_;

				// Segmented[hgp(i荞MZ)
				double mymoi_;

			public:
				// Getter 
				AgilentSampleSet^ getAgilentSampleSet(){return m_sampleSet;}
				// Setter
				void setMode(const int spmode) {mymode_ = spmode;}
				void setMoI(const double moi) {mymoi_ = moi;}

			protected:
				// ʏALC-̕f[^Ǎޕ@
				bool setSpecDatas(kome::clr::DataGroupNodeWrapper^ rootGroup);

				// SegmentTICړIŎgp@
				//bool setMixedSpectrums(kome::clr::DataGroupNodeWrapper^ rootGroup);

				// SegmentWJ
				bool setSegmentedSpectrums(kome::clr::DataGroupNodeWrapper^ rootGroup);

				// MRMݒ肷@
				bool setMRMChroms(kome::clr::DataGroupNodeWrapper^ rootGroup);

				// RowID擾@
				AgilentSpectrum^ createSpectrumWithRowId(
					Agilent::MassSpectrometry::DataAnalysis::IMSScanRecord^ pCR,
					const int idx);

				// TICRTSpectrum擾@
				AgilentSpectrum^ createSpectrumWithRT(
					const int idx,
					const double tic,
					const double rt);
				
				//XyNg̍쐬
				AgilentSpectrum^ onCreateSpectrum(
					Agilent::MassSpectrometry::DataAnalysis::IBDASpecData^ scan, 
					const int idx);
				
				//MRMIuWFNg̍쐬
				AgilentChromatogram^ onCreateMRMObjectRng(
					const int idx, 
					Agilent::MassSpectrometry::DataAnalysis::IRange^ rng);

				AgilentChromatogram^ onCreateMRMObject(
					const int idx,
					double q1,
					double q3
				);

			private:
				// Set myproperties
				void onSetRootProps(
					kome::clr::DataGroupNodeWrapper^ rootGroup,
						int segmentIdx
					);
				void setFileInfo( kome::clr::PropertiesWrapper^ props );
				void setDeviceInfo( kome::clr::PropertiesWrapper^ props );

				void setGroupInfo(
					kome::clr::PropertiesWrapper^ prop,
					int segmentIdx
					);

				// Spectrum̃vpeBZbg
				void setSpectrumProp(
					kome::clr::PropertiesWrapper^ specProps,
					Agilent::MassSpectrometry::DataAnalysis::IBDASpecData^ scan);

				// t@CǍ̃|C^sh~
				bool resetMyReader();

				// APĨeXgp
				void checkDoingAPIs();

				// eXgpR[hiLq̂)
				void TestCodes();

			public:
				/**
				 * @param rootGroup root spectrum group
				 * @return If true, it succeeded to open this sample.
				 */
				virtual bool onOpenSample(
					kome::clr::DataGroupNodeWrapper^ rootGroup) override;

				/**
				 * @brief This method is called by closeSample method. (override method)
				 * @return If true, it succeeded to close this sample.
				 */
				virtual bool onCloseSample() override;
			};
		}
	}
}

#endif		// __KOME_IO_AGILENT_SAMPLE_H__
