/**
 * @file StatusBar.h
 * @brief Status Bar
 * @author OKADA, H.
 * @date 2011/01/07
 * Copyright (C) 2014 Shimadzu Corporation All rights reserved.
 */

#ifndef _STATUSBAR_H_
#define _STATUSBAR_H_

#include <wx/statusbr.h> 
#include "MainFrame.h"
#include "wx/frame.h"

namespace kome {
	namespace window {
		
		/** 
		 * @class StatusBar
		 * @ brief Status Bar class
		 */
		class WINDOW_MANAGER_CLASS StatusBar : public wxFrameBase {
			
		protected:
			/**
			 * @fn StatusBar()
			 * @brief constructor
			 */
			StatusBar();
			
			/**
			 * @fn ~StatusBar()
			 * @brief constructor
			 */
			virtual ~StatusBar();
			
		public:
			/**
			 * @ typedef enum StatusBarTarget
			 * @brief status bar target type 
			 */
			typedef enum{
				STATUS_BAR_TARGET_NONE, 		// none
				STATUS_BAR_TARGET_SPECTRUM, 	// spectrum
				STATUS_BAR_TARGET_CHROMATOGRAM, // chromatogram
				STATUS_BAR_TARGET_DATAMAP 		// datamap
			}StatusBarTarget;

		public:
			/**
			 * @fn static StatusBar& getInstance( void )
			 * @brief get StatusBar object
			 * @return refer to the only StatusBar object
			 */
			static StatusBar& getInstance( void );

		protected:
			/**
			 * @fn void getStatusBarInfo( void )
			 * @brief get getStatusBarInfo / xmlt@Cǂݍ܂ꂽXe[^Xo[SĎ擾
			 */
			void getStatusBarInfo( void );
			
		public:
			/**
			 * @fn int setRangeStatusMsg( const char* szPos, const char* szMessage )
			 * @brief get setRangeStatusMsg / Xe[^Xo[ɕ\ݒ
			 * @param[in] szPos Xe[^Xo[̖O
			 * @param[in] szMessage Xe[^Xo[ɕ\w
			 * @return plug-in szPosɖOvXe[^Xo[܂ł
			 */
			int setRangeStatusMsg( const char* szPos, const char* szMessage );

		protected:
			/**
			 * @fn void getMainWindow( void );
			 * @brief CEChEւ̃|C^擾
			 */
			void getMainWindow( void );

		protected:
			/**
			 * @fn int isDispNow( kome::plugin::StatusBarInfo& statusBarInfo )
			 * @brief Ŏw肵Xe[^Xo[\邩ۂʂ
			 * @param[in] statusBarInfo fXe[^Xo[w
			 * @return 0=\ׂłȂ 1=\ׂ
			 */
			int isDispNow( kome::plugin::StatusBarInfo& statusBarInfo );

		protected:
			/**
			 * @fn kome::plugin::StatusBarInfo::StatusBarTargetValue getActiveWindowKind( void )
			 * @brief ݃ANeBuȃEChE̎ނ擾
			 * @return kome::plugin::StatusBarInfo::StatusBarTargetValue 
							VAL_SB_TGT_OTHER		ANeBuȃEChE擾łȂ
							VAL_SB_TGT_NONE			ANeBuȃEChÉAspectrum, chromatogram, datamap̂ǂłȂ
							VAL_SB_TGT_SPECTRUM		ANeBuȃEChÉAspectrum
							VAL_SB_TGT_CHROMATOGRAM	ANeBuȃEChÉAchromatogram
							VAL_SB_TGT_DATAMAP		ANeBuȃEChÉAdatamap

			 */
			kome::plugin::StatusBarInfo::StatusBarTargetValue getActiveWindowKind( void );

		public:
			/**
			 * @fn void dispAuto( void )
			 * @brief SẴXe[^Xo[`FbNāA\ׂ̂\
			 */
			void dispAuto( void );

		protected:
			/**
			 * @fn int getPositionByName( const char* szName )
			 * @brief Ŏw肳ꂽÕXe[^Xo[̈ʒui琔ĉԖڂjԂB
			 * @param[in] szName Xe[^Xo[
			 * @return int Xe[^Xo[̈ʒuB珇ɁA0,1,2cƐB
			 */
			int getPositionByName( const char* szName );

		public:
			/**
			 * @fn int setFlgDisp(  const char* szPos, int flgDisp )
			 * @brief w肵Xe[^Xo[̕\/\߂
			 * @param[in] szPos Xe[^Xo[
			 * @param[in] flgDisp 0:̃Xe[^Xo[\ 0ȊO:\
			 * @return 0: -1:szPosɈvXe[^Xo[͂Ȃ
			 */
			int setFlgDisp(  const char* szPos, int flgDisp );

			/**
			 * @fn int setStatusMsg( const char* szPos, const char* szMessage )
			 * @brief get setStatusMsg / Xe[^Xo[ɕ\ݒ
			 * @param[in] szPos Xe[^Xo[̖O
			 * @param[in] szMessage Xe[^Xo[ɕ\w
			 * @return plug-in szPosɖOvXe[^Xo[܂ł
			 */
			int setStatusMsg( const char* szPos, const char* szMessage );
 		private:
			
			/** status bar */
			wxStatusBar *m_pStatbar;

			/** status bar info */
			std::vector< kome::plugin::StatusBarInfo > m_totalStatusBarInfo;

			/** MainFrame */
			kome::window::MainFrame* m_pFrame;

		};
	}
}


#endif
