/**
 * @file NormalDistribution.cpp
 * @brief implements of NormalDistribution class
 *
 * @author S.Tanaka
 * @date 2012.06.29
 * 
 * Copyright(C) 2006-2014 Eisai Co., Ltd. All rights reserved.
 */


#include "stdafx.h"
#include "NormalDistribution.h"

#include "Statistics.h"
#include "Math.h"


using namespace kome::numeric;


#include <crtdbg.h>
#ifdef _DEBUG
    #define new new( _NORMAL_BLOCK, __FILE__, __LINE__ )
    #define malloc( s ) _malloc_dbg( s, _NORMAL_BLOCK, __FILE__, __LINE__ )
#endif    // _DEBUG



#define ELEMENT_WIDTH            0.01



// constructor
NormalDistribution::NormalDistribution() {
	m_tableSize = 612;
	m_table = new double[ m_tableSize ];

	m_table[0] = 0.5;
	m_table[1] = 0.503989356;
	m_table[2] = 0.507978314;
	m_table[3] = 0.511966473;
	m_table[4] = 0.515953437;
	m_table[5] = 0.519938806;
	m_table[6] = 0.523922183;
	m_table[7] = 0.52790317;
	m_table[8] = 0.531881372;
	m_table[9] = 0.535856393;
	m_table[10] = 0.539827837;
	m_table[11] = 0.543795313;
	m_table[12] = 0.547758426;
	m_table[13] = 0.551716787;
	m_table[14] = 0.555670005;
	m_table[15] = 0.559617692;
	m_table[16] = 0.563559463;
	m_table[17] = 0.567494932;
	m_table[18] = 0.571423716;
	m_table[19] = 0.575345435;
	m_table[20] = 0.579259709;
	m_table[21] = 0.583166163;
	m_table[22] = 0.587064423;
	m_table[23] = 0.590954115;
	m_table[24] = 0.594834872;
	m_table[25] = 0.598706326;
	m_table[26] = 0.602568113;
	m_table[27] = 0.606419873;
	m_table[28] = 0.610261248;
	m_table[29] = 0.614091881;
	m_table[30] = 0.617911422;
	m_table[31] = 0.621719522;
	m_table[32] = 0.625515835;
	m_table[33] = 0.629300019;
	m_table[34] = 0.633071736;
	m_table[35] = 0.636830651;
	m_table[36] = 0.640576433;
	m_table[37] = 0.644308755;
	m_table[38] = 0.648027292;
	m_table[39] = 0.651731727;
	m_table[40] = 0.655421742;
	m_table[41] = 0.659097026;
	m_table[42] = 0.662757273;
	m_table[43] = 0.666402179;
	m_table[44] = 0.670031446;
	m_table[45] = 0.67364478;
	m_table[46] = 0.67724189;
	m_table[47] = 0.680822491;
	m_table[48] = 0.684386303;
	m_table[49] = 0.687933051;
	m_table[50] = 0.691462461;
	m_table[51] = 0.694974269;
	m_table[52] = 0.698468212;
	m_table[53] = 0.701944035;
	m_table[54] = 0.705401484;
	m_table[55] = 0.708840313;
	m_table[56] = 0.712260281;
	m_table[57] = 0.715661151;
	m_table[58] = 0.719042691;
	m_table[59] = 0.722404675;
	m_table[60] = 0.725746882;
	m_table[61] = 0.729069096;
	m_table[62] = 0.732371107;
	m_table[63] = 0.735652708;
	m_table[64] = 0.7389137;
	m_table[65] = 0.742153889;
	m_table[66] = 0.745373085;
	m_table[67] = 0.748571105;
	m_table[68] = 0.75174777;
	m_table[69] = 0.754902906;
	m_table[70] = 0.758036348;
	m_table[71] = 0.761147932;
	m_table[72] = 0.764237502;
	m_table[73] = 0.767304908;
	m_table[74] = 0.770350003;
	m_table[75] = 0.773372648;
	m_table[76] = 0.776372708;
	m_table[77] = 0.779350054;
	m_table[78] = 0.782304562;
	m_table[79] = 0.785236116;
	m_table[80] = 0.788144601;
	m_table[81] = 0.791029912;
	m_table[82] = 0.793891946;
	m_table[83] = 0.796730608;
	m_table[84] = 0.799545807;
	m_table[85] = 0.802337457;
	m_table[86] = 0.805105479;
	m_table[87] = 0.807849798;
	m_table[88] = 0.810570345;
	m_table[89] = 0.813267057;
	m_table[90] = 0.815939875;
	m_table[91] = 0.818588745;
	m_table[92] = 0.82121362;
	m_table[93] = 0.823814458;
	m_table[94] = 0.82639122;
	m_table[95] = 0.828943874;
	m_table[96] = 0.831472393;
	m_table[97] = 0.833976754;
	m_table[98] = 0.836456941;
	m_table[99] = 0.83891294;
	m_table[100] = 0.841344746;
	m_table[101] = 0.843752355;
	m_table[102] = 0.84613577;
	m_table[103] = 0.848494997;
	m_table[104] = 0.85083005;
	m_table[105] = 0.853140944;
	m_table[106] = 0.8554277;
	m_table[107] = 0.857690346;
	m_table[108] = 0.85992891;
	m_table[109] = 0.862143428;
	m_table[110] = 0.864333939;
	m_table[111] = 0.866500487;
	m_table[112] = 0.868643119;
	m_table[113] = 0.870761888;
	m_table[114] = 0.872856849;
	m_table[115] = 0.874928064;
	m_table[116] = 0.876975597;
	m_table[117] = 0.878999516;
	m_table[118] = 0.880999893;
	m_table[119] = 0.882976804;
	m_table[120] = 0.88493033;
	m_table[121] = 0.886860554;
	m_table[122] = 0.888767563;
	m_table[123] = 0.890651448;
	m_table[124] = 0.892512303;
	m_table[125] = 0.894350226;
	m_table[126] = 0.896165319;
	m_table[127] = 0.897957685;
	m_table[128] = 0.899727432;
	m_table[129] = 0.901474671;
	m_table[130] = 0.903199515;
	m_table[131] = 0.904902082;
	m_table[132] = 0.906582491;
	m_table[133] = 0.908240864;
	m_table[134] = 0.909877328;
	m_table[135] = 0.911492009;
	m_table[136] = 0.913085038;
	m_table[137] = 0.914656549;
	m_table[138] = 0.916206678;
	m_table[139] = 0.917735561;
	m_table[140] = 0.919243341;
	m_table[141] = 0.920730159;
	m_table[142] = 0.922196159;
	m_table[143] = 0.92364149;
	m_table[144] = 0.9250663;
	m_table[145] = 0.92647074;
	m_table[146] = 0.927854963;
	m_table[147] = 0.929219123;
	m_table[148] = 0.930563377;
	m_table[149] = 0.931887882;
	m_table[150] = 0.933192799;
	m_table[151] = 0.934478288;
	m_table[152] = 0.935744512;
	m_table[153] = 0.936991636;
	m_table[154] = 0.938219823;
	m_table[155] = 0.939429242;
	m_table[156] = 0.940620059;
	m_table[157] = 0.941792444;
	m_table[158] = 0.942946567;
	m_table[159] = 0.944082597;
	m_table[160] = 0.945200708;
	m_table[161] = 0.946301072;
	m_table[162] = 0.947383862;
	m_table[163] = 0.948449252;
	m_table[164] = 0.949497417;
	m_table[165] = 0.950528532;
	m_table[166] = 0.951542774;
	m_table[167] = 0.952540318;
	m_table[168] = 0.953521342;
	m_table[169] = 0.954486023;
	m_table[170] = 0.955434537;
	m_table[171] = 0.956367063;
	m_table[172] = 0.957283779;
	m_table[173] = 0.958184862;
	m_table[174] = 0.959070491;
	m_table[175] = 0.959940843;
	m_table[176] = 0.960796097;
	m_table[177] = 0.96163643;
	m_table[178] = 0.96246202;
	m_table[179] = 0.963273044;
	m_table[180] = 0.964069681;
	m_table[181] = 0.964852106;
	m_table[182] = 0.965620498;
	m_table[183] = 0.966375031;
	m_table[184] = 0.967115881;
	m_table[185] = 0.967843225;
	m_table[186] = 0.968557237;
	m_table[187] = 0.969258091;
	m_table[188] = 0.969945961;
	m_table[189] = 0.97062102;
	m_table[190] = 0.97128344;
	m_table[191] = 0.971933393;
	m_table[192] = 0.97257105;
	m_table[193] = 0.973196581;
	m_table[194] = 0.973810155;
	m_table[195] = 0.97441194;
	m_table[196] = 0.975002105;
	m_table[197] = 0.975580815;
	m_table[198] = 0.976148236;
	m_table[199] = 0.976704532;
	m_table[200] = 0.977249868;
	m_table[201] = 0.977784406;
	m_table[202] = 0.978308306;
	m_table[203] = 0.97882173;
	m_table[204] = 0.979324837;
	m_table[205] = 0.979817785;
	m_table[206] = 0.98030073;
	m_table[207] = 0.980773828;
	m_table[208] = 0.981237234;
	m_table[209] = 0.9816911;
	m_table[210] = 0.982135579;
	m_table[211] = 0.982570822;
	m_table[212] = 0.982996977;
	m_table[213] = 0.983414193;
	m_table[214] = 0.983822617;
	m_table[215] = 0.984222393;
	m_table[216] = 0.984613665;
	m_table[217] = 0.984996577;
	m_table[218] = 0.985371269;
	m_table[219] = 0.985737882;
	m_table[220] = 0.986096552;
	m_table[221] = 0.986447419;
	m_table[222] = 0.986790616;
	m_table[223] = 0.987126279;
	m_table[224] = 0.987454539;
	m_table[225] = 0.987775527;
	m_table[226] = 0.988089375;
	m_table[227] = 0.988396208;
	m_table[228] = 0.988696156;
	m_table[229] = 0.988989342;
	m_table[230] = 0.98927589;
	m_table[231] = 0.989555923;
	m_table[232] = 0.989829561;
	m_table[233] = 0.990096924;
	m_table[234] = 0.99035813;
	m_table[235] = 0.990613294;
	m_table[236] = 0.990862532;
	m_table[237] = 0.991105957;
	m_table[238] = 0.991343681;
	m_table[239] = 0.991575814;
	m_table[240] = 0.991802464;
	m_table[241] = 0.99202374;
	m_table[242] = 0.992239746;
	m_table[243] = 0.992450589;
	m_table[244] = 0.992656369;
	m_table[245] = 0.992857189;
	m_table[246] = 0.993053149;
	m_table[247] = 0.993244347;
	m_table[248] = 0.993430881;
	m_table[249] = 0.993612845;
	m_table[250] = 0.993790335;
	m_table[251] = 0.993963442;
	m_table[252] = 0.994132258;
	m_table[253] = 0.994296874;
	m_table[254] = 0.994457377;
	m_table[255] = 0.994613854;
	m_table[256] = 0.994766392;
	m_table[257] = 0.994915074;
	m_table[258] = 0.995059984;
	m_table[259] = 0.995201203;
	m_table[260] = 0.995338812;
	m_table[261] = 0.995472889;
	m_table[262] = 0.995603512;
	m_table[263] = 0.995730757;
	m_table[264] = 0.995854699;
	m_table[265] = 0.995975411;
	m_table[266] = 0.996092967;
	m_table[267] = 0.996207438;
	m_table[268] = 0.996318892;
	m_table[269] = 0.996427399;
	m_table[270] = 0.996533026;
	m_table[271] = 0.99663584;
	m_table[272] = 0.996735904;
	m_table[273] = 0.996833284;
	m_table[274] = 0.996928041;
	m_table[275] = 0.997020237;
	m_table[276] = 0.997109932;
	m_table[277] = 0.997197185;
	m_table[278] = 0.997282055;
	m_table[279] = 0.997364598;
	m_table[280] = 0.99744487;
	m_table[281] = 0.997522925;
	m_table[282] = 0.997598818;
	m_table[283] = 0.9976726;
	m_table[284] = 0.997744323;
	m_table[285] = 0.997814039;
	m_table[286] = 0.997881795;
	m_table[287] = 0.997947641;
	m_table[288] = 0.998011624;
	m_table[289] = 0.998073791;
	m_table[290] = 0.998134187;
	m_table[291] = 0.998192856;
	m_table[292] = 0.998249843;
	m_table[293] = 0.99830519;
	m_table[294] = 0.998358939;
	m_table[295] = 0.99841113;
	m_table[296] = 0.998461805;
	m_table[297] = 0.998511001;
	m_table[298] = 0.998558758;
	m_table[299] = 0.998605113;
	m_table[300] = 0.998650102;
	m_table[301] = 0.998693762;
	m_table[302] = 0.998736127;
	m_table[303] = 0.998777231;
	m_table[304] = 0.998817109;
	m_table[305] = 0.998855793;
	m_table[306] = 0.998893315;
	m_table[307] = 0.998929706;
	m_table[308] = 0.998964997;
	m_table[309] = 0.998999218;
	m_table[310] = 0.999032397;
	m_table[311] = 0.999064563;
	m_table[312] = 0.999095745;
	m_table[313] = 0.999125968;
	m_table[314] = 0.999155261;
	m_table[315] = 0.999183648;
	m_table[316] = 0.999211154;
	m_table[317] = 0.999237805;
	m_table[318] = 0.999263625;
	m_table[319] = 0.999288636;
	m_table[320] = 0.999312862;
	m_table[321] = 0.999336325;
	m_table[322] = 0.999359047;
	m_table[323] = 0.999381049;
	m_table[324] = 0.999402352;
	m_table[325] = 0.999422975;
	m_table[326] = 0.999442939;
	m_table[327] = 0.999462263;
	m_table[328] = 0.999480965;
	m_table[329] = 0.999499063;
	m_table[330] = 0.999516576;
	m_table[331] = 0.99953352;
	m_table[332] = 0.999549913;
	m_table[333] = 0.99956577;
	m_table[334] = 0.999581108;
	m_table[335] = 0.999595942;
	m_table[336] = 0.999610288;
	m_table[337] = 0.999624159;
	m_table[338] = 0.999637571;
	m_table[339] = 0.999650537;
	m_table[340] = 0.999663071;
	m_table[341] = 0.999675186;
	m_table[342] = 0.999686894;
	m_table[343] = 0.999698209;
	m_table[344] = 0.999709143;
	m_table[345] = 0.999719707;
	m_table[346] = 0.999729912;
	m_table[347] = 0.999739771;
	m_table[348] = 0.999749293;
	m_table[349] = 0.99975849;
	m_table[350] = 0.999767371;
	m_table[351] = 0.999775947;
	m_table[352] = 0.999784227;
	m_table[353] = 0.99979222;
	m_table[354] = 0.999799936;
	m_table[355] = 0.999807384;
	m_table[356] = 0.999814573;
	m_table[357] = 0.999821509;
	m_table[358] = 0.999828203;
	m_table[359] = 0.999834661;
	m_table[360] = 0.999840891;
	m_table[361] = 0.999846901;
	m_table[362] = 0.999852698;
	m_table[363] = 0.999858289;
	m_table[364] = 0.999863681;
	m_table[365] = 0.99986888;
	m_table[366] = 0.999873892;
	m_table[367] = 0.999878725;
	m_table[368] = 0.999883383;
	m_table[369] = 0.999887873;
	m_table[370] = 0.9998922;
	m_table[371] = 0.99989637;
	m_table[372] = 0.999900389;
	m_table[373] = 0.99990426;
	m_table[374] = 0.99990799;
	m_table[375] = 0.999911583;
	m_table[376] = 0.999915043;
	m_table[377] = 0.999918376;
	m_table[378] = 0.999921586;
	m_table[379] = 0.999924676;
	m_table[380] = 0.999927652;
	m_table[381] = 0.999930517;
	m_table[382] = 0.999933274;
	m_table[383] = 0.999935928;
	m_table[384] = 0.999938483;
	m_table[385] = 0.999940941;
	m_table[386] = 0.999943306;
	m_table[387] = 0.999945582;
	m_table[388] = 0.999947772;
	m_table[389] = 0.999949878;
	m_table[390] = 0.999951904;
	m_table[391] = 0.999953852;
	m_table[392] = 0.999955726;
	m_table[393] = 0.999957527;
	m_table[394] = 0.999959259;
	m_table[395] = 0.999960924;
	m_table[396] = 0.999962525;
	m_table[397] = 0.999964064;
	m_table[398] = 0.999965542;
	m_table[399] = 0.999966963;
	m_table[400] = 0.999968329;
	m_table[401] = 0.999969641;
	m_table[402] = 0.999970901;
	m_table[403] = 0.999972112;
	m_table[404] = 0.999973274;
	m_table[405] = 0.999974391;
	m_table[406] = 0.999975464;
	m_table[407] = 0.999976493;
	m_table[408] = 0.999977482;
	m_table[409] = 0.999978431;
	m_table[410] = 0.999979342;
	m_table[411] = 0.999980217;
	m_table[412] = 0.999981056;
	m_table[413] = 0.999981862;
	m_table[414] = 0.999982635;
	m_table[415] = 0.999983376;
	m_table[416] = 0.999984088;
	m_table[417] = 0.99998477;
	m_table[418] = 0.999985425;
	m_table[419] = 0.999986052;
	m_table[420] = 0.999986654;
	m_table[421] = 0.999987231;
	m_table[422] = 0.999987785;
	m_table[423] = 0.999988315;
	m_table[424] = 0.999988824;
	m_table[425] = 0.999989311;
	m_table[426] = 0.999989779;
	m_table[427] = 0.999990226;
	m_table[428] = 0.999990655;
	m_table[429] = 0.999991066;
	m_table[430] = 0.99999146;
	m_table[431] = 0.999991837;
	m_table[432] = 0.999992199;
	m_table[433] = 0.999992545;
	m_table[434] = 0.999992876;
	m_table[435] = 0.999993193;
	m_table[436] = 0.999993497;
	m_table[437] = 0.999993788;
	m_table[438] = 0.999994066;
	m_table[439] = 0.999994332;
	m_table[440] = 0.999994587;
	m_table[441] = 0.999994831;
	m_table[442] = 0.999995065;
	m_table[443] = 0.999995288;
	m_table[444] = 0.999995502;
	m_table[445] = 0.999995706;
	m_table[446] = 0.999995902;
	m_table[447] = 0.999996089;
	m_table[448] = 0.999996268;
	m_table[449] = 0.999996439;
	m_table[450] = 0.999996602;
	m_table[451] = 0.999996759;
	m_table[452] = 0.999996908;
	m_table[453] = 0.999997051;
	m_table[454] = 0.999997187;
	m_table[455] = 0.999997318;
	m_table[456] = 0.999997442;
	m_table[457] = 0.999997561;
	m_table[458] = 0.999997675;
	m_table[459] = 0.999997784;
	m_table[460] = 0.999997888;
	m_table[461] = 0.999997987;
	m_table[462] = 0.999998081;
	m_table[463] = 0.999998172;
	m_table[464] = 0.999998258;
	m_table[465] = 0.99999834;
	m_table[466] = 0.999998419;
	m_table[467] = 0.999998494;
	m_table[468] = 0.999998566;
	m_table[469] = 0.999998634;
	m_table[470] = 0.999998699;
	m_table[471] = 0.999998761;
	m_table[472] = 0.999998821;
	m_table[473] = 0.999998877;
	m_table[474] = 0.999998931;
	m_table[475] = 0.999998983;
	m_table[476] = 0.999999032;
	m_table[477] = 0.999999079;
	m_table[478] = 0.999999124;
	m_table[479] = 0.999999166;
	m_table[480] = 0.999999207;
	m_table[481] = 0.999999245;
	m_table[482] = 0.999999282;
	m_table[483] = 0.999999317;
	m_table[484] = 0.999999351;
	m_table[485] = 0.999999383;
	m_table[486] = 0.999999413;
	m_table[487] = 0.999999442;
	m_table[488] = 0.99999947;
	m_table[489] = 0.999999496;
	m_table[490] = 0.999999521;
	m_table[491] = 0.999999545;
	m_table[492] = 0.999999567;
	m_table[493] = 0.999999589;
	m_table[494] = 0.999999609;
	m_table[495] = 0.999999629;
	m_table[496] = 0.999999648;
	m_table[497] = 0.999999665;
	m_table[498] = 0.999999682;
	m_table[499] = 0.999999698;
	m_table[500] = 0.999999713;
	m_table[501] = 0.999999728;
	m_table[502] = 0.999999742;
	m_table[503] = 0.999999755;
	m_table[504] = 0.999999767;
	m_table[505] = 0.999999779;
	m_table[506] = 0.99999979;
	m_table[507] = 0.999999801;
	m_table[508] = 0.999999811;
	m_table[509] = 0.999999821;
	m_table[510] = 0.99999983;
	m_table[511] = 0.999999839;
	m_table[512] = 0.999999847;
	m_table[513] = 0.999999855;
	m_table[514] = 0.999999863;
	m_table[515] = 0.99999987;
	m_table[516] = 0.999999877;
	m_table[517] = 0.999999883;
	m_table[518] = 0.999999889;
	m_table[519] = 0.999999895;
	m_table[520] = 0.9999999;
	m_table[521] = 0.999999906;
	m_table[522] = 0.999999911;
	m_table[523] = 0.999999915;
	m_table[524] = 0.99999992;
	m_table[525] = 0.999999924;
	m_table[526] = 0.999999928;
	m_table[527] = 0.999999932;
	m_table[528] = 0.999999935;
	m_table[529] = 0.999999939;
	m_table[530] = 0.999999942;
	m_table[531] = 0.999999945;
	m_table[532] = 0.999999948;
	m_table[533] = 0.999999951;
	m_table[534] = 0.999999954;
	m_table[535] = 0.999999956;
	m_table[536] = 0.999999958;
	m_table[537] = 0.999999961;
	m_table[538] = 0.999999963;
	m_table[539] = 0.999999965;
	m_table[540] = 0.999999967;
	m_table[541] = 0.999999968;
	m_table[542] = 0.99999997;
	m_table[543] = 0.999999972;
	m_table[544] = 0.999999973;
	m_table[545] = 0.999999975;
	m_table[546] = 0.999999976;
	m_table[547] = 0.999999977;
	m_table[548] = 0.999999979;
	m_table[549] = 0.99999998;
	m_table[550] = 0.999999981;
	m_table[551] = 0.999999982;
	m_table[552] = 0.999999983;
	m_table[553] = 0.999999984;
	m_table[554] = 0.999999985;
	m_table[555] = 0.999999986;
	m_table[556] = 0.999999987;
	m_table[557] = 0.999999987;
	m_table[558] = 0.999999988;
	m_table[559] = 0.999999989;
	m_table[560] = 0.999999989;
	m_table[561] = 0.99999999;
	m_table[562] = 0.99999999;
	m_table[563] = 0.999999991;
	m_table[564] = 0.999999991;
	m_table[565] = 0.999999992;
	m_table[566] = 0.999999992;
	m_table[567] = 0.999999993;
	m_table[568] = 0.999999993;
	m_table[569] = 0.999999994;
	m_table[570] = 0.999999994;
	m_table[571] = 0.999999994;
	m_table[572] = 0.999999995;
	m_table[573] = 0.999999995;
	m_table[574] = 0.999999995;
	m_table[575] = 0.999999996;
	m_table[576] = 0.999999996;
	m_table[577] = 0.999999996;
	m_table[578] = 0.999999996;
	m_table[579] = 0.999999996;
	m_table[580] = 0.999999997;
	m_table[581] = 0.999999997;
	m_table[582] = 0.999999997;
	m_table[583] = 0.999999997;
	m_table[584] = 0.999999997;
	m_table[585] = 0.999999998;
	m_table[586] = 0.999999998;
	m_table[587] = 0.999999998;
	m_table[588] = 0.999999998;
	m_table[589] = 0.999999998;
	m_table[590] = 0.999999998;
	m_table[591] = 0.999999998;
	m_table[592] = 0.999999998;
	m_table[593] = 0.999999998;
	m_table[594] = 0.999999999;
	m_table[595] = 0.999999999;
	m_table[596] = 0.999999999;
	m_table[597] = 0.999999999;
	m_table[598] = 0.999999999;
	m_table[599] = 0.999999999;
	m_table[600] = 0.999999999;
	m_table[601] = 0.999999999;
	m_table[602] = 0.999999999;
	m_table[603] = 0.999999999;
	m_table[604] = 0.999999999;
	m_table[605] = 0.999999999;
	m_table[606] = 0.999999999;
	m_table[607] = 0.999999999;
	m_table[608] = 0.999999999;
	m_table[609] = 0.999999999;
	m_table[610] = 0.999999999;
	m_table[611] = 1.0;
}

// destructor
NormalDistribution::~NormalDistribution() {
	delete[] m_table;
}

// calculates p - value
double NormalDistribution::calcP( const double x ) {
	bool negativeFlg = ( x < 0.0 );
	double v = fabs( x );

	// index
	double pos = v / ELEMENT_WIDTH;
	int idx0 = (int)floor( pos );
	int idx1 = (int)ceil( pos );

	if( idx1 <= 0 ) {
		return 0.5;
	}

	double p = 0.0;

	if( idx1 > (int)m_tableSize || idx0 >= (int)m_tableSize ) {
		p = 1.0;
	}
	else if( idx0 == idx1 ) {
		p = m_table[ idx0 ];
	}
	else {
		double v0 = m_table[ idx0 ];
		double v1 = m_table[ idx1 ];

		double m = pos - floor( pos );
		p = v0 * ( 1.0 - m ) + m * v1;
	}

	if( !negativeFlg ) {
		p = 1.0 - p;
	}

	return p;
}
