/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.dto.settings.impl;

import jp.mosp.framework.base.BaseDto;
import jp.mosp.time.dto.settings.SubordinateFiscalListDtoInterface;

/**
 * 部下年度一覧DTO。
 */
public class SubordinateFiscalListDto extends BaseDto implements SubordinateFiscalListDtoInterface {
	
	private static final long	serialVersionUID	= 1196620813400130781L;
	
	/**
	 * 個人ID。
	 */
	private String				personalId;
	
	/**
	 * 表示年度。<br>
	 */
	private int					fiscalYear;
	
	/**
	 * 対象年。<br>
	 */
	private int					targetYear;
	
	/**
	 * 対象月。<br>
	 */
	private int					targetMonth;
	
	/**
	 * 社員コード。
	 */
	private String				employeeCode;
	/**
	 * 社員氏名(姓)。
	 */
	private String				lastName;
	/**
	 * 社員氏名(名)。
	 */
	private String				firstName;
	/**
	 * 所属コード。
	 */
	private String				sectionCode;
	
	/**
	 * 残業時間。
	 */
	private Integer				overTime;
	
	/**
	 * 普休始(日)。
	 */
	private Double				paidHolidayDays;
	
	/**
	 * 普休始(時間)。
	 */
	private Integer				paidHolidayTime;
	
	/**
	 * 普休残(日)。
	 */
	private Double				paidHolidayRestDays;
	
	/**
	 * 普休残(時間)。
	 */
	private Integer				paidHolidayRestTime;
	
	/**
	 * 保休始。
	 */
	private Double				stockHolidayDays;
	
	/**
	 * 保休残。
	 */
	private Double				stockHolidayRestDays;
	
	/**
	 * 季休始。
	 */
	private Double				seasonHolidayDays;
	
	/**
	 * 季休残。
	 */
	private Double				seasonHolidayRestDays;
	
	
	@Override
	public String getPersonalId() {
		return personalId;
	}
	
	@Override
	public void setPersonalId(String personalId) {
		this.personalId = personalId;
	}
	
	@Override
	public String getEmployeeCode() {
		return employeeCode;
	}
	
	@Override
	public void setEmployeeCode(String employeeCode) {
		this.employeeCode = employeeCode;
	}
	
	@Override
	public String getLastName() {
		return lastName;
	}
	
	@Override
	public String getFirstName() {
		return firstName;
	}
	
	@Override
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	
	@Override
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	
	@Override
	public String getSectionCode() {
		return sectionCode;
	}
	
	@Override
	public void setSectionCode(String sectionCode) {
		this.sectionCode = sectionCode;
	}
	
	@Override
	public int getFiscalYear() {
		return fiscalYear;
	}
	
	@Override
	public int getTargetYear() {
		return targetYear;
	}
	
	@Override
	public int getTargetMonth() {
		return targetMonth;
	}
	
	@Override
	public Integer getOverTime() {
		return overTime;
	}
	
	@Override
	public Double getPaidHolidayDays() {
		return paidHolidayDays;
	}
	
	@Override
	public Double getPaidHolidayRestDays() {
		return paidHolidayRestDays;
	}
	
	@Override
	public Double getStockHolidayDays() {
		return stockHolidayDays;
	}
	
	@Override
	public Double getStockHolidayRestDays() {
		return stockHolidayRestDays;
	}
	
	@Override
	public Double getSeasonHolidayDays() {
		return seasonHolidayDays;
	}
	
	@Override
	public Double getSeasonHolidayRestDays() {
		return seasonHolidayRestDays;
	}
	
	@Override
	public void setFiscalYear(int fiscalYear) {
		this.fiscalYear = fiscalYear;
	}
	
	@Override
	public void setTargetYear(int targetYear) {
		this.targetYear = targetYear;
	}
	
	@Override
	public void setTargetMonth(int targetMonth) {
		this.targetMonth = targetMonth;
	}
	
	@Override
	public void setOverTime(Integer overTime) {
		this.overTime = overTime;
	}
	
	@Override
	public void setPaidHolidayDays(Double paidHolidayDays) {
		this.paidHolidayDays = paidHolidayDays;
	}
	
	@Override
	public void setPaidHolidayRestDays(Double paidHolidayRestDays) {
		this.paidHolidayRestDays = paidHolidayRestDays;
	}
	
	@Override
	public void setStockHolidayDays(Double stockHolidayDays) {
		this.stockHolidayDays = stockHolidayDays;
	}
	
	@Override
	public void setStockHolidayRestDays(Double stockHolidayRestDays) {
		this.stockHolidayRestDays = stockHolidayRestDays;
	}
	
	@Override
	public void setSeasonHolidayDays(Double seasonHolidayDays) {
		this.seasonHolidayDays = seasonHolidayDays;
	}
	
	@Override
	public void setSeasonHolidayRestDays(Double seasonHolidayRestDays) {
		this.seasonHolidayRestDays = seasonHolidayRestDays;
	}
	
	@Override
	public Integer getPaidHolidayTime() {
		return paidHolidayTime;
	}
	
	@Override
	public Integer getPaidHolidayRestTime() {
		return paidHolidayRestTime;
	}
	
	@Override
	public void setPaidHolidayTime(Integer paidHolidayTime) {
		this.paidHolidayTime = paidHolidayTime;
	}
	
	@Override
	public void setPaidHolidayRestTime(Integer paidHolidayRestTime) {
		this.paidHolidayRestTime = paidHolidayRestTime;
	}
	
}
