/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRXlsxDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Workbook;

public class JRXlsxQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JRXlsxQueryExecuter.class);
    private JRXlsxDataSource datasource;

    protected JRXlsxQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
    }

    protected JRXlsxQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this(DefaultJasperReportsContext.getInstance(), dataset, parametersMap);
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        try {
            Workbook workbook = (Workbook)this.getParameterValue("XLSX_WORKBOOK");
            if (workbook != null) {
                this.datasource = new JRXlsxDataSource(workbook);
            } else {
                InputStream xlsxInputStream = (InputStream)this.getParameterValue("XLSX_INPUT_STREAM");
                if (xlsxInputStream != null) {
                    this.datasource = new JRXlsxDataSource(xlsxInputStream);
                } else {
                    File xlsxFile = (File)this.getParameterValue("XLSX_FILE");
                    if (xlsxFile != null) {
                        this.datasource = new JRXlsxDataSource(xlsxFile);
                    } else {
                        String xlsxSource = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.source");
                        if (xlsxSource != null) {
                            this.datasource = new JRXlsxDataSource(this.getJasperReportsContext(), xlsxSource);
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)"No XLS source was provided.");
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        if (this.datasource != null) {
            List<Object> columnNamesList = null;
            String columnNames = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.column.names");
            if (columnNames != null) {
                columnNamesList = new ArrayList<String>();
                columnNamesList.add(columnNames);
            } else {
                String[] columnNamesArray = (String[])this.getParameterValue("XLSX_COLUMN_NAMES_ARRAY", true);
                if (columnNamesArray != null) {
                    columnNamesList = Arrays.asList(columnNamesArray);
                } else {
                    String propertiesPrefix = "net.sf.jasperreports.xlsx.column.names";
                    List<JRPropertiesUtil.PropertySuffix> properties = this.getPropertiesUtil().getAllProperties(this.dataset, propertiesPrefix);
                    if (properties != null && !properties.isEmpty()) {
                        columnNamesList = new ArrayList();
                        for (int i = 0; i < properties.size(); ++i) {
                            JRPropertiesUtil.PropertySuffix property = properties.get(i);
                            columnNamesList.add(property.getValue());
                        }
                    } else {
                        JRField[] fields = this.dataset.getFields();
                        if (fields != null && fields.length > 0) {
                            columnNamesList = new ArrayList();
                            for (int i = 0; i < fields.length; ++i) {
                                columnNamesList.add(fields[i].getName());
                            }
                        }
                    }
                }
            }
            ArrayList<String> splitColumnNamesList = null;
            if (columnNamesList != null && columnNamesList.size() > 0) {
                splitColumnNamesList = new ArrayList<String>();
                for (int i = 0; i < columnNamesList.size(); ++i) {
                    String names = (String)columnNamesList.get(i);
                    String[] arr$ = names.split(",");
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String token = arr$[i$];
                        splitColumnNamesList.add(token.trim());
                    }
                }
            }
            List<Object> columnIndexesList = null;
            String columnIndexes = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.column.indexes");
            if (columnIndexes != null) {
                columnIndexesList = new ArrayList();
                for (String colIndex : columnIndexes.split(",")) {
                    columnIndexesList.add(Integer.valueOf(colIndex.trim()));
                }
            } else {
                Integer[] columnIndexesArray = (Integer[])this.getParameterValue("XLSX_COLUMN_INDEXES_ARRAY", true);
                if (columnIndexesArray != null) {
                    columnIndexesList = Arrays.asList(columnIndexesArray);
                } else {
                    String propertiesPrefix = "net.sf.jasperreports.xlsx.column.indexes";
                    List<JRPropertiesUtil.PropertySuffix> properties = this.getPropertiesUtil().getAllProperties(this.dataset, propertiesPrefix);
                    if (properties != null && !properties.isEmpty()) {
                        columnIndexesList = new ArrayList();
                        for (int i = 0; i < properties.size(); ++i) {
                            String propertyValue = properties.get(i).getValue();
                            for (String colIndex : propertyValue.split(",")) {
                                columnIndexesList.add(Integer.valueOf(colIndex.trim()));
                            }
                        }
                    }
                }
            }
            if (splitColumnNamesList != null) {
                if (columnIndexesList != null) {
                    int[] indexesArray = new int[columnIndexesList.size()];
                    for (int i = 0; i < columnIndexesList.size(); ++i) {
                        indexesArray[i] = (Integer)columnIndexesList.get(i);
                    }
                    this.datasource.setColumnNames(splitColumnNamesList.toArray(new String[splitColumnNamesList.size()]), indexesArray);
                } else {
                    this.datasource.setColumnNames(splitColumnNamesList.toArray(new String[splitColumnNamesList.size()]));
                }
            } else if (columnIndexesList != null) {
                this.datasource.setColumnIndexes(columnIndexesList.toArray(new Integer[columnIndexesList.size()]));
            } else if (log.isWarnEnabled()) {
                log.warn((Object)"No column names or column indexes were specified.");
            }
            DateFormat dateFormat = (DateFormat)this.getParameterValue("XLSX_DATE_FORMAT", true);
            if (dateFormat != null) {
                this.datasource.setDateFormat(dateFormat);
            } else {
                String dateFormatPattern = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.date.pattern");
                if (dateFormatPattern != null) {
                    this.datasource.setDatePattern(dateFormatPattern);
                }
            }
            NumberFormat numberFormat = (NumberFormat)this.getParameterValue("XLSX_NUMBER_FORMAT", true);
            if (numberFormat != null) {
                this.datasource.setNumberFormat(numberFormat);
            } else {
                String numberFormatPattern = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.number.pattern");
                if (numberFormatPattern != null) {
                    this.datasource.setNumberPattern(numberFormatPattern);
                }
            }
            this.datasource.setUseFirstRowAsHeader(this.getBooleanParameterOrProperty("XLSX_USE_FIRST_ROW_AS_HEADER", false));
            Locale xlsxLocale = (Locale)this.getParameterValue("REPORT_LOCALE", true);
            if (xlsxLocale != null) {
                this.datasource.setLocale(xlsxLocale);
            } else {
                String xlsxLocaleCode = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.locale.code");
                if (xlsxLocaleCode != null) {
                    this.datasource.setLocale(xlsxLocaleCode);
                }
            }
            TimeZone xlsxTimezone = (TimeZone)this.getParameterValue("REPORT_TIME_ZONE", true);
            if (xlsxTimezone != null) {
                this.datasource.setTimeZone(xlsxTimezone);
            } else {
                String xlsxTimezoneId = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.timezone.id");
                if (xlsxTimezoneId != null) {
                    this.datasource.setTimeZone(xlsxTimezoneId);
                }
            }
        }
        return this.datasource;
    }

    @Override
    public void close() {
        if (this.datasource != null) {
            this.datasource.close();
        }
    }

    @Override
    public boolean cancelQuery() throws JRException {
        return false;
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }
}

