/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.TimeZone;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillDatasetRun;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;

public abstract class JRFillElementDataset
implements JRElementDataset {
    protected JRElementDataset parent;
    private final JRBaseFiller filler;
    protected JRGroup resetGroup;
    protected JRGroup incrementGroup;
    private boolean isIncremented = true;
    protected JRFillDatasetRun datasetRun;
    private boolean increment;

    protected JRFillElementDataset(JRElementDataset dataset, JRFillObjectFactory factory) {
        factory.put(dataset, this);
        this.parent = dataset;
        this.filler = factory.getFiller();
        this.resetGroup = factory.getGroup(dataset.getResetGroup());
        this.incrementGroup = factory.getGroup(dataset.getIncrementGroup());
        this.datasetRun = factory.getDatasetRun(dataset.getDatasetRun());
    }

    protected void setBand(JRFillBand band) {
        if (this.datasetRun != null) {
            this.datasetRun.setBand(band);
        }
    }

    @Override
    public ResetTypeEnum getResetTypeValue() {
        return this.parent.getResetTypeValue();
    }

    @Override
    public IncrementTypeEnum getIncrementTypeValue() {
        return this.parent.getIncrementTypeValue();
    }

    @Override
    public JRGroup getResetGroup() {
        return this.resetGroup;
    }

    @Override
    public JRGroup getIncrementGroup() {
        return this.incrementGroup;
    }

    protected TimeZone getTimeZone() {
        return this.filler.getTimeZone();
    }

    protected void initialize() {
        this.customInitialize();
        this.isIncremented = false;
        this.increment = false;
    }

    protected void evaluate(JRCalculator calculator) throws JRExpressionEvalException {
        this.evaluateIncrementWhenExpression(calculator);
        if (this.increment) {
            this.customEvaluate(calculator);
        }
        this.isIncremented = false;
    }

    protected void evaluateIncrementWhenExpression(JRCalculator calculator) throws JRExpressionEvalException {
        Boolean evaluated;
        JRExpression incrementWhenExpression = this.getIncrementWhenExpression();
        this.increment = incrementWhenExpression == null ? true : (evaluated = (Boolean)calculator.evaluate(incrementWhenExpression)) != null && evaluated != false;
    }

    protected void increment() {
        if (!this.isIncremented && this.increment) {
            this.customIncrement();
        }
        this.isIncremented = true;
    }

    protected abstract void customInitialize();

    protected abstract void customEvaluate(JRCalculator var1) throws JRExpressionEvalException;

    protected abstract void customIncrement();

    @Override
    public JRDatasetRun getDatasetRun() {
        return this.datasetRun;
    }

    public void evaluateDatasetRun(byte evaluation) throws JRException {
        if (this.datasetRun != null) {
            this.datasetRun.evaluate(this, evaluation);
        }
    }

    public JRFillDataset getInputDataset() {
        JRFillDataset inputDataset = this.datasetRun != null ? this.datasetRun.getDataset() : this.filler.mainDataset;
        return inputDataset;
    }

    @Override
    public JRExpression getIncrementWhenExpression() {
        return this.parent.getIncrementWhenExpression();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public JRFillDataset getFillDataset() {
        return this.datasetRun == null ? this.filler.getMainDataset() : this.datasetRun.getDataset();
    }
}

