/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.component;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentManager;
import net.sf.jasperreports.engine.component.ComponentsBundle;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ComponentsEnvironment {
    private static final Log log = LogFactory.getLog(ComponentsEnvironment.class);
    private final ReferenceMap cache = new ReferenceMap(2, 0);
    private JasperReportsContext jasperReportsContext;

    private ComponentsEnvironment(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    private static ComponentsEnvironment getDefaultInstance() {
        return new ComponentsEnvironment(DefaultJasperReportsContext.getInstance());
    }

    public static ComponentsEnvironment getInstance(JasperReportsContext jasperReportsContext) {
        return new ComponentsEnvironment(jasperReportsContext);
    }

    public Collection<ComponentsBundle> getBundles() {
        Map<String, ComponentsBundle> components = this.getCachedBundles();
        return components.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ComponentsBundle> getCachedBundles() {
        Object cacheKey = ExtensionsEnvironment.getExtensionsCacheKey();
        ReferenceMap referenceMap = this.cache;
        synchronized (referenceMap) {
            Map<String, ComponentsBundle> components = (Map<String, ComponentsBundle>)this.cache.get(cacheKey);
            if (components == null) {
                components = this.findBundles();
                this.cache.put(cacheKey, components);
            }
            return components;
        }
    }

    protected Map<String, ComponentsBundle> findBundles() {
        HashMap<String, ComponentsBundle> components = new HashMap<String, ComponentsBundle>();
        List<ComponentsBundle> bundles = this.jasperReportsContext.getExtensions(ComponentsBundle.class);
        for (ComponentsBundle bundle : bundles) {
            String namespace = bundle.getXmlParser().getNamespace();
            if (components.containsKey(namespace)) {
                log.warn((Object)("Found two components for namespace " + namespace));
                continue;
            }
            components.put(namespace, bundle);
        }
        return components;
    }

    public ComponentsBundle getBundle(String namespace) {
        Map<String, ComponentsBundle> components = this.getCachedBundles();
        ComponentsBundle componentsBundle = components.get(namespace);
        if (componentsBundle == null) {
            throw new JRRuntimeException("No components bundle registered for namespace " + namespace);
        }
        return componentsBundle;
    }

    public ComponentManager getManager(ComponentKey componentKey) {
        String namespace = componentKey.getNamespace();
        ComponentsBundle componentsBundle = this.getBundle(namespace);
        String name = componentKey.getName();
        return componentsBundle.getComponentManager(name);
    }

    public static Collection<ComponentsBundle> getComponentBundles() {
        return ComponentsEnvironment.getDefaultInstance().getBundles();
    }

    protected static Map<String, ComponentsBundle> getCachedComponentBundles() {
        return ComponentsEnvironment.getDefaultInstance().getCachedBundles();
    }

    protected static Map<String, ComponentsBundle> findComponentBundles() {
        return ComponentsEnvironment.getDefaultInstance().findBundles();
    }

    public static ComponentsBundle getComponentsBundle(String namespace) {
        return ComponentsEnvironment.getDefaultInstance().getBundle(namespace);
    }

    public static ComponentManager getComponentManager(ComponentKey componentKey) {
        return ComponentsEnvironment.getDefaultInstance().getManager(componentKey);
    }
}

