/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVisitable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentManager;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.component.ConditionalStyleAwareFillComponent;
import net.sf.jasperreports.engine.component.FillComponent;
import net.sf.jasperreports.engine.component.FillContext;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.component.StretchableFillComponent;
import net.sf.jasperreports.engine.fill.FillContainerContext;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillDatasetRun;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class JRFillComponentElement
extends JRFillElement
implements JRComponentElement,
FillContext {
    private FillComponent fillComponent;
    private boolean filling;
    private List<JRFillDatasetRun> componentDatasetRuns;

    public JRFillComponentElement(JRBaseFiller filler, JRComponentElement element, JRFillObjectFactory factory) {
        super(filler, element, factory);
        ComponentKey componentKey = element.getComponentKey();
        ComponentManager manager = ComponentsEnvironment.getInstance(filler.getJasperReportsContext()).getManager(componentKey);
        factory.trackDatasetRuns();
        this.fillComponent = manager.getComponentFillFactory(filler.getJasperReportsContext()).toFillComponent(element.getComponent(), factory);
        this.fillComponent.initialize(this);
        this.componentDatasetRuns = factory.getTrackedDatasetRuns();
    }

    public JRFillComponentElement(JRFillComponentElement element, JRFillCloneFactory factory) {
        super(element, factory);
        ComponentKey componentKey = element.getComponentKey();
        ComponentManager manager = ComponentsEnvironment.getInstance(this.filler.getJasperReportsContext()).getManager(componentKey);
        this.fillComponent = manager.getComponentFillFactory(this.filler.getJasperReportsContext()).cloneFillComponent(element.fillComponent, factory);
        this.fillComponent.initialize(this);
    }

    @Override
    protected void setBand(JRFillBand band) {
        super.setBand(band);
        if (this.componentDatasetRuns != null && !this.componentDatasetRuns.isEmpty()) {
            for (JRFillDatasetRun datasetRun : this.componentDatasetRuns) {
                datasetRun.setBand(band);
            }
        }
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.fillComponent.evaluate(evaluation);
        }
        this.filling = false;
    }

    @Override
    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        super.prepare(availableHeight, isOverflow);
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (!this.filling && isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
            isToPrint = false;
        }
        if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
            isToPrint = false;
            willOverflow = true;
        }
        if (!this.filling && isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isPrintRepeatedValues())) {
            isReprinted = true;
        }
        if (isToPrint) {
            FillPrepareResult result = this.fillComponent.prepare(availableHeight - this.getRelativeY());
            isToPrint = result.isToPrint();
            willOverflow = result.willOverflow();
            this.setStretchHeight(result.getStretchHeight());
            this.filling = willOverflow;
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    @Override
    protected void setStretchHeight(int stretchHeight) {
        StretchableFillComponent stretchableFillComponent;
        super.setStretchHeight(stretchHeight);
        StretchableFillComponent stretchableFillComponent2 = stretchableFillComponent = this.fillComponent instanceof StretchableFillComponent ? (StretchableFillComponent)((Object)this.fillComponent) : null;
        if (stretchableFillComponent != null) {
            stretchableFillComponent.setStretchHeight(stretchHeight);
        }
    }

    @Override
    public void setConditionalStylesContainer(JRFillElementContainer conditionalStylesContainer) {
        ConditionalStyleAwareFillComponent conditionalStyleAwareFillComponent;
        super.setConditionalStylesContainer(conditionalStylesContainer);
        ConditionalStyleAwareFillComponent conditionalStyleAwareFillComponent2 = conditionalStyleAwareFillComponent = this.fillComponent instanceof ConditionalStyleAwareFillComponent ? (ConditionalStyleAwareFillComponent)((Object)this.fillComponent) : null;
        if (conditionalStyleAwareFillComponent != null) {
            conditionalStyleAwareFillComponent.setConditionalStylesContainer(conditionalStylesContainer);
        }
    }

    @Override
    protected JRPrintElement fill() throws JRException {
        return this.fillComponent.fill();
    }

    @Override
    protected JRTemplateElement createElementTemplate() {
        return null;
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation, JREvaluationTime evaluationTime) throws JRException {
        this.performDelayedEvaluation(element, evaluation);
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        this.fillComponent.evaluateDelayedElement(element, evaluation);
    }

    @Override
    protected void rewind() throws JRException {
        this.fillComponent.rewind();
        this.filling = false;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitComponentElement(this);
        if (this.fillComponent instanceof JRVisitable) {
            ((JRVisitable)((Object)this.fillComponent)).visit(visitor);
        }
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillComponentElement(this, factory);
    }

    @Override
    public Component getComponent() {
        return ((JRComponentElement)this.parent).getComponent();
    }

    @Override
    public ComponentKey getComponentKey() {
        return ((JRComponentElement)this.parent).getComponentKey();
    }

    @Override
    public Object evaluate(JRExpression expression, byte evaluation) throws JRException {
        return super.evaluateExpression(expression, evaluation);
    }

    @Override
    public JRFillDataset getFillDataset() {
        return this.expressionEvaluator.getFillDataset();
    }

    @Override
    public JRComponentElement getComponentElement() {
        return this;
    }

    @Override
    public int getElementSourceId() {
        return this.elementId;
    }

    @Override
    public JROrigin getElementOrigin() {
        return super.getElementOrigin();
    }

    @Override
    public int getElementPrintY() {
        return this.getRelativeY();
    }

    @Override
    public JRStyle getElementStyle() {
        return this.getStyle();
    }

    @Override
    public void registerDelayedEvaluation(JRPrintElement printElement, EvaluationTimeEnum evaluationTime, String evaluationGroup) {
        this.filler.addBoundElement((JRFillElement)this, printElement, evaluationTime, evaluationGroup, this.band);
    }

    @Override
    public Locale getReportLocale() {
        return this.filler.getLocale();
    }

    @Override
    public ResourceBundle getReportResourceBundle() {
        return this.filler.getResourceBundle();
    }

    @Override
    public TimeZone getReportTimezone() {
        return this.filler.getTimeZone();
    }

    @Override
    public JRBaseFiller getFiller() {
        return this.filler;
    }

    @Override
    public FillContainerContext getFillContainerContext() {
        return this.fillContainerContext;
    }
}

