/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.gopher;

import gnu.inet.gopher.DirectoryListing;
import gnu.inet.util.CRLFInputStream;
import gnu.inet.util.MessageInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class GopherConnection {
    public static final int DEFAULT_PORT = 80;
    protected Socket socket;
    protected InputStream in;
    protected OutputStream out;

    public GopherConnection(String host) throws IOException {
        this(host, 80);
    }

    public GopherConnection(String host, int port) throws IOException {
        if (port <= 0) {
            port = 80;
        }
        this.socket = new Socket(host, port);
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
    }

    public DirectoryListing list() throws IOException {
        byte[] CRLF = new byte[]{13, 10};
        this.out.write(CRLF);
        this.out.flush();
        FilterInputStream listStream = new CRLFInputStream(this.in);
        listStream = new MessageInputStream(listStream);
        return new DirectoryListing(listStream);
    }

    public InputStream get(String selector) throws IOException {
        byte[] chars = selector.getBytes("US-ASCII");
        byte[] line = new byte[chars.length + 2];
        System.arraycopy(chars, 0, line, 0, chars.length);
        line[chars.length] = 13;
        line[chars.length + 1] = 10;
        this.out.write(line);
        this.out.flush();
        return this.in;
    }
}

