/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.util.zip.Checksum;

public class CRC16
implements Checksum {
    public static final int CRC_ANSY_POLY = 40961;
    public static final int CRC_ANSY_INIT = 0;
    public static final int CCITT_POLY = 33800;
    public static final int CCITT_INIT = 65535;
    public static final int DefaultPOLY = 40961;
    public static final int DefaultINIT = 0;
    private int crc;
    private int init;
    private int[] crcTable;

    public CRC16() {
        this(40961, 0);
    }

    public CRC16(int poly) {
        this(poly, poly == 33800 ? 65535 : 0);
    }

    public CRC16(int poly, int init) {
        this(CRC16.makeCrcTable(poly), init);
    }

    public CRC16(int[] crcTable, int init) {
        int BYTE_PATTERNS = 256;
        if (crcTable.length != 256) {
            throw new IllegalArgumentException("crcTable.length must equals 256");
        }
        this.crcTable = crcTable;
        this.init = init;
        this.reset();
    }

    public void update(int byte8) {
        int BYTE_BITS = 8;
        this.crc = this.crc >> 8 ^ this.crcTable[(this.crc ^ byte8) & 0xFF];
    }

    public void update(byte[] buffer) {
        this.update(buffer, 0, buffer.length);
    }

    public void update(byte[] buffer, int index, int length) {
        int BYTE_BITS = 8;
        while ((index & 3) > 0 && length-- > 0) {
            this.crc = this.crc >> 8 ^ this.crcTable[(this.crc ^ buffer[index++]) & 0xFF];
        }
        while (4 <= length) {
            int data = buffer[index++] & 0xFF | (buffer[index++] & 0xFF) << 8 | (buffer[index++] & 0xFF) << 16 | buffer[index++] << 24;
            this.crc = this.crc >> 8 ^ this.crcTable[(this.crc ^ data) & 0xFF];
            this.crc = this.crc >> 8 ^ this.crcTable[(this.crc ^ (data >>>= 8)) & 0xFF];
            this.crc = this.crc >> 8 ^ this.crcTable[(this.crc ^ (data >>>= 8)) & 0xFF];
            this.crc = this.crc >> 8 ^ this.crcTable[(this.crc ^ (data >>>= 8)) & 0xFF];
            length -= 4;
        }
        while (length-- > 0) {
            this.crc = this.crc >> 8 ^ this.crcTable[(this.crc ^ buffer[index++]) & 0xFF];
        }
    }

    public void reset() {
        this.crc = this.init;
    }

    public long getValue() {
        return this.crc & 0xFFFF;
    }

    public static int[] makeCrcTable(int poly) {
        int BYTE_PATTERNS = 256;
        int BYTE_BITS = 8;
        int[] crcTable = new int[256];
        int i = 0;
        while (i < 256) {
            crcTable[i] = i;
            int j = 0;
            while (j < 8) {
                if ((crcTable[i] & 1) != 0) {
                    crcTable[i] = crcTable[i] >> 1 ^ poly;
                } else {
                    int n = i;
                    crcTable[n] = crcTable[n] >> 1;
                }
                ++j;
            }
            ++i;
        }
        return crcTable;
    }
}

