/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 未入力時のメッセージコード。
 */
var MSG_REQUIRED = "PFW0102"

/**
 * 休憩/外出チェックエラーメッセージ。
 */
var MSG_REST_CHECK = "TMW0247";

/**
 * 終了時刻チェックエラーメッセージ。
 */
var MSG_END_TIME_CHECK = "TMW0280";

/**
 * 申請モード【新規】。
 */
var	MODE_APPLICATION_NEW	= "new";

/**
 * 申請モード【下書編集】。
 */
var MODE_APPLICATION_DRAFT	= "draft";

/**
 * 申請モード【差戻編集】（1次戻）。
 */
var MODE_APPLICATION_REVERT = "revert";

/**
 * 申請モード【申請済】。
 */
var MODE_APPLICATION_APPLIED = "applied";

/**
 * 申請モード【休日承認済】。
 */
var MODE_APPLICATION_COMPLETED_HOLIDAY = "completedHoliday";

/**
 * 画面読込時追加処理
 * @param 無し
 * @return 無し
 * @throws 実行時例外
 */
function onLoadExtra() {
	// 申請モード(新規)
	if (modeCardEdit == MODE_APPLICATION_NEW) {
		// 申請/下書ボタン押下不可
		setDisabled("btnRegist", false);
		setDisabled("btnDraft", false);
	}
	// 申請モード(下書)
	if (modeCardEdit == MODE_APPLICATION_DRAFT) {
		// 申請/下書ボタン押下可
		setDisabled("btnRegist", false);
		setDisabled("btnDraft", false);
	}
	// 申請モード(差戻)
	if (modeCardEdit == MODE_APPLICATION_REVERT) {
		// 申請/下書ボタン押下可
		setDisabled("btnRegist", false);
		setDisabled("btnDraft", true);
	}
	// 申請モード(申請済或いは休日承認済)
	if(modeCardEdit == MODE_APPLICATION_APPLIED || modeCardEdit == MODE_APPLICATION_COMPLETED_HOLIDAY) {
		// チェックボックス編集不可
		setDisabled("ckbDirectStart", true);
		setDisabled("ckbDirectEnd", true);
		// 申請/下書ボタン押下不可
		setDisabled("btnSelect", true);
		setDisabled("btnRegist", true);
		setDisabled("btnDraft", true);
	}
}

/**
 * テキストエリア桁数設定。
 */
function isMaxlength(obj) {
	var mlength = obj.getAttribute ? parseInt(obj.getAttribute("maxlength")) : "";
	if (obj.getAttribute && obj.value.length > mlength) {
		obj.value = obj.value.substring(0, mlength);
	}
}

function checkDraftTimes(aryMessage, event) {
	var aryTimeHour = new Array("txtStartTimeHour", "txtEndTimeHour");
	var aryTimeMinute = new Array("txtStartTimeMinute", "txtEndTimeMinute");
	// 時刻チェック
	checkDraftTime(aryTimeHour[0], aryTimeMinute[0], aryMessage);
	// エラーが発生したら処理を終了する
	if (aryMessage.length != 0) {
		return;
	}
	// 時刻チェック
	checkDraftTime(aryTimeHour[1], aryTimeMinute[1], aryMessage);
	// エラーが発生したら処理を終了する
	if (aryMessage.length != 0) {
		return;
	}
	checkTimes(aryMessage, event);
	checkDirect(aryMessage);
}

function checkRegistTimes(aryMessage, event) {
	var aryTimeHour = new Array("txtStartTimeHour", "txtEndTimeHour");
	var aryTimeMinute = new Array("txtStartTimeMinute", "txtEndTimeMinute");
	// 時刻チェック
	checkTime(aryTimeHour[0], aryTimeMinute[0], aryMessage);
	// エラーが発生したら処理を終了する
	if (aryMessage.length != 0) {
		return;
	}
	// 時刻チェック
	checkTime(aryTimeHour[1], aryTimeMinute[1], aryMessage);
	// エラーが発生したら処理を終了する
	if (aryMessage.length != 0) {
		return;
	}
	checkTimes(aryMessage, event);
	checkDirect(aryMessage);
}

/**
 * 始業/終業時刻、休憩1～6、公用外出1～2、私用外出1～2の時刻チェックを行う。<br>
 * 全て存在しており、一つでも入力されていたら時刻の妥当性確認を行う。<br>
 * @param aryMessage メッセージ配列
 * @param event      イベントオブジェクト
 */
function checkTimes(aryMessage, event) {
	var rep= "";
	var aryTimeHour = new Array("txtStartTimeHour", "txtEndTimeHour");
	var aryTimeMinute = new Array("txtStartTimeMinute", "txtEndTimeMinute");
	var aryStartTimeHour = new Array("txtRestStartHour1", "txtRestStartHour2", "txtRestStartHour3", 
			"txtRestStartHour4", "txtRestStartHour5", "txtRestStartHour6", "txtPublicStartHour1", 
			"txtPublicStartHour2", "txtPrivateStartHour1", "txtPrivateStartHour2");
	var aryStartTimeMinute = new Array("txtRestStartMinute1", "txtRestStartMinute2", "txtRestStartMinute3", 
			"txtRestStartMinute4", "txtRestStartMinute5", "txtRestStartMinute6", "txtPublicStartMinute1", 
			"txtPublicStartMinute2", "txtPrivateStartMinute1", "txtPrivateStartMinute2");
	var aryEndTimeHour = new Array("txtRestEndHour1", "txtRestEndHour2", "txtRestEndHour3", "txtRestEndHour4", 
			"txtRestEndHour5", "txtRestEndHour6", "txtPublicEndHour1", "txtPublicEndHour2", "txtPrivateEndHour1", 
			"txtPrivateEndHour2");
	var aryEndTimeMinute = new Array("txtRestEndMinute1", "txtRestEndMinute2", "txtRestEndMinute3", 
			"txtRestEndMinute4", "txtRestEndMinute5", "txtRestEndMinute6", "txtPublicEndMinute1", 
			"txtPublicEndMinute2", "txtPrivateEndMinute1", "txtPrivateEndMinute2");
	var startTimeHour = "";
	var startTimeMinute = "";
	var endTimeHour = "";
	var endTimeMinute = "";

	// 休憩1～6、公用外出1～2、私用外出1～2の時刻チェックと相関チェック
	for(var i = 0; i < aryStartTimeHour.length; i++) {
		rep = getLabel(aryStartTimeHour[i]);
		startTimeHour = getFormValue(aryStartTimeHour[i]);
		startTimeMinute = getFormValue(aryStartTimeMinute[i]);
		endTimeHour = getFormValue(aryEndTimeHour[i]);
		endTimeMinute = getFormValue(aryEndTimeMinute[i]);
		// 項目のどれか一つでも入力されていたら相関チェックを行う
		if(startTimeHour != "" || startTimeMinute != "" || endTimeHour != "" || endTimeMinute != "") {
			if(startTimeHour == "" || startTimeMinute == "" || endTimeHour == "" || endTimeMinute == "") {
				if (aryMessage.length == 0) {
					setFocus(aryStartTimeHour[i]);
				}
				setBgColor(aryStartTimeHour[i], COLOR_FIELD_ERROR);
				aryMessage.push(getMessage(MSG_REQUIRED, rep));
				return;
			}
			// 時刻チェック
			rep = getLabel(aryStartTimeHour[i]);
			checkTime(aryStartTimeHour[i], aryStartTimeMinute[i], aryMessage);
			// エラーが発生したら処理を終了する
			if (aryMessage.length != 0) {
				return;
			}
			rep = getLabel(aryEndTimeHour[i]);
			checkTime(aryEndTimeHour[i], aryEndTimeMinute[i], aryMessage);
			// エラーが発生したら処理を終了する
			if (aryMessage.length != 0) {
				return;
			}
			var startTime = startTimeHour * 60 + parseIntDecimal(startTimeMinute);
			var endTime = endTimeHour * 60 + parseIntDecimal(endTimeMinute);
			if (startTime != 0 || endTime != 0) {
				if (startTime < getFormValue(aryTimeHour[0]) * 60 + parseIntDecimal(getFormValue(aryTimeMinute[0]))) {
					setBgColor(aryStartTimeHour[i], COLOR_FIELD_ERROR);
					setBgColor(aryStartTimeMinute[i], COLOR_FIELD_ERROR);
					aryMessage.push(getMessage(MSG_REST_CHECK, getLabel(aryStartTimeHour[i])));
					return;
				}
				if (endTime > getFormValue(aryTimeHour[1]) * 60 + parseIntDecimal(getFormValue(aryTimeMinute[1]))) {
					setBgColor(aryEndTimeHour[i], COLOR_FIELD_ERROR);
					setBgColor(aryEndTimeMinute[i], COLOR_FIELD_ERROR);
					aryMessage.push(getMessage(MSG_REST_CHECK, getLabel(aryStartTimeHour[i])));
					return;
				}
				if (startTime > endTime) {
					setBgColor(aryEndTimeHour[i], COLOR_FIELD_ERROR);
					setBgColor(aryEndTimeMinute[i], COLOR_FIELD_ERROR);
					var repArray = [getLabel(aryStartTimeHour[i]), getLabel(aryStartTimeHour[i])];
					aryMessage.push(getMessage(MSG_END_TIME_CHECK, repArray));
					return;
				}
			}
		}
	}
}

function checkDraftTime(targetHour, targetMinute, aryMessage) {
	// 範囲宣言
	var MIN_HOUR = 0;
	var MAX_HOUR = 47;
	var MIN_MINUTE = 0;
	var MAX_MINUTE = 59;
	// 時分を取得
	var hour = getFormValue(targetHour);
	var minute = getFormValue(targetMinute);
	var isHourEmpty = hour == "";
	var isMinuteEmpty = minute == "";
	if (isHourEmpty && isMinuteEmpty) {
		return;
	}
	// 時間確認
	if (isHourEmpty) {
		if (aryMessage.length == 0) {
			setFocus(targetHour);
		}
		setBgColor(targetHour, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage(MSG_HOUR_CHECK, 47));
	} else {
		if (hour < MIN_HOUR || hour > MAX_HOUR) {
			if (aryMessage.length == 0) {
				setFocus(targetHour);
			}
			setBgColor(targetHour, COLOR_FIELD_ERROR);
			aryMessage.push(getMessage(MSG_HOUR_CHECK, 47));
		}
	}
	// 分確認
	if (isMinuteEmpty) {
		if (aryMessage.length == 0) {
			setFocus(targetMinute);
		}
		setBgColor(targetMinute, COLOR_FIELD_ERROR);
		aryMessage.push(getMessage(MSG_MINUTE_CHECK, null));
	} else {
		if (minute < MIN_MINUTE || minute > MAX_MINUTE) {
			if (aryMessage.length == 0) {
				setFocus(targetMinute);
			}
			setBgColor(targetMinute, COLOR_FIELD_ERROR);
			aryMessage.push(getMessage(MSG_MINUTE_CHECK, null));
		}
	}
}

/**
 * @param aryMessage メッセージ配列
 * @return 無し
 */
function checkDirect(aryMessage) {
	if (isCheckableChecked("ckbDirectStart") || isCheckableChecked("ckbDirectEnd")) {
		// 直行又は直帰にチェックされている場合は勤怠コメントを必須とする
		checkRequired("txtTimeComment", aryMessage);
	}
}

/**
 * 文字列を整数に変換する。
 * @param string 解析する文字列
 */
function parseIntDecimal(string) {
	return parseInt(string, 10);
}
