<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software: you can redistribute it and/or
modify it under the terms of the GNU Affero General Public License
as published by the Free Software Foundation, either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
--%>
<%@ page
language     = "java"
pageEncoding = "UTF-8"
buffer       = "128kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@page 
import = "jp.mosp.framework.base.MospParams"
import = "jp.mosp.framework.constant.MospConst"
import = "jp.mosp.framework.utils.HtmlUtility"
import = "jp.mosp.platform.comparator.base.ActivateDateComparator"
import = "jp.mosp.platform.comparator.base.InactivateComparator"
import = "jp.mosp.platform.constant.PlatformConst"
import = "jp.mosp.platform.utils.PlatformUtility"
import = "jp.mosp.time.comparator.settings.PaidHolidayMasterPaidHolidayAbbrComparator"
import = "jp.mosp.time.comparator.settings.PaidHolidayMasterPaidHolidayCodeComparator"
import = "jp.mosp.time.comparator.settings.PaidHolidayMasterPaidHolidayNameComparator"
import = "jp.mosp.time.comparator.settings.PaidHolidayMasterPaidHolidayTypeComparator"
import = "jp.mosp.time.settings.action.PaidHolidayCardAction"
import = "jp.mosp.time.settings.action.PaidHolidayListAction"
import = "jp.mosp.time.settings.vo.PaidHolidayListVo"
%><%
MospParams params = (MospParams)request.getAttribute(MospConst.ATT_MOSP_PARAMS);
PaidHolidayListVo vo = (PaidHolidayListVo)params.getVo();
%>
<div class="List" id="divSearch">
	<table class="InputTable">
		<tr>
			<th class="ListTableTh" colspan="6">
			<span class="TitleTh"><%= params.getName("Search") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><span class="RequiredLabel">*&nbsp;</span><%= params.getName("ActivateDate") %></td>
			<td class="InputTd" id="tdActivateDate">
				<input type="text" class="Number4RequiredTextBox" id="txtSearchActivateYear" name="txtSearchActivateYear" value="<%= HtmlUtility.escapeHTML(vo.getTxtSearchActivateYear()) %>" />
				<label for="txtSearchActivateYear"><%= params.getName("Year") %></label>
				<input type="text" class="Number2RequiredTextBox" id="txtSearchActivateMonth" name="txtSearchActivateMonth" value="<%= HtmlUtility.escapeHTML(vo.getTxtSearchActivateMonth()) %>" />
				<label for="txtSearchActivateMonth"><%= params.getName("Month") %></label>
				<input type="text" class="Number2RequiredTextBox" id="txtSearchActivateDay" name="txtSearchActivateDay" value="<%= HtmlUtility.escapeHTML(vo.getTxtSearchActivateDay()) %>" />
				<label for="txtSearchActivateDay"><%= params.getName("Day") %></label>
			</td>
			<td class="TitleTd"><label for="txtSearchPaidHolidayName"><%= params.getName("PaidHolidayType") %></label></td>
			<td class="InputTd">
				<select class="Name3PullDown" id="pltSearchPaidHolidayType" name="pltSearchPaidHolidayType">
					<option value=""></option>
					<%= HtmlUtility.getSelectOption(vo.getAryPltSearchPaidHolidayType(), vo.getPltSearchPaidHolidayType()) %>
				</select>
			</td>
			<td class="TitleTd"><label for="txtSearchPaidHolidayName"><%= params.getName("PaidHoliday") %><%= params.getName("Code") %></label></td>
			<td class="InputTd"><input type="text" class="Code10TextBox" id="txtSearchPaidHolidayCode" name="txtSearchPaidHolidayCode" value="<%= HtmlUtility.escapeHTML(vo.getTxtSearchPaidHolidayCode()) %>" /></td>
		</tr>
		<tr>
			<td class="TitleTd"><label for="txtSearchPaidHolidayName"><%= params.getName("PaidHoliday") %><%= params.getName("Name") %></label></td>
			<td class="InputTd"><input type="text" class="Name15TextBox" id="txtSearchPaidHolidayName" name="txtSearchPaidHolidayName" value="<%= HtmlUtility.escapeHTML(vo.getTxtSearchPaidHolidayName()) %>" /></td>
			<td class="TitleTd"><label for="txtSearchPaidHolidayAbbr"><%= params.getName("PaidHoliday") %><%= params.getName("Abbreviation") %></label></td>
			<td class="InputTd"><input type="text" class="Name3TextBox" id="txtSearchPaidHolidayAbbr" name="txtSearchPaidHolidayAbbr" value="<%= HtmlUtility.escapeHTML(vo.getTxtSearchPaidHolidayAbbr()) %>" /></td>
			<td class="TitleTd"><label for="pltSearchInactivate"><%= params.getName("Effectiveness") %><%= params.getName("Slash") %><%= params.getName("Inactivate") %></label></td>
			<td class="InputTd">
			<select class="Name2PullDown" id="pltSearchInactivate" name="pltSearchInactivate">
				<%= HtmlUtility.getSelectOption(params, PlatformConst.CODE_KEY_INACTIVATE_FLAG, vo.getPltSearchInactivate(), true) %>
			</select>
			</td>
		</tr>
	</table>
	<table class="ButtonTable">
		<tr>
			<td class="ButtonTd" id="">
				<button type="button" id="btnRegist" class="Name2Button" onclick="submitForm(event, 'divSearch', null, '<%= PaidHolidayListAction.CMD_SEARCH %>')"><%= params.getName("Search") %></button>
			</td>
		</tr>
	</table>
</div>
<%= HtmlUtility.getListInfoFlex(params, vo.getList(), vo.getPageCommand(), vo.getDataPerPage(), vo.getSelectIndex()) %>
<div class="FixList">
	<table class="LeftListTable" id="list">
		<tr>
			<th class="ListSortTh" id="thButton"></th>
			<th class="ListSortTh" id="ththActivateDate" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= ActivateDateComparator.class.getName() %>'), '<%= PaidHolidayListAction.CMD_SORT %>')"><%= params.getName("ActivateDate") %><%= PlatformUtility.getSortMark(ActivateDateComparator.class.getName(), params) %></th>
			<th class="ListSortTh" id="thPaidHolidayType" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= PaidHolidayMasterPaidHolidayTypeComparator.class.getName() %>'), '<%= PaidHolidayListAction.CMD_SORT %>')"><%= params.getName("PaidHolidayType") %><%= PlatformUtility.getSortMark(PaidHolidayMasterPaidHolidayTypeComparator.class.getName(), params) %></th>
			<th class="ListSortTh" id="thPaidHolidayCode" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= PaidHolidayMasterPaidHolidayCodeComparator.class.getName() %>'), '<%= PaidHolidayListAction.CMD_SORT %>')"><%= params.getName("PaidHoliday") %><%= params.getName("Code") %><%= PlatformUtility.getSortMark(PaidHolidayMasterPaidHolidayCodeComparator.class.getName(), params) %></th>
			<th class="ListSortTh" id="thPaidHolidayName" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= PaidHolidayMasterPaidHolidayNameComparator.class.getName() %>'), '<%= PaidHolidayListAction.CMD_SORT %>')"><%= params.getName("PaidHoliday") %><%= params.getName("Name") %><%= PlatformUtility.getSortMark(PaidHolidayMasterPaidHolidayNameComparator.class.getName(), params) %></th>
			<th class="ListSortTh" id="thPaidHolidayAbbr" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= PaidHolidayMasterPaidHolidayAbbrComparator.class.getName() %>'), '<%= PaidHolidayListAction.CMD_SORT %>')"><%= params.getName("PaidHoliday") %><%= params.getName("Abbreviation") %><%= PlatformUtility.getSortMark(PaidHolidayMasterPaidHolidayAbbrComparator.class.getName(), params) %></th>
			<th class="ListSortTh" id="thInactivate" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_SORT_KEY %>', '<%= InactivateComparator.class.getName() %>'), '<%= PaidHolidayListAction.CMD_SORT %>')"><%= params.getName("EffectivenessExistence") %><%= params.getName("Slash") %><%= params.getName("InactivateExistence") %><%= PlatformUtility.getSortMark(InactivateComparator.class.getName(), params) %></th>
<%--
			<th class="ListSortTh" id="thSelect">
<%
if (vo.getAryLblActivateDate().length > 0) {
%>
				<input type="checkbox" class="" id="ckbSelect" onclick="doAllBoxChecked(this);">
<%
}
%>
			</th>
--%>
		</tr>
<%
for (int i = 0; i < vo.getAryLblActivateDate().length; i++) {
%>
		<tr>
			<td class="ListSelectTd">
				<button type="button" onclick="submitTransfer(event, null, null, new Array('<%= PlatformConst.PRM_TRANSFERRED_ACTIVATE_DATE %>', '<%= HtmlUtility.escapeHTML(vo.getAryLblActivateDate()[i]) %>', '<%= PlatformConst.PRM_TRANSFERRED_CODE %>' , '<%= HtmlUtility.escapeHTML(vo.getAryLblPaidHolidayCode()[i]) %>'), '<%= PaidHolidayCardAction.CMD_SELECT_SHOW %>')"><%= params.getName("Detail") %></button>
			</td>
			<td class="ListInputTd" id=""><%= HtmlUtility.escapeHTML(vo.getAryLblActivateDate()[i]) %></td>
			<td class="ListSelectTd" id=""><%= HtmlUtility.escapeHTML(vo.getAryLblPaidHolidayType()[i]) %></td>
			<td class="ListInputTd"  id=""><%= HtmlUtility.escapeHTML(vo.getAryLblPaidHolidayCode()[i]) %></td>
			<td class="ListInputTd"  id=""><%= HtmlUtility.escapeHTML(vo.getAryLblPaidHolidayName()[i]) %></td>
			<td class="ListInputTd"  id=""><%= HtmlUtility.escapeHTML(vo.getAryLblPaidHolidayAbbr()[i]) %></td>
			<td class="ListSelectTd" id=""><%= HtmlUtility.escapeHTML(vo.getAryLblInactivate()[i]) %></td>
<%--
			<td class="ListSelectTd" id=""><input type="checkbox" class="" name="ckbSelect" value="<%= vo.getAryCkbPaidHolidayListId()[i] %>"></td>
--%>
		</tr>
<%
}
%>
	</table>
</div>
<%-- 
<%
if (vo.getAryLblActivateDate().length > 0) {
%>
<div class="List" id="divUpdate">
	<table class="InputTable">
		<tr>
			<th class="UpdateTableTh" colspan="4">
				<span class="TitleTh"><%= params.getName("Bulk") %><%= params.getName("Update") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><span class="RequiredLabel">*&nbsp;</span><%= params.getName("ActivateDate") %></td>
			<td class="InputTd">
				<input type="text" class="Number4RequiredTextBox" id="txtUpdateActivateYear" name="txtUpdateActivateYear" value="<%= HtmlUtility.escapeHTML(vo.getTxtUpdateActivateYear()) %>" />
				<label for="txtUpdateActivateYear"><%= params.getName("Year") %></label>
				<input type="text" class="Number2RequiredTextBox" id="txtUpdateActivateMonth" name="txtUpdateActivateMonth" value="<%= HtmlUtility.escapeHTML(vo.getTxtUpdateActivateMonth()) %>" />
				<label for="txtUpdateActivateMonth"><%= params.getName("Month") %></label>
				<input type="text" class="Number2RequiredTextBox" id="txtUpdateActivateDay" name="txtUpdateActivateDay" value="<%= HtmlUtility.escapeHTML(vo.getTxtUpdateActivateDay()) %>" />
				<label for="txtUpdateActivateDay"><%= params.getName("Day") %></label>
			</td>
			<td class="TitleTd"><%= params.getName("Effectiveness") %><%= params.getName("Slash") %><%= params.getName("Inactivate") %></td>
			<td class="InputTd">
				<select id="pltUpdateInactivate" name="pltUpdateInactivate">
					<%= HtmlUtility.getSelectOption(params, PlatformConst.CODE_KEY_INACTIVATE_FLAG, vo.getPltUpdateInactivate(), false) %>
				</select>
			</td>
		</tr>
	</table>
	<table class="ButtonTable">
		<tr>
			<td class="ButtonTd" id="">
				<button type="button" id="btnRegist" class="Name2Button" onclick="submitRegist(event, 'divUpdate', checkExtra, '<%= PaidHolidayListAction.CMD_BATCH_UPDATE %>')"><%= params.getName("Update") %></button>
			</td>
		</tr>
	</table>
</div>
<%
}
%>
--%>
<div class="Button">
	<button type="button" class="Name4Button" onclick="submitTransfer(event, null, null, null, '<%= PaidHolidayCardAction.CMD_SHOW %>');"><%= params.getName("New") %><%= params.getName("Insert") %></button>
</div>
<%
if (vo.getAryLblActivateDate().length > 0) {
%>
<div class="MoveUpLink" id="divMoveUp">
	<a onclick="pageToTop()"><%= params.getName("UpperTriangular") %><%= params.getName("TopOfPage") %></a>
</div>
<%
}
%>
