/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import net.sf.jasperreports.charts.ChartContext;
import net.sf.jasperreports.charts.ChartTheme;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.fill.JRFillCategoryDataset;
import net.sf.jasperreports.charts.fill.JRFillChartAxis;
import net.sf.jasperreports.charts.fill.JRFillGanttDataset;
import net.sf.jasperreports.charts.fill.JRFillHighLowDataset;
import net.sf.jasperreports.charts.fill.JRFillMultiAxisPlot;
import net.sf.jasperreports.charts.fill.JRFillPieDataset;
import net.sf.jasperreports.charts.fill.JRFillTimePeriodDataset;
import net.sf.jasperreports.charts.fill.JRFillTimeSeriesDataset;
import net.sf.jasperreports.charts.fill.JRFillXyDataset;
import net.sf.jasperreports.charts.fill.JRFillXyzDataset;
import net.sf.jasperreports.charts.type.AxisPositionEnum;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.charts.util.CategoryChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.ChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.charts.util.HighLowChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.charts.util.MultiAxisChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.PieChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.TimePeriodChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.TimeSeriesChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.XYChartHyperlinkProvider;
import net.sf.jasperreports.engine.JRAbstractChartCustomizer;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.LineBoxWrapper;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.general.Dataset;

public class JRFillChart
extends JRFillElement
implements JRChart {
    protected byte chartType;
    protected JRFont titleFont;
    protected JRFont subtitleFont;
    protected JRFont legendFont;
    protected final JRLineBox lineBox;
    protected JRGroup evaluationGroup;
    protected JRFillChartDataset dataset;
    protected JRChartPlot plot;
    protected JRRenderable renderer;
    private String anchorName;
    private String hyperlinkReference;
    private String hyperlinkAnchor;
    private Integer hyperlinkPage;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    protected String customizerClass;
    protected JRChartCustomizer chartCustomizer;
    protected String renderType;
    protected String themeName;
    protected JFreeChart jfreeChart;
    protected ChartHyperlinkProvider chartHyperlinkProvider;

    protected JRFillChart(JRBaseFiller filler, JRChart chart, JRFillObjectFactory factory) {
        super(filler, chart, factory);
        this.chartType = chart.getChartType();
        switch (this.chartType) {
            case 1: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 3: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 2: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                break;
            }
            case 4: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyzDataset((JRXyzDataset)chart.getDataset()));
                this.plot = factory.getBubblePlot((JRBubblePlot)chart.getPlot());
                break;
            }
            case 5: {
                this.dataset = (JRFillChartDataset)((Object)factory.getHighLowDataset((JRHighLowDataset)chart.getDataset()));
                this.plot = factory.getCandlestickPlot((JRCandlestickPlot)chart.getPlot());
                break;
            }
            case 6: {
                this.dataset = (JRFillChartDataset)((Object)factory.getHighLowDataset((JRHighLowDataset)chart.getDataset()));
                this.plot = factory.getHighLowPlot((JRHighLowPlot)chart.getPlot());
                break;
            }
            case 7: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            case 17: {
                this.dataset = (JRFillChartDataset)((Object)factory.getValueDataset((JRValueDataset)chart.getDataset()));
                this.plot = factory.getMeterPlot((JRMeterPlot)chart.getPlot());
                break;
            }
            case 19: {
                this.plot = factory.getMultiAxisPlot((JRMultiAxisPlot)chart.getPlot());
                this.dataset = ((JRFillMultiAxisPlot)this.plot).getMainDataset();
                break;
            }
            case 9: {
                this.dataset = (JRFillChartDataset)((Object)factory.getPieDataset((JRPieDataset)chart.getDataset()));
                this.plot = factory.getPiePlot((JRPiePlot)chart.getPlot());
                break;
            }
            case 8: {
                this.dataset = (JRFillChartDataset)((Object)factory.getPieDataset((JRPieDataset)chart.getDataset()));
                this.plot = factory.getPie3DPlot((JRPie3DPlot)chart.getPlot());
                break;
            }
            case 10: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                this.plot = factory.getScatterPlot((JRScatterPlot)chart.getPlot());
                break;
            }
            case 12: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 11: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                break;
            }
            case 18: {
                this.dataset = (JRFillChartDataset)((Object)factory.getValueDataset((JRValueDataset)chart.getDataset()));
                this.plot = factory.getThermometerPlot((JRThermometerPlot)chart.getPlot());
                break;
            }
            case 16: {
                this.dataset = (JRFillChartDataset)((Object)factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset()));
                this.plot = factory.getTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot());
                break;
            }
            case 13: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 14: {
                switch (chart.getDataset().getDatasetType()) {
                    case 6: {
                        this.dataset = (JRFillChartDataset)((Object)factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset()));
                        break;
                    }
                    case 5: {
                        this.dataset = (JRFillChartDataset)((Object)factory.getTimePeriodDataset((JRTimePeriodDataset)chart.getDataset()));
                        break;
                    }
                    case 3: {
                        this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                    }
                }
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 15: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            case 20: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 21: {
                this.dataset = (JRFillChartDataset)((Object)factory.getGanttDataset((JRGanttDataset)chart.getDataset()));
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
        this.titleFont = new JRBaseFont(chart, chart.getTitleFont());
        this.subtitleFont = new JRBaseFont(chart, chart.getSubtitleFont());
        this.legendFont = new JRBaseFont(chart, chart.getLegendFont());
        this.lineBox = chart.getLineBox().clone(this);
        this.evaluationGroup = factory.getGroup(chart.getEvaluationGroup());
        this.customizerClass = chart.getCustomizerClass();
        if (this.customizerClass != null && this.customizerClass.length() > 0) {
            try {
                Class myClass = JRClassLoader.loadClassForName(this.customizerClass);
                this.chartCustomizer = (JRChartCustomizer)myClass.newInstance();
            }
            catch (Exception e) {
                throw new JRRuntimeException("Could not create chart customizer instance.", e);
            }
            if (this.chartCustomizer instanceof JRAbstractChartCustomizer) {
                ((JRAbstractChartCustomizer)this.chartCustomizer).init(filler, this);
            }
        }
        this.renderType = chart.getRenderType();
        if (this.renderType == null) {
            this.renderType = JRProperties.getProperty(this.getParentProperties(), "net.sf.jasperreports.chart.render.type");
        }
        this.themeName = chart.getTheme();
        if (this.themeName == null) {
            this.themeName = JRProperties.getProperty(this.getParentProperties(), "net.sf.jasperreports.chart.theme");
        }
    }

    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode((JRCommonElement)this, ModeEnum.TRANSPARENT);
    }

    public boolean isShowLegend() {
        return ((JRChart)this.parent).isShowLegend();
    }

    public void setShowLegend(boolean isShowLegend) {
    }

    public Boolean getShowLegend() {
        return ((JRChart)this.parent).getShowLegend();
    }

    public void setShowLegend(Boolean isShowLegend) {
    }

    public String getRenderType() {
        return this.renderType;
    }

    public void setRenderType(String renderType) {
    }

    public String getTheme() {
        return this.themeName;
    }

    public void setTheme(String theme) {
    }

    public byte getEvaluationTime() {
        return this.getEvaluationTimeValue().getValue();
    }

    public EvaluationTimeEnum getEvaluationTimeValue() {
        return ((JRChart)this.parent).getEvaluationTimeValue();
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getPen());
    }

    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getPen());
    }

    public void setBorder(byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.getLineBox().getPen());
    }

    public void setBorder(Byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.getLineBox().getPen());
    }

    public Color getBorderColor() {
        return this.getLineBox().getPen().getLineColor();
    }

    public Color getOwnBorderColor() {
        return this.getLineBox().getPen().getOwnLineColor();
    }

    public void setBorderColor(Color borderColor) {
        this.getLineBox().getPen().setLineColor(borderColor);
    }

    public int getPadding() {
        return this.getLineBox().getPadding();
    }

    public Integer getOwnPadding() {
        return this.getLineBox().getOwnPadding();
    }

    public void setPadding(int padding) {
        this.getLineBox().setPadding(padding);
    }

    public void setPadding(Integer padding) {
        this.getLineBox().setPadding(padding);
    }

    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getTopPen());
    }

    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getTopPen());
    }

    public void setTopBorder(byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.getLineBox().getTopPen());
    }

    public void setTopBorder(Byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.getLineBox().getTopPen());
    }

    public Color getTopBorderColor() {
        return this.getLineBox().getTopPen().getLineColor();
    }

    public Color getOwnTopBorderColor() {
        return this.getLineBox().getTopPen().getOwnLineColor();
    }

    public void setTopBorderColor(Color topBorderColor) {
        this.getLineBox().getTopPen().setLineColor(topBorderColor);
    }

    public int getTopPadding() {
        return this.getLineBox().getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.getLineBox().getOwnTopPadding();
    }

    public void setTopPadding(int topPadding) {
        this.getLineBox().setTopPadding(topPadding);
    }

    public void setTopPadding(Integer topPadding) {
        this.getLineBox().setTopPadding(topPadding);
    }

    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getLeftPen());
    }

    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getLeftPen());
    }

    public void setLeftBorder(byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.getLineBox().getLeftPen());
    }

    public void setLeftBorder(Byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.getLineBox().getLeftPen());
    }

    public Color getLeftBorderColor() {
        return this.getLineBox().getLeftPen().getLineColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.getLineBox().getLeftPen().getOwnLineColor();
    }

    public void setLeftBorderColor(Color leftBorderColor) {
        this.getLineBox().getLeftPen().setLineColor(leftBorderColor);
    }

    public int getLeftPadding() {
        return this.getLineBox().getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.getLineBox().getOwnLeftPadding();
    }

    public void setLeftPadding(int leftPadding) {
        this.getLineBox().setLeftPadding(leftPadding);
    }

    public void setLeftPadding(Integer leftPadding) {
        this.getLineBox().setLeftPadding(leftPadding);
    }

    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getBottomPen());
    }

    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getBottomPen());
    }

    public void setBottomBorder(byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.getLineBox().getBottomPen());
    }

    public void setBottomBorder(Byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.getLineBox().getBottomPen());
    }

    public Color getBottomBorderColor() {
        return this.getLineBox().getBottomPen().getLineColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.getLineBox().getBottomPen().getOwnLineColor();
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
        this.getLineBox().getBottomPen().setLineColor(bottomBorderColor);
    }

    public int getBottomPadding() {
        return this.getLineBox().getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.getLineBox().getOwnBottomPadding();
    }

    public void setBottomPadding(int bottomPadding) {
        this.getLineBox().setBottomPadding(bottomPadding);
    }

    public void setBottomPadding(Integer bottomPadding) {
        this.getLineBox().setBottomPadding(bottomPadding);
    }

    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.getLineBox().getRightPen());
    }

    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.getLineBox().getRightPen());
    }

    public void setRightBorder(byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.getLineBox().getRightPen());
    }

    public void setRightBorder(Byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.getLineBox().getRightPen());
    }

    public Color getRightBorderColor() {
        return this.getLineBox().getRightPen().getLineColor();
    }

    public Color getOwnRightBorderColor() {
        return this.getLineBox().getRightPen().getOwnLineColor();
    }

    public void setRightBorderColor(Color rightBorderColor) {
        this.getLineBox().getRightPen().setLineColor(rightBorderColor);
    }

    public int getRightPadding() {
        return this.getLineBox().getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.getLineBox().getOwnRightPadding();
    }

    public void setRightPadding(int rightPadding) {
        this.getLineBox().setRightPadding(rightPadding);
    }

    public void setRightPadding(Integer rightPadding) {
        this.getLineBox().setRightPadding(rightPadding);
    }

    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public byte getTitlePosition() {
        return this.getTitlePositionValue() == null ? EdgeEnum.TOP.getValue() : this.getTitlePositionValue().getValue();
    }

    public void setTitlePosition(byte titlePosition) {
        throw new UnsupportedOperationException();
    }

    public Byte getTitlePositionByte() {
        return this.getTitlePositionValue() == null ? null : this.getTitlePositionValue().getValueByte();
    }

    public void setTitlePosition(Byte titlePosition) {
        throw new UnsupportedOperationException();
    }

    public EdgeEnum getTitlePositionValue() {
        return ((JRChart)this.parent).getTitlePositionValue();
    }

    public void setTitlePosition(EdgeEnum titlePosition) {
        throw new UnsupportedOperationException();
    }

    public Color getTitleColor() {
        return JRStyleResolver.getTitleColor(this);
    }

    public Color getOwnTitleColor() {
        return ((JRChart)this.parent).getOwnTitleColor();
    }

    public void setTitleColor(Color titleColor) {
    }

    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public Color getOwnSubtitleColor() {
        return ((JRChart)this.parent).getOwnSubtitleColor();
    }

    public Color getSubtitleColor() {
        return JRStyleResolver.getSubtitleColor(this);
    }

    public void setSubtitleColor(Color subtitleColor) {
    }

    public Color getOwnLegendColor() {
        return ((JRChart)this.parent).getOwnLegendColor();
    }

    public Color getLegendColor() {
        return JRStyleResolver.getLegendColor(this);
    }

    public void setLegendColor(Color legendColor) {
    }

    public Color getOwnLegendBackgroundColor() {
        return ((JRChart)this.parent).getOwnLegendBackgroundColor();
    }

    public Color getLegendBackgroundColor() {
        return JRStyleResolver.getLegendBackgroundColor(this);
    }

    public void setLegendBackgroundColor(Color legendBackgroundColor) {
    }

    public JRFont getLegendFont() {
        return this.legendFont;
    }

    public byte getLegendPosition() {
        return this.getLegendPositionValue() == null ? EdgeEnum.BOTTOM.getValue() : this.getLegendPositionValue().getValue();
    }

    public void setLegendPosition(byte legendPosition) {
        throw new UnsupportedOperationException();
    }

    public Byte getLegendPositionByte() {
        return this.getLegendPositionValue() == null ? null : Byte.valueOf(this.getLegendPositionValue().getValue());
    }

    public void setLegendPosition(Byte legendPosition) {
        throw new UnsupportedOperationException();
    }

    public EdgeEnum getLegendPositionValue() {
        return ((JRChart)this.parent).getLegendPositionValue();
    }

    public void setLegendPosition(EdgeEnum legendPosition) {
        throw new UnsupportedOperationException();
    }

    public JRExpression getTitleExpression() {
        return ((JRChart)this.parent).getTitleExpression();
    }

    public JRExpression getSubtitleExpression() {
        return ((JRChart)this.parent).getSubtitleExpression();
    }

    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return ((JRChart)this.parent).getHyperlinkTypeValue();
    }

    public byte getHyperlinkTarget() {
        return ((JRChart)this.parent).getHyperlinkTarget();
    }

    public JRExpression getAnchorNameExpression() {
        return ((JRChart)this.parent).getAnchorNameExpression();
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRChart)this.parent).getHyperlinkReferenceExpression();
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRChart)this.parent).getHyperlinkAnchorExpression();
    }

    public JRExpression getHyperlinkPageExpression() {
        return ((JRChart)this.parent).getHyperlinkPageExpression();
    }

    public Locale getLocale() {
        return this.filler.getLocale();
    }

    public TimeZone getTimeZone() {
        return this.filler.getTimeZone();
    }

    public JRChartDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRFillChartDataset dataset) {
        this.dataset = dataset;
    }

    public JRChartPlot getPlot() {
        return this.plot;
    }

    protected JRRenderable getRenderer() {
        return this.renderer;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    protected JRTemplateImage getJRTemplateImage() {
        return (JRTemplateImage)this.getElementTemplate();
    }

    protected JRTemplateElement createElementTemplate() {
        return new JRTemplateImage(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
    }

    protected void rewind() {
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) && this.getEvaluationTimeValue() == EvaluationTimeEnum.NOW) {
            this.evaluateRenderer(evaluation);
        }
    }

    protected void evaluateRenderer(byte evaluation) throws JRException {
        JFreeChart chart = this.evaluateChart(evaluation);
        Rectangle2D.Double rectangle = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        this.renderer = ChartUtil.getChartRendererFactory(this.getRenderType()).getRenderer(chart, this.chartHyperlinkProvider, rectangle);
    }

    protected ChartHyperlinkProvider getHyperlinkProvider() {
        return this.chartHyperlinkProvider;
    }

    protected JFreeChart evaluateChart(byte evaluation) throws JRException {
        this.evaluateProperties(evaluation);
        this.evaluateDatasetRun(evaluation);
        ChartTheme theme = ChartUtil.getChartTheme(this.themeName);
        if (this.getChartType() == 19) {
            this.createMultiAxisChart(evaluation);
        } else {
            this.jfreeChart = theme.createChart(new FillChartContext(evaluation));
            this.chartHyperlinkProvider = this.createChartHyperlinkProvider();
        }
        if (this.chartCustomizer != null) {
            this.chartCustomizer.customize(this.jfreeChart, this);
        }
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), evaluation);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), evaluation);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this, this.expressionEvaluator, evaluation);
        return this.jfreeChart;
    }

    protected boolean prepare(int availableHeight, boolean isOverflow) {
        boolean willOverflow = false;
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.getEvaluationTimeValue() == EvaluationTimeEnum.NOW) {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && this.getRenderer() == null) {
                isToPrint = false;
            }
        } else {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected JRPrintElement fill() {
        JRTemplatePrintImage printImage = new JRTemplatePrintImage(this.getJRTemplateImage());
        printImage.setX(this.getX());
        printImage.setY(this.getRelativeY());
        printImage.setWidth(this.getWidth());
        printImage.setHeight(this.getStretchHeight());
        EvaluationTimeEnum evaluationTime = this.getEvaluationTimeValue();
        if (evaluationTime == EvaluationTimeEnum.NOW) {
            this.copy(printImage);
        } else {
            this.filler.addBoundElement((JRFillElement)this, (JRPrintElement)printImage, evaluationTime, this.getEvaluationGroup(), this.band);
        }
        return printImage;
    }

    protected void copy(JRPrintImage printImage) {
        printImage.setRenderer(this.getRenderer());
        printImage.setAnchorName(this.getAnchorName());
        printImage.setHyperlinkReference(this.getHyperlinkReference());
        printImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
        printImage.setHyperlinkPage(this.getHyperlinkPage());
        printImage.setHyperlinkTooltip(this.getHyperlinkTooltip());
        printImage.setBookmarkLevel(this.getBookmarkLevel());
        printImage.setHyperlinkParameters(this.hyperlinkParameters);
        this.transferProperties(printImage);
    }

    public byte getChartType() {
        return this.chartType;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitChart(this);
    }

    protected ChartHyperlinkProvider createChartHyperlinkProvider() {
        ChartHyperlinkProvider chartHyperlinkProvider = null;
        block0 : switch (this.getChartType()) {
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 20: {
                chartHyperlinkProvider = new CategoryChartHyperlinkProvider(((JRFillCategoryDataset)this.getDataset()).getItemHyperlinks());
                break;
            }
            case 4: {
                chartHyperlinkProvider = new XYChartHyperlinkProvider(((JRFillXyzDataset)this.getDataset()).getItemHyperlinks());
                break;
            }
            case 10: 
            case 13: 
            case 15: {
                chartHyperlinkProvider = new XYChartHyperlinkProvider(((JRFillXyDataset)this.getDataset()).getItemHyperlinks());
                break;
            }
            case 5: 
            case 6: {
                chartHyperlinkProvider = new HighLowChartHyperlinkProvider(((JRFillHighLowDataset)this.getDataset()).getItemHyperlinks());
                break;
            }
            case 19: {
                break;
            }
            case 8: 
            case 9: {
                chartHyperlinkProvider = new PieChartHyperlinkProvider(((JRFillPieDataset)this.getDataset()).getSectionHyperlinks());
                break;
            }
            case 16: {
                chartHyperlinkProvider = new TimeSeriesChartHyperlinkProvider(((JRFillTimeSeriesDataset)this.getDataset()).getItemHyperlinks());
                break;
            }
            case 14: {
                switch (this.getDataset().getDatasetType()) {
                    case 6: {
                        chartHyperlinkProvider = new TimeSeriesChartHyperlinkProvider(((JRFillTimeSeriesDataset)this.getDataset()).getItemHyperlinks());
                        break block0;
                    }
                    case 5: {
                        chartHyperlinkProvider = new TimePeriodChartHyperlinkProvider(((JRFillTimePeriodDataset)this.getDataset()).getItemHyperlinks());
                        break block0;
                    }
                    case 3: {
                        chartHyperlinkProvider = new XYChartHyperlinkProvider(((JRFillXyDataset)this.getDataset()).getItemHyperlinks());
                        break block0;
                    }
                }
                break;
            }
            case 21: {
                chartHyperlinkProvider = new CategoryChartHyperlinkProvider(((JRFillGanttDataset)this.getDataset()).getItemHyperlinks());
                break;
            }
            case 17: 
            case 18: {
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type " + this.getChartType() + " not supported.");
            }
        }
        return chartHyperlinkProvider;
    }

    protected void createMultiAxisChart(byte evaluation) throws JRException {
        Plot mainPlot = null;
        JRFillMultiAxisPlot jrPlot = (JRFillMultiAxisPlot)this.getPlot();
        MultiAxisChartHyperlinkProvider multiHyperlinkProvider = new MultiAxisChartHyperlinkProvider();
        Iterator iter = jrPlot.getAxes().iterator();
        if (iter.hasNext()) {
            JRFillChartAxis axis = (JRFillChartAxis)iter.next();
            JRFillChart fillChart = axis.getFillChart();
            this.jfreeChart = fillChart.evaluateChart(evaluation);
            mainPlot = this.jfreeChart.getPlot();
            ChartHyperlinkProvider axisHyperlinkProvider = fillChart.getHyperlinkProvider();
            if (mainPlot instanceof CategoryPlot) {
                CategoryPlot categoryPlot = (CategoryPlot)mainPlot;
                categoryPlot.setRangeAxisLocation(0, this.getChartAxisLocation(axis));
                if (axisHyperlinkProvider != null) {
                    multiHyperlinkProvider.addHyperlinkProvider((Dataset)categoryPlot.getDataset(), axisHyperlinkProvider);
                }
            } else if (mainPlot instanceof XYPlot) {
                XYPlot xyPlot = (XYPlot)mainPlot;
                xyPlot.setRangeAxisLocation(0, this.getChartAxisLocation(axis));
                if (axisHyperlinkProvider != null) {
                    multiHyperlinkProvider.addHyperlinkProvider((Dataset)xyPlot.getDataset(), axisHyperlinkProvider);
                }
            }
        }
        int axisNumber = 0;
        while (iter.hasNext()) {
            CategoryPlot axisPlot;
            ++axisNumber;
            JRFillChartAxis chartAxis = (JRFillChartAxis)iter.next();
            JRFillChart fillChart = chartAxis.getFillChart();
            JFreeChart axisChart = fillChart.evaluateChart(evaluation);
            ChartHyperlinkProvider axisHyperlinkProvider = fillChart.getHyperlinkProvider();
            if (mainPlot instanceof CategoryPlot) {
                CategoryPlot mainCatPlot = (CategoryPlot)mainPlot;
                if (!(axisChart.getPlot() instanceof CategoryPlot)) {
                    throw new JRException("You can not mix plot types in a MultiAxisChart");
                }
                axisPlot = (CategoryPlot)axisChart.getPlot();
                mainCatPlot.setRangeAxis(axisNumber, axisPlot.getRangeAxis());
                mainCatPlot.setRangeAxisLocation(axisNumber, this.getChartAxisLocation(chartAxis));
                mainCatPlot.setDataset(axisNumber, axisPlot.getDataset());
                mainCatPlot.mapDatasetToRangeAxis(axisNumber, axisNumber);
                mainCatPlot.setRenderer(axisNumber, axisPlot.getRenderer());
                this.configureAxisSeriesColors(axisPlot.getRenderer(), fillChart.getPlot());
                if (axisHyperlinkProvider == null) continue;
                multiHyperlinkProvider.addHyperlinkProvider((Dataset)axisPlot.getDataset(), axisHyperlinkProvider);
                continue;
            }
            if (mainPlot instanceof XYPlot) {
                XYPlot mainXyPlot = (XYPlot)mainPlot;
                if (!(axisChart.getPlot() instanceof XYPlot)) {
                    throw new JRException("You can not mix plot types in a MultiAxisChart");
                }
                axisPlot = (XYPlot)axisChart.getPlot();
                mainXyPlot.setRangeAxis(axisNumber, axisPlot.getRangeAxis());
                mainXyPlot.setRangeAxisLocation(axisNumber, this.getChartAxisLocation(chartAxis));
                mainXyPlot.setDataset(axisNumber, axisPlot.getDataset());
                mainXyPlot.mapDatasetToRangeAxis(axisNumber, axisNumber);
                mainXyPlot.setRenderer(axisNumber, axisPlot.getRenderer());
                this.configureAxisSeriesColors(axisPlot.getRenderer(), fillChart.getPlot());
                if (axisHyperlinkProvider == null) continue;
                multiHyperlinkProvider.addHyperlinkProvider((Dataset)axisPlot.getDataset(), axisHyperlinkProvider);
                continue;
            }
            throw new JRException("MultiAxis charts only support Category and XY plots.");
        }
        this.chartHyperlinkProvider = multiHyperlinkProvider;
    }

    private void configureAxisSeriesColors(CategoryItemRenderer renderer, JRChartPlot jrPlot) {
        SortedSet seriesColors = jrPlot.getSeriesColors();
        if (seriesColors != null) {
            for (JRChartPlot.JRSeriesColor seriesColor : seriesColors) {
                renderer.setSeriesPaint(seriesColor.getSeriesOrder(), (Paint)seriesColor.getColor());
            }
        }
    }

    private void configureAxisSeriesColors(XYItemRenderer renderer, JRChartPlot jrPlot) {
        SortedSet seriesColors = jrPlot.getSeriesColors();
        if (seriesColors != null) {
            for (JRChartPlot.JRSeriesColor seriesColor : seriesColors) {
                renderer.setSeriesPaint(seriesColor.getSeriesOrder(), (Paint)seriesColor.getColor());
            }
        }
    }

    protected Range convertRange(JRDataRange dataRange, byte evaluation) throws JRException {
        if (dataRange == null) {
            return null;
        }
        Number low = (Number)this.evaluateExpression(dataRange.getLowExpression(), evaluation);
        Number high = (Number)this.evaluateExpression(dataRange.getHighExpression(), evaluation);
        return new Range(low != null ? low.doubleValue() : 0.0, high != null ? high.doubleValue() : 100.0);
    }

    protected MeterInterval convertInterval(JRMeterInterval interval, byte evaluation) throws JRException {
        String label = interval.getLabel();
        if (label == null) {
            label = "";
        }
        Range range = this.convertRange(interval.getDataRange(), evaluation);
        Color color = interval.getBackgroundColor();
        float[] components = color.getRGBColorComponents(null);
        float alpha = interval.getAlphaDouble() == null ? 1.0f : interval.getAlphaDouble().floatValue();
        Color alphaColor = new Color(components[0], components[1], components[2], alpha);
        return new MeterInterval(label, range, (Paint)alphaColor, null, (Paint)alphaColor);
    }

    protected AxisLocation getChartAxisLocation(JRFillChartAxis chartAxis) {
        return chartAxis.getPositionValue() != null && chartAxis.getPositionValue() == AxisPositionEnum.RIGHT_OR_BOTTOM ? AxisLocation.BOTTOM_OR_RIGHT : AxisLocation.TOP_OR_LEFT;
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateRenderer(evaluation);
        this.copy((JRPrintImage)element);
    }

    public int getBookmarkLevel() {
        return ((JRChart)this.parent).getBookmarkLevel();
    }

    public String getCustomizerClass() {
        return this.customizerClass;
    }

    private void evaluateDatasetRun(byte evaluation) throws JRException {
        this.dataset.evaluateDatasetRun(evaluation);
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return null;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRChart)this.parent).getHyperlinkParameters();
    }

    public String getLinkType() {
        return ((JRChart)this.parent).getLinkType();
    }

    public String getLinkTarget() {
        return ((JRChart)this.parent).getLinkTarget();
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRChart)this.parent).getHyperlinkTooltipExpression();
    }

    class FillChartContext
    implements ChartContext {
        private final byte evaluation;

        protected FillChartContext(byte evaluation) {
            this.evaluation = evaluation;
        }

        public Object evaluateExpression(JRExpression expression) throws JRException {
            return JRFillChart.this.evaluateExpression(expression, this.evaluation);
        }

        public JRChart getChart() {
            return JRFillChart.this;
        }

        public Dataset getDataset() {
            return ((JRFillChartDataset)JRFillChart.this.getDataset()).getDataset();
        }

        public Object getLabelGenerator() {
            return ((JRFillChartDataset)JRFillChart.this.getDataset()).getLabelGenerator();
        }

        public Locale getLocale() {
            return JRFillChart.this.getLocale();
        }

        public TimeZone getTimeZone() {
            return JRFillChart.this.getTimeZone();
        }

        public byte getEvaluation() {
            return JRFillChart.this.getEvaluationTimeValue().getValue();
        }
    }
}

