/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.report.bean;

import java.util.Date;

import jp.mosp.framework.base.MospException;

/**
 * 予定簿作成インターフェース。
 */
public interface ScheduleBookBeanInterface {
	
	/**
	 * MosPアプリケーション設定キー(テンプレートファイルパス：出勤簿)。<br>
	 * 出力ファイル名としても用いられる。<br>
	 */
	public static final String	APP_REPORT_ATTENDANCE_BOOK	= "attendanceBook.pdf";
	

	/**
	 * 個人ID及び対象日で予定簿を作成する。<br>
	 * @param personalId 取得対象個人ID
	 * @param targetDate 取得対象日
	 * @throws MospException インスタンスの取得或いはSQL実行に失敗した場合
	 */
	void makeScheduleBook(String personalId, Date targetDate) throws MospException;
	
	/**
	 * 個人ID及び年月で予定簿を作成する。<br>
	 * @param personalId 取得対象個人ID
	 * @param year       取得対象年
	 * @param month      取得対象月
	 * @throws MospException インスタンスの取得或いはSQL実行に失敗した場合
	 */
	void makeScheduleBook(String personalId, int year, int month) throws MospException;
	
	/**
	 * 個人ID及び年月で予定簿を作成する。<br>
	 * @param personalIds 取得対象個人ID配列
	 * @param year        取得対象年
	 * @param month       取得対象月
	 * @throws MospException インスタンスの取得或いはSQL実行に失敗した場合
	 */
	void makeScheduleBooks(String[] personalIds, int year, int month) throws MospException;
	
}
