/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.bean;

import java.util.List;

import jp.mosp.framework.base.MospException;

/**
 * エクスポートテーブル参照インターフェース。
 */
public interface ExportTableReferenceBeanInterface {
	
	/**
	 * テーブル内容表示欄を取得する。
	 * @param table テーブル
	 * @param selectSelectedArray テーブル内容選択欄配列
	 * @return テーブル内容表示欄
	 */
	String[][] getSelectTable(String table, String[][] selectSelectedArray);
	
	/**
	 * テーブル内容選択欄を取得する。
	 * @param exportCode エクスポートコード
	 * @return テーブル内容選択欄
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	String[][] getSelectSelected(String exportCode) throws MospException;
	
	/**
	 * エクスポートを行う。<br>
	 * @param exportCode エクスポートコード
	 * @param startYear 開始年
	 * @param startMonth 開始月
	 * @param endYear 終了年
	 * @param endMonth 終了月
	 * @param cutoffCode 締日コード
	 * @param workPlaceCode 勤務地コード
	 * @param employmentCode 雇用契約コード
	 * @param sectionCode 所属コード
	 * @param positionCode 職位コード
	 * @return エクスポートリスト
	 * @throws MospException インスタンスの取得、或いはSQL実行に失敗した場合
	 */
	List<String[]> export(String exportCode, int startYear, int startMonth, int endYear, int endMonth,
			String cutoffCode, String workPlaceCode, String employmentCode, String sectionCode, String positionCode)
			throws MospException;
	
}
