/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.human.vo;

import jp.mosp.platform.human.base.PlatformHumanVo;

/**
 * 人事情報一覧画面の情報を格納する。<br>
 */
public class HumanInfoVo extends PlatformHumanVo {
	
	private static final long	serialVersionUID	= -7529586050432800847L;
	
	/**
	 * 入社日。<br>
	 */
	private String				lblEntranceDate;
	/**
	 * 雇用契約。<br>
	 */
	private String				lblEmployment;
	/**
	 * 社員名(ｶﾅ)。<br>
	 */
	private String				lblEmployeeKana;
	/**
	 * 勤務地。<br>
	 */
	private String				lblWorkPlace;
	/**
	 * 所属。<br>
	 */
	private String				lblSection;
	/**
	 * 役職。<br>
	 */
	private String				lblPosition;
	/**
	 * 退職日。<br>
	 */
	private String				lblRetirementDate;
	/**
	 * 退職理由。<br>
	 */
	private String				lblRetirementReason;
	/**
	 * 詳細。<br>
	 */
	private String				lblRetirementDetail;
	/**
	 * 休職開始日。<br>
	 */
	private String[]			arySuspensionStartDate;
	/**
	 * 休職終了日。<br>
	 */
	private String[]			arySuspensionEndDate;
	/**
	 * 休職終了予定日。<br>
	 */
	private String[]			arySuspensionsScheduleEndDate;
	/**
	 * 休職理由。<br>
	 */
	private String[]			arySuspensionReason;
	/**
	 * 開始日(兼務)。<br>
	 */
	private String[]			aryConcurrentStartDate;
	/**
	 * 終了日(兼務)。<br>
	 */
	private String[]			aryConcurrentEndDate;
	/**
	 * 所属略称(兼務)。<br>
	 */
	private String[]			aryConcurrentSectionAbbr;
	/**
	 * 職位略称(兼務)。<br>
	 */
	private String[]			aryConcurrentPositionAbbr;
	/**
	 * 備考(兼務)。<br>
	 */
	private String[]			aryConcurrentRemark;
	

	/**
	 * @param lblEntranceDate セットする lblEntranceDate
	 */
	public void setLblEntranceDate(String lblEntranceDate) {
		this.lblEntranceDate = lblEntranceDate;
	}
	
	/**
	 * @return lblEntranceDate
	 */
	public String getLblEntranceDate() {
		return lblEntranceDate;
	}
	
	/**
	 * @param lblEmployment セットする lblEmployment
	 */
	public void setLblEmployment(String lblEmployment) {
		this.lblEmployment = lblEmployment;
	}
	
	/**
	 * @return lblEmployment
	 */
	public String getLblEmployment() {
		return lblEmployment;
	}
	
	/**
	 * @return lblEmployeeKana
	 */
	public String getLblEmployeeKana() {
		return lblEmployeeKana;
	}
	
	/**
	 * @param lblEmployeeKana セットする lblEmployeeKana
	 */
	public void setLblEmployeeKana(String lblEmployeeKana) {
		this.lblEmployeeKana = lblEmployeeKana;
	}
	
	/**
	 * @return lblWorkPlace
	 */
	public String getLblWorkPlace() {
		return lblWorkPlace;
	}
	
	/**
	 * @param lblWorkPlace セットする lblWorkPlace
	 */
	public void setLblWorkPlace(String lblWorkPlace) {
		this.lblWorkPlace = lblWorkPlace;
	}
	
	/**
	 * @param lblPosition セットする lblPosition
	 */
	public void setLblPosition(String lblPosition) {
		this.lblPosition = lblPosition;
	}
	
	/**
	 * @return lblPosition
	 */
	public String getLblPosition() {
		return lblPosition;
	}
	
	/**
	 * @param lblRetirementDate セットする lblRetirementDate
	 */
	public void setLblRetirementDate(String lblRetirementDate) {
		this.lblRetirementDate = lblRetirementDate;
	}
	
	/**
	 * @return lblRetirementDate
	 */
	public String getLblRetirementDate() {
		return lblRetirementDate;
	}
	
	/**
	 * @param lblRetirementReason セットする lblRetirementReason
	 */
	public void setLblRetirementReason(String lblRetirementReason) {
		this.lblRetirementReason = lblRetirementReason;
	}
	
	/**
	 * @return lblRetirementReason
	 */
	public String getLblRetirementReason() {
		return lblRetirementReason;
	}
	
	/**
	 * @param lblRetirementDetail セットする lblRetirementDetail
	 */
	public void setLblRetirementDetail(String lblRetirementDetail) {
		this.lblRetirementDetail = lblRetirementDetail;
	}
	
	/**
	 * @return lblRetirementDetail
	 */
	public String getLblRetirementDetail() {
		return lblRetirementDetail;
	}
	
	/**
	 * @param arySuspensionStartDate セットする arySuspensionStartDate
	 */
	public void setArySuspensionStartDate(String[] arySuspensionStartDate) {
		this.arySuspensionStartDate = getStringArrayClone(arySuspensionStartDate);
	}
	
	/**
	 * @return arySuspensionStartDate
	 */
	public String[] getArySuspensionStartDate() {
		return getStringArrayClone(arySuspensionStartDate);
	}
	
	/**
	 * @param arySuspensionEndDate セットする arySuspensionEndDate
	 */
	public void setArySuspensionEndDate(String[] arySuspensionEndDate) {
		this.arySuspensionEndDate = getStringArrayClone(arySuspensionEndDate);
	}
	
	/**
	 * @return arySuspensionEndDate
	 */
	public String[] getArySuspensionEndDate() {
		return getStringArrayClone(arySuspensionEndDate);
	}
	
	/**
	 * @param arySuspensionsScheduleEndDate セットする arySuspensionsScheduleEndDate
	 */
	public void setArySuspensionsScheduleEndDate(String[] arySuspensionsScheduleEndDate) {
		this.arySuspensionsScheduleEndDate = getStringArrayClone(arySuspensionsScheduleEndDate);
	}
	
	/**
	 * @return arySuspensionsScheduleEndDate
	 */
	public String[] getArySuspensionsScheduleEndDate() {
		return getStringArrayClone(arySuspensionsScheduleEndDate);
	}
	
	/**
	 * @param arySuspensionReason セットする arySuspensionReason
	 */
	public void setArySuspensionReason(String[] arySuspensionReason) {
		this.arySuspensionReason = getStringArrayClone(arySuspensionReason);
	}
	
	/**
	 * @return arySuspensionReason
	 */
	public String[] getArySuspensionReason() {
		return getStringArrayClone(arySuspensionReason);
	}
	
	/**
	 * @param aryConcurrentStartDate セットする aryConcurrentStartDate
	 */
	public void setAryConcurrentStartDate(String[] aryConcurrentStartDate) {
		this.aryConcurrentStartDate = getStringArrayClone(aryConcurrentStartDate);
	}
	
	/**
	 * @return aryConcurrentStartDate
	 */
	public String[] getAryConcurrentStartDate() {
		return getStringArrayClone(aryConcurrentStartDate);
	}
	
	/**
	 * @param aryConcurrentEndDate セットする aryConcurrentEndDate
	 */
	public void setAryConcurrentEndDate(String[] aryConcurrentEndDate) {
		this.aryConcurrentEndDate = getStringArrayClone(aryConcurrentEndDate);
	}
	
	/**
	 * @return aryConcurrentEndDate
	 */
	public String[] getAryConcurrentEndDate() {
		return getStringArrayClone(aryConcurrentEndDate);
	}
	
	/**
	 * @param aryConcurrentSectionAbbr セットする aryConcurrentSectionAbbr
	 */
	public void setAryConcurrentSectionAbbr(String[] aryConcurrentSectionAbbr) {
		this.aryConcurrentSectionAbbr = getStringArrayClone(aryConcurrentSectionAbbr);
	}
	
	/**
	 * @return aryConcurrentSectionAbbr
	 */
	public String[] getAryConcurrentSectionAbbr() {
		return getStringArrayClone(aryConcurrentSectionAbbr);
	}
	
	/**
	 * @param aryConcurrentPositionAbbr セットする aryConcurrentPositionAbbr
	 */
	public void setAryConcurrentPositionAbbr(String[] aryConcurrentPositionAbbr) {
		this.aryConcurrentPositionAbbr = getStringArrayClone(aryConcurrentPositionAbbr);
	}
	
	/**
	 * @return aryConcurrentPositionAbbr
	 */
	public String[] getAryConcurrentPositionAbbr() {
		return getStringArrayClone(aryConcurrentPositionAbbr);
	}
	
	/**
	 * @param aryConcurrentRemark セットする aryConcurrentRemark
	 */
	public void setAryConcurrentRemark(String[] aryConcurrentRemark) {
		this.aryConcurrentRemark = getStringArrayClone(aryConcurrentRemark);
	}
	
	/**
	 * @return aryConcurrentRemark
	 */
	public String[] getAryConcurrentRemark() {
		return getStringArrayClone(aryConcurrentRemark);
	}
	
	/**
	 * @param lblSection セットする lblSection
	 */
	public void setLblSection(String lblSection) {
		this.lblSection = lblSection;
	}
	
	/**
	 * @return lblSection
	 */
	public String getLblSection() {
		return lblSection;
	}
	
}
