/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.human.base;

import jp.mosp.platform.base.PlatformVo;

/**
 * MosPプラットフォーム人事管理におけるVOの基本となる情報を格納する。<br>
 */
public abstract class PlatformHumanVo extends PlatformVo {
	
	private static final long	serialVersionUID	= -8491195829751058929L;
	

	/**
	 * VOの初期設定を行う。<br>
	 * <br>
	 */
	public PlatformHumanVo() {
		// 処理無し
	}
	

	/**
	 * 対象社員コード。<br>
	 * 各画面では、この社員コードを用いて情報の検索を行う。<br>
	 */
	private String	employeeCode;
	
	/**
	 * 対象有効日。<br>
	 * 各画面では、この有効日を用いて情報の検索を行う。<br>
	 */
	private String	activateDate;
	
	/**
	 * 対象個人ID。<br>
	 * 対象社員コード及び対象有効日で取得した個人IDを格納する。<br>
	 */
	private String	personalId;
	
	/**
	 * 社員名。<br>
	 */
	private String	lblEmployeeName;
	
	/**
	 * 次社員コード。<br>
	 */
	private String	lblNextEmployeeCode;
	/**
	 * 前社員コード。<br>
	 */
	private String	lblBackEmployeeCode;
	
	/**
	 * 再表示有効日(年)。<br>
	 */
	private String	txtSearchActivateYear;
	/**
	 * 再表示有効日(月)。<br>
	 */
	private String	txtSearchActivateMonth;
	/**
	 * 再表示有効日(日)。<br>
	 */
	private String	txtSearchActivateDay;
	
	/**
	 * 検索社員コード<br>
	 */
	private String	txtSearchEmployeeCode;
	
	/**
	 * 人事管理共通情報表示モード。<br>
	 */
	private String	modeHumanLayout;
	
	/**
	 * 検索時コマンド<br>
	 */
	private String	cmdSaerch;
	

	/**
	 * @return employeeCode
	 */
	public String getEmployeeCode() {
		return employeeCode;
	}
	
	/**
	 * @param employeeCode セットする employeeCode
	 */
	public void setEmployeeCode(String employeeCode) {
		this.employeeCode = employeeCode;
	}
	
	/**
	 * @return activateDate
	 */
	public String getActivateDate() {
		return activateDate;
	}
	
	/**
	 * @param activateDate セットする activateDate
	 */
	public void setActivateDate(String activateDate) {
		this.activateDate = activateDate;
	}
	
	/**
	 * @return personalId
	 */
	public String getPersonalId() {
		return personalId;
	}
	
	/**
	 * @param personalId セットする personalId
	 */
	public void setPersonalId(String personalId) {
		this.personalId = personalId;
	}
	
	/**
	 * @return cmdSaerch
	 */
	public String getCmdSaerch() {
		return cmdSaerch;
	}
	
	/**
	 * @param cmdSaerch セットする cmdSaerch
	 */
	public void setCmdSaerch(String cmdSaerch) {
		this.cmdSaerch = cmdSaerch;
	}
	
	/**
	 * @return txtSearchActivateYear
	 */
	public String getTxtSearchActivateYear() {
		return txtSearchActivateYear;
	}
	
	/**
	 * @param txtSearchActivateYear セットする txtSearchActivateYear
	 */
	public void setTxtSearchActivateYear(String txtSearchActivateYear) {
		this.txtSearchActivateYear = txtSearchActivateYear;
	}
	
	/**
	 * @return txtSearchActivateMonth
	 */
	public String getTxtSearchActivateMonth() {
		return txtSearchActivateMonth;
	}
	
	/**
	 * @param txtSearchActivateMonth セットする txtSearchActivateMonth
	 */
	public void setTxtSearchActivateMonth(String txtSearchActivateMonth) {
		this.txtSearchActivateMonth = txtSearchActivateMonth;
	}
	
	/**
	 * @return txtSearchActivateDay
	 */
	public String getTxtSearchActivateDay() {
		return txtSearchActivateDay;
	}
	
	/**
	 * @param txtSearchActivateDay セットする txtSearchActivateDay
	 */
	public void setTxtSearchActivateDay(String txtSearchActivateDay) {
		this.txtSearchActivateDay = txtSearchActivateDay;
	}
	
	/**
	 * @return txtSearchEmployeeCode
	 */
	public String getTxtSearchEmployeeCode() {
		return txtSearchEmployeeCode;
	}
	
	/**
	 * @param txtSearchEmployeeCode セットする txtSearchEmployeeCode
	 */
	public void setTxtSearchEmployeeCode(String txtSearchEmployeeCode) {
		this.txtSearchEmployeeCode = txtSearchEmployeeCode;
	}
	
	/**
	 * @return lblEmployeeName
	 */
	public String getLblEmployeeName() {
		return lblEmployeeName;
	}
	
	/**
	 * @param lblEmployeeName セットする lblEmployeeName
	 */
	public void setLblEmployeeName(String lblEmployeeName) {
		this.lblEmployeeName = lblEmployeeName;
	}
	
	/**
	 * @return lblNextEmployeeCode
	 */
	public String getLblNextEmployeeCode() {
		return lblNextEmployeeCode;
	}
	
	/**
	 * @param lblNextEmployeeCode セットする lblNextEmployeeCode
	 */
	public void setLblNextEmployeeCode(String lblNextEmployeeCode) {
		this.lblNextEmployeeCode = lblNextEmployeeCode;
	}
	
	/**
	 * @return lblBackEmployeeCode
	 */
	public String getLblBackEmployeeCode() {
		return lblBackEmployeeCode;
	}
	
	/**
	 * @param lblBackEmployeeCode セットする lblBackEmployeeCode
	 */
	public void setLblBackEmployeeCode(String lblBackEmployeeCode) {
		this.lblBackEmployeeCode = lblBackEmployeeCode;
	}
	
	/**
	 * @return modeScreenLayout
	 */
	public String getModeHumanLayout() {
		return modeHumanLayout;
	}
	
	/**
	 * @param modeHumanLayout セットする modeHumanLayout
	 */
	public void setModeHumanLayout(String modeHumanLayout) {
		this.modeHumanLayout = modeHumanLayout;
	}
	
}
