<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software: you can redistribute it and/or
modify it under the terms of the GNU Affero General Public License
as published by the Free Software Foundation, either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
--%>
<%@ page
language     = "java"
pageEncoding = "UTF-8"
buffer       = "32kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@page
import = "jp.mosp.framework.base.MospParams"
import = "jp.mosp.framework.constant.MospConst"
import = "jp.mosp.framework.utils.HtmlUtility"
import = "jp.mosp.platform.constant.PlatformConst"
import = "jp.mosp.time.constant.TimeMessageConst"
import = "jp.mosp.time.management.action.ApprovalCardAction"
import = "jp.mosp.time.management.vo.ApprovalCardVo"
import = "jp.mosp.time.constant.TimeConst"
%><%
MospParams params = (MospParams)request.getAttribute(MospConst.ATT_MOSP_PARAMS);
ApprovalCardVo vo = (ApprovalCardVo)params.getVo();
%>
<div class="ListHeader">
	<table class="EmployeeLabelTable">
		<jsp:include page="<%= TimeConst.PATH_TIME_COMMON_INFO_JSP %>"flush="false" />
	</table>
	<table class="DateTable">
		<tr>
			<td>&nbsp; 
				<%= vo.getLblYear() %><%= params.getName("Year") %>
				<%= vo.getLblMonth() %><%= params.getName("Month") %>
				<%= vo.getLblDay() %><%= params.getName("Day") %>
			</td>
		</tr>
	</table>
</div>
<div class="FixList">
<%
if (vo.getLblWorkType() != null) {
%>
	<div id="divAttendance">
	<table class="InputTable" id="tblCorrection">
		<tr>
			<th class="ListTableTh" colspan="2"><span class="TitleTh"><%= params.getName("Correction") %><%= params.getName("Information") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Correction") %><%= params.getName("Information") %></td>
			<td class="InputTd"><%= HtmlUtility.escapeHTML(vo.getLblCorrectionHistory()) %></td>
		</tr>
	</table>
	<table class="InputTable" id="tblAttendance">
		<tr>
			<th class="ListTableTh" colspan="6"><span class="TitleTh"><%= params.getName("Attendance") %><%= params.getName("Information") %></span>				
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Work") %><%= params.getName("Form") %></td>
			<td class="InputTd" id="lblWorkType"><%= HtmlUtility.escapeHTML(vo.getLblWorkType()) %>
			</td>
			<td class="TitleTd"><%= params.getName("StartWork") %><%= params.getName("Moment") %></td>
			<td class="InputTd" id="lblStartTime"><%= HtmlUtility.escapeHTML(vo.getLblStartTime()) %>
			</td>
			<td class="TitleTd"><%= params.getName("EndWork") %><%= params.getName("Moment") %></td>
			<td class="InputTd" id="lblEndTime"><%= HtmlUtility.escapeHTML(vo.getLblEndTime()) %>
			</td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Work") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblWorkType"><%= HtmlUtility.escapeHTML(vo.getLblWorkTime()) %></td>
			<td class="TitleTd"><%= params.getName("DirectStart") %><%= params.getName("Slash") %><%= params.getName("DirectEnd") %></td>
			<td class="InputTd" id="lblApprovalState"><%= HtmlUtility.escapeHTML(vo.getLblDirectWorkManage()) %></td>
			<td class="Blank" colspan="2"></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("WorkManage") %><%= params.getName("Comment") %></td>
			<td class="InputTd" id="tdAttendanceComment" colspan="5"><%= HtmlUtility.escapeHTML(vo.getLblTimeComment()) %></td>
		</tr>
	</table>
	<table class="InputTable" id="tblRest">
		<tr>
			<th class="ListTableTh" colspan="6"><span class="TitleTh"><%= params.getName("RestTime") %><%= params.getName("Information") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Legal") %><%= params.getName("Inside") %><%= params.getName("RestTime") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblRestTimeIn"><%= HtmlUtility.escapeHTML(vo.getLblRestTime()) %></td>
			<td class="TitleTd"><%= params.getName("RestTime") %><%= params.getName("No1") %></td>
			<td class="InputTd" id="lblRestTime1"><%= HtmlUtility.escapeHTML(vo.getLblRestTime1()) %></td>
			<td class="TitleTd"><%= params.getName("RestTime") %><%= params.getName("No2") %></td>
			<td class="InputTd" id="lblRestTime2"><%= HtmlUtility.escapeHTML(vo.getLblRestTime2()) %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Legal") %><%= params.getName("Outside") %><%= params.getName("RestTime") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblRestTimeOut"><%= HtmlUtility.escapeHTML(vo.getLblOverRestTime()) %></td>
			<td class="TitleTd"><%= params.getName("RestTime") %><%= params.getName("No3") %></td>
			<td class="InputTd" id="lblRestTime3"><%= HtmlUtility.escapeHTML(vo.getLblRestTime3()) %></td>
			<td class="TitleTd"><%= params.getName("RestTime") %><%= params.getName("No4") %></td>
			<td class="InputTd" id="lblRestTime4"><%= HtmlUtility.escapeHTML(vo.getLblRestTime4()) %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Midnight") %><%= params.getName("RestTime") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblLateRestTime"><%= HtmlUtility.escapeHTML(vo.getLblNightRestTime()) %></td>
			<td class="TitleTd"><%= params.getName("RestTime") %><%= params.getName("No5") %></td>
			<td class="InputTd" id="lblRestTime5"><%= HtmlUtility.escapeHTML(vo.getLblRestTime5()) %></td>
			<td class="TitleTd"><%= params.getName("RestTime") %><%= params.getName("No6") %></td>
			<td class="InputTd" id="lblRestTime6"><%= HtmlUtility.escapeHTML(vo.getLblRestTime6()) %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Official") %><%= params.getName("GoingOut") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblPublicTime"><%= HtmlUtility.escapeHTML(vo.getLblPublicTime()) %></td>
			<td class="TitleTd"><%= params.getName("Official") %><%= params.getName("GoingOut") %><%= params.getName("No1") %></td>
			<td class="InputTd" id="lblPublicTime1"><%= HtmlUtility.escapeHTML(vo.getLblPublicTime1()) %></td>
			<td class="TitleTd"><%= params.getName("Official") %><%= params.getName("GoingOut") %><%= params.getName("No2") %></td>
			<td class="InputTd" id="lblPublicTime2"><%= HtmlUtility.escapeHTML(vo.getLblPublicTime2()) %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Private") %><%= params.getName("GoingOut") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblPrivateTime"><%= HtmlUtility.escapeHTML(vo.getLblPrivateTime()) %></td>
			<td class="TitleTd"><%= params.getName("Private") %><%= params.getName("GoingOut") %><%= params.getName("No1") %></td>
			<td class="InputTd" id="lblPrivateTime1"><%= HtmlUtility.escapeHTML(vo.getLblPrivateTime1()) %></td>
			<td class="TitleTd"><%= params.getName("Private") %><%= params.getName("GoingOut") %><%= params.getName("No2") %></td>
			<td class="InputTd" id="lblPrivateTime2"><%= HtmlUtility.escapeHTML(vo.getLblPrivateTime2()) %></td>
		</tr>
	</table>
	<table class="InputTable" id="tblLateEarly">
		<tr>
			<th class="ListTableTh" colspan="6"><span class="TitleTh"><%= params.getName("Tardiness") %><%= params.getName("LeaveEarly") %><%= params.getName("Information") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Tardiness") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblLateTime"><%= HtmlUtility.escapeHTML(vo.getLblLateTime()) %></td>
			<td class="TitleTd"><%= params.getName("Tardiness") %><%= params.getName("Reason") %></td>
			<td class="InputTd" id="lblLateReason"><%= HtmlUtility.escapeHTML(vo.getLblLateReason()) %></td>
			<td class="TitleTd"><%= params.getName("Certificates") %></td>
			<td class="InputTd" id="lblLateCertificate"><%= HtmlUtility.escapeHTML(vo.getLblLateCertificate()) %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Comment") %></td>
			<td class="InputTd" id="lblLateComment" colspan="5"><%= HtmlUtility.escapeHTML(vo.getLblLateComment()) %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("LeaveEarly") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblLeaveEarlyTime"><%= HtmlUtility.escapeHTML(vo.getLblLeaveEarlyTime()) %></td>
			<td class="TitleTd"><%= params.getName("LeaveEarly") %><%= params.getName("Reason") %></td>
			<td class="InputTd" id="lblLeaveEarlyReason"><%= HtmlUtility.escapeHTML(vo.getLblLeaveEarlyReason()) %></td>
			<td class="TitleTd"><%= params.getName("Certificates") %></td>
			<td class="InputTd" id="lblLeaveEarlyCertificate"><%= HtmlUtility.escapeHTML(vo.getLblLeaveEarlyCertificate()) %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Comment") %></td>
			<td class="InputTd" id="lblLeaveEarlyComment" colspan="5"><%= HtmlUtility.escapeHTML(vo.getLblLeaveEarlyComment()) %></td>
		</tr>
	</table>
	<table class="InputTable" id="tblOverTime">
		<tr>
			<th class="ListTableTh" colspan="6"><span class="TitleTh"><%= params.getName("OvertimeWork") %><%= params.getName("Information") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("OvertimeWork") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblOverTimeIn"><%= HtmlUtility.escapeHTML(vo.getLblOverTimeIn()) %></td>
			<td class="TitleTd"><%= params.getName("Legal") %><%= params.getName("Outside") %><%= params.getName("OvertimeWork") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblOverTimeOut"><%= HtmlUtility.escapeHTML(vo.getLblOverTimeOut()) %></td>
			<td class="TitleTd"><%= params.getName("Midnight") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblLateNightTime"><%= HtmlUtility.escapeHTML(vo.getLblLateNightTime()) %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Prescribed") %><%= params.getName("Holiday") %><%= params.getName("Work") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblSpecificWorkTime"><%= HtmlUtility.escapeHTML(vo.getLblSpecificWorkTimeIn()) %></td>
			<td class="TitleTd"><%= params.getName("Legal") %><%= params.getName("Holiday") %><%= params.getName("Work") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblLegalWorkTime"><%= HtmlUtility.escapeHTML(vo.getLblLegalWorkTime()) %></td>
			<td class="TitleTd"><%= params.getName("Reduced") %><%= params.getName("Target") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblDecreaseTime"><%= HtmlUtility.escapeHTML(vo.getLblDecreaseTime()) %></td>
		</tr>
	</table>
	</div>
	<table class="LeftListTable">
		<tr>
<%
if (vo.isAttendance()) {
%>
			<th class="EditTableTh" colspan="6">
<%
} else {
%>
			<th class="ListTableTh" colspan="6">
<%
}
%>
				<span class="TitleTh"><%= params.getName("WorkManage") %><%= params.getName("Information") %><%= params.getName("Approval") %><%= params.getName("Situation") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd">
				<label for="txtAttendanceComment"><%=params.getName("Comment")%></label>
			</td>
			<td class="InputTd" id="tdApprovalComment" colspan="3">
<%
if (vo.isAttendance() && vo.isNeedApproveButton()) {
%>
				<input type="text" class="Name30TextBox" id="txtAttendanceComment", name="txtAttendanceComment" />
<%
} else {
%>
				<%= HtmlUtility.escapeHTML(vo.getLblAttendanceComment()) %>
<%
}
%>
			</td>
			<td class="TitleTd"><%= params.getName("State") %></td>
			<td class="InputTd" id="lblAttendanceState"><%= HtmlUtility.escapeHTML(vo.getLblAttendanceState()) %></td>
		</tr>
		<tr>
			<td class="Blank" colspan="4">
			<td class="TitleTd"><%= params.getName("Approver") %></td>
			<td class="InputTd" id="lblAttendanceApprover"><%= HtmlUtility.escapeHTML(vo.getLblAttendanceApprover()) %></td>
		</tr>
	</table>
<%
}
if (vo.getLblOverTimeType() != null) {
%>
	<table class="LeftListTable">
		<tr>
<%
if (vo.isOvertime()) {
%>
			<th class="EditTableTh" colspan="6">
<%
} else {
%>
			<th class="ListTableTh" colspan="6">
<%
}
%>
				<span class="TitleTh"><%= params.getName("jp.mosp.time.input.vo.OvertimeRequestVo") %><%= params.getName("Situation") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("OvertimeWork") %><%= params.getName("Type") %></td>
			<td class="InputTd" id="lblOverTimeType"><%= HtmlUtility.escapeHTML(vo.getLblOverTimeType()) %></td>
			<td class="TitleTd"><%= params.getName("Application") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblOverTimeSchedule"><%= HtmlUtility.escapeHTML(vo.getLblOverTimeSchedule()) %></td>
			<td class="TitleTd"><%= params.getName("Performance") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblOverTimeResult"><%= HtmlUtility.escapeHTML(vo.getLblOverTimeResult()) %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("OvertimeWork") %><%= params.getName("Reason") %></td>
			<td class="InputTd" id="lblOverTimeReason" colspan="3"><%= HtmlUtility.escapeHTML(vo.getLblOverTimeReason()) %></td>
			<td class="TitleTd"><%= params.getName("State") %></td>
			<td class="InputTd" id="lblOverTimeState"><%= HtmlUtility.escapeHTML(vo.getLblOverTimeState()) %></td>
		</tr>
		<tr>
			<td class="TitleTd">
				<label for="txtOverTimeComment"><%= params.getName("Comment") %></label>
			</td>
			<td class="InputTd" id="tdApprovalComment" colspan="3">
<%
if (vo.isOvertime() && vo.isNeedApproveButton()) {
%>
				<input type="text" class="Name30TextBox" id="txtOverTimeComment", name="txtOverTimeComment" />
<%
} else {
%>
				<%= HtmlUtility.escapeHTML(vo.getLblOverTimeComment()) %>
<%
}
%>
			</td>
			<td class="TitleTd"><%= params.getName("Approver") %></td>
			<td class="InputTd" id="lblOverTimeApprover"><%= HtmlUtility.escapeHTML(vo.getLblOverTimeApprover()) %></td>
		</tr>
	</table>
<%
}
if (vo.getLblHolidayType() != null) {
%>
	<table class="LeftListTable">
		<tr>
<%
if (vo.isHoliday()) {
%>
			<th class="EditTableTh" colspan="6">
<%
} else {
%>
			<th class="ListTableTh" colspan="6">
<%
}
%>
				<span class="TitleTh"><%= params.getName("jp.mosp.time.input.vo.HolidayRequestVo") %><%= params.getName("Situation") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Vacation") %><%= params.getName("Classification") %></td>
			<td class="InputTd" id="lblHolidayType"><%= HtmlUtility.escapeHTML(vo.getLblHolidayType()) %></td>
			<td class="TitleTd"><%= params.getName("Vacation") %><%= params.getName("Content") %></td>
			<td class="InputTd" id="lblHolidayLength"><%= HtmlUtility.escapeHTML(vo.getLblHolidayLength()) %></td>
			<td class="TitleTd"><%= params.getName("Vacation") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblHolidayTime"><%= HtmlUtility.escapeHTML(vo.getLblHolidayTime()) %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Vacation") %><%= params.getName("Reason") %></td>
			<td class="InputTd" id="lblHolidayReason" colspan="3"><%= HtmlUtility.escapeHTML(vo.getLblHolidayReason()) %></td>
			<td class="TitleTd"><%= params.getName("State") %></td>
			<td class="InputTd" id="lblHolidayState"><%= HtmlUtility.escapeHTML(vo.getLblHolidayState()) %></td>
		</tr>
		<tr>
			<td class="TitleTd">
				<label for="txtHolidayComment"><%= params.getName("Comment") %></label>
			</td>
			<td class="InputTd" id="tdApprovalComment" colspan="3">
<%
if (vo.isHoliday() && vo.isNeedApproveButton()) {
%>
				<input type="text" class="Name30TextBox" id="txtHolidayComment", name="txtHolidayComment" />
<%
} else {
%>
				<%= HtmlUtility.escapeHTML(vo.getLblHolidayComment()) %>
<%
}
%>
			</td>
			<td class="TitleTd"><%= params.getName("Approver") %></td>
			<td class="InputTd" id="lblHolidayApprover"><%= HtmlUtility.escapeHTML(vo.getLblHolidayApprover()) %></td>
	
		</tr>
	</table>
<%
}
if (vo.getLblWorkOnHolidayDate() != null) {
%>
	<table class="LeftListTable">
		<tr>
<%
if (vo.isWorkOnHoliday()) {
%>
			<th class="EditTableTh" colspan="6">
<%
} else {
%>
			<th class="ListTableTh" colspan="6">
<%
}
%>
				<span class="TitleTh"><%= params.getName("jp.mosp.time.input.vo.WorkOnHolidayRequestVo") %><%= params.getName("Situation") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("GoingWork") %><%= params.getName("Day") %></td>
			<td class="InputTd" id="lblWorkOnHolidayDate"><%= HtmlUtility.escapeHTML(vo.getLblWorkOnHolidayDate()) %></td>
			<td class="TitleTd"><%= params.getName("GoingWork") %><%= params.getName("Schedule") %><%= params.getName("Moment") %></td>
			<td class="InputTd" id="lblWorkOnHolidayTime"><%= HtmlUtility.escapeHTML(vo.getLblWorkOnHolidayTime()) %></td>
			<td class="TitleTd"><%= params.getName("Transfer") %><%= params.getName("Day") %></td>
			<td class="InputTd" id="lblWorkOnHolidayTransferDate"><%= HtmlUtility.escapeHTML(vo.getLblWorkOnHolidayTransferDate()) %></td>
	
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Application") %><%= params.getName("Reason") %></td>
			<td class="InputTd" id="lblWorkOnHolidayReason" colspan="3"><%= HtmlUtility.escapeHTML(vo.getLblWorkOnHolidayReason()) %></td>
			<td class="TitleTd"><%= params.getName("State") %></td>
			<td class="InputTd" id="lblWorkOnHolidayState"><%= HtmlUtility.escapeHTML(vo.getLblWorkOnHolidayState()) %></td>
		</tr>
		<tr>
			<td class="TitleTd">
				<label for="txtWorkOnHolidayComment"><%= params.getName("Comment") %></label>
			</td>
			<td class="InputTd" id="tdApprovalComment" colspan="3">
<%
if (vo.isWorkOnHoliday() && vo.isNeedApproveButton()) {
%>
				<input type="text" class="Name30TextBox" id="txtWorkOnHolidayComment", name="txtWorkOnHolidayComment" />
<%
} else {
%>
				<%= HtmlUtility.escapeHTML(vo.getLblWorkOnHolidayComment()) %>
<%
}
%>
			</td>
			<td class="TitleTd"><%= params.getName("Approver") %></td>
			<td class="InputTd" id="lblWorkOnHolidayApprover"><%= HtmlUtility.escapeHTML(vo.getLblWorkOnHolidayApprover()) %></td>
		</tr>
	</table>
<%
}
if (vo.getLblSubHolidayDate() != null) {
%>
	<table class="LeftListTable">
		<tr>
<%
if (vo.isSubHoliday()) {
%>
			<th class="EditTableTh" colspan="6">
<%
} else {
%>
			<th class="ListTableTh" colspan="6">
<%
}
%>
				<span class="TitleTh"><%= params.getName("jp.mosp.time.input.vo.SubHolidayRequestVo") %><%= params.getName("Situation") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("CompensatoryHoliday") %><%= params.getName("Day") %></td>
			<td class="InputTd" id="lblSubHolidayDate"><%= HtmlUtility.escapeHTML(vo.getLblSubHolidayDate()) %></td>
			<td class="TitleTd"><%= params.getName("GoingWork") %><%= params.getName("Day") %></td>
			<td class="InputTd" id="lblSubHolidayWorkDate"><%= HtmlUtility.escapeHTML(vo.getLblSubHolidayWorkDate()) %></td>
			<td class="TitleTd"><%= params.getName("State") %></td>
			<td class="InputTd" id="lblSubHolidayState"><%= HtmlUtility.escapeHTML(vo.getLblSubHolidayState()) %></td>
		</tr>
		<tr>
			<td class="TitleTd">
				<label for="txtCompensationComment"><%= params.getName("Comment") %></label>
			</td>
			<td class="InputTd" id="tdApprovalComment" colspan="3">
<%
if (vo.isSubHoliday() && vo.isNeedApproveButton()) {
%>
				<input type="text" class="Name30TextBox" id="txtCompensationComment", name="txtCompensationComment" />
<%
} else {
%>
				<%= HtmlUtility.escapeHTML(vo.getLblSubHolidayComment()) %>
<%
}
%>
			</td>
			<td class="TitleTd"><%= params.getName("Approver") %></td>
			<td class="InputTd" id="lblSubHolidayApprover"><%= HtmlUtility.escapeHTML(vo.getLblSubHolidayApprover()) %></td>
		</tr>
	</table>
<%
}
if (vo.getLblDifferenceDate() != null) {
%>
	<table class="LeftListTable">
		<tr>
<%
if (vo.isDifference()) {
%>
			<th class="EditTableTh" colspan="6">
<%
} else {
%>
			<th class="ListTableTh" colspan="6">
<%
}
%>
				<span class="TitleTh"><%= params.getName("jp.mosp.time.input.vo.DifferenceRequestVo") %><%= params.getName("Situation") %></span>
			</th>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("GoingWork") %><%= params.getName("Day") %></td>
			<td class="InputTd" id="lblDifferenceDate"><%= HtmlUtility.escapeHTML(vo.getLblDifferenceDate()) %></td>
			<td class="TitleTd"><%= params.getName("Application") %><%= params.getName("Ahead") %><%= params.getName("Work") %><%= params.getName("Form") %></td>
			<td class="InputTd" id="lblDifferenceWorkType"><%= HtmlUtility.escapeHTML(vo.getLblDifferenceWorkType()) %></td>
			<td class="TitleTd"><%= params.getName("Application") %><%= params.getName("Later") %><%= params.getName("Work") %><%= params.getName("Time") %></td>
			<td class="InputTd" id="lblDifferenceWorkTime"><%= HtmlUtility.escapeHTML(vo.getLblDifferenceWorkTime()) %></td>
		</tr>
		<tr>
			<td class="TitleTd"><%= params.getName("Application") %><%= params.getName("Reason") %></td>
			<td class="InputTd" id="lblDifferenceReason" colspan="3"><%= HtmlUtility.escapeHTML(vo.getLblDifferenceReason()) %></td>
			<td class="TitleTd"><%= params.getName("State") %></td>
			<td class="InputTd" id="lblDifferenceState"><%= HtmlUtility.escapeHTML(vo.getLblDifferenceState()) %></td>
		</tr>
		<tr>
			<td class="TitleTd">
				<label for="txtDifferenceComment"><%= params.getName("Comment") %></label>
			</td>
			<td class="InputTd" id="tdApprovalComment" colspan="3">
<%
if (vo.isDifference() && vo.isNeedApproveButton()) {
%>
				<input type="text" class="Name30TextBox" id="txtDifferenceComment", name="txtDifferenceComment" />
<%
} else {
%>
				<%= HtmlUtility.escapeHTML(vo.getLblDifferenceComment()) %>
<%
}
%>
			</td>
			<td class="TitleTd"><%= params.getName("Approver") %></td>
			<td class="InputTd" id="lblDifferenceApprover"><%= HtmlUtility.escapeHTML(vo.getLblDifferenceApprover()) %></td>
		</tr>
<%
}
%>
	</table>
</div>
<div class="Button">
<%
if (vo.isNeedCancelButton()) {
%>
	<button type="button" id="btnDelete" class="Name4Button" onclick="submitDelete(event, null, null, '<%= ApprovalCardAction.CMD_DELETE %>');""><%= params.getName("Approval") %><%= params.getName("Release") %></button>
<%
}
if (vo.isNeedApproveButton()) {
%>
	<button type="button" class="Name4Button" onclick="submitRegist(event, 'ApprovalUpdate', null, '<%= ApprovalCardAction.CMD_APPROVAL %>');""><%= params.getName("Approval") %></button>
	<button type="button" class="Name4Button" onclick="submitRegist(event, 'ApprovalUpdate', checkRevert, '<%= ApprovalCardAction.CMD_REVERTING %>');""><%= params.getName("SendingBack") %></button>
<%
}
%>
</div>
