/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import jp.gr.java_conf.dangan.util.lha.LzssOutputStream;
import jp.gr.java_conf.dangan.util.lha.LzssSearchMethod;

public class SimpleSearch
implements LzssSearchMethod {
    private int DictionarySize;
    private int MaxMatch;
    private int Threshold;
    private byte[] TextBuffer;
    private int DictionaryLimit;

    private SimpleSearch() {
    }

    public SimpleSearch(int DictionarySize, int MaxMatch, int Threshold, byte[] TextBuffer) {
        this.DictionarySize = DictionarySize;
        this.MaxMatch = MaxMatch;
        this.Threshold = Threshold;
        this.TextBuffer = TextBuffer;
        this.DictionaryLimit = this.DictionarySize;
    }

    public void put(int position) {
    }

    public int searchAndPut(int position) {
        int matchlen = this.Threshold - 1;
        int matchpos = position;
        int scanlimit = Math.max(this.DictionaryLimit, position - this.DictionarySize);
        int scanpos = position - 1;
        byte[] buf = this.TextBuffer;
        int max = position + this.MaxMatch;
        int p = 0;
        int s = 0;
        int len = 0;
        while (scanlimit < scanpos) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max <= ++p) break;
            }
            if (matchlen < (len = p - position)) {
                matchpos = scanpos;
                matchlen = len;
                if (this.MaxMatch == len) break;
            }
            --scanpos;
        }
        if (this.Threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    public int search(int position, int lastPutPos) {
        int matchlen = this.Threshold - 1;
        int matchpos = position;
        int scanlimit = Math.max(this.DictionaryLimit, position - this.DictionarySize);
        int scanpos = position - 1;
        byte[] buf = this.TextBuffer;
        int max = Math.min(position + this.MaxMatch, this.TextBuffer.length);
        int p = 0;
        int s = 0;
        int len = 0;
        while (scanlimit < scanpos) {
            s = scanpos;
            p = position;
            while (buf[s] == buf[p]) {
                ++s;
                if (max <= ++p) break;
            }
            if (matchlen < (len = p - position)) {
                matchpos = scanpos;
                matchlen = len;
                if (this.MaxMatch == len) break;
            }
            --scanpos;
        }
        if (this.Threshold <= matchlen) {
            return LzssOutputStream.createSearchReturn(matchlen, matchpos);
        }
        return -1;
    }

    public void slide() {
        this.DictionaryLimit = Math.max(0, this.DictionaryLimit - this.DictionarySize);
    }

    public int putRequires() {
        return 0;
    }
}

