/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.report.dto;

import java.sql.SQLException;
import java.util.List;

import jp.mosp.common.common.BaseDto;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.kintai.common.dto.MKihonDto;
import jp.mosp.kintai.human.dto.MKojinDto;
import jp.mosp.legal.LegalConst;
import jp.mosp.payroll.base.CalculateAction;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.dao.PdPayDeductionDao;
import jp.mosp.payroll.dto.CdAdjustmentDto;
import jp.mosp.payroll.dto.CmCompanyDto;
import jp.mosp.payroll.dto.CmIncomeTaxDto;
import jp.mosp.payroll.dto.CmMidwayEnterDto;
import jp.mosp.payroll.dto.DetailMoneyDto;
import jp.mosp.payroll.dto.PhPaymentDto;

/**
 * @author koike
 *
 */
public class WithholdingListDto extends BaseDto {
	
	private static final long	serialVersionUID	= 2613587750422757053L;
	
	// tB[h
	private String				adjustYearYY;								// NNx(N̂)
	private String				adjustYear;								// NNx
	private String				stationCode;								// R[h
	private String				stationName;								// 
	private String				positionCode;								// EʃR[h
	private String				positionName;								// Eʖ
	private String				touKyu;									// 
																			
	private String				kCode;										// ЈR[h
	private String				kName;										// Ј
	private String				fName;										// tKi
	private String				postalCode;								// X֔ԍ
	private String				address;									// Z
																			
	private String				birthDate;									// N
																			
	private String				paymentMonth01;							// x01
	private String				paymentMonth02;							// x02
	private String				paymentMonth03;							// x03
	private String				paymentMonth04;							// x04
	private String				paymentMonth05;							// x05
	private String				paymentMonth06;							// x06
	private String				paymentMonth07;							// x07
	private String				paymentMonth08;							// x08
	private String				paymentMonth09;							// x09
	private String				paymentMonth10;							// x10
	private String				paymentMonth11;							// x11
	private String				paymentMonth12;							// x12
	private String				paymentPayDay01;							// x01
	private String				paymentPayDay02;							// x02
	private String				paymentPayDay03;							// x03
	private String				paymentPayDay04;							// x04
	private String				paymentPayDay05;							// x05
	private String				paymentPayDay06;							// x06
	private String				paymentPayDay07;							// x07
	private String				paymentPayDay08;							// x08
	private String				paymentPayDay09;							// x09
	private String				paymentPayDay10;							// x10
	private String				paymentPayDay11;							// x11
	private String				paymentPayDay12;							// x12
	private Integer				payTotalAllowance01;						// xz01 
	private Integer				payTotalAllowance02;						// xz02
	private Integer				payTotalAllowance03;						// xz03
	private Integer				payTotalAllowance04;						// xz04
	private Integer				payTotalAllowance05;						// xz05
	private Integer				payTotalAllowance06;						// xz06
	private Integer				payTotalAllowance07;						// xz07
	private Integer				payTotalAllowance08;						// xz08
	private Integer				payTotalAllowance09;						// xz09
	private Integer				payTotalAllowance10;						// xz10
	private Integer				payTotalAllowance11;						// xz11
	private Integer				payTotalAllowance12;						// xz12
	private Integer				payTaxFree01;								// ېŊz01
	private Integer				payTaxFree02;								// ېŊz02
	private Integer				payTaxFree03;								// ېŊz03
	private Integer				payTaxFree04;								// ېŊz04
	private Integer				payTaxFree05;								// ېŊz05
	private Integer				payTaxFree06;								// ېŊz06
	private Integer				payTaxFree07;								// ېŊz07
	private Integer				payTaxFree08;								// ېŊz08
	private Integer				payTaxFree09;								// ېŊz09
	private Integer				payTaxFree10;								// ېŊz10
	private Integer				payTaxFree11;								// ېŊz11
	private Integer				payTaxFree12;								// ېŊz12
	private Integer				payTaxation01;								// ېŎxz01
	private Integer				payTaxation02;								// ېŎxz02
	private Integer				payTaxation03;								// ېŎxz03
	private Integer				payTaxation04;								// ېŎxz04
	private Integer				payTaxation05;								// ېŎxz05
	private Integer				payTaxation06;								// ېŎxz06
	private Integer				payTaxation07;								// ېŎxz07
	private Integer				payTaxation08;								// ېŎxz08
	private Integer				payTaxation09;								// ېŎxz09
	private Integer				payTaxation10;								// ېŎxz10
	private Integer				payTaxation11;								// ېŎxz11
	private Integer				payTaxation12;								// ېŎxz12
	private Integer				paySocInsDeduction01;						// Љی01
	private Integer				paySocInsDeduction02;						// Љی02
	private Integer				paySocInsDeduction03;						// Љی03
	private Integer				paySocInsDeduction04;						// Љی04
	private Integer				paySocInsDeduction05;						// Љی05
	private Integer				paySocInsDeduction06;						// Љی06
	private Integer				paySocInsDeduction07;						// Љی07
	private Integer				paySocInsDeduction08;						// Љی08
	private Integer				paySocInsDeduction09;						// Љی09
	private Integer				paySocInsDeduction10;						// Љی10
	private Integer				paySocInsDeduction11;						// Љی11
	private Integer				paySocInsDeduction12;						// Љی12
	private Integer				payPayInsDeduction01;						// ЉیT̋^̋z01
	private Integer				payPayInsDeduction02;						// ЉیT̋^̋z02
	private Integer				payPayInsDeduction03;						// ЉیT̋^̋z03
	private Integer				payPayInsDeduction04;						// ЉیT̋^̋z04
	private Integer				payPayInsDeduction05;						// ЉیT̋^̋z05
	private Integer				payPayInsDeduction06;						// ЉیT̋^̋z06
	private Integer				payPayInsDeduction07;						// ЉیT̋^̋z07
	private Integer				payPayInsDeduction08;						// ЉیT̋^̋z08
	private Integer				payPayInsDeduction09;						// ЉیT̋^̋z09
	private Integer				payPayInsDeduction10;						// ЉیT̋^̋z10
	private Integer				payPayInsDeduction11;						// ЉیT̋^̋z11
	private Integer				payPayInsDeduction12;						// ЉیT̋^̋z12
	private Integer				payDependentCount01;						// }{e(^)01
	private Integer				payDependentCount02;						// }{e(^)02
	private Integer				payDependentCount03;						// }{e(^)03
	private Integer				payDependentCount04;						// }{e(^)04
	private Integer				payDependentCount05;						// }{e(^)05
	private Integer				payDependentCount06;						// }{e(^)06
	private Integer				payDependentCount07;						// }{e(^)07
	private Integer				payDependentCount08;						// }{e(^)08
	private Integer				payDependentCount09;						// }{e(^)09
	private Integer				payDependentCount10;						// }{e(^)10
	private Integer				payDependentCount11;						// }{e(^)11
	private Integer				payDependentCount12;						// }{e(^)12
	private Integer				payIncomeTax01;							// 01 
	private Integer				payIncomeTax02;							// 02
	private Integer				payIncomeTax03;							// 03
	private Integer				payIncomeTax04;							// 04
	private Integer				payIncomeTax05;							// 05
	private Integer				payIncomeTax06;							// 06
	private Integer				payIncomeTax07;							// 07
	private Integer				payIncomeTax08;							// 08
	private Integer				payIncomeTax09;							// 09
	private Integer				payIncomeTax10;							// 10
	private Integer				payIncomeTax11;							// 11
	private Integer				payIncomeTax12;							// 12
	private Integer				payAdjCalcGap01;							// Nɂߕs01
	private Integer				payAdjCalcGap02;							// Nɂߕs02
	private Integer				payAdjCalcGap03;							// Nɂߕs03
	private Integer				payAdjCalcGap04;							// Nɂߕs04
	private Integer				payAdjCalcGap05;							// Nɂߕs05
	private Integer				payAdjCalcGap06;							// Nɂߕs06
	private Integer				payAdjCalcGap07;							// Nɂߕs07
	private Integer				payAdjCalcGap08;							// Nɂߕs08
	private Integer				payAdjCalcGap09;							// Nɂߕs09
	private Integer				payAdjCalcGap10;							// Nɂߕs10
	private Integer				payAdjCalcGap11;							// Nɂߕs11
	private Integer				payAdjCalcGap12;							// Nɂߕs12
	private Integer				payVariousDeduction01;						// T01
	private Integer				payVariousDeduction02;						// T02
	private Integer				payVariousDeduction03;						// T03
	private Integer				payVariousDeduction04;						// T04
	private Integer				payVariousDeduction05;						// T05
	private Integer				payVariousDeduction06;						// T06
	private Integer				payVariousDeduction07;						// T07
	private Integer				payVariousDeduction08;						// T08
	private Integer				payVariousDeduction09;						// T09
	private Integer				payVariousDeduction10;						// T10
	private Integer				payVariousDeduction11;						// T11
	private Integer				payVariousDeduction12;						// T12
	private Integer				payPaymentTotal01;							// xz01
	private Integer				payPaymentTotal02;							// xz02
	private Integer				payPaymentTotal03;							// xz03
	private Integer				payPaymentTotal04;							// xz04
	private Integer				payPaymentTotal05;							// xz05
	private Integer				payPaymentTotal06;							// xz06
	private Integer				payPaymentTotal07;							// xz07
	private Integer				payPaymentTotal08;							// xz08
	private Integer				payPaymentTotal09;							// xz09
	private Integer				payPaymentTotal10;							// xz10
	private Integer				payPaymentTotal11;							// xz11
	private Integer				payPaymentTotal12;							// xz12
																			
	private Integer				payPaymentTax01;							// Ŋz01
	private Integer				payPaymentTax02;							// Ŋz02
	private Integer				payPaymentTax03;							// Ŋz03
	private Integer				payPaymentTax04;							// Ŋz04
	private Integer				payPaymentTax05;							// Ŋz05
	private Integer				payPaymentTax06;							// Ŋz06
	private Integer				payPaymentTax07;							// Ŋz07
	private Integer				payPaymentTax08;							// Ŋz08
	private Integer				payPaymentTax09;							// Ŋz09
	private Integer				payPaymentTax10;							// Ŋz10
	private Integer				payPaymentTax11;							// Ŋz11
	private Integer				payPaymentTax12;							// Ŋz12
																			
	private String				bonusMonth01;								// x(ܗ^)01
	private String				bonusMonth02;								// x(ܗ^)02
	private String				bonusMonth03;								// x(ܗ^)03
	private String				bonusMonth04;								// x(ܗ^)04
	private String				bonusMonth05;								// x(ܗ^)05
	private String				bonusMonth06;								// x(ܗ^)06
	private String				bonusPayDay01;								// x(ܗ^)01
	private String				bonusPayDay02;								// x(ܗ^)02
	private String				bonusPayDay03;								// x(ܗ^)03
	private String				bonusPayDay04;								// x(ܗ^)04
	private String				bonusPayDay05;								// x(ܗ^)05
	private String				bonusPayDay06;								// x(ܗ^)06
	private Integer				bonTotalAllowance01;						// xz(ܗ^01)
	private Integer				bonTotalAllowance02;						// xz(ܗ^02)
	private Integer				bonTotalAllowance03;						// xz(ܗ^03)
	private Integer				bonTotalAllowance04;						// xz(ܗ^04)
	private Integer				bonTotalAllowance05;						// xz(ܗ^05)
	private Integer				bonTotalAllowance06;						// xz(ܗ^06)
	private Integer				bonTaxFree01;								// ېŊz(ܗ^)01
	private Integer				bonTaxFree02;								// ېŊz(ܗ^)02
	private Integer				bonTaxFree03;								// ېŊz(ܗ^)03
	private Integer				bonTaxFree04;								// ېŊz(ܗ^)04
	private Integer				bonTaxFree05;								// ېŊz(ܗ^)05
	private Integer				bonTaxFree06;								// ېŊz(ܗ^)05
	private Integer				bonTaxation01;								// ېŎxz(ܗ^)01
	private Integer				bonTaxation02;								// ېŎxz(ܗ^)02
	private Integer				bonTaxation03;								// ېŎxz(ܗ^)03
	private Integer				bonTaxation04;								// ېŎxz(ܗ^)04
	private Integer				bonTaxation05;								// ېŎxz(ܗ^)05
	private Integer				bonTaxation06;								// ېŎxz(ܗ^)06
	private Integer				bonSocInsDeduction01;						// Љی(ܗ^)01
	private Integer				bonSocInsDeduction02;						// Љی(ܗ^)02
	private Integer				bonSocInsDeduction03;						// Љی(ܗ^)03
	private Integer				bonSocInsDeduction04;						// Љی(ܗ^)04
	private Integer				bonSocInsDeduction05;						// Љی(ܗ^)05
	private Integer				bonSocInsDeduction06;						// Љی(ܗ^)06
	private Integer				bonPayInsDeduction01;						// ЉیT̋^̋z(ܗ^)01
	private Integer				bonPayInsDeduction02;						// ЉیT̋^̋z(ܗ^)02
	private Integer				bonPayInsDeduction03;						// ЉیT̋^̋z(ܗ^)03
	private Integer				bonPayInsDeduction04;						// ЉیT̋^̋z(ܗ^)04
	private Integer				bonPayInsDeduction05;						// ЉیT̋^̋z(ܗ^)05
	private Integer				bonPayInsDeduction06;						// ЉیT̋^̋z(ܗ^)06
	private Integer				bonDependentCount01;						// }{e(ܗ^)01
	private Integer				bonDependentCount02;						// }{e(ܗ^)02
	private Integer				bonDependentCount03;						// }{e(ܗ^)03
	private Integer				bonDependentCount04;						// }{e(ܗ^)04
	private Integer				bonDependentCount05;						// }{e(ܗ^)05
	private Integer				bonDependentCount06;						// }{e(ܗ^)06
																			
	private Integer				bonIncomeTax01;							// (ܗ^)01
	private Integer				bonIncomeTax02;							// (ܗ^)02
	private Integer				bonIncomeTax03;							// (ܗ^)03
	private Integer				bonIncomeTax04;							// (ܗ^)04
	private Integer				bonIncomeTax05;							// (ܗ^)05
	private Integer				bonIncomeTax06;							// (ܗ^)06
	private Float				bonIncomeTaxRate01;						// ŗ(ܗ^)01
	private Float				bonIncomeTaxRate02;						// ŗ(ܗ^)02
	private Float				bonIncomeTaxRate03;						// ŗ(ܗ^)03
	private Float				bonIncomeTaxRate04;						// ŗ(ܗ^)04
	private Float				bonIncomeTaxRate05;						// ŗ(ܗ^)05
	private Float				bonIncomeTaxRate06;						// ŗ(ܗ^)06
																			
	private Integer				bonAdjCalcGap01;							// Nɂߕs(ܗ^)01
	private Integer				bonAdjCalcGap02;							// Nɂߕs(ܗ^)02
	private Integer				bonAdjCalcGap03;							// Nɂߕs(ܗ^)03
	private Integer				bonAdjCalcGap04;							// Nɂߕs(ܗ^)04
	private Integer				bonAdjCalcGap05;							// Nɂߕs(ܗ^)05
	private Integer				bonAdjCalcGap06;							// Nɂߕs(ܗ^)06
	private Integer				bonVariousDeduction01;						// T(ܗ^)01
	private Integer				bonVariousDeduction02;						// T(ܗ^)02
	private Integer				bonVariousDeduction03;						// T(ܗ^)03
	private Integer				bonVariousDeduction04;						// T(ܗ^)04
	private Integer				bonVariousDeduction05;						// T(ܗ^)05
	private Integer				bonVariousDeduction06;						// T(ܗ^)06
	private Integer				bonPaymentTotal01;							// xz(ܗ^)01
	private Integer				bonPaymentTotal02;							// xz(ܗ^)02
	private Integer				bonPaymentTotal03;							// xz(ܗ^)03
	private Integer				bonPaymentTotal04;							// xz(ܗ^)04
	private Integer				bonPaymentTotal05;							// xz(ܗ^)05
	private Integer				bonPaymentTotal06;							// xz(ܗ^)06
																			
	private Integer				bonPaymentTax01;							// (ܗ^)01
	private Integer				bonPaymentTax02;							// (ܗ^)02
	private Integer				bonPaymentTax03;							// (ܗ^)03
	private Integer				bonPaymentTax04;							// (ܗ^)04
	private Integer				bonPaymentTax05;							// (ܗ^)05
	private Integer				bonPaymentTax06;							// (ܗ^)06
																			
	private Integer				totalAllowance;							// xzv
	private Integer				taxFree;									// ېŊzv
	private Integer				taxation;									// ېŊzv
	private Integer				socInsDeduction;							// Љیv 
	private Integer				totalPayInsDeduction;						// ЉیT̋^̋zv
	private Integer				incomeTax;									// ōv
	private Integer				variousDeduction;							// Tv
	private Integer				paymentTotal;								// xzv
																			
	private Integer				midwayType;								// rЋ敪
	private Integer				formerIncome;								// OΖz
	private Integer				formerInsurance;							// OΖЉیz
	private Integer				formerTax;									// OΖ揊Ŋz
																			
	private Integer				paymentAllowance;							// ^A蓖z
	private Integer				paymentIncomeTax;							// ^A蓖Ŋz
	private Integer				bonusAllowance;							// ܗ^z
	private Integer				bonusIncomeTax;							// ܗ^Ŋz
	private Integer				midwayAdjustIncome;						// rAz
	private Integer				midwayAdjustTax;							// rAŊz
	private Integer				adjTotalAllowance;							// xzv
	private Integer				adjTotalIncome;							// Ŋzv
	private Integer				afterDeductIncome;							// ^T̋^̋z
	private Integer				payInsDeduction;							// Љی^̍T
	private Integer				socialInsDeduction;						// ЉیTz
	private Integer				mutualAidDeduction;						// K͊Ƌϓ|Tz
	private Integer				lifeInsDeduction;							// یTz
	private Integer				damageInsDeduction;						// QیTz
	private Integer				spouseSpDeduction;							// zғʍTz
	private Integer				dependentsDeduction;						// zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	private Integer				incomeDeductSum;							// Tzv
	private Integer				finalIncomeTax;							// NŊz
	private Integer				houseLoanDeduction;						// ZؓʍTz
	private Integer				taxGap;									// Ŋz擾
	private Integer				calcTaxedIncome;							// ېŋ^z
	private Integer				spouseSumIncome;							// z҂̖{N̍vžϊz
	private Integer				generalLifeIns;							// ʂ̐ی
	private Integer				privatePension;							// lNی
	private Integer				earthquakeIns;								// nkی
	private Integer				longTermDamageIns;							// Qی
	private Integer				allowanceAdjustment;						// xz
	private Integer				taxFreeAdjustment;							// ېŒz
	private Integer				taxIncAdjustment;							// Œz
	private String				withholdSlipNotes;							// 򒥎[Ev
	private Integer				calcIncomeTax;								// ZoNŊz
	private Integer				adjustedIncomeTax;							// NNŊz
	private Integer				deductedIncomeTax;							// N藦TzŊz
	private Integer				socInsAdjustment;							// Љیz
																			
	private String				incomeTaxType;								// ېŕ
	private String				adjustmentType;							// N敪
																			
	/* }{T{l */
	private String				spHandicap;								// ʏQ 
	private String				geHandicap;								// ʏQ
	private String				geWidow;									// ʉǕw
	private String				spWidow;									// ʉǕw
	private String				widow;										// Ǖv
	private String				studentGeneral;							// ΘJw
	/* }{Tzҍ */
	private String				lwSpHandiEl;								// ʏQҘVl		
	private String				lwSpHandicap;								// ʏQ
	private String				spouseEl;									// Vlz
	private String				spouseGe;									// ʔz(̑)
																			
	private String				generalDependent;							// ʕ}{e
	private String				specificDependent;							// }{e
	private String				elderlyDependent;							// Vl}{e
	private String				liveWithEldRel;							// Ve
	private String				liveWithHandiGe;							// 
	private String				liveWithHandiSp;							// 
	private String				liveWithHandiEl;							// Vl
	private String				liveWithHandiEr;							// Ve
	private String				generalHandicap;							// ʏQ
	private String				specificHandicap;							// ʏQ
	private String				totallHandicap;							// QҌv
	private String				totallDeduction;							// ]鋋^TΏ۔z҂ƕ}{e̍vTΏێҐ
	private String				consortFlg;								// zҗL\("L"E"")
																			
	private String				companyName;								// Ж
																			
	private Integer				totalPayTotalAllowance;					//^xzv
	private Integer				totalPayTaxFree;							//^ېŊzv
	private Integer				totalPayTaxation;							//^ېŎxzv
	private Integer				totalPayIncomeTax;							//^ōv
	private Integer				totalPaySocInsDeduction;					//^Љیv
	private Integer				totalPayPayInsDeduction;					//^ЉیT̋^̋zv
	private Integer				totalPayVariousDeduction;					//^Tv
	private Integer				totalPayPaymentTotal;						//^xzv
	private Integer				totalPayAdjCalcGap;						//^Nɂߕsv
																			
	private Integer				totalBonTotalAllowance;					//ܗ^xzv
	private Integer				totalBonTaxFree;							//ܗ^ېŊzv
	private Integer				totalBonTaxation;							//ܗ^ېŎxzv
	private Integer				totalBonIncomeTax;							//ܗ^ōv
	private Integer				totalBonSocInsDeduction;					//ܗ^Љیv
	private Integer				totalBonPayInsDeduction;					//ܗ^ЉیT̏ܗ^̋zv
	private Integer				totalBonVariousDeduction;					//ܗ^Tv
	private Integer				totalBonPaymentTotal;						//ܗ^xzv
	private Integer				totalBonAdjCalcGap;						//ܗ^Nɂߕsv
																			
	private String				monthType01;								// 敪01
	private String				monthType02;								// 敪02
	private String				monthType03;								// 敪03
	private String				monthType04;								// 敪04
	private String				monthType05;								// 敪05
	private String				monthType06;								// 敪06
	private String				monthType07;								// 敪07
	private String				monthType08;								// 敪08
	private String				monthType09;								// 敪09
	private String				monthType10;								// 敪10
	private String				monthType11;								// 敪11
	private String				monthType12;								// 敪12
																			
	private String				strMidwayType;								// rЋ敪
																			
	
	/**
	 * 򒥎o͂ɕKvȏݒ肷B<br>
	 * @param targetAdjustYear NΏ۔N
	 * @param cdAdjustmentDto  N
	 * @param uhBasisDto       l{
	 * @param cmIncomeTaxDto   lŏ
	 * @param cmMidwayEnterDto lrЏ
	 * @param listPaymentData  ^
	 * @param listBonusData    ܗ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @param cmCompanyDto     Џ
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	public WithholdingListDto(int targetAdjustYear, CdAdjustmentDto cdAdjustmentDto, MKihonDto uhBasisDto,
			MKojinDto mKojinDto, CmIncomeTaxDto cmIncomeTaxDto, CmMidwayEnterDto cmMidwayEnterDto,
			List<PhPaymentDto> listPaymentData, List<PhBounsDto> listBonusData, PdPayDeductionDao pdPayDeductionDao,
			CmCompanyDto cmCompanyDto) throws SQLException, NoSuchFieldException, IllegalAccessException {
		super();
		// o͔Nݒ
		adjustYear = String.valueOf(targetAdjustYear);
		adjustYearYY = String.valueOf(targetAdjustYear);
		// Жݒ
		companyName = cmCompanyDto.getCompanyName();
		// l{AŁArЁAǉݒ
		setBasisFields(uhBasisDto, cmIncomeTaxDto, cmMidwayEnterDto, mKojinDto);
		// Nݒ
		setAdjustFields(cdAdjustmentDto);
		// ܗ^ݒ
		setPaymentFields(pdPayDeductionDao, listPaymentData, listBonusData);
	}
	
	/**
	 * tB[hݒ(Nf[^)
	 * @param cdAdjustmentDto 
	 * @throws MospException 
	 */
	private void setAdjustFields(CdAdjustmentDto cdAdjustmentDto) {
		if (cdAdjustmentDto != null) {
			// AdjustStatus = String.valueOf( getCodeName(cdAdjustmentDto.getAdjustStatus(), UnicConst.getAdjuStatusArray());
			generalLifeIns = new Integer(cdAdjustmentDto.getGeneralLifeIns());
			privatePension = new Integer(cdAdjustmentDto.getPrivatePension());
			lifeInsDeduction = new Integer(cdAdjustmentDto.getLifeInsDeduction());
			earthquakeIns = new Integer(cdAdjustmentDto.getEarthquakeIns());
			longTermDamageIns = new Integer(cdAdjustmentDto.getLongTermDamageIns());
			damageInsDeduction = new Integer(cdAdjustmentDto.getDamageInsDeduction());
			socialInsDeduction = new Integer(cdAdjustmentDto.getSocialInsDeduction());
			mutualAidDeduction = new Integer(cdAdjustmentDto.getMutualAidDeduction());
			spouseSumIncome = new Integer(cdAdjustmentDto.getSpouseSumIncome());
			spouseSpDeduction = new Integer(cdAdjustmentDto.getSpouseSpDeduction());
			houseLoanDeduction = new Integer(cdAdjustmentDto.getHouseLoanDeduction());
			allowanceAdjustment = new Integer(cdAdjustmentDto.getAllowanceAdjustment());
			taxFreeAdjustment = new Integer(cdAdjustmentDto.getTaxFreeAdjustment());
			socInsAdjustment = new Integer(cdAdjustmentDto.getSocInsAdjustment());
			taxIncAdjustment = new Integer(cdAdjustmentDto.getTaxIncAdjustment());
			withholdSlipNotes = cdAdjustmentDto.getWithholdSlipNotes();
			paymentAllowance = new Integer(cdAdjustmentDto.getPaymentAllowance());
			paymentIncomeTax = new Integer(cdAdjustmentDto.getPaymentIncomeTax());
			bonusAllowance = new Integer(cdAdjustmentDto.getBonusAllowance());
			bonusIncomeTax = new Integer(cdAdjustmentDto.getBonusIncomeTax());
			midwayAdjustIncome = new Integer(cdAdjustmentDto.getMidwayAdjustIncome());
			midwayAdjustTax = new Integer(cdAdjustmentDto.getMidwayAdjustTax());
			afterDeductIncome = new Integer(cdAdjustmentDto.getAfterDeductIncome());
			payInsDeduction = new Integer(cdAdjustmentDto.getPayInsDeduction());
			dependentsDeduction = new Integer(cdAdjustmentDto.getDependentsDeduction());
			calcTaxedIncome = new Integer(cdAdjustmentDto.getCalcTaxedIncome());
			calcIncomeTax = new Integer(cdAdjustmentDto.getCalcIncomeTax());
			adjustedIncomeTax = new Integer(cdAdjustmentDto.getAdjustedIncomeTax());
			deductedIncomeTax = new Integer(cdAdjustmentDto.getDeductedIncomeTax());
			finalIncomeTax = new Integer(cdAdjustmentDto.getFinalIncomeTax());
			incomeDeductSum = new Integer(cdAdjustmentDto.getIncomeDeductSum());
			taxGap = new Integer(cdAdjustmentDto.getTaxGap());
			adjTotalAllowance = new Integer(cdAdjustmentDto.getTaxedPaymentSum());
			adjTotalIncome = new Integer(cdAdjustmentDto.getIncomeTaxSum());
		} else {
			// Nf[^݂Ȃꍇ̓f[^쐬
			//AdjustStatus = String.valueOf( UnicConst.ADJU_STATUS_NON_NAME;
		}
		
	}
	
	/**
	 * tB[hݒ
	 * @param cmIncomeTaxDto   tB[h擾ΏDTO
	 * @param cmMidwayEnterDto tB[h擾ΏDTO
	 */
	private void setBasisFields(MKihonDto mKihonDto, CmIncomeTaxDto cmIncomeTaxDto, CmMidwayEnterDto cmMidwayEnterDto,
			MKojinDto mKojinDto) {
		// f[^̐ݒ
		if (mKihonDto != null) {
			kCode = mKihonDto.getKCode();
			kName = mKihonDto.getSimei();
			fName = mKihonDto.getFurigana();
			stationCode = mKihonDto.getSCode();
			positionCode = mKihonDto.getYCode();
			touKyu = mKihonDto.getTokyu(); // ̏
			
		}
		
		// {l敪ĔfAX^XNݒ		
		if (cmIncomeTaxDto != null) {
			String handicapType = cmIncomeTaxDto.getSelfHandicapType();
			String studentType = cmIncomeTaxDto.getSelfStudentType();
			
			if (handicapType.equals(LegalConst.HANDICAP_GENERAL)) {
				// ʏQ
				geHandicap = PayrollConst.ADJ_APPLICABLE;
			} else if (handicapType.equals(LegalConst.HANDICAP_SPECIAL)) {
				// ʏQ
				spHandicap = PayrollConst.ADJ_APPLICABLE;
			}
			// {l敪ΘJw
			if (studentType.equals(LegalConst.STUDENT_GENERAL)) {
				studentGeneral = PayrollConst.ADJ_APPLICABLE;
			}
			String spouseType = cmIncomeTaxDto.getSpouseIntendType();
			
			// zҗLݒ
			if (spouseType.equals("")) {
				consortFlg = PayrollConst.PRESENCE_OFF;
			} else {
				consortFlg = PayrollConst.PRESENCE_ON;
			}
			
			// zҋ敪ʏQҘVl
			if (spouseType.equals(LegalConst.SPOUSE_INTEND_LWSH_EL)) {
				lwSpHandiEl = PayrollConst.ADJ_APPLICABLE;
			}
			// zҋ敪ʏQ
			if (spouseType.equals(LegalConst.SPOUSE_INTEND_LWSH)) {
				lwSpHandicap = PayrollConst.ADJ_APPLICABLE;
			}
			// zҋ敪Vlz
			if (spouseType.equals(LegalConst.SPOUSE_INTEND_ELDERLY)) {
				spouseEl = PayrollConst.ADJ_APPLICABLE;
			}
			// zҋ敪Vlz
			if (spouseType.equals(LegalConst.SPOUSE_INTEND_GENERAL)) {
				spouseGe = PayrollConst.ADJ_APPLICABLE;
			}
			
			generalDependent = String.valueOf(cmIncomeTaxDto.getGeneralDependent()); // ʕ}{e
			specificDependent = String.valueOf(cmIncomeTaxDto.getSpecificDependent()); // }{e
			elderlyDependent = String.valueOf(cmIncomeTaxDto.getElderlyDependent()); // Vl}{e
			liveWithEldRel = String.valueOf(cmIncomeTaxDto.getLiveWithEldRel()); // Ve
			liveWithHandiGe = String.valueOf(cmIncomeTaxDto.getLiveWithHandiGe()); // 
			liveWithHandiSp = String.valueOf(cmIncomeTaxDto.getLiveWithHandiSp()); // 
			liveWithHandiEl = String.valueOf(cmIncomeTaxDto.getLiveWithHandiEl()); // Vl
			liveWithHandiEr = String.valueOf(cmIncomeTaxDto.getLiveWithHandiEr()); // Vl
			generalHandicap = String.valueOf(cmIncomeTaxDto.getGeneralHandicap()); // ʏQ
			specificHandicap = String.valueOf(cmIncomeTaxDto.getSpecificHandicap()); // ʏQ
			totallHandicap = String.valueOf(cmIncomeTaxDto.getGeneralHandicap() + cmIncomeTaxDto.getSpecificHandicap()); // QҌv
			totallDeduction = String.valueOf( // TΏێҐ
				cmIncomeTaxDto.getGeneralDependent() + // ʕ}{e
						cmIncomeTaxDto.getSpecificDependent() + // }{e
						cmIncomeTaxDto.getElderlyDependent() + // Vl}{e
						cmIncomeTaxDto.getLiveWithEldRel() + // Ve
						cmIncomeTaxDto.getGeneralHandicap() + // ʏQ
						cmIncomeTaxDto.getSpecificHandicap()); // ʏQ
			
			incomeTaxType = String.valueOf(cmIncomeTaxDto.getIncomeTaxType()); // ېŋ敪
			adjustmentType = String.valueOf(cmIncomeTaxDto.getAdjustmentType()); // N敪
		}
		
		formerIncome = new Integer(0);
		formerInsurance = new Integer(0);
		formerTax = new Integer(0);
		
		if (cmMidwayEnterDto != null) {
			if (mKihonDto != null) {
				// Ώ۔NГNULLłȂΔf
				if (mKihonDto.getNyDate() != 0) {
					// Ώ۔NŒrЂ̎Ј
					if (MospUtility.getYear(DateUtil.convIntegerDateToDate(mKihonDto.getNyDate())) == Integer
						.parseInt(adjustYear)) {
						if (cmMidwayEnterDto.getMidwayType().equals(LegalConst.MIDWAY_ENTER)) {
							formerIncome = new Integer(cmMidwayEnterDto.getFormerIncome());
							formerInsurance = new Integer(cmMidwayEnterDto.getFormerInsurance());
							formerTax = new Integer(cmMidwayEnterDto.getFormerTax());
							strMidwayType = LegalConst.MIDWAY_ENTER_NAME;
						} else {
							strMidwayType = "";
						}
					}
				}
				
			}
		}
		if (mKojinDto != null) {
			address = CalculateAction.getPrefecture(mKojinDto.getPrefectures()) + mKojinDto.getJyuusyo1()
					+ mKojinDto.getJyuusyo2() + mKojinDto.getJyuusyo3();
			postalCode = mKojinDto.getYubinban();
		}
	}
	
	/**
	 * ܗ^ݒ肷B<br>
	 * @param pdPayDeductionDao ^׏DAO
	 * @param listPaymentData ^
	 * @param listBonusData   ܗ^
	 * @param cdAdjustmentDto N
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentFields(PdPayDeductionDao pdPayDeductionDao, List<PhPaymentDto> listPaymentData,
			List<PhBounsDto> listBonusData) throws SQLException, NoSuchFieldException, IllegalAccessException {
		// ^ݒ
		for (int i = 0; i < PayrollConst.CNT_ADJ_PAYMENT_MONTH; i++) {
			for (int j = 0; j < listPaymentData.size(); j++) {
				// ^擾
				PhPaymentDto phPaymentDto = listPaymentData.get(j);
				// ^xmF
				if (i + 1 == MospUtility.getMonth(phPaymentDto.getPayDate())) {
					// e̋^f[^ݒ
					setPaymentData(i, true, phPaymentDto, pdPayDeductionDao);
					break;
				}
				if (j == listPaymentData.size() - 1) {
					// e̋^f[^ɋݒ
					setPaymentData(i, false, null, pdPayDeductionDao);
				}
			}
		}
		// ܗ^ݒ
		for (int i = 0; i < PayrollConst.CNT_OUT_BONUS_MONTH; i++) {
			if (i < listBonusData.size()) {
				// DTOjݒ
				PhBounsDto udBonusDto = listBonusData.get(i);
				// ȅܗ^f[^ݒ
				setBonusData(i, true, udBonusDto);
			} else {
				// ȅܗ^f[^ɋݒ
				setBonusData(i, false, null);
			}
		}
		// vlݒ
		setTotalPayment();
	}
	
	private void setTotalPayment() {
		setTotalAllowance();
		setTotalTaxFree();
		setTotalTaxation();
		setTotalSocInsDeduction();
		setTotalPayInsDeduction();
		setTotalIncomeTax();
		setTotalVariousDeduction();
		setTotalPaymentTotal();
		setTotalpayAdjCalcGapTotal();
	}
	
	private void setTotalAllowance() {
		int amount01 = payTotalAllowance01 == null ? 0 : payTotalAllowance01.intValue();
		int amount02 = payTotalAllowance02 == null ? 0 : payTotalAllowance02.intValue();
		int amount03 = payTotalAllowance03 == null ? 0 : payTotalAllowance03.intValue();
		int amount04 = payTotalAllowance04 == null ? 0 : payTotalAllowance04.intValue();
		int amount05 = payTotalAllowance05 == null ? 0 : payTotalAllowance05.intValue();
		int amount06 = payTotalAllowance06 == null ? 0 : payTotalAllowance06.intValue();
		int amount07 = payTotalAllowance07 == null ? 0 : payTotalAllowance07.intValue();
		int amount08 = payTotalAllowance08 == null ? 0 : payTotalAllowance08.intValue();
		int amount09 = payTotalAllowance09 == null ? 0 : payTotalAllowance09.intValue();
		int amount10 = payTotalAllowance10 == null ? 0 : payTotalAllowance10.intValue();
		int amount11 = payTotalAllowance11 == null ? 0 : payTotalAllowance11.intValue();
		int amount12 = payTotalAllowance12 == null ? 0 : payTotalAllowance12.intValue();
		int amountBon01 = bonTotalAllowance01 == null ? 0 : bonTotalAllowance01.intValue();
		int amountBon02 = bonTotalAllowance02 == null ? 0 : bonTotalAllowance02.intValue();
		int amountBon03 = bonTotalAllowance03 == null ? 0 : bonTotalAllowance03.intValue();
		int amountBon04 = bonTotalAllowance04 == null ? 0 : bonTotalAllowance04.intValue();
		int amountBon05 = bonTotalAllowance05 == null ? 0 : bonTotalAllowance05.intValue();
		int amountBon06 = bonTotalAllowance06 == null ? 0 : bonTotalAllowance06.intValue();
		
		totalPayTotalAllowance = new Integer(amount01 + amount02 + amount03 + amount04 + amount05 + amount06 + amount07
				+ amount08 + amount09 + amount10 + amount11 + amount12);
		
		totalBonTotalAllowance = new Integer(amountBon01 + amountBon02 + amountBon03 + amountBon04 + amountBon05
				+ amountBon06);
		
		totalAllowance = new Integer(amount01 + amount02 + amount03 + amount04 + amount05 + amount06 + amount07
				+ amount08 + amount09 + amount10 + amount11 + amount12 + amountBon01 + amountBon02 + amountBon03
				+ amountBon04 + amountBon05 + amountBon06);
		
	}
	
	private void setTotalTaxFree() {
		int amount01 = payTaxFree01 == null ? 0 : payTaxFree01.intValue();
		int amount02 = payTaxFree02 == null ? 0 : payTaxFree02.intValue();
		int amount03 = payTaxFree03 == null ? 0 : payTaxFree03.intValue();
		int amount04 = payTaxFree04 == null ? 0 : payTaxFree04.intValue();
		int amount05 = payTaxFree05 == null ? 0 : payTaxFree05.intValue();
		int amount06 = payTaxFree06 == null ? 0 : payTaxFree06.intValue();
		int amount07 = payTaxFree07 == null ? 0 : payTaxFree07.intValue();
		int amount08 = payTaxFree08 == null ? 0 : payTaxFree08.intValue();
		int amount09 = payTaxFree09 == null ? 0 : payTaxFree09.intValue();
		int amount10 = payTaxFree10 == null ? 0 : payTaxFree10.intValue();
		int amount11 = payTaxFree11 == null ? 0 : payTaxFree11.intValue();
		int amount12 = payTaxFree12 == null ? 0 : payTaxFree12.intValue();
		
		int amountBon01 = bonTaxFree01 == null ? 0 : bonTaxFree01.intValue();
		int amountBon02 = bonTaxFree02 == null ? 0 : bonTaxFree02.intValue();
		int amountBon03 = bonTaxFree03 == null ? 0 : bonTaxFree03.intValue();
		int amountBon04 = bonTaxFree04 == null ? 0 : bonTaxFree04.intValue();
		int amountBon05 = bonTaxFree05 == null ? 0 : bonTaxFree05.intValue();
		int amountBon06 = bonTaxFree06 == null ? 0 : bonTaxFree06.intValue();
		
		totalPayTaxFree = new Integer(+amount01 + amount02 + amount03 + amount04 + amount05 + amount06 + amount07
				+ amount08 + amount09 + amount10 + amount11 + amount12);
		
		totalBonTaxFree = new Integer(amountBon01 + amountBon02 + amountBon03 + amountBon04 + amountBon05 + amountBon06);
		
		taxFree = new Integer(+amount01 + amount02 + amount03 + amount04 + amount05 + amount06 + amount07 + amount08
				+ amount09 + amount10 + amount11 + amount12 + amountBon01 + amountBon02 + amountBon03 + amountBon04
				+ amountBon05 + amountBon06);
		
	}
	
	private void setTotalTaxation() {
		int amount01 = payTaxation01 == null ? 0 : payTaxation01.intValue();
		int amount02 = payTaxation02 == null ? 0 : payTaxation02.intValue();
		int amount03 = payTaxation03 == null ? 0 : payTaxation03.intValue();
		int amount04 = payTaxation04 == null ? 0 : payTaxation04.intValue();
		int amount05 = payTaxation05 == null ? 0 : payTaxation05.intValue();
		int amount06 = payTaxation06 == null ? 0 : payTaxation06.intValue();
		int amount07 = payTaxation07 == null ? 0 : payTaxation07.intValue();
		int amount08 = payTaxation08 == null ? 0 : payTaxation08.intValue();
		int amount09 = payTaxation09 == null ? 0 : payTaxation09.intValue();
		int amount10 = payTaxation10 == null ? 0 : payTaxation10.intValue();
		int amount11 = payTaxation11 == null ? 0 : payTaxation11.intValue();
		int amount12 = payTaxation12 == null ? 0 : payTaxation12.intValue();
		
		int amountBon01 = bonTaxation01 == null ? 0 : bonTaxation01.intValue();
		int amountBon02 = bonTaxation02 == null ? 0 : bonTaxation02.intValue();
		int amountBon03 = bonTaxation03 == null ? 0 : bonTaxation03.intValue();
		int amountBon04 = bonTaxation04 == null ? 0 : bonTaxation04.intValue();
		int amountBon05 = bonTaxation05 == null ? 0 : bonTaxation05.intValue();
		int amountBon06 = bonTaxation06 == null ? 0 : bonTaxation06.intValue();
		
		totalPayTaxation = new Integer(amount01 + amount02 + amount03 + amount04 + amount05 + amount06 + amount07
				+ amount08 + amount09 + amount10 + amount11 + amount12);
		
		totalBonTaxation = new Integer(+amountBon01 + amountBon02 + amountBon03 + amountBon04 + amountBon05
				+ amountBon06);
		
		taxation = new Integer(+amount01 + amount02 + amount03 + amount04 + amount05 + amount06 + amount07 + amount08
				+ amount09 + amount10 + amount11 + amount12 + amountBon01 + amountBon02 + amountBon03 + amountBon04
				+ amountBon05 + amountBon06);
		
	}
	
	private void setTotalSocInsDeduction() {
		int amount01 = paySocInsDeduction01 == null ? 0 : paySocInsDeduction01.intValue();
		int amount02 = paySocInsDeduction02 == null ? 0 : paySocInsDeduction02.intValue();
		int amount03 = paySocInsDeduction03 == null ? 0 : paySocInsDeduction03.intValue();
		int amount04 = paySocInsDeduction04 == null ? 0 : paySocInsDeduction04.intValue();
		int amount05 = paySocInsDeduction05 == null ? 0 : paySocInsDeduction05.intValue();
		int amount06 = paySocInsDeduction06 == null ? 0 : paySocInsDeduction06.intValue();
		int amount07 = paySocInsDeduction07 == null ? 0 : paySocInsDeduction07.intValue();
		int amount08 = paySocInsDeduction08 == null ? 0 : paySocInsDeduction08.intValue();
		int amount09 = paySocInsDeduction09 == null ? 0 : paySocInsDeduction09.intValue();
		int amount10 = paySocInsDeduction10 == null ? 0 : paySocInsDeduction10.intValue();
		int amount11 = paySocInsDeduction11 == null ? 0 : paySocInsDeduction11.intValue();
		int amount12 = paySocInsDeduction12 == null ? 0 : paySocInsDeduction12.intValue();
		
		int amountBon01 = bonSocInsDeduction01 == null ? 0 : bonSocInsDeduction01.intValue();
		int amountBon02 = bonSocInsDeduction02 == null ? 0 : bonSocInsDeduction02.intValue();
		int amountBon03 = bonSocInsDeduction03 == null ? 0 : bonSocInsDeduction03.intValue();
		int amountBon04 = bonSocInsDeduction04 == null ? 0 : bonSocInsDeduction04.intValue();
		int amountBon05 = bonSocInsDeduction05 == null ? 0 : bonSocInsDeduction05.intValue();
		int amountBon06 = bonSocInsDeduction06 == null ? 0 : bonSocInsDeduction06.intValue();
		
		totalPaySocInsDeduction = new Integer(+amount01 + amount02 + amount03 + amount04 + amount05 + amount06
				+ amount07 + amount08 + amount09 + amount10 + amount11 + amount12);
		
		totalBonSocInsDeduction = new Integer(amountBon01 + amountBon02 + amountBon03 + amountBon04 + amountBon05
				+ amountBon06);
		
		socInsDeduction = new Integer(+amount01 + amount02 + amount03 + amount04 + amount05 + amount06 + amount07
				+ amount08 + amount09 + amount10 + amount11 + amount12 + amountBon01 + amountBon02 + amountBon03
				+ amountBon04 + amountBon05 + amountBon06);
		
		payInsDeduction = new Integer(+amount01 + amount02 + amount03 + amount04 + amount05 + amount06 + amount07
				+ amount08 + amount09 + amount10 + amount11 + amount12 + amountBon01 + amountBon02 + amountBon03
				+ amountBon04 + amountBon05 + amountBon06);
	}
	
	private void setTotalPayInsDeduction() {
		int amount01 = payPayInsDeduction01 == null ? 0 : payPayInsDeduction01.intValue();
		int amount02 = payPayInsDeduction02 == null ? 0 : payPayInsDeduction02.intValue();
		int amount03 = payPayInsDeduction03 == null ? 0 : payPayInsDeduction03.intValue();
		int amount04 = payPayInsDeduction04 == null ? 0 : payPayInsDeduction04.intValue();
		int amount05 = payPayInsDeduction05 == null ? 0 : payPayInsDeduction05.intValue();
		int amount06 = payPayInsDeduction06 == null ? 0 : payPayInsDeduction06.intValue();
		int amount07 = payPayInsDeduction07 == null ? 0 : payPayInsDeduction07.intValue();
		int amount08 = payPayInsDeduction08 == null ? 0 : payPayInsDeduction08.intValue();
		int amount09 = payPayInsDeduction09 == null ? 0 : payPayInsDeduction09.intValue();
		int amount10 = payPayInsDeduction10 == null ? 0 : payPayInsDeduction10.intValue();
		int amount11 = payPayInsDeduction11 == null ? 0 : payPayInsDeduction11.intValue();
		int amount12 = payPayInsDeduction12 == null ? 0 : payPayInsDeduction12.intValue();
		
		int amountBon01 = bonPayInsDeduction01 == null ? 0 : bonPayInsDeduction01.intValue();
		int amountBon02 = bonPayInsDeduction02 == null ? 0 : bonPayInsDeduction02.intValue();
		int amountBon03 = bonPayInsDeduction03 == null ? 0 : bonPayInsDeduction03.intValue();
		int amountBon04 = bonPayInsDeduction04 == null ? 0 : bonPayInsDeduction04.intValue();
		int amountBon05 = bonPayInsDeduction05 == null ? 0 : bonPayInsDeduction05.intValue();
		int amountBon06 = bonPayInsDeduction06 == null ? 0 : bonPayInsDeduction06.intValue();
		
		totalPayPayInsDeduction = new Integer(amount01 + amount02 + amount03 + amount04 + amount05 + amount06
				+ amount07 + amount08 + amount09 + amount10 + amount11 + amount12);
		
		totalBonPayInsDeduction = new Integer(

		amountBon01 + amountBon02 + amountBon03 + amountBon04 + amountBon05 + amountBon06);
		
		totalPayInsDeduction = new Integer(+amount01 + amount02 + amount03 + amount04 + amount05 + amount06 + amount07
				+ amount08 + amount09 + amount10 + amount11 + amount12 + amountBon01 + amountBon02 + amountBon03
				+ amountBon04 + amountBon05 + amountBon06);
		
	}
	
	private void setTotalIncomeTax() {
		int amount01 = payIncomeTax01 == null ? 0 : payIncomeTax01.intValue();
		int amount02 = payIncomeTax02 == null ? 0 : payIncomeTax02.intValue();
		int amount03 = payIncomeTax03 == null ? 0 : payIncomeTax03.intValue();
		int amount04 = payIncomeTax04 == null ? 0 : payIncomeTax04.intValue();
		int amount05 = payIncomeTax05 == null ? 0 : payIncomeTax05.intValue();
		int amount06 = payIncomeTax06 == null ? 0 : payIncomeTax06.intValue();
		int amount07 = payIncomeTax07 == null ? 0 : payIncomeTax07.intValue();
		int amount08 = payIncomeTax08 == null ? 0 : payIncomeTax08.intValue();
		int amount09 = payIncomeTax09 == null ? 0 : payIncomeTax09.intValue();
		int amount10 = payIncomeTax10 == null ? 0 : payIncomeTax10.intValue();
		int amount11 = payIncomeTax11 == null ? 0 : payIncomeTax11.intValue();
		int amount12 = payIncomeTax12 == null ? 0 : payIncomeTax12.intValue();
		
		int amountBon01 = bonIncomeTax01 == null ? 0 : bonIncomeTax01.intValue();
		int amountBon02 = bonIncomeTax02 == null ? 0 : bonIncomeTax02.intValue();
		int amountBon03 = bonIncomeTax03 == null ? 0 : bonIncomeTax03.intValue();
		int amountBon04 = bonIncomeTax04 == null ? 0 : bonIncomeTax04.intValue();
		int amountBon05 = bonIncomeTax05 == null ? 0 : bonIncomeTax05.intValue();
		int amountBon06 = bonIncomeTax06 == null ? 0 : bonIncomeTax06.intValue();
		
		totalPayIncomeTax = new Integer(+amount01 + amount02 + amount03 + amount04 + amount05 + amount06 + amount07
				+ amount08 + amount09 + amount10 + amount11 + amount12);
		
		totalBonIncomeTax = new Integer(amountBon01 + amountBon02 + amountBon03 + amountBon04 + amountBon05
				+ amountBon06);
		
		incomeTax = new Integer(+amount01 + amount02 + amount03 + amount04 + amount05 + amount06 + amount07 + amount08
				+ amount09 + amount10 + amount11 + amount12 + amountBon01 + amountBon02 + amountBon03 + amountBon04
				+ amountBon05 + amountBon06);
		
	}
	
	private void setTotalVariousDeduction() {
		int amount01 = payVariousDeduction01 == null ? 0 : payVariousDeduction01.intValue();
		int amount02 = payVariousDeduction02 == null ? 0 : payVariousDeduction02.intValue();
		int amount03 = payVariousDeduction03 == null ? 0 : payVariousDeduction03.intValue();
		int amount04 = payVariousDeduction04 == null ? 0 : payVariousDeduction04.intValue();
		int amount05 = payVariousDeduction05 == null ? 0 : payVariousDeduction05.intValue();
		int amount06 = payVariousDeduction06 == null ? 0 : payVariousDeduction06.intValue();
		int amount07 = payVariousDeduction07 == null ? 0 : payVariousDeduction07.intValue();
		int amount08 = payVariousDeduction08 == null ? 0 : payVariousDeduction08.intValue();
		int amount09 = payVariousDeduction09 == null ? 0 : payVariousDeduction09.intValue();
		int amount10 = payVariousDeduction10 == null ? 0 : payVariousDeduction10.intValue();
		int amount11 = payVariousDeduction11 == null ? 0 : payVariousDeduction11.intValue();
		int amount12 = payVariousDeduction12 == null ? 0 : payVariousDeduction12.intValue();
		
		int amountBon01 = bonVariousDeduction01 == null ? 0 : bonVariousDeduction01.intValue();
		int amountBon02 = bonVariousDeduction02 == null ? 0 : bonVariousDeduction02.intValue();
		int amountBon03 = bonVariousDeduction03 == null ? 0 : bonVariousDeduction03.intValue();
		int amountBon04 = bonVariousDeduction04 == null ? 0 : bonVariousDeduction04.intValue();
		int amountBon05 = bonVariousDeduction05 == null ? 0 : bonVariousDeduction05.intValue();
		int amountBon06 = bonVariousDeduction06 == null ? 0 : bonVariousDeduction06.intValue();
		
		totalPayVariousDeduction = new Integer(amount01 + amount02 + amount03 + amount04 + amount05 + amount06
				+ amount07 + amount08 + amount09 + amount10 + amount11 + amount12);
		
		totalBonVariousDeduction = new Integer(amountBon01 + amountBon02 + amountBon03 + amountBon04 + amountBon05
				+ amountBon06);
		
		variousDeduction = new Integer(+amount01 + amount02 + amount03 + amount04 + amount05 + amount06 + amount07
				+ amount08 + amount09 + amount10 + amount11 + amount12 + amountBon01 + amountBon02 + amountBon03
				+ amountBon04 + amountBon05 + amountBon06);
		
	}
	
	private void setTotalPaymentTotal() {
		int amount01 = payPaymentTotal01 == null ? 0 : payPaymentTotal01.intValue();
		int amount02 = payPaymentTotal02 == null ? 0 : payPaymentTotal02.intValue();
		int amount03 = payPaymentTotal03 == null ? 0 : payPaymentTotal03.intValue();
		int amount04 = payPaymentTotal04 == null ? 0 : payPaymentTotal04.intValue();
		int amount05 = payPaymentTotal05 == null ? 0 : payPaymentTotal05.intValue();
		int amount06 = payPaymentTotal06 == null ? 0 : payPaymentTotal06.intValue();
		int amount07 = payPaymentTotal07 == null ? 0 : payPaymentTotal07.intValue();
		int amount08 = payPaymentTotal08 == null ? 0 : payPaymentTotal08.intValue();
		int amount09 = payPaymentTotal09 == null ? 0 : payPaymentTotal09.intValue();
		int amount10 = payPaymentTotal10 == null ? 0 : payPaymentTotal10.intValue();
		int amount11 = payPaymentTotal11 == null ? 0 : payPaymentTotal11.intValue();
		int amount12 = payPaymentTotal12 == null ? 0 : payPaymentTotal12.intValue();
		
		int amountBon01 = bonPaymentTotal01 == null ? 0 : bonPaymentTotal01.intValue();
		int amountBon02 = bonPaymentTotal02 == null ? 0 : bonPaymentTotal02.intValue();
		int amountBon03 = bonPaymentTotal03 == null ? 0 : bonPaymentTotal03.intValue();
		int amountBon04 = bonPaymentTotal04 == null ? 0 : bonPaymentTotal04.intValue();
		int amountBon05 = bonPaymentTotal05 == null ? 0 : bonPaymentTotal05.intValue();
		int amountBon06 = bonPaymentTotal06 == null ? 0 : bonPaymentTotal06.intValue();
		
		totalPayPaymentTotal = new Integer(amount01 + amount02 + amount03 + amount04 + amount05 + amount06 + amount07
				+ amount08 + amount09 + amount10 + amount11 + amount12);
		
		totalBonPaymentTotal = new Integer(amountBon01 + amountBon02 + amountBon03 + amountBon04 + amountBon05
				+ amountBon06);
		
		paymentTotal = new Integer(+amount01 + amount02 + amount03 + amount04 + amount05 + amount06 + amount07
				+ amount08 + amount09 + amount10 + amount11 + amount12 + amountBon01 + amountBon02 + amountBon03
				+ amountBon04 + amountBon05 + amountBon06);
		
	}
	
	private void setTotalpayAdjCalcGapTotal() {
		
		int amount01 = payAdjCalcGap01 == null ? 0 : payAdjCalcGap01.intValue();
		int amount02 = payAdjCalcGap02 == null ? 0 : payAdjCalcGap02.intValue();
		int amount03 = payAdjCalcGap03 == null ? 0 : payAdjCalcGap03.intValue();
		int amount04 = payAdjCalcGap04 == null ? 0 : payAdjCalcGap04.intValue();
		int amount05 = payAdjCalcGap05 == null ? 0 : payAdjCalcGap05.intValue();
		int amount06 = payAdjCalcGap06 == null ? 0 : payAdjCalcGap06.intValue();
		int amount07 = payAdjCalcGap07 == null ? 0 : payAdjCalcGap07.intValue();
		int amount08 = payAdjCalcGap08 == null ? 0 : payAdjCalcGap08.intValue();
		int amount09 = payAdjCalcGap09 == null ? 0 : payAdjCalcGap09.intValue();
		int amount10 = payAdjCalcGap10 == null ? 0 : payAdjCalcGap10.intValue();
		int amount11 = payAdjCalcGap11 == null ? 0 : payAdjCalcGap11.intValue();
		int amount12 = payAdjCalcGap12 == null ? 0 : payAdjCalcGap12.intValue();
		
		int amountBon01 = bonAdjCalcGap01 == null ? 0 : bonAdjCalcGap01.intValue();
		int amountBon02 = bonAdjCalcGap02 == null ? 0 : bonAdjCalcGap02.intValue();
		int amountBon03 = bonAdjCalcGap03 == null ? 0 : bonAdjCalcGap03.intValue();
		int amountBon04 = bonAdjCalcGap04 == null ? 0 : bonAdjCalcGap04.intValue();
		int amountBon05 = bonAdjCalcGap05 == null ? 0 : bonAdjCalcGap05.intValue();
		int amountBon06 = bonAdjCalcGap06 == null ? 0 : bonAdjCalcGap06.intValue();
		
		totalPayAdjCalcGap = new Integer(amount01 + amount02 + amount03 + amount04 + amount05 + amount06 + amount07
				+ amount08 + amount09 + amount10 + amount11 + amount12);
		totalBonAdjCalcGap = new Integer(amountBon01 + amountBon02 + amountBon03 + amountBon04 + amountBon05
				+ amountBon06);
	}
	
	/**
	 * ^ݒ肷B<br>
	 * @param idx          ݒΏی
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData(int idx, boolean isSetData, PhPaymentDto phPaymentDto,
			PdPayDeductionDao pdPayDeductionDao) throws SQLException, NoSuchFieldException, IllegalAccessException {
		switch (idx) {
			case 0:
				setPaymentData01(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 1:
				setPaymentData02(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 2:
				setPaymentData03(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 3:
				setPaymentData04(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 4:
				setPaymentData05(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 5:
				setPaymentData06(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 6:
				setPaymentData07(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 7:
				setPaymentData08(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 8:
				setPaymentData09(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 9:
				setPaymentData10(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 10:
				setPaymentData11(isSetData, phPaymentDto, pdPayDeductionDao);
				break;
			case 11:
				setPaymentData12(isSetData, phPaymentDto, pdPayDeductionDao);
			default:
				break;
		}
	}
	
	/**
	 * 1̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData01(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao)
			throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto; // ^׃f[^pDTO
		int restaxTmp = 0; // ZŎ擾p
		int genaraldeductionTmp = 0; // TvZp
		
		//ZŎ擾
		restaxTmp = 0;
		
		if (isSetData) {
			pdPayDeductionDto = pdPayDeductionDao.findForDetail(phPaymentDto.getKCode(), phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if (pdPayDeductionDto != null) {
				restaxTmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeductionTmp = phPaymentDto.getDeductionTotal() - phPaymentDto.getIncomeTax() - restaxTmp
					- phPaymentDto.getSocInsTotal();
			if (genaraldeductionTmp < 0) {
				genaraldeductionTmp = 0;
			}
			
			paymentMonth01 = String.valueOf(MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay01 = String.valueOf(MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance01 = new Integer(phPaymentDto.getAllowanceTotal());
			payTaxFree01 = new Integer(phPaymentDto.getTaxExempt());
			payTaxation01 = new Integer(phPaymentDto.getAmountToTaxation() + phPaymentDto.getSocInsTotal());
			payIncomeTax01 = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction01 = new Integer(phPaymentDto.getSocInsTotal());
			payPayInsDeduction01 = new Integer(phPaymentDto.getAmountToTaxation());
			payDependentCount01 = new Integer(phPaymentDto.getDependent());
			payVariousDeduction01 = new Integer(genaraldeductionTmp); // Tzݒ
			payPaymentTotal01 = new Integer(phPaymentDto.getPaymentTotal());
			payAdjCalcGap01 = new Integer(0);
			payPaymentTax01 = payIncomeTax01 - payAdjCalcGap01; // Ŋz01
		} else {
			paymentMonth01 = "";
			paymentPayDay01 = "";
			payTotalAllowance01 = null;
			payTaxFree01 = null;
			payTaxation01 = null;
			payIncomeTax01 = null;
			paySocInsDeduction01 = null;
			payPayInsDeduction01 = null;
			payDependentCount01 = null;
			payAdjCalcGap01 = null;
			payVariousDeduction01 = null;
			payPaymentTotal01 = null;
			payPaymentTax01 = null; // Ŋz01
		}
	}
	
	/**
	 * 2̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData02(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao)
			throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto; // ^׃f[^pDTO
		int restaxTmp = 0; // ZŎ擾p
		int genaraldeductionTmp = 0; // TvZp
		
		//ZŎ擾
		restaxTmp = 0;
		if (isSetData) {
			pdPayDeductionDto = pdPayDeductionDao.findForDetail(phPaymentDto.getKCode(), phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if (pdPayDeductionDto != null) {
				restaxTmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeductionTmp = phPaymentDto.getDeductionTotal() - phPaymentDto.getIncomeTax() - restaxTmp
					- phPaymentDto.getSocInsTotal();
			if (genaraldeductionTmp < 0) {
				genaraldeductionTmp = 0;
			}
			paymentMonth02 = String.valueOf(MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay02 = String.valueOf(MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance02 = new Integer(phPaymentDto.getAllowanceTotal());
			payTaxFree02 = new Integer(phPaymentDto.getTaxExempt());
			payTaxation02 = new Integer(phPaymentDto.getAmountToTaxation() + phPaymentDto.getSocInsTotal());
			payIncomeTax02 = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction02 = new Integer(phPaymentDto.getSocInsTotal());
			payPayInsDeduction02 = new Integer(phPaymentDto.getAmountToTaxation());
			payDependentCount02 = new Integer(phPaymentDto.getDependent());
			payVariousDeduction02 = new Integer(genaraldeductionTmp);
			payPaymentTotal02 = new Integer(phPaymentDto.getPaymentTotal());
			payAdjCalcGap02 = new Integer(0);
			payPaymentTax02 = payIncomeTax02 - payAdjCalcGap02; // Ŋz02
		} else {
			paymentMonth02 = "";
			paymentPayDay02 = "";
			payTotalAllowance02 = null;
			payTaxFree02 = null;
			payTaxation02 = null;
			payIncomeTax02 = null;
			paySocInsDeduction02 = null;
			payPayInsDeduction02 = null;
			payDependentCount02 = null;
			payAdjCalcGap02 = null;
			payVariousDeduction02 = null;
			payPaymentTotal02 = null;
			payPaymentTax02 = null; // Ŋz02
		}
	}
	
	/**
	 * 3̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData03(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao)
			throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto; // ^׃f[^pDTO
		int restaxTmp = 0; // ZŎ擾p
		int genaraldeductionTmp = 0; // TvZp
		
		//ZŎ擾
		restaxTmp = 0;
		if (isSetData) {
			pdPayDeductionDto = pdPayDeductionDao.findForDetail(phPaymentDto.getKCode(), phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if (pdPayDeductionDto != null) {
				restaxTmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeductionTmp = phPaymentDto.getDeductionTotal() - phPaymentDto.getIncomeTax() - restaxTmp
					- phPaymentDto.getSocInsTotal();
			if (genaraldeductionTmp < 0) {
				genaraldeductionTmp = 0;
			}
			
			paymentMonth03 = String.valueOf(MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay03 = String.valueOf(MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance03 = new Integer(phPaymentDto.getAllowanceTotal());
			payTaxFree03 = new Integer(phPaymentDto.getTaxExempt());
			payTaxation03 = new Integer(phPaymentDto.getAmountToTaxation() + phPaymentDto.getSocInsTotal());
			payIncomeTax03 = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction03 = new Integer(phPaymentDto.getSocInsTotal());
			payPayInsDeduction03 = new Integer(phPaymentDto.getAmountToTaxation());
			payDependentCount03 = new Integer(phPaymentDto.getDependent());
			payVariousDeduction03 = new Integer(genaraldeductionTmp);
			payPaymentTotal03 = new Integer(phPaymentDto.getPaymentTotal());
			payAdjCalcGap03 = null;
			payPaymentTax03 = payIncomeTax03; // Ŋz03
		} else {
			paymentMonth03 = "";
			paymentPayDay03 = "";
			payTotalAllowance03 = null;
			payTaxFree03 = null;
			payTaxation03 = null;
			payIncomeTax03 = null;
			paySocInsDeduction03 = null;
			payPayInsDeduction03 = null;
			payDependentCount03 = null;
			payAdjCalcGap03 = null;
			payVariousDeduction03 = null;
			payPaymentTotal03 = null;
		}
	}
	
	/**
	 * 4̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData04(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao)
			throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto; // ^׃f[^pDTO
		int restaxTmp = 0; // ZŎ擾p
		int genaraldeductionTmp = 0; // TvZp
		
		//ZŎ擾
		restaxTmp = 0;
		
		if (isSetData) {
			pdPayDeductionDto = pdPayDeductionDao.findForDetail(phPaymentDto.getKCode(), phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if (pdPayDeductionDto != null) {
				restaxTmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeductionTmp = phPaymentDto.getDeductionTotal() - phPaymentDto.getIncomeTax() - restaxTmp
					- phPaymentDto.getSocInsTotal();
			if (genaraldeductionTmp < 0) {
				genaraldeductionTmp = 0;
			}
			
			paymentMonth04 = String.valueOf(MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay04 = String.valueOf(MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance04 = new Integer(phPaymentDto.getAllowanceTotal());
			payTaxFree04 = new Integer(phPaymentDto.getTaxExempt());
			payTaxation04 = new Integer(phPaymentDto.getAmountToTaxation() + phPaymentDto.getSocInsTotal());
			payIncomeTax04 = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction04 = new Integer(phPaymentDto.getSocInsTotal());
			payPayInsDeduction04 = new Integer(phPaymentDto.getAmountToTaxation());
			payDependentCount04 = new Integer(phPaymentDto.getDependent());
			payVariousDeduction04 = new Integer(genaraldeductionTmp);
			payPaymentTotal04 = new Integer(phPaymentDto.getPaymentTotal());
			payAdjCalcGap04 = null;
			payPaymentTax04 = payIncomeTax04; // Ŋz04
		} else {
			paymentMonth04 = "";
			paymentPayDay04 = "";
			payTotalAllowance04 = null;
			payTaxFree04 = null;
			payTaxation04 = null;
			payIncomeTax04 = null;
			paySocInsDeduction04 = null;
			payPayInsDeduction04 = null;
			payDependentCount04 = null;
			payAdjCalcGap04 = null;
			payVariousDeduction04 = null;
			payPaymentTotal04 = null;
		}
	}
	
	/**
	 * 5̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData05(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao)
			throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto; // ^׃f[^pDTO
		int restaxTmp = 0; // ZŎ擾p
		int genaraldeductionTmp = 0; // TvZp
		
		//ZŎ擾
		restaxTmp = 0;
		
		if (isSetData) {
			pdPayDeductionDto = pdPayDeductionDao.findForDetail(phPaymentDto.getKCode(), phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if (pdPayDeductionDto != null) {
				restaxTmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeductionTmp = phPaymentDto.getDeductionTotal() - phPaymentDto.getIncomeTax() - restaxTmp
					- phPaymentDto.getSocInsTotal();
			if (genaraldeductionTmp < 0) {
				genaraldeductionTmp = 0;
			}
			
			paymentMonth05 = String.valueOf(MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay05 = String.valueOf(MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance05 = new Integer(phPaymentDto.getAllowanceTotal());
			payTaxFree05 = new Integer(phPaymentDto.getTaxExempt());
			payTaxation05 = new Integer(phPaymentDto.getAmountToTaxation() + phPaymentDto.getSocInsTotal());
			payIncomeTax05 = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction05 = new Integer(phPaymentDto.getSocInsTotal());
			payPayInsDeduction05 = new Integer(phPaymentDto.getAmountToTaxation());
			payDependentCount05 = new Integer(phPaymentDto.getDependent());
			payVariousDeduction05 = new Integer(genaraldeductionTmp);
			payPaymentTotal05 = new Integer(phPaymentDto.getPaymentTotal());
			payAdjCalcGap05 = null;
			payPaymentTax05 = payIncomeTax05; // Ŋz05
		} else {
			paymentMonth05 = "";
			paymentPayDay05 = "";
			payTotalAllowance05 = null;
			payTaxFree05 = null;
			payTaxation05 = null;
			payIncomeTax05 = null;
			paySocInsDeduction05 = null;
			payPayInsDeduction05 = null;
			payDependentCount05 = null;
			payAdjCalcGap05 = null;
			payVariousDeduction05 = null;
			payPaymentTotal05 = null;
		}
	}
	
	/**
	 * 6̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData06(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao)
			throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto; // ^׃f[^pDTO
		int restaxTmp = 0; // ZŎ擾p
		int genaraldeductionTmp = 0; // TvZp
		
		//ZŎ擾
		restaxTmp = 0;
		
		if (isSetData) {
			pdPayDeductionDto = pdPayDeductionDao.findForDetail(phPaymentDto.getKCode(), phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if (pdPayDeductionDto != null) {
				restaxTmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeductionTmp = phPaymentDto.getDeductionTotal() - phPaymentDto.getIncomeTax() - restaxTmp
					- phPaymentDto.getSocInsTotal();
			if (genaraldeductionTmp < 0) {
				genaraldeductionTmp = 0;
			}
			
			paymentMonth06 = String.valueOf(MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay06 = String.valueOf(MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance06 = new Integer(phPaymentDto.getAllowanceTotal());
			payTaxFree06 = new Integer(phPaymentDto.getTaxExempt());
			payTaxation06 = new Integer(phPaymentDto.getAmountToTaxation() + phPaymentDto.getSocInsTotal());
			payIncomeTax06 = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction06 = new Integer(phPaymentDto.getSocInsTotal());
			payPayInsDeduction06 = new Integer(phPaymentDto.getAmountToTaxation());
			payDependentCount06 = new Integer(phPaymentDto.getDependent());
			payVariousDeduction06 = new Integer(genaraldeductionTmp);
			payPaymentTotal06 = new Integer(phPaymentDto.getPaymentTotal());
			payAdjCalcGap06 = null;
			payPaymentTax06 = payIncomeTax06; // Ŋz06
		} else {
			paymentMonth06 = "";
			paymentPayDay06 = "";
			payTotalAllowance06 = null;
			payTaxFree06 = null;
			payTaxation06 = null;
			payIncomeTax06 = null;
			paySocInsDeduction06 = null;
			payPayInsDeduction06 = null;
			payDependentCount06 = null;
			payAdjCalcGap06 = null;
			payVariousDeduction06 = null;
			payPaymentTotal06 = null;
		}
	}
	
	/**
	 * 7̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData07(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao)
			throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto; // ^׃f[^pDTO
		int restaxTmp = 0; // ZŎ擾p
		int genaraldeductionmp = 0; // TvZp
		
		//ZŎ擾
		restaxTmp = 0;
		
		if (isSetData) {
			pdPayDeductionDto = pdPayDeductionDao.findForDetail(phPaymentDto.getKCode(), phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if (pdPayDeductionDto != null) {
				restaxTmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeductionmp = phPaymentDto.getDeductionTotal() - phPaymentDto.getIncomeTax() - restaxTmp
					- phPaymentDto.getSocInsTotal();
			if (genaraldeductionmp < 0) {
				genaraldeductionmp = 0;
			}
			
			paymentMonth07 = String.valueOf(MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay07 = String.valueOf(MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance07 = new Integer(phPaymentDto.getAllowanceTotal());
			payTaxFree07 = new Integer(phPaymentDto.getTaxExempt());
			payTaxation07 = new Integer(phPaymentDto.getAmountToTaxation() + phPaymentDto.getSocInsTotal());
			payIncomeTax07 = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction07 = new Integer(phPaymentDto.getSocInsTotal());
			payPayInsDeduction07 = new Integer(phPaymentDto.getAmountToTaxation());
			payDependentCount07 = new Integer(phPaymentDto.getDependent());
			payVariousDeduction07 = new Integer(genaraldeductionmp);
			payPaymentTotal07 = new Integer(phPaymentDto.getPaymentTotal());
			payAdjCalcGap07 = null;
			payPaymentTax07 = payIncomeTax07; // Ŋz07
		} else {
			paymentMonth07 = "";
			paymentPayDay07 = "";
			payTotalAllowance07 = null;
			payTaxFree07 = null;
			payTaxation07 = null;
			payIncomeTax07 = null;
			paySocInsDeduction07 = null;
			payPayInsDeduction07 = null;
			payDependentCount07 = null;
			payAdjCalcGap07 = null;
			payVariousDeduction07 = null;
			payPaymentTotal07 = null;
		}
	}
	
	/**
	 * 8̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData08(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao)
			throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto; // ^׃f[^pDTO
		int restaxTmp = 0; // ZŎ擾p
		int genaraldeductionTmp = 0; // TvZp
		
		//ZŎ擾
		restaxTmp = 0;
		
		if (isSetData) {
			pdPayDeductionDto = pdPayDeductionDao.findForDetail(phPaymentDto.getKCode(), phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if (pdPayDeductionDto != null) {
				restaxTmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeductionTmp = phPaymentDto.getDeductionTotal() - phPaymentDto.getIncomeTax() - restaxTmp
					- phPaymentDto.getSocInsTotal();
			if (genaraldeductionTmp < 0) {
				genaraldeductionTmp = 0;
			}
			
			paymentMonth08 = String.valueOf(MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay08 = String.valueOf(MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance08 = new Integer(phPaymentDto.getAllowanceTotal());
			payTaxFree08 = new Integer(phPaymentDto.getTaxExempt());
			payTaxation08 = new Integer(phPaymentDto.getAmountToTaxation() + phPaymentDto.getSocInsTotal());
			payIncomeTax08 = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction08 = new Integer(phPaymentDto.getSocInsTotal());
			payPayInsDeduction08 = new Integer(phPaymentDto.getAmountToTaxation());
			payDependentCount08 = new Integer(phPaymentDto.getDependent());
			payVariousDeduction08 = new Integer(genaraldeductionTmp);
			payPaymentTotal08 = new Integer(phPaymentDto.getPaymentTotal());
			payAdjCalcGap08 = null;
			payPaymentTax08 = payIncomeTax08; // Ŋz08
		} else {
			paymentMonth08 = "";
			paymentPayDay08 = "";
			payTotalAllowance08 = null;
			payTaxFree08 = null;
			payTaxation08 = null;
			payIncomeTax08 = null;
			paySocInsDeduction08 = null;
			payPayInsDeduction08 = null;
			payDependentCount08 = null;
			payAdjCalcGap08 = null;
			payVariousDeduction08 = null;
			payPaymentTotal08 = null;
		}
	}
	
	/**
	 * 9̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData09(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao)
			throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto; // ^׃f[^pDTO
		int restaxTmp = 0; // ZŎ擾p
		int genaraldeductionTmp = 0; // TvZp
		
		//ZŎ擾
		restaxTmp = 0;
		
		if (isSetData) {
			pdPayDeductionDto = pdPayDeductionDao.findForDetail(phPaymentDto.getKCode(), phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if (pdPayDeductionDto != null) {
				restaxTmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeductionTmp = phPaymentDto.getDeductionTotal() - phPaymentDto.getIncomeTax() - restaxTmp
					- phPaymentDto.getSocInsTotal();
			if (genaraldeductionTmp < 0) {
				genaraldeductionTmp = 0;
			}
			
			paymentMonth09 = String.valueOf(MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay09 = String.valueOf(MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance09 = new Integer(phPaymentDto.getAllowanceTotal());
			payTaxFree09 = new Integer(phPaymentDto.getTaxExempt());
			payTaxation09 = new Integer(phPaymentDto.getAmountToTaxation() + phPaymentDto.getSocInsTotal());
			payIncomeTax09 = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction09 = new Integer(phPaymentDto.getSocInsTotal());
			payPayInsDeduction09 = new Integer(phPaymentDto.getAmountToTaxation());
			payDependentCount09 = new Integer(phPaymentDto.getDependent());
			payVariousDeduction09 = new Integer(genaraldeductionTmp);
			payPaymentTotal09 = new Integer(phPaymentDto.getPaymentTotal());
			payAdjCalcGap09 = null;
			payPaymentTax09 = payIncomeTax09; // Ŋz09
		} else {
			paymentMonth09 = "";
			paymentPayDay09 = "";
			payTotalAllowance09 = null;
			payTaxFree09 = null;
			payTaxation09 = null;
			payIncomeTax09 = null;
			paySocInsDeduction09 = null;
			payPayInsDeduction09 = null;
			payDependentCount09 = null;
			payAdjCalcGap09 = null;
			payVariousDeduction09 = null;
			payPaymentTotal09 = null;
		}
	}
	
	/**
	 * 10̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData10(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao)
			throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto; // ^׃f[^pDTO
		int restaxTmp = 0; // ZŎ擾p
		int genaraldeductionTmp = 0; // TvZp
		
		//ZŎ擾
		restaxTmp = 0;
		
		if (isSetData) {
			pdPayDeductionDto = pdPayDeductionDao.findForDetail(phPaymentDto.getKCode(), phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if (pdPayDeductionDto != null) {
				restaxTmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeductionTmp = phPaymentDto.getDeductionTotal() - phPaymentDto.getIncomeTax() - restaxTmp
					- phPaymentDto.getSocInsTotal();
			if (genaraldeductionTmp < 0) {
				genaraldeductionTmp = 0;
			}
			
			paymentMonth10 = String.valueOf(MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay10 = String.valueOf(MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance10 = new Integer(phPaymentDto.getAllowanceTotal());
			payTaxFree10 = new Integer(phPaymentDto.getTaxExempt());
			payTaxation10 = new Integer(phPaymentDto.getAmountToTaxation() + phPaymentDto.getSocInsTotal());
			payIncomeTax10 = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction10 = new Integer(phPaymentDto.getSocInsTotal());
			payPayInsDeduction10 = new Integer(phPaymentDto.getAmountToTaxation());
			payDependentCount10 = new Integer(phPaymentDto.getDependent());
			payVariousDeduction10 = new Integer(genaraldeductionTmp);
			payPaymentTotal10 = new Integer(phPaymentDto.getPaymentTotal());
			payAdjCalcGap10 = null;
			payPaymentTax10 = payIncomeTax10; // Ŋz10
		} else {
			paymentMonth10 = "";
			paymentPayDay10 = "";
			payTotalAllowance10 = null;
			payTaxFree10 = null;
			payTaxation10 = null;
			payIncomeTax10 = null;
			paySocInsDeduction10 = null;
			payPayInsDeduction10 = null;
			payDependentCount10 = null;
			payAdjCalcGap10 = null;
			payVariousDeduction10 = null;
			payPaymentTotal10 = null;
		}
	}
	
	/**
	 * 11̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData11(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao)
			throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto; // ^׃f[^pDTO
		int restaxTmp = 0; // ZŎ擾p
		int genaraldeductionTmp = 0; // TvZp
		
		//ZŎ擾
		restaxTmp = 0;
		
		if (isSetData) {
			pdPayDeductionDto = pdPayDeductionDao.findForDetail(phPaymentDto.getKCode(), phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if (pdPayDeductionDto != null) {
				restaxTmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeductionTmp = phPaymentDto.getDeductionTotal() - phPaymentDto.getIncomeTax() - restaxTmp
					- phPaymentDto.getSocInsTotal();
			if (genaraldeductionTmp < 0) {
				genaraldeductionTmp = 0;
			}
			
			paymentMonth11 = String.valueOf(MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay11 = String.valueOf(MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance11 = new Integer(phPaymentDto.getAllowanceTotal());
			payTaxFree11 = new Integer(phPaymentDto.getTaxExempt());
			payTaxation11 = new Integer(phPaymentDto.getAmountToTaxation() + phPaymentDto.getSocInsTotal());
			payIncomeTax11 = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction11 = new Integer(phPaymentDto.getSocInsTotal());
			payPayInsDeduction11 = new Integer(phPaymentDto.getAmountToTaxation());
			payDependentCount11 = new Integer(phPaymentDto.getDependent());
			payVariousDeduction11 = new Integer(genaraldeductionTmp);
			payPaymentTotal11 = new Integer(phPaymentDto.getPaymentTotal());
			payAdjCalcGap11 = null;
			payPaymentTax11 = payIncomeTax11; // Ŋz11
		} else {
			paymentMonth11 = "";
			paymentPayDay11 = "";
			payTotalAllowance11 = null;
			payTaxFree11 = null;
			payTaxation11 = null;
			payIncomeTax11 = null;
			paySocInsDeduction11 = null;
			payPayInsDeduction11 = null;
			payDependentCount11 = null;
			payAdjCalcGap11 = null;
			payVariousDeduction11 = null;
			payPaymentTotal11 = null;
		}
	}
	
	/**
	 * 12̋^ݒ肷B<br>
	 * @param isSetData    ݒtO(trueFݒAfalseF)
	 * @param phPaymentDto ݒΏۋ^
	 * @param pdPayDeductionDao ^׏DAO
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 * @throws SQLException 
	 */
	private void setPaymentData12(boolean isSetData, PhPaymentDto phPaymentDto, PdPayDeductionDao pdPayDeductionDao)
			throws SQLException, NoSuchFieldException, IllegalAccessException {
		DetailMoneyDto pdPayDeductionDto; // ^׃f[^pDTO
		int restaxTmp = 0; // ZŎ擾p
		int genaraldeductionTmp = 0; // TvZp
		
		//ZŎ擾
		restaxTmp = 0;
		
		if (isSetData) {
			pdPayDeductionDto = pdPayDeductionDao.findForDetail(phPaymentDto.getKCode(), phPaymentDto.getCalcMonth(),
					PayrollConst.DTL_RESIDENCE_TAX);
			if (pdPayDeductionDto != null) {
				restaxTmp = pdPayDeductionDto.getAmount();
			}
			// Tz = Tz|Ŋz|ZŁ|Љی
			genaraldeductionTmp = phPaymentDto.getDeductionTotal() - phPaymentDto.getIncomeTax() - restaxTmp
					- phPaymentDto.getSocInsTotal();
			if (genaraldeductionTmp < 0) {
				genaraldeductionTmp = 0;
			}
			
			paymentMonth12 = String.valueOf(MospUtility.getMonth(phPaymentDto.getPayDate()));
			paymentPayDay12 = String.valueOf(MospUtility.getDay(phPaymentDto.getPayDate()));
			payTotalAllowance12 = new Integer(phPaymentDto.getAllowanceTotal());
			payTaxFree12 = new Integer(phPaymentDto.getTaxExempt());
			payTaxation12 = new Integer(phPaymentDto.getAmountToTaxation() + phPaymentDto.getSocInsTotal());
			payIncomeTax12 = new Integer(phPaymentDto.getIncomeTax());
			paySocInsDeduction12 = new Integer(phPaymentDto.getSocInsTotal());
			payPayInsDeduction12 = new Integer(phPaymentDto.getAmountToTaxation());
			payDependentCount12 = new Integer(phPaymentDto.getDependent());
			payVariousDeduction12 = new Integer(genaraldeductionTmp);
			payPaymentTotal12 = new Integer(phPaymentDto.getPaymentTotal());
			payAdjCalcGap12 = null;
			payPaymentTax12 = payIncomeTax12; // Ŋz12
		} else {
			paymentMonth12 = "";
			paymentPayDay12 = "";
			payTotalAllowance12 = null;
			payTaxFree12 = null;
			payTaxation12 = null;
			payIncomeTax12 = null;
			paySocInsDeduction12 = null;
			payPayInsDeduction12 = null;
			payDependentCount12 = null;
			payAdjCalcGap12 = null;
			payVariousDeduction12 = null;
			payPaymentTotal12 = null;
		}
	}
	
	/**
	 * ܗ^ݒ肷B<br>
	 * @param idx        ݒΏۉ
	 * @param isSetData  ݒtO(trueFݒAfalseF)
	 * @param udBonusDto ݒΏۏܗ^
	 */
	private void setBonusData(int idx, boolean isSetData, PhBounsDto udBonusDto) {
		switch (idx) {
			case 0:
				setBonusData01(isSetData, udBonusDto);
				break;
			case 1:
				setBonusData02(isSetData, udBonusDto);
				break;
			case 2:
				setBonusData03(isSetData, udBonusDto);
				break;
			case 3:
				setBonusData04(isSetData, udBonusDto);
				break;
			case 4:
				setBonusData05(isSetData, udBonusDto);
				break;
			case 5:
				setBonusData06(isSetData, udBonusDto);
				break;
			default:
				break;
		}
	}
	
	/**
	 * 1̏ܗ^ݒ肷B<br>
	 * @param isSetData  ݒtO(trueFݒAfalseF)
	 * @param udBonusDto ݒΏۋ^
	 */
	private void setBonusData01(boolean isSetData, PhBounsDto udBonusDto) {
		if (isSetData) {
			bonusMonth01 = String.valueOf(MospUtility.getMonth(udBonusDto.getPayDate()));
			bonusPayDay01 = String.valueOf(MospUtility.getDay(udBonusDto.getPayDate()));
			bonTotalAllowance01 = new Integer(udBonusDto.getAllowanceTotal());
			bonTaxFree01 = null;
			bonTaxation01 = new Integer(udBonusDto.getAllowanceTotal());
			bonIncomeTax01 = new Integer(udBonusDto.getIncomeTax());
//			bonIncomeTaxRate01   = new Float(udBonusDto.getIncomeRate() * 100); // ŗ
			bonIncomeTaxRate01 = new Float(0); // ŗ
			bonSocInsDeduction01 = new Integer(udBonusDto.getSocInsTotal());
			bonPayInsDeduction01 = new Integer(udBonusDto.getAllowanceTotal() - udBonusDto.getSocInsTotal());
			bonDependentCount01 = new Integer(udBonusDto.getDependent());
//			bonVariousDeduction01 = new Integer(udBonusDto.calcBonusGenaralDeduction());	// Tz
			bonVariousDeduction01 = new Integer(0); // Tz
			bonPaymentTotal01 = new Integer(udBonusDto.getPaymentTotal());
			bonAdjCalcGap01 = null;
			bonPaymentTax01 = bonIncomeTax01; // (ܗ^)01
		} else {
			bonusMonth01 = "";
			bonusPayDay01 = "";
			bonTotalAllowance01 = null;
			bonTaxFree01 = null;
			bonTaxation01 = null;
			bonIncomeTaxRate01 = null;
			bonIncomeTax01 = null;
			bonSocInsDeduction01 = null;
			bonPayInsDeduction01 = null;
			bonDependentCount01 = null;
			bonVariousDeduction01 = null;
			bonPaymentTotal01 = null;
			bonAdjCalcGap01 = null;
			bonPaymentTotal01 = null;
		}
	}
	
	/**
	 * 2̏ܗ^ݒ肷B<br>
	 * @param isSetData  ݒtO(trueFݒAfalseF)
	 * @param udBonusDto ݒΏۋ^
	 */
	private void setBonusData02(boolean isSetData, PhBounsDto udBonusDto) {
		if (isSetData) {
			bonusMonth02 = String.valueOf(MospUtility.getMonth(udBonusDto.getPayDate()));
			bonusPayDay02 = String.valueOf(MospUtility.getDay(udBonusDto.getPayDate()));
			bonTotalAllowance02 = new Integer(udBonusDto.getAllowanceTotal());
			bonTaxFree02 = null;
			bonTaxation02 = new Integer(udBonusDto.getAllowanceTotal());
			bonIncomeTax02 = new Integer(udBonusDto.getIncomeTax());
//			bonIncomeTaxRate02   = new Float(udBonusDto.getIncomeRate() * 100); // ŗ
			bonIncomeTaxRate02 = new Float(0); // ŗ
			bonSocInsDeduction02 = new Integer(udBonusDto.getSocInsTotal());
			bonPayInsDeduction02 = new Integer(udBonusDto.getAllowanceTotal() - udBonusDto.getSocInsTotal());
			bonDependentCount02 = new Integer(udBonusDto.getDependent());
//			bonVariousDeduction02 = new Integer(udBonusDto.calcBonusGenaralDeduction()); // Tz
			bonVariousDeduction02 = new Integer(0); // Tz
			bonPaymentTotal02 = new Integer(udBonusDto.getPaymentTotal());
			bonAdjCalcGap02 = null;
			bonPaymentTax02 = bonIncomeTax02; // (ܗ^)02
		} else {
			bonusMonth02 = "";
			bonusPayDay02 = "";
			bonTotalAllowance02 = null;
			bonTaxFree02 = null;
			bonTaxation02 = null;
			bonIncomeTax02 = null;
			bonIncomeTaxRate02 = null;
			bonSocInsDeduction02 = null;
			bonPayInsDeduction02 = null;
			bonDependentCount02 = null;
			bonVariousDeduction02 = null;
			bonPaymentTotal02 = null;
			bonAdjCalcGap02 = null;
			bonPaymentTax02 = null; // (ܗ^)02
		}
	}
	
	/**
	 * 3̏ܗ^ݒ肷B<br>
	 * @param isSetData  ݒtO(trueFݒAfalseF)
	 * @param udBonusDto ݒΏۋ^
	 */
	private void setBonusData03(boolean isSetData, PhBounsDto udBonusDto) {
		if (isSetData) {
			bonusMonth03 = String.valueOf(MospUtility.getMonth(udBonusDto.getPayDate()));
			bonusPayDay03 = String.valueOf(MospUtility.getDay(udBonusDto.getPayDate()));
			bonTotalAllowance03 = new Integer(udBonusDto.getAllowanceTotal());
			bonTaxFree03 = null;
			bonTaxation03 = new Integer(udBonusDto.getAllowanceTotal());
			bonIncomeTax03 = new Integer(udBonusDto.getIncomeTax());
//			bonIncomeTaxRate03   = new Float(udBonusDto.getIncomeRate() * 100); // ŗ
			bonIncomeTaxRate03 = new Float(0); // ŗ
			bonSocInsDeduction03 = new Integer(udBonusDto.getSocInsTotal());
			bonPayInsDeduction03 = new Integer(udBonusDto.getAllowanceTotal() - udBonusDto.getSocInsTotal());
			bonDependentCount03 = new Integer(udBonusDto.getDependent());
//			bonVariousDeduction03 = new Integer(udBonusDto.calcBonusGenaralDeduction()); // Tz
			bonVariousDeduction03 = new Integer(0); // Tz
			bonPaymentTotal03 = new Integer(udBonusDto.getPaymentTotal());
			bonAdjCalcGap03 = null;
			bonPaymentTax03 = bonIncomeTax03; // (ܗ^)03
		} else {
			bonusMonth03 = "";
			bonusPayDay03 = "";
			bonTotalAllowance03 = null;
			bonTaxFree03 = null;
			bonTaxation03 = null;
			bonIncomeTax03 = null;
			bonIncomeTaxRate03 = null;
			bonSocInsDeduction03 = null;
			bonPayInsDeduction03 = null;
			bonDependentCount03 = null;
			bonVariousDeduction03 = null;
			bonPaymentTotal03 = null;
			bonAdjCalcGap03 = null;
			bonPaymentTax03 = null; // (ܗ^)03
		}
	}
	
	/**
	 * 4̏ܗ^ݒ肷B<br>
	 * @param isSetData  ݒtO(trueFݒAfalseF)
	 * @param udBonusDto ݒΏۋ^
	 */
	private void setBonusData04(boolean isSetData, PhBounsDto udBonusDto) {
		if (isSetData) {
			bonusMonth04 = String.valueOf(MospUtility.getMonth(udBonusDto.getPayDate()));
			bonusPayDay04 = String.valueOf(MospUtility.getDay(udBonusDto.getPayDate()));
			bonTotalAllowance04 = new Integer(udBonusDto.getAllowanceTotal());
			bonTaxFree04 = null;
			bonTaxation04 = new Integer(udBonusDto.getAllowanceTotal());
			bonIncomeTax04 = new Integer(udBonusDto.getIncomeTax());
//			bonIncomeTaxRate03   = new Float(udBonusDto.getIncomeRate() * 100); // ŗ
			bonIncomeTaxRate03 = new Float(0); // ŗ
			bonSocInsDeduction04 = new Integer(udBonusDto.getSocInsTotal());
			bonPayInsDeduction04 = new Integer(udBonusDto.getAllowanceTotal() - udBonusDto.getSocInsTotal());
			bonDependentCount04 = new Integer(udBonusDto.getDependent());
//			bonVariousDeduction04 = new Integer(udBonusDto.calcBonusGenaralDeduction()); // Tz
			bonVariousDeduction04 = new Integer(0); // Tz
			bonPaymentTotal04 = new Integer(udBonusDto.getPaymentTotal());
			bonAdjCalcGap04 = null;
			bonPaymentTax04 = bonIncomeTax04; // (ܗ^)04
		} else {
			bonusMonth04 = "";
			bonusPayDay04 = "";
			bonTotalAllowance04 = null;
			bonTaxFree04 = null;
			bonTaxation04 = null;
			bonIncomeTax04 = null;
			bonIncomeTaxRate04 = null;
			bonSocInsDeduction04 = null;
			bonPayInsDeduction04 = null;
			bonDependentCount04 = null;
			bonVariousDeduction04 = null;
			bonPaymentTotal04 = null;
			bonAdjCalcGap04 = null;
			bonPaymentTax04 = null; // (ܗ^)04
		}
	}
	
	/**
	 * 5̏ܗ^ݒ肷B<br>
	 * @param isSetData  ݒtO(trueFݒAfalseF)
	 * @param udBonusDto ݒΏۋ^
	 */
	private void setBonusData05(boolean isSetData, PhBounsDto udBonusDto) {
		if (isSetData) {
			bonusMonth05 = String.valueOf(MospUtility.getMonth(udBonusDto.getPayDate()));
			bonusPayDay05 = String.valueOf(MospUtility.getDay(udBonusDto.getPayDate()));
			bonTotalAllowance05 = new Integer(udBonusDto.getAllowanceTotal());
			bonTaxFree05 = null;
			bonTaxation05 = new Integer(udBonusDto.getAllowanceTotal());
			bonIncomeTax05 = new Integer(udBonusDto.getIncomeTax());
//			bonIncomeTaxRate03   = new Float(udBonusDto.getIncomeRate() * 100); // ŗ
			bonIncomeTaxRate03 = new Float(0); // ŗ
			bonSocInsDeduction05 = new Integer(udBonusDto.getSocInsTotal());
			bonPayInsDeduction05 = new Integer(udBonusDto.getAllowanceTotal() - udBonusDto.getSocInsTotal());
			bonDependentCount05 = new Integer(udBonusDto.getDependent());
//			bonVariousDeduction05 = new Integer(udBonusDto.calcBonusGenaralDeduction()); // Tz
			bonVariousDeduction05 = new Integer(0); // Tz
			bonPaymentTotal05 = new Integer(udBonusDto.getPaymentTotal());
			bonAdjCalcGap05 = null;
			bonPaymentTax05 = bonIncomeTax05; // (ܗ^)05
		} else {
			bonusMonth05 = "";
			bonusPayDay05 = "";
			bonTotalAllowance05 = null;
			bonTaxFree05 = null;
			bonTaxation05 = null;
			bonIncomeTax05 = null;
			bonIncomeTaxRate05 = null;
			bonSocInsDeduction05 = null;
			bonPayInsDeduction05 = null;
			bonDependentCount05 = null;
			bonVariousDeduction05 = null;
			bonPaymentTotal05 = null;
			bonAdjCalcGap05 = null;
			bonPaymentTax05 = null; // (ܗ^)05
		}
	}
	
	/**
	 * 6̏ܗ^ݒ肷B<br>
	 * @param isSetData  ݒtO(trueFݒAfalseF)
	 * @param udBonusDto ݒΏۋ^
	 */
	private void setBonusData06(boolean isSetData, PhBounsDto udBonusDto) {
		if (isSetData) {
			bonusMonth06 = String.valueOf(MospUtility.getMonth(udBonusDto.getPayDate()));
			bonusPayDay06 = String.valueOf(MospUtility.getDay(udBonusDto.getPayDate()));
			bonTotalAllowance06 = new Integer(udBonusDto.getAllowanceTotal());
			bonTaxFree06 = null;
			bonTaxation06 = new Integer(udBonusDto.getAllowanceTotal());
			bonIncomeTax06 = new Integer(udBonusDto.getIncomeTax());
//			bonIncomeTaxRate03   = new Float(udBonusDto.getIncomeRate() * 100); // ŗ
			bonIncomeTaxRate03 = new Float(0); // ŗ
			bonSocInsDeduction06 = new Integer(udBonusDto.getSocInsTotal());
			bonPayInsDeduction06 = new Integer(udBonusDto.getAllowanceTotal() - udBonusDto.getSocInsTotal());
			bonDependentCount06 = new Integer(udBonusDto.getDependent());
//			bonVariousDeduction06 = new Integer(udBonusDto.calcBonusGenaralDeduction()); // Tz
			bonVariousDeduction06 = new Integer(0); // Tz
			bonPaymentTotal06 = new Integer(udBonusDto.getPaymentTotal());
			bonAdjCalcGap06 = null;
			bonPaymentTax06 = bonIncomeTax06; // (ܗ^)06
		} else {
			bonusMonth06 = "";
			bonusPayDay06 = "";
			bonTotalAllowance06 = null;
			bonTaxFree06 = null;
			bonTaxation06 = null;
			bonIncomeTax06 = null;
			bonIncomeTaxRate06 = null;
			bonSocInsDeduction06 = null;
			bonPayInsDeduction06 = null;
			bonDependentCount06 = null;
			bonVariousDeduction06 = null;
			bonPaymentTotal06 = null;
			bonAdjCalcGap06 = null;
			bonPaymentTax06 = null; // (ܗ^)06
		}
	}
	
	// ANZT\bh
	/**
	 * @param adjustYear
	 */
	public void setAdjustYear(String adjustYear) {
		this.adjustYear = adjustYear;
	}
	
	/**
	 * @param adjustYear
	 */
	public void setAdjustYearYY(String adjustYear) {
		adjustYearYY = adjustYear;
	}
	
	/**
	 * @param stationCode
	 */
	public void setStationCode(String stationCode) {
		this.stationCode = stationCode;
	}
	
	public void setStationName(String stationName) {
		this.stationName = stationName;
	}
	
	public void setPositionCode(String positionCode) {
		this.positionCode = positionCode;
	}
	
	public void setPositionName(String positionName) {
		this.positionName = positionName;
	}
	
	public void settouKyu(String toukyu) {
		touKyu = toukyu;
	}
	
	public void setKCode(String kCode) {
		this.kCode = kCode;
	}
	
	public void setKName(String kName) {
		this.kName = kName;
	}
	
	/**
	 * @param fName
	 */
	public void setFName(String fName) {
		this.fName = fName;
	}
	
	/**
	 * @param postalCode
	 */
	public void setPostalCode(String postalCode) {
		this.postalCode = postalCode;
	}
	
	/**
	 * @param address
	 */
	public void setAddress(String address) {
		this.address = address;
	}
	
	public void setBirthDate(String birthDate) {
		this.birthDate = birthDate;
	}
	
	public void setPaymentMonth01(String paymentMonth01) {
		this.paymentMonth01 = paymentMonth01;
	} // x01
	
	public void setPaymentMonth02(String paymentMonth02) {
		this.paymentMonth02 = paymentMonth02;
	} // x02
	
	public void setPaymentMonth03(String paymentMonth03) {
		this.paymentMonth03 = paymentMonth03;
	} // x03
	
	public void setPaymentMonth04(String paymentMonth04) {
		this.paymentMonth04 = paymentMonth04;
	} // x04
	
	public void setPaymentMonth05(String paymentMonth05) {
		this.paymentMonth05 = paymentMonth05;
	} // x05
	
	public void setPaymentMonth06(String paymentMonth06) {
		this.paymentMonth06 = paymentMonth06;
	} // x06
	
	public void setPaymentMonth07(String paymentMonth07) {
		this.paymentMonth07 = paymentMonth07;
	} // x07
	
	public void setPaymentMonth08(String paymentMonth08) {
		this.paymentMonth08 = paymentMonth08;
	} // x08
	
	public void setPaymentMonth09(String paymentMonth09) {
		this.paymentMonth09 = paymentMonth09;
	} // x09
	
	public void setPaymentMonth10(String paymentMonth10) {
		this.paymentMonth10 = paymentMonth10;
	} // x10
	
	public void setPaymentMonth11(String paymentMonth11) {
		this.paymentMonth11 = paymentMonth11;
	} // x11
	
	public void setPaymentMonth12(String paymentMonth12) {
		this.paymentMonth12 = paymentMonth12;
	} // x12
	
	public void setPaymentPayDay01(String paymentPayDay01) {
		this.paymentPayDay01 = paymentPayDay01;
	} // x01
	
	public void setPaymentPayDay02(String paymentPayDay02) {
		this.paymentPayDay02 = paymentPayDay02;
	} // x02
	
	public void setPaymentPayDay03(String paymentPayDay03) {
		this.paymentPayDay03 = paymentPayDay03;
	} // x03
	
	public void setPaymentPayDay04(String paymentPayDay04) {
		this.paymentPayDay04 = paymentPayDay04;
	} // x04
	
	public void setPaymentPayDay05(String paymentPayDay05) {
		this.paymentPayDay05 = paymentPayDay05;
	} // x05
	
	public void setPaymentPayDay06(String paymentPayDay06) {
		this.paymentPayDay06 = paymentPayDay06;
	} // x06
	
	public void setPaymentPayDay07(String paymentPayDay07) {
		this.paymentPayDay07 = paymentPayDay07;
	} // x07
	
	public void setPaymentPayDay08(String paymentPayDay08) {
		this.paymentPayDay08 = paymentPayDay08;
	} // x08
	
	public void setPaymentPayDay09(String paymentPayDay09) {
		this.paymentPayDay09 = paymentPayDay09;
	} // x09
	
	public void setPaymentPayDay10(String paymentPayDay10) {
		this.paymentPayDay10 = paymentPayDay10;
	} // x10
	
	public void setPaymentPayDay11(String paymentPayDay11) {
		this.paymentPayDay11 = paymentPayDay11;
	} // x11
	
	public void setPaymentPayDay12(String paymentPayDay12) {
		this.paymentPayDay12 = paymentPayDay12;
	} // x12
	
	public void setPayTotalAllowance01(Integer payTotalAllowance01) {
		this.payTotalAllowance01 = payTotalAllowance01;
	} // xz01 
	
	public void setPayTotalAllowance02(Integer payTotalAllowance02) {
		this.payTotalAllowance02 = payTotalAllowance02;
	} // xz02
	
	public void setPayTotalAllowance03(Integer payTotalAllowance03) {
		this.payTotalAllowance03 = payTotalAllowance03;
	} // xz03
	
	public void setPayTotalAllowance04(Integer payTotalAllowance04) {
		this.payTotalAllowance04 = payTotalAllowance04;
	} // xz04
	
	public void setPayTotalAllowance05(Integer payTotalAllowance05) {
		this.payTotalAllowance05 = payTotalAllowance05;
	} // xz05
	
	public void setPayTotalAllowance06(Integer payTotalAllowance06) {
		this.payTotalAllowance06 = payTotalAllowance06;
	} // xz06
	
	public void setPayTotalAllowance07(Integer payTotalAllowance07) {
		this.payTotalAllowance07 = payTotalAllowance07;
	} // xz07
	
	public void setPayTotalAllowance08(Integer payTotalAllowance08) {
		this.payTotalAllowance08 = payTotalAllowance08;
	} // xz08
	
	public void setPayTotalAllowance09(Integer payTotalAllowance09) {
		this.payTotalAllowance09 = payTotalAllowance09;
	} // xz09
	
	public void setPayTotalAllowance10(Integer payTotalAllowance10) {
		this.payTotalAllowance10 = payTotalAllowance10;
	} // xz10
	
	public void setPayTotalAllowance11(Integer payTotalAllowance11) {
		this.payTotalAllowance11 = payTotalAllowance11;
	} // xz11
	
	public void setPayTotalAllowance12(Integer payTotalAllowance12) {
		this.payTotalAllowance12 = payTotalAllowance12;
	} // xz12
	
	public void setPayTaxFree01(Integer payTaxFree01) {
		this.payTaxFree01 = payTaxFree01;
	} // ېŊz01
	
	public void setPayTaxFree02(Integer payTaxFree02) {
		this.payTaxFree02 = payTaxFree02;
	} // ېŊz02
	
	public void setPayTaxFree03(Integer payTaxFree03) {
		this.payTaxFree03 = payTaxFree03;
	} // ېŊz03
	
	public void setPayTaxFree04(Integer payTaxFree04) {
		this.payTaxFree04 = payTaxFree04;
	} // ېŊz04
	
	public void setPayTaxFree05(Integer payTaxFree05) {
		this.payTaxFree05 = payTaxFree05;
	} // ېŊz05
	
	public void setPayTaxFree06(Integer payTaxFree06) {
		this.payTaxFree06 = payTaxFree06;
	} // ېŊz06
	
	public void setPayTaxFree07(Integer payTaxFree07) {
		this.payTaxFree07 = payTaxFree07;
	} // ېŊz07
	
	public void setPayTaxFree08(Integer payTaxFree08) {
		this.payTaxFree08 = payTaxFree08;
	} // ېŊz08
	
	public void setPayTaxFree09(Integer payTaxFree09) {
		this.payTaxFree09 = payTaxFree09;
	} // ېŊz09
	
	public void setPayTaxFree10(Integer payTaxFree10) {
		this.payTaxFree10 = payTaxFree10;
	} // ېŊz10
	
	public void setPayTaxFree11(Integer payTaxFree11) {
		this.payTaxFree11 = payTaxFree11;
	} // ېŊz11
	
	public void setPayTaxFree12(Integer payTaxFree12) {
		this.payTaxFree12 = payTaxFree12;
	} // ېŊz12
	
	public void setPayTaxation01(Integer payTaxation01) {
		this.payTaxation01 = payTaxation01;
	} // ېŎxz01
	
	public void setPayTaxation02(Integer payTaxation02) {
		this.payTaxation02 = payTaxation02;
	} // ېŎxz02
	
	public void setPayTaxation03(Integer payTaxation03) {
		this.payTaxation03 = payTaxation03;
	} // ېŎxz03
	
	public void setPayTaxation04(Integer payTaxation04) {
		this.payTaxation04 = payTaxation04;
	} // ېŎxz04
	
	public void setPayTaxation05(Integer payTaxation05) {
		this.payTaxation05 = payTaxation05;
	} // ېŎxz05
	
	public void setPayTaxation06(Integer payTaxation06) {
		this.payTaxation06 = payTaxation06;
	} // ېŎxz06
	
	public void setPayTaxation07(Integer payTaxation07) {
		this.payTaxation07 = payTaxation07;
	} // ېŎxz07
	
	public void setPayTaxation08(Integer payTaxation08) {
		this.payTaxation08 = payTaxation08;
	} // ېŎxz08
	
	public void setPayTaxation09(Integer payTaxation09) {
		this.payTaxation09 = payTaxation09;
	} // ېŎxz09
	
	public void setPayTaxation10(Integer payTaxation10) {
		this.payTaxation10 = payTaxation10;
	} // ېŎxz10
	
	public void setPayTaxation11(Integer payTaxation11) {
		this.payTaxation11 = payTaxation11;
	} // ېŎxz11
	
	public void setPayTaxation12(Integer payTaxation12) {
		this.payTaxation12 = payTaxation12;
	} // ېŎxz12
	
	public void setPaySocInsDeduction01(Integer paySocInsDeduction01) {
		this.paySocInsDeduction01 = paySocInsDeduction01;
	} // Љی01
	
	public void setPaySocInsDeduction02(Integer paySocInsDeduction02) {
		this.paySocInsDeduction02 = paySocInsDeduction02;
	} // Љی02
	
	public void setPaySocInsDeduction03(Integer paySocInsDeduction03) {
		this.paySocInsDeduction03 = paySocInsDeduction03;
	} // Љی03
	
	public void setPaySocInsDeduction04(Integer paySocInsDeduction04) {
		this.paySocInsDeduction04 = paySocInsDeduction04;
	} // Љی04
	
	public void setPaySocInsDeduction05(Integer paySocInsDeduction05) {
		this.paySocInsDeduction05 = paySocInsDeduction05;
	} // Љی05
	
	public void setPaySocInsDeduction06(Integer paySocInsDeduction06) {
		this.paySocInsDeduction06 = paySocInsDeduction06;
	} // Љی06
	
	public void setPaySocInsDeduction07(Integer paySocInsDeduction07) {
		this.paySocInsDeduction07 = paySocInsDeduction07;
	} // Љی07
	
	public void setPaySocInsDeduction08(Integer paySocInsDeduction08) {
		this.paySocInsDeduction08 = paySocInsDeduction08;
	} // Љی08
	
	public void setPaySocInsDeduction09(Integer paySocInsDeduction09) {
		this.paySocInsDeduction09 = paySocInsDeduction09;
	} // Љی09
	
	public void setPaySocInsDeduction10(Integer paySocInsDeduction10) {
		this.paySocInsDeduction10 = paySocInsDeduction10;
	} // Љی10
	
	public void setPaySocInsDeduction11(Integer paySocInsDeduction11) {
		this.paySocInsDeduction11 = paySocInsDeduction11;
	} // Љی11
	
	public void setPaySocInsDeduction12(Integer paySocInsDeduction12) {
		this.paySocInsDeduction12 = paySocInsDeduction12;
	} // Љی12
	
	public void setPayPayInsDeduction01(Integer payPayInsDeduction01) {
		this.payPayInsDeduction01 = payPayInsDeduction01;
	} // ЉیT̋^̋z01
	
	public void setPayPayInsDeduction02(Integer payPayInsDeduction02) {
		this.payPayInsDeduction02 = payPayInsDeduction02;
	} // ЉیT̋^̋z02
	
	public void setPayPayInsDeduction03(Integer payPayInsDeduction03) {
		this.payPayInsDeduction03 = payPayInsDeduction03;
	} // ЉیT̋^̋z03
	
	public void setPayPayInsDeduction04(Integer payPayInsDeduction04) {
		this.payPayInsDeduction04 = payPayInsDeduction04;
	} // ЉیT̋^̋z04
	
	public void setPayPayInsDeduction05(Integer payPayInsDeduction05) {
		this.payPayInsDeduction05 = payPayInsDeduction05;
	} // ЉیT̋^̋z05
	
	public void setPayPayInsDeduction06(Integer payPayInsDeduction06) {
		this.payPayInsDeduction06 = payPayInsDeduction06;
	} // ЉیT̋^̋z06
	
	public void setPayPayInsDeduction07(Integer payPayInsDeduction07) {
		this.payPayInsDeduction07 = payPayInsDeduction07;
	} // ЉیT̋^̋z07
	
	public void setPayPayInsDeduction08(Integer payPayInsDeduction08) {
		this.payPayInsDeduction08 = payPayInsDeduction08;
	} // ЉیT̋^̋z08
	
	public void setPayPayInsDeduction09(Integer payPayInsDeduction09) {
		this.payPayInsDeduction09 = payPayInsDeduction09;
	} // ЉیT̋^̋z09
	
	public void setPayPayInsDeduction10(Integer payPayInsDeduction10) {
		this.payPayInsDeduction10 = payPayInsDeduction10;
	} // ЉیT̋^̋z10
	
	public void setPayPayInsDeduction11(Integer payPayInsDeduction11) {
		this.payPayInsDeduction11 = payPayInsDeduction11;
	} // ЉیT̋^̋z11
	
	public void setPayPayInsDeduction12(Integer payPayInsDeduction12) {
		this.payPayInsDeduction12 = payPayInsDeduction12;
	} // ЉیT̋^̋z12
	
	public void setPayDependentCount01(Integer payDependentCount01) {
		this.payDependentCount01 = payDependentCount01;
	} // }{e(^)01
	
	public void setPayDependentCount02(Integer payDependentCount02) {
		this.payDependentCount02 = payDependentCount02;
	} // }{e(^)02
	
	public void setPayDependentCount03(Integer payDependentCount03) {
		this.payDependentCount03 = payDependentCount03;
	} // }{e(^)03
	
	public void setPayDependentCount04(Integer payDependentCount04) {
		this.payDependentCount04 = payDependentCount04;
	} // }{e(^)04
	
	public void setPayDependentCount05(Integer payDependentCount05) {
		this.payDependentCount05 = payDependentCount05;
	} // }{e(^)05
	
	public void setPayDependentCount06(Integer payDependentCount06) {
		this.payDependentCount06 = payDependentCount06;
	} // }{e(^)06
	
	public void setPayDependentCount07(Integer payDependentCount07) {
		this.payDependentCount07 = payDependentCount07;
	} // }{e(^)07
	
	public void setPayDependentCount08(Integer payDependentCount08) {
		this.payDependentCount08 = payDependentCount08;
	} // }{e(^)08
	
	public void setPayDependentCount09(Integer payDependentCount09) {
		this.payDependentCount09 = payDependentCount09;
	} // }{e(^)09
	
	public void setPayDependentCount10(Integer payDependentCount10) {
		this.payDependentCount10 = payDependentCount10;
	} // }{e(^)10
	
	public void setPayDependentCount11(Integer payDependentCount11) {
		this.payDependentCount11 = payDependentCount11;
	} // }{e(^)11
	
	public void setPayDependentCount12(Integer payDependentCount12) {
		this.payDependentCount12 = payDependentCount12;
	} // }{e(^)12
	
	public void setPayIncomeTax01(Integer payIncomeTax01) {
		this.payIncomeTax01 = payIncomeTax01;
	} // 01 
	
	public void setPayIncomeTax02(Integer payIncomeTax02) {
		this.payIncomeTax02 = payIncomeTax02;
	} // 02
	
	public void setPayIncomeTax03(Integer payIncomeTax03) {
		this.payIncomeTax03 = payIncomeTax03;
	} // 03
	
	public void setPayIncomeTax04(Integer payIncomeTax04) {
		this.payIncomeTax04 = payIncomeTax04;
	} // 04
	
	public void setPayIncomeTax05(Integer payIncomeTax05) {
		this.payIncomeTax05 = payIncomeTax05;
	} // 05
	
	public void setPayIncomeTax06(Integer payIncomeTax06) {
		this.payIncomeTax06 = payIncomeTax06;
	} // 06
	
	public void setPayIncomeTax07(Integer payIncomeTax07) {
		this.payIncomeTax07 = payIncomeTax07;
	} // 07
	
	public void setPayIncomeTax08(Integer payIncomeTax08) {
		this.payIncomeTax08 = payIncomeTax08;
	} // 08
	
	public void setPayIncomeTax09(Integer payIncomeTax09) {
		this.payIncomeTax09 = payIncomeTax09;
	} // 09
	
	public void setPayIncomeTax10(Integer payIncomeTax10) {
		this.payIncomeTax10 = payIncomeTax10;
	} // 10
	
	public void setPayIncomeTax11(Integer payIncomeTax11) {
		this.payIncomeTax11 = payIncomeTax11;
	} // 11
	
	public void setPayIncomeTax12(Integer payIncomeTax12) {
		this.payIncomeTax12 = payIncomeTax12;
	} // 12
	
	public void setPayAdjCalcGap01(Integer payAdjCalcGap01) {
		this.payAdjCalcGap01 = payAdjCalcGap01;
	} // Nɂߕs01
	
	public void setPayAdjCalcGap02(Integer payAdjCalcGap02) {
		this.payAdjCalcGap02 = payAdjCalcGap02;
	} // Nɂߕs02
	
	public void setPayAdjCalcGap03(Integer payAdjCalcGap03) {
		this.payAdjCalcGap03 = payAdjCalcGap03;
	} // Nɂߕs03
	
	public void setPayAdjCalcGap04(Integer payAdjCalcGap04) {
		this.payAdjCalcGap04 = payAdjCalcGap04;
	} // Nɂߕs04
	
	public void setPayAdjCalcGap05(Integer payAdjCalcGap05) {
		this.payAdjCalcGap05 = payAdjCalcGap05;
	} // Nɂߕs05
	
	public void setPayAdjCalcGap06(Integer payAdjCalcGap06) {
		this.payAdjCalcGap06 = payAdjCalcGap06;
	} // Nɂߕs06
	
	public void setPayAdjCalcGap07(Integer payAdjCalcGap07) {
		this.payAdjCalcGap07 = payAdjCalcGap07;
	} // Nɂߕs07
	
	public void setPayAdjCalcGap08(Integer payAdjCalcGap08) {
		this.payAdjCalcGap08 = payAdjCalcGap08;
	} // Nɂߕs08
	
	public void setPayAdjCalcGap09(Integer payAdjCalcGap09) {
		this.payAdjCalcGap09 = payAdjCalcGap09;
	} // Nɂߕs09
	
	public void setPayAdjCalcGap10(Integer payAdjCalcGap10) {
		this.payAdjCalcGap10 = payAdjCalcGap10;
	} // Nɂߕs10
	
	public void setPayAdjCalcGap11(Integer payAdjCalcGap11) {
		this.payAdjCalcGap11 = payAdjCalcGap11;
	} // Nɂߕs11
	
	public void setPayAdjCalcGap12(Integer payAdjCalcGap12) {
		this.payAdjCalcGap12 = payAdjCalcGap12;
	} // Nɂߕs12
	
	public void setPayVariousDeduction01(Integer payVariousDeduction01) {
		this.payVariousDeduction01 = payVariousDeduction01;
	} // T01
	
	public void setPayVariousDeduction02(Integer payVariousDeduction02) {
		this.payVariousDeduction02 = payVariousDeduction02;
	} // T02
	
	public void setPayVariousDeduction03(Integer payVariousDeduction03) {
		this.payVariousDeduction03 = payVariousDeduction03;
	} // T03
	
	public void setPayVariousDeduction04(Integer payVariousDeduction04) {
		this.payVariousDeduction04 = payVariousDeduction04;
	} // T04
	
	public void setPayVariousDeduction05(Integer payVariousDeduction05) {
		this.payVariousDeduction05 = payVariousDeduction05;
	} // T05
	
	public void setPayVariousDeduction06(Integer payVariousDeduction06) {
		this.payVariousDeduction06 = payVariousDeduction06;
	} // T06
	
	public void setPayVariousDeduction07(Integer payVariousDeduction07) {
		this.payVariousDeduction07 = payVariousDeduction07;
	} // T07
	
	public void setPayVariousDeduction08(Integer payVariousDeduction08) {
		this.payVariousDeduction08 = payVariousDeduction08;
	} // T08
	
	public void setPayVariousDeduction09(Integer payVariousDeduction09) {
		this.payVariousDeduction09 = payVariousDeduction09;
	} // T09
	
	public void setPayVariousDeduction10(Integer payVariousDeduction10) {
		this.payVariousDeduction10 = payVariousDeduction10;
	} // T10
	
	public void setPayVariousDeduction11(Integer payVariousDeduction11) {
		this.payVariousDeduction11 = payVariousDeduction11;
	} // T11
	
	public void setPayVariousDeduction12(Integer payVariousDeduction12) {
		this.payVariousDeduction12 = payVariousDeduction12;
	} // T12
	
	public void setPayPaymentTotal01(Integer payPaymentTotal01) {
		this.payPaymentTotal01 = payPaymentTotal01;
	} // xz01
	
	public void setPayPaymentTotal02(Integer payPaymentTotal02) {
		this.payPaymentTotal02 = payPaymentTotal02;
	} // xz02
	
	public void setPayPaymentTotal03(Integer payPaymentTotal03) {
		this.payPaymentTotal03 = payPaymentTotal03;
	} // xz03
	
	public void setPayPaymentTotal04(Integer payPaymentTotal04) {
		this.payPaymentTotal04 = payPaymentTotal04;
	} // xz04
	
	public void setPayPaymentTotal05(Integer payPaymentTotal05) {
		this.payPaymentTotal05 = payPaymentTotal05;
	} // xz05
	
	public void setPayPaymentTotal06(Integer payPaymentTotal06) {
		this.payPaymentTotal06 = payPaymentTotal06;
	} // xz06
	
	public void setPayPaymentTotal07(Integer payPaymentTotal07) {
		this.payPaymentTotal07 = payPaymentTotal07;
	} // xz07
	
	public void setPayPaymentTotal08(Integer payPaymentTotal08) {
		this.payPaymentTotal08 = payPaymentTotal08;
	} // xz08
	
	public void setPayPaymentTotal09(Integer payPaymentTotal09) {
		this.payPaymentTotal09 = payPaymentTotal09;
	} // xz09
	
	public void setPayPaymentTotal10(Integer payPaymentTotal10) {
		this.payPaymentTotal10 = payPaymentTotal10;
	} // xz10
	
	public void setPayPaymentTotal11(Integer payPaymentTotal11) {
		this.payPaymentTotal11 = payPaymentTotal11;
	} // xz11
	
	public void setPayPaymentTotal12(Integer payPaymentTotal12) {
		this.payPaymentTotal12 = payPaymentTotal12;
	} // xz12
	
	public void setPayPaymentTax01(Integer payPaymentTax01) {
		this.payPaymentTax01 = payPaymentTax01;
	} // Ŋz01
	
	public void setPayPaymentTax02(Integer payPaymentTax02) {
		this.payPaymentTax02 = payPaymentTax02;
	} // Ŋz02
	
	public void setPayPaymentTax03(Integer payPaymentTax03) {
		this.payPaymentTax03 = payPaymentTax03;
	} // Ŋz03
	
	public void setPayPaymentTax04(Integer payPaymentTax04) {
		this.payPaymentTax04 = payPaymentTax04;
	} // Ŋz04
	
	public void setPayPaymentTax05(Integer payPaymentTax05) {
		this.payPaymentTax05 = payPaymentTax05;
	} // Ŋz05
	
	public void setPayPaymentTax06(Integer payPaymentTax06) {
		this.payPaymentTax06 = payPaymentTax06;
	} // Ŋz06
	
	public void setPayPaymentTax07(Integer payPaymentTax07) {
		this.payPaymentTax07 = payPaymentTax07;
	} // Ŋz07
	
	public void setPayPaymentTax08(Integer payPaymentTax08) {
		this.payPaymentTax08 = payPaymentTax08;
	} // Ŋz08
	
	public void setPayPaymentTax09(Integer payPaymentTax09) {
		this.payPaymentTax09 = payPaymentTax09;
	} // Ŋz09
	
	public void setPayPaymentTax10(Integer payPaymentTax10) {
		this.payPaymentTax10 = payPaymentTax10;
	} // Ŋz10
	
	public void setPayPaymentTax11(Integer payPaymentTax11) {
		this.payPaymentTax11 = payPaymentTax11;
	} // Ŋz11
	
	public void setPayPaymentTax12(Integer payPaymentTax12) {
		this.payPaymentTax12 = payPaymentTax12;
	} // Ŋz12
	
	public void setBonusMonth01(String bonusMonth01) {
		this.bonusMonth01 = bonusMonth01;
	} // x(ܗ^)01
	
	public void setBonusMonth02(String bonusMonth02) {
		this.bonusMonth02 = bonusMonth02;
	} // x(ܗ^)02
	
	public void setBonusMonth03(String bonusMonth03) {
		this.bonusMonth03 = bonusMonth03;
	} // x(ܗ^)03
	
	public void setBonusMonth04(String bonusMonth04) {
		this.bonusMonth04 = bonusMonth04;
	} // x(ܗ^)04
	
	public void setBonusMonth05(String bonusMonth05) {
		this.bonusMonth05 = bonusMonth05;
	} // x(ܗ^)05
	
	public void setBonusMonth06(String bonusMonth06) {
		this.bonusMonth06 = bonusMonth06;
	} // x(ܗ^)06
	
	public void setBonusPayDay01(String bonusPayDay01) {
		this.bonusPayDay01 = bonusPayDay01;
	} // x(ܗ^)01
	
	public void setBonusPayDay02(String bonusPayDay02) {
		this.bonusPayDay02 = bonusPayDay02;
	} // x(ܗ^)02
	
	public void setBonusPayDay03(String bonusPayDay03) {
		this.bonusPayDay03 = bonusPayDay03;
	} // x(ܗ^)03
	
	public void setBonusPayDay04(String bonusPayDay04) {
		this.bonusPayDay04 = bonusPayDay04;
	} // x(ܗ^)04
	
	public void setBonusPayDay05(String bonusPayDay05) {
		this.bonusPayDay05 = bonusPayDay05;
	} // x(ܗ^)05
	
	public void setBonusPayDay06(String bonusPayDay06) {
		this.bonusPayDay06 = bonusPayDay06;
	} // x(ܗ^)06
	
	public void setBonTotalAllowance01(Integer bonTotalAllowance01) {
		this.bonTotalAllowance01 = bonTotalAllowance01;
	} // xz(ܗ^01)
	
	public void setBonTotalAllowance02(Integer bonTotalAllowance02) {
		this.bonTotalAllowance02 = bonTotalAllowance02;
	} // xz(ܗ^02)
	
	public void setBonTotalAllowance03(Integer bonTotalAllowance03) {
		this.bonTotalAllowance03 = bonTotalAllowance03;
	} // xz(ܗ^03)
	
	public void setBonTotalAllowance04(Integer bonTotalAllowance04) {
		this.bonTotalAllowance04 = bonTotalAllowance04;
	} // xz(ܗ^04)
	
	public void setBonTotalAllowance05(Integer bonTotalAllowance05) {
		this.bonTotalAllowance05 = bonTotalAllowance05;
	} // xz(ܗ^05)
	
	public void setBonTotalAllowance06(Integer bonTotalAllowance06) {
		this.bonTotalAllowance06 = bonTotalAllowance06;
	} // xz(ܗ^06)
	
	public void setBonTaxFree01(Integer bonTaxFree01) {
		this.bonTaxFree01 = bonTaxFree01;
	} // ېŊz(ܗ^)01
	
	public void setBonTaxFree02(Integer bonTaxFree02) {
		this.bonTaxFree02 = bonTaxFree02;
	} // ېŊz(ܗ^)02
	
	public void setBonTaxFree03(Integer bonTaxFree03) {
		this.bonTaxFree03 = bonTaxFree03;
	} // ېŊz(ܗ^)03
	
	public void setBonTaxFree04(Integer bonTaxFree04) {
		this.bonTaxFree04 = bonTaxFree04;
	} // ېŊz(ܗ^)04
	
	public void setBonTaxFree05(Integer bonTaxFree05) {
		this.bonTaxFree05 = bonTaxFree05;
	} // ېŊz(ܗ^)05
	
	public void setBonTaxFree06(Integer bonTaxFree06) {
		this.bonTaxFree06 = bonTaxFree06;
	} // ېŊz(ܗ^)06
	
	public void setBonTaxation01(Integer bonTaxation01) {
		this.bonTaxation01 = bonTaxation01;
	} // ېŎxz(ܗ^)01
	
	public void setBonTaxation02(Integer bonTaxation02) {
		this.bonTaxation02 = bonTaxation02;
	} // ېŎxz(ܗ^)02
	
	public void setBonTaxation03(Integer bonTaxation03) {
		this.bonTaxation03 = bonTaxation03;
	} // ېŎxz(ܗ^)03
	
	public void setBonTaxation04(Integer bonTaxation04) {
		this.bonTaxation04 = bonTaxation04;
	} // ېŎxz(ܗ^)04
	
	public void setBonTaxation05(Integer bonTaxation05) {
		this.bonTaxation05 = bonTaxation05;
	} // ېŎxz(ܗ^)05
	
	public void setBonTaxation06(Integer bonTaxation06) {
		this.bonTaxation06 = bonTaxation06;
	} // ېŎxz(ܗ^)06
	
	public void setBonSocInsDeduction01(Integer bonSocInsDeduction01) {
		this.bonSocInsDeduction01 = bonSocInsDeduction01;
	} // Љی(ܗ^)01
	
	public void setBonSocInsDeduction02(Integer bonSocInsDeduction02) {
		this.bonSocInsDeduction02 = bonSocInsDeduction02;
	} // Љی(ܗ^)02
	
	public void setBonSocInsDeduction03(Integer bonSocInsDeduction03) {
		this.bonSocInsDeduction03 = bonSocInsDeduction03;
	} // Љی(ܗ^)03
	
	public void setBonSocInsDeduction04(Integer bonSocInsDeduction04) {
		this.bonSocInsDeduction04 = bonSocInsDeduction04;
	} // Љی(ܗ^)04
	
	public void setBonSocInsDeduction05(Integer bonSocInsDeduction05) {
		this.bonSocInsDeduction05 = bonSocInsDeduction05;
	} // Љی(ܗ^)05
	
	public void setBonSocInsDeduction06(Integer bonSocInsDeduction06) {
		this.bonSocInsDeduction06 = bonSocInsDeduction06;
	} // Љی(ܗ^)06
	
	public void setBonPayInsDeduction01(Integer bonPayInsDeduction01) {
		this.bonPayInsDeduction01 = bonPayInsDeduction01;
	} // ЉیT̋^̋z(ܗ^)01
	
	public void setBonPayInsDeduction02(Integer bonPayInsDeduction02) {
		this.bonPayInsDeduction02 = bonPayInsDeduction02;
	} // ЉیT̋^̋z(ܗ^)02
	
	public void setBonPayInsDeduction03(Integer bonPayInsDeduction03) {
		this.bonPayInsDeduction03 = bonPayInsDeduction03;
	} // ЉیT̋^̋z(ܗ^)03
	
	public void setBonPayInsDeduction04(Integer bonPayInsDeduction04) {
		this.bonPayInsDeduction04 = bonPayInsDeduction04;
	} // ЉیT̋^̋z(ܗ^)04
	
	public void setBonPayInsDeduction05(Integer bonPayInsDeduction05) {
		this.bonPayInsDeduction05 = bonPayInsDeduction05;
	} // ЉیT̋^̋z(ܗ^)05
	
	public void setBonPayInsDeduction06(Integer bonPayInsDeduction06) {
		this.bonPayInsDeduction06 = bonPayInsDeduction06;
	} // ЉیT̋^̋z(ܗ^)06
	
	public void setBonDependentCount01(Integer bonDependentCount01) {
		this.bonDependentCount01 = bonDependentCount01;
	} // }{e(ܗ^)01
	
	public void setBonDependentCount02(Integer bonDependentCount02) {
		this.bonDependentCount02 = bonDependentCount02;
	} // }{e(ܗ^)02
	
	public void setBonDependentCount03(Integer bonDependentCount03) {
		this.bonDependentCount03 = bonDependentCount03;
	} // }{e(ܗ^)03
	
	public void setBonDependentCount04(Integer bonDependentCount04) {
		this.bonDependentCount04 = bonDependentCount04;
	} // }{e(ܗ^)04
	
	public void setBonDependentCount05(Integer bonDependentCount05) {
		this.bonDependentCount05 = bonDependentCount05;
	} // }{e(ܗ^)05
	
	public void setBonDependentCount06(Integer bonDependentCount06) {
		this.bonDependentCount06 = bonDependentCount06;
	} // }{e(ܗ^)06
	
	public void setBonIncomeTax01(Integer bonIncomeTax01) {
		this.bonIncomeTax01 = bonIncomeTax01;
	} // (ܗ^)01
	
	public void setBonIncomeTax02(Integer bonIncomeTax02) {
		this.bonIncomeTax02 = bonIncomeTax02;
	} // (ܗ^)02
	
	public void setBonIncomeTax03(Integer bonIncomeTax03) {
		this.bonIncomeTax03 = bonIncomeTax03;
	} // (ܗ^)03
	
	public void setBonIncomeTax04(Integer bonIncomeTax04) {
		this.bonIncomeTax04 = bonIncomeTax04;
	} // (ܗ^)04
	
	public void setBonIncomeTax05(Integer bonIncomeTax05) {
		this.bonIncomeTax05 = bonIncomeTax05;
	} // (ܗ^)05
	
	public void setBonIncomeTax06(Integer bonIncomeTax06) {
		this.bonIncomeTax06 = bonIncomeTax06;
	} // (ܗ^)06
	
	public void setBonIncomeTaxRate01(Float bonIncomeTaxRate01) {
		this.bonIncomeTaxRate01 = bonIncomeTaxRate01;
	}// ŗ(ܗ^)01
	
	public void setBonIncomeTaxRate02(Float bonIncomeTaxRate02) {
		this.bonIncomeTaxRate02 = bonIncomeTaxRate02;
	}// ŗ(ܗ^)02
	
	public void setBonIncomeTaxRate03(Float bonIncomeTaxRate03) {
		this.bonIncomeTaxRate03 = bonIncomeTaxRate03;
	}// ŗ(ܗ^)03
	
	public void setBonIncomeTaxRate04(Float bonIncomeTaxRate04) {
		this.bonIncomeTaxRate04 = bonIncomeTaxRate04;
	}// ŗ(ܗ^)04
	
	public void setBonIncomeTaxRate05(Float bonIncomeTaxRate05) {
		this.bonIncomeTaxRate05 = bonIncomeTaxRate05;
	}// ŗ(ܗ^)05
	
	public void setBonIncomeTaxRate06(Float bonIncomeTaxRate06) {
		this.bonIncomeTaxRate06 = bonIncomeTaxRate06;
	}// ŗ(ܗ^)06
	
	public void setBonAdjCalcGap01(Integer bonAdjCalcGap01) {
		this.bonAdjCalcGap01 = bonAdjCalcGap01;
	} // Nɂߕs(ܗ^)01
	
	public void setBonAdjCalcGap02(Integer bonAdjCalcGap02) {
		this.bonAdjCalcGap02 = bonAdjCalcGap02;
	} // Nɂߕs(ܗ^)02
	
	public void setBonAdjCalcGap03(Integer bonAdjCalcGap03) {
		this.bonAdjCalcGap03 = bonAdjCalcGap03;
	} // Nɂߕs(ܗ^)03
	
	public void setBonAdjCalcGap04(Integer bonAdjCalcGap04) {
		this.bonAdjCalcGap04 = bonAdjCalcGap04;
	} // Nɂߕs(ܗ^)04
	
	public void setBonAdjCalcGap05(Integer bonAdjCalcGap05) {
		this.bonAdjCalcGap05 = bonAdjCalcGap05;
	} // Nɂߕs(ܗ^)05
	
	public void setBonAdjCalcGap06(Integer bonAdjCalcGap06) {
		this.bonAdjCalcGap06 = bonAdjCalcGap06;
	} // Nɂߕs(ܗ^)06
	
	public void setBonVariousDeduction01(Integer bonVariousDeduction01) {
		this.bonVariousDeduction01 = bonVariousDeduction01;
	} // T(ܗ^)01
	
	public void setBonVariousDeduction02(Integer bonVariousDeduction02) {
		this.bonVariousDeduction02 = bonVariousDeduction02;
	} // T(ܗ^)02
	
	public void setBonVariousDeduction03(Integer bonVariousDeduction03) {
		this.bonVariousDeduction03 = bonVariousDeduction03;
	} // T(ܗ^)03
	
	public void setBonVariousDeduction04(Integer bonVariousDeduction04) {
		this.bonVariousDeduction04 = bonVariousDeduction04;
	} // T(ܗ^)04
	
	public void setBonVariousDeduction05(Integer bonVariousDeduction05) {
		this.bonVariousDeduction05 = bonVariousDeduction05;
	} // T(ܗ^)05
	
	public void setBonVariousDeduction06(Integer bonVariousDeduction06) {
		this.bonVariousDeduction06 = bonVariousDeduction06;
	} // T(ܗ^)06
	
	public void setBonPaymentTotal01(Integer bonPaymentTotal01) {
		this.bonPaymentTotal01 = bonPaymentTotal01;
	} // xz(ܗ^)01
	
	public void setBonPaymentTotal02(Integer bonPaymentTotal02) {
		this.bonPaymentTotal02 = bonPaymentTotal02;
	} // xz(ܗ^)02
	
	public void setBonPaymentTotal03(Integer bonPaymentTotal03) {
		this.bonPaymentTotal03 = bonPaymentTotal03;
	} // xz(ܗ^)03
	
	public void setBonPaymentTotal04(Integer bonPaymentTotal04) {
		this.bonPaymentTotal04 = bonPaymentTotal04;
	} // xz(ܗ^)04
	
	public void setBonPaymentTotal05(Integer bonPaymentTotal05) {
		this.bonPaymentTotal05 = bonPaymentTotal05;
	} // xz(ܗ^)05
	
	public void setBonPaymentTotal06(Integer bonPaymentTotal06) {
		this.bonPaymentTotal06 = bonPaymentTotal06;
	} // xz(ܗ^)06
	
	public void setBonPaymentTax01(Integer bonPaymentTax01) {
		this.bonPaymentTax01 = bonPaymentTax01;
	} // Ŋz01
	
	public void setBonPaymentTax02(Integer bonPaymentTax02) {
		this.bonPaymentTax02 = bonPaymentTax02;
	} // Ŋz02
	
	public void setBonPaymentTax03(Integer bonPaymentTax03) {
		this.bonPaymentTax03 = bonPaymentTax03;
	} // Ŋz03
	
	public void setBonPaymentTax04(Integer bonPaymentTax04) {
		this.bonPaymentTax04 = bonPaymentTax04;
	} // Ŋz04
	
	public void setBonPaymentTax05(Integer bonPaymentTax05) {
		this.bonPaymentTax05 = bonPaymentTax05;
	} // Ŋz05
	
	public void setBonPaymentTax06(Integer bonPaymentTax06) {
		this.bonPaymentTax06 = bonPaymentTax06;
	} // Ŋz06
	
	public void setTotalAllowance(Integer totalAllowance) {
		this.totalAllowance = totalAllowance;
	} // xzv
	
	public void setTaxFree(Integer taxFree) {
		this.taxFree = taxFree;
	} // ېŊzv
	
	public void setTaxation(Integer taxation) {
		this.taxation = taxation;
	} // ېŊzv
	
	public void setSocInsDeduction(Integer socInsDeduction) {
		this.socInsDeduction = socInsDeduction;
	} // Љیv 
	
	public void setTotalPayInsDeduction(Integer totalPayInsDeduction) {
		this.totalPayInsDeduction = totalPayInsDeduction;
	} // ЉیT̋^̋zv
	
	public void setIncomeTax(Integer incomeTax) {
		this.incomeTax = incomeTax;
	} // ōv
	
	public void setVariousDeduction(Integer variousDeduction) {
		this.variousDeduction = variousDeduction;
	} // Tv
	
	public void setPaymentTotal(Integer paymentTotal) {
		this.paymentTotal = paymentTotal;
	} // xzv
	
	public void setMidwayType(Integer midwayType) {
		this.midwayType = midwayType;
	} // rЋ敪
	
	public void setFormerIncome(Integer formerIncome) {
		this.formerIncome = formerIncome;
	} // OΖz
	
	public void setFormerInsurance(Integer formerInsurance) {
		this.formerInsurance = formerInsurance;
	} // OΖЉیz
	
	public void setFormerTax(Integer formerTax) {
		this.formerTax = formerTax;
	} // OΖ揊Ŋz
	
	public void setPaymentAllowance(Integer paymentAllowance) {
		this.paymentAllowance = paymentAllowance;
	} // ^A蓖z
	
	public void setPaymentIncomeTax(Integer paymentIncomeTax) {
		this.paymentIncomeTax = paymentIncomeTax;
	} // ^A蓖Ŋz
	
	public void setBonusAllowance(Integer bonusAllowance) {
		this.bonusAllowance = bonusAllowance;
	} // ܗ^z
	
	public void setBonusIncomeTax(Integer bonusIncomeTax) {
		this.bonusIncomeTax = bonusIncomeTax;
	} // ܗ^Ŋz
	
	public void setMidwayAdjustIncome(Integer midwayAdjustIncome) {
		this.midwayAdjustIncome = midwayAdjustIncome;
	} // rAz
	
	public void setMidwayAdjustTax(Integer midwayAdjustTax) {
		this.midwayAdjustTax = midwayAdjustTax;
	} // rAŊz
	
	public void setAdjTotalAllowance(Integer adjTotalAllowance) {
		this.adjTotalAllowance = adjTotalAllowance;
	} // xzv
	
	public void setAdjTotalIncome(Integer adjTotalIncome) {
		this.adjTotalIncome = adjTotalIncome;
	} // Ŋzv
	
	public void setAfterDeductIncome(Integer afterDeductIncome) {
		this.afterDeductIncome = afterDeductIncome;
	} // ^T̋^̋z
	
	public void setPayInsDeduction(Integer payInsDeduction) {
		this.payInsDeduction = payInsDeduction;
	} // Љی^̍T
	
	public void setSocialInsDeduction(Integer socialInsDeduction) {
		this.socialInsDeduction = socialInsDeduction;
	} // ЉیTz
	
	public void setMutualAidDeduction(Integer mutualAidDeduction) {
		this.mutualAidDeduction = mutualAidDeduction;
	} // K͊Ƌϓ|Tz
	
	public void setLifeInsDeduction(Integer lifeInsDeduction) {
		this.lifeInsDeduction = lifeInsDeduction;
	} // یTz
	
	public void setDamageInsDeduction(Integer damageInsDeduction) {
		this.damageInsDeduction = damageInsDeduction;
	} // QیTz
	
	public void setSpouseSpDeduction(Integer spouseSpDeduction) {
		this.spouseSpDeduction = spouseSpDeduction;
	} // zғʍTz
	
	public void setDependentsDeduction(Integer dependentsDeduction) {
		this.dependentsDeduction = dependentsDeduction;
	} // zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	
	public void setIncomeDeductSum(Integer incomeDeductSum) {
		this.incomeDeductSum = incomeDeductSum;
	} // Tzv
	
	public void setFinalIncomeTax(Integer finalIncomeTax) {
		this.finalIncomeTax = finalIncomeTax;
	} // NŊz
	
	public void setHouseLoanDeduction(Integer houseLoanDeduction) {
		this.houseLoanDeduction = houseLoanDeduction;
	} // ZؓʍTz
	
	public void setTaxGap(Integer taxGap) {
		this.taxGap = taxGap;
	} // Ŋz擾
	
	public void setCalcTaxedIncome(Integer calcTaxedIncome) {
		this.calcTaxedIncome = calcTaxedIncome;
	} // ېŋ^z
	
	public void setSpouseSumIncome(Integer spouseSumIncome) {
		this.spouseSumIncome = spouseSumIncome;
	} // z҂̖{N̍vžϊz
	
	public void setGeneralLifeIns(Integer generalLifeIns) {
		this.generalLifeIns = generalLifeIns;
	} // ʂ̐ی
	
	public void setPrivatePension(Integer privatePension) {
		this.privatePension = privatePension;
	} // lNی
	
	public void setEarthquakeIns(Integer earthquakeIns) {
		this.earthquakeIns = earthquakeIns;
	} // nkی
	
	public void setLongTermDamageIns(Integer longTermDamageIns) {
		this.longTermDamageIns = longTermDamageIns;
	} // Qی
	
	public void setAllowanceAdjustment(Integer allowanceAdjustment) {
		this.allowanceAdjustment = allowanceAdjustment;
	} // xz
	
	public void setTaxFreeAdjustment(Integer taxFreeAdjustment) {
		this.taxFreeAdjustment = taxFreeAdjustment;
	} // ېŒz
	
	public void setTaxIncAdjustment(Integer taxIncAdjustment) {
		this.taxIncAdjustment = taxIncAdjustment;
	} // Œz
	
	public void setWithholdSlipNotes(String withholdSlipNotes) {
		this.withholdSlipNotes = withholdSlipNotes;
	} // 򒥎[Ev
	
	public void setCalcIncomeTax(Integer calcIncomeTax) {
		this.calcIncomeTax = calcIncomeTax;
	} // ZoNŊz
	
	public void setAdjustedIncomeTax(Integer adjustedIncomeTax) {
		this.adjustedIncomeTax = adjustedIncomeTax;
	} // NNŊz
	
	public void setDeductedIncomeTax(Integer deductedIncomeTax) {
		this.deductedIncomeTax = deductedIncomeTax;
	} // N藦TzŊz
	
	public void setSocInsAdjustment(Integer socInsAdjustment) {
		this.socInsAdjustment = socInsAdjustment;
	} // Љیz
	
	public void setIncomeTaxType(String incomeTaxType) {
		this.incomeTaxType = incomeTaxType;
	} // ېŋ敪
	
	public void setAdjustmentType(String adjustmentType) {
		this.adjustmentType = adjustmentType;
	} // N敪
	
	public void setSpHandicap(String spHandicap) {
		this.spHandicap = spHandicap;
	}// ʏQ 
	
	public void setGeHandicap(String geHandicap) {
		this.geHandicap = geHandicap;
	}// ʏQ
	
	public void setGeWidow(String geWidow) {
		this.geWidow = geWidow;
	}// ʉǕw
	
	public void setSpWidow(String spWidow) {
		this.spWidow = spWidow;
	}// ʉǕw
	
	public void setWidow(String widow) {
		this.widow = widow;
	}// Ǖv
	
	public void setStudentGeneral(String studentGeneral) {
		this.studentGeneral = studentGeneral;
	}// ΘJw
	
	public void setLwSpHandiEl(String lwSpHandiEl) {
		this.lwSpHandiEl = lwSpHandiEl;
	}// ʏQҘVl
	
	public void setLwSpHandicap(String lwSpHandicap) {
		this.lwSpHandicap = lwSpHandicap;
	}// ʏQ
	
	public void setSpouseEl(String spouseEl) {
		this.spouseEl = spouseEl;
	}// Vlz
	
	public void setSpouseGe(String spouseGe) {
		this.spouseGe = spouseGe;
	}// ʔz(̑)
	
	public void setGeneralDependent(String generalDependent) {
		this.generalDependent = generalDependent;
	} // ʕ}{e
	
	public void setSpecificDependent(String specificDependent) {
		this.specificDependent = specificDependent;
	} // }{e
	
	public void setElderlyDependent(String elderlyDependent) {
		this.elderlyDependent = elderlyDependent;
	} // Vl}{e
	
	public void setLiveWithEldRel(String liveWithEldRel) {
		this.liveWithEldRel = liveWithEldRel;
	} // Ve
	
	public void setLiveWithHandiGe(String liveWithHandiGe) {
		this.liveWithHandiGe = liveWithHandiGe;
	} // 
	
	public void setLiveWithHandiSp(String liveWithHandiSp) {
		this.liveWithHandiSp = liveWithHandiSp;
	} // 
	
	public void setLiveWithHandiEl(String liveWithHandiEl) {
		this.liveWithHandiEl = liveWithHandiEl;
	} // Vl
	
	public void setLiveWithHandiEr(String liveWithHandiEr) {
		this.liveWithHandiEr = liveWithHandiEr;
	} // Ve
	
	public void setGeneralHandicap(String generalHandicap) {
		this.generalHandicap = generalHandicap;
	} // ʏQ
	
	public void setSpecificHandicap(String specificHandicap) {
		this.specificHandicap = specificHandicap;
	} // ʏQ
	
	public void setTotallHandicap(String totallHandicap) {
		this.totallHandicap = totallHandicap;
	} // QҌv
	
	public void setTotallDeduction(String totallDeduction) {
		this.totallDeduction = totallDeduction;
	} // TΏێҐ
	
	public void setConsortFlg(String consortFlg) {
		this.consortFlg = consortFlg;
	} // zҗL\("L"E"")
	
	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}// Ж
	
	public void setTotalTotalPayTotalAllowance(Integer totalPayTotalAllowance) {
		this.totalPayTotalAllowance = totalPayTotalAllowance;
	} //^xzv
	
	public void setTotalTotalPayTaxFree(Integer totalPayTaxFree) {
		this.totalPayTaxFree = totalPayTaxFree;
	} //^ېŊzv
	
	public void setTotalTotalPayTaxation(Integer totalPayTaxation) {
		this.totalPayTaxation = totalPayTaxation;
	} //^ېŎxzv
	
	public void setTotalTotalPayIncomeTax(Integer totalPayIncomeTax) {
		this.totalPayIncomeTax = totalPayIncomeTax;
	} //^ōv
	
	public void setTotalTotalPaySocInsDeduction(Integer totalPaySocInsDeduction) {
		this.totalPaySocInsDeduction = totalPaySocInsDeduction;
	} //^Љیv
	
	public void setTotalTotalPayPayInsDeduction(Integer totalPayPayInsDeduction) {
		this.totalPayPayInsDeduction = totalPayPayInsDeduction;
	} //^ЉیT̋^̋zv
	
	public void setTotalTotalPayVariousDeduction(Integer totalPayVariousDeduction) {
		this.totalPayVariousDeduction = totalPayVariousDeduction;
	} //^Tv
	
	public void setTotalTotalPayPaymentTotal(Integer totalPayPaymentTotal) {
		this.totalPayPaymentTotal = totalPayPaymentTotal;
	} //^xzv
	
	public void setTotalTotalPayAdjCalcGap(Integer totalPayAdjCalcGap) {
		this.totalPayAdjCalcGap = totalPayAdjCalcGap;
	} //^Nɂߕsv
	
	public void setTotalBonTotalAllowance(Integer totalBonTotalAllowance) {
		this.totalBonTotalAllowance = totalBonTotalAllowance;
	} //ܗ^xzv
	
	public void setTotalBonTaxFree(Integer totalBonTaxFree) {
		this.totalBonTaxFree = totalBonTaxFree;
	} //ܗ^ېŊzv
	
	public void setTotalBonTaxation(Integer totalBonTaxation) {
		this.totalBonTaxation = totalBonTaxation;
	} //ܗ^ېŎxzv
	
	public void setTotalBonIncomeTax(Integer totalBonIncomeTax) {
		this.totalBonIncomeTax = totalBonIncomeTax;
	} //ܗ^ōv
	
	public void setTotalBonSocInsDeduction(Integer totalBonSocInsDeduction) {
		this.totalBonSocInsDeduction = totalBonSocInsDeduction;
	} //ܗ^Љیv
	
	public void setTotalBonPayInsDeduction(Integer totalBonPayInsDeduction) {
		this.totalBonPayInsDeduction = totalBonPayInsDeduction;
	} //ܗ^ЉیT̏ܗ^̋zv
	
	public void setTotalBonVariousDeduction(Integer totalBonVariousDeduction) {
		this.totalBonVariousDeduction = totalBonVariousDeduction;
	} //ܗ^Tv
	
	public void setTotalBonPaymentTotal(Integer totalBonPaymentTotal) {
		this.totalBonPaymentTotal = totalBonPaymentTotal;
	} //ܗ^xzv
	
	public void setTotalBonAdjCalcGap(Integer totalBonAdjCalcGap) {
		this.totalBonAdjCalcGap = totalBonAdjCalcGap;
	} //ܗ^Nɂߕsv
	
	public void setMonthType01(String monthType01) {
		this.monthType01 = monthType01;
	}// 敪01
	
	public void setMonthType02(String monthType02) {
		this.monthType02 = monthType02;
	}// 敪02
	
	public void setMonthType03(String monthType03) {
		this.monthType03 = monthType03;
	}// 敪03
	
	public void setMonthType04(String monthType04) {
		this.monthType04 = monthType04;
	}// 敪04
	
	public void setMonthType05(String monthType05) {
		this.monthType05 = monthType05;
	}// 敪05
	
	public void setMonthType06(String monthType06) {
		this.monthType06 = monthType06;
	}// 敪06
	
	public void setMonthType07(String monthType07) {
		this.monthType07 = monthType07;
	}// 敪07
	
	public void setMonthType08(String monthType08) {
		this.monthType08 = monthType08;
	}// 敪08
	
	public void setMonthType09(String monthType09) {
		this.monthType09 = monthType09;
	}// 敪09
	
	public void setMonthType10(String monthType10) {
		this.monthType10 = monthType10;
	}// 敪10
	
	public void setMonthType11(String monthType11) {
		this.monthType11 = monthType11;
	}// 敪11
	
	public void setMonthType12(String monthType12) {
		this.monthType12 = monthType12;
	}// 敪12
	
	public String getAdjustYear() {
		return adjustYear;
	}
	
	public String getAdjustYearYY() {
		return adjustYearYY;
	}
	
	public String getStationCode() {
		return stationCode;
	}
	
	public String getStationName() {
		return stationName;
	}
	
	public String getPositionCode() {
		return positionCode;
	}
	
	public String getPositionName() {
		return positionName;
	}
	
	public String getTouKyu() {
		return touKyu;
	}
	
	public String getKCode() {
		return kCode;
	}
	
	public String getKName() {
		return kName;
	}
	
	public String getFName() {
		return fName;
	}
	
	public String getPostalCode() {
		return postalCode;
	}
	
	public String getAddress() {
		return address;
	}
	
	public String getBirthDate() {
		return birthDate;
	}
	
	public String getPaymentMonth01() {
		return paymentMonth01;
	} // x01
	
	public String getPaymentMonth02() {
		return paymentMonth02;
	} // x02
	
	public String getPaymentMonth03() {
		return paymentMonth03;
	} // x03
	
	public String getPaymentMonth04() {
		return paymentMonth04;
	} // x04
	
	public String getPaymentMonth05() {
		return paymentMonth05;
	} // x05
	
	public String getPaymentMonth06() {
		return paymentMonth06;
	} // x06
	
	public String getPaymentMonth07() {
		return paymentMonth07;
	} // x07
	
	public String getPaymentMonth08() {
		return paymentMonth08;
	} // x08
	
	public String getPaymentMonth09() {
		return paymentMonth09;
	} // x09
	
	public String getPaymentMonth10() {
		return paymentMonth10;
	} // x10
	
	public String getPaymentMonth11() {
		return paymentMonth11;
	} // x11
	
	public String getPaymentMonth12() {
		return paymentMonth12;
	} // x12
	
	public String getPaymentPayDay01() {
		return paymentPayDay01;
	} // x01
	
	public String getPaymentPayDay02() {
		return paymentPayDay02;
	} // x02
	
	public String getPaymentPayDay03() {
		return paymentPayDay03;
	} // x03
	
	public String getPaymentPayDay04() {
		return paymentPayDay04;
	} // x04
	
	public String getPaymentPayDay05() {
		return paymentPayDay05;
	} // x05
	
	public String getPaymentPayDay06() {
		return paymentPayDay06;
	} // x06
	
	public String getPaymentPayDay07() {
		return paymentPayDay07;
	} // x07
	
	public String getPaymentPayDay08() {
		return paymentPayDay08;
	} // x08
	
	public String getPaymentPayDay09() {
		return paymentPayDay09;
	} // x09
	
	public String getPaymentPayDay10() {
		return paymentPayDay10;
	} // x10
	
	public String getPaymentPayDay11() {
		return paymentPayDay11;
	} // x11
	
	public String getPaymentPayDay12() {
		return paymentPayDay12;
	} // x12
	
	public Integer getPayTotalAllowance01() {
		return payTotalAllowance01;
	} // xz01 
	
	public Integer getPayTotalAllowance02() {
		return payTotalAllowance02;
	} // xz02
	
	public Integer getPayTotalAllowance03() {
		return payTotalAllowance03;
	} // xz03
	
	public Integer getPayTotalAllowance04() {
		return payTotalAllowance04;
	} // xz04
	
	public Integer getPayTotalAllowance05() {
		return payTotalAllowance05;
	} // xz05
	
	public Integer getPayTotalAllowance06() {
		return payTotalAllowance06;
	} // xz06
	
	public Integer getPayTotalAllowance07() {
		return payTotalAllowance07;
	} // xz07
	
	public Integer getPayTotalAllowance08() {
		return payTotalAllowance08;
	} // xz08
	
	public Integer getPayTotalAllowance09() {
		return payTotalAllowance09;
	} // xz09
	
	public Integer getPayTotalAllowance10() {
		return payTotalAllowance10;
	} // xz10
	
	public Integer getPayTotalAllowance11() {
		return payTotalAllowance11;
	} // xz11
	
	public Integer getPayTotalAllowance12() {
		return payTotalAllowance12;
	} // xz12
	
	public Integer getPayTaxFree01() {
		return payTaxFree01;
	} // ېŊz01
	
	public Integer getPayTaxFree02() {
		return payTaxFree02;
	} // ېŊz02
	
	public Integer getPayTaxFree03() {
		return payTaxFree03;
	} // ېŊz03
	
	public Integer getPayTaxFree04() {
		return payTaxFree04;
	} // ېŊz04
	
	public Integer getPayTaxFree05() {
		return payTaxFree05;
	} // ېŊz05
	
	public Integer getPayTaxFree06() {
		return payTaxFree06;
	} // ېŊz06
	
	public Integer getPayTaxFree07() {
		return payTaxFree07;
	} // ېŊz07
	
	public Integer getPayTaxFree08() {
		return payTaxFree08;
	} // ېŊz08
	
	public Integer getPayTaxFree09() {
		return payTaxFree09;
	} // ېŊz09
	
	public Integer getPayTaxFree10() {
		return payTaxFree10;
	} // ېŊz10
	
	public Integer getPayTaxFree11() {
		return payTaxFree11;
	} // ېŊz11
	
	public Integer getPayTaxFree12() {
		return payTaxFree12;
	} // ېŊz12
	
	public Integer getPayTaxation01() {
		return payTaxation01;
	} // ېŎxz01
	
	public Integer getPayTaxation02() {
		return payTaxation02;
	} // ېŎxz02
	
	public Integer getPayTaxation03() {
		return payTaxation03;
	} // ېŎxz03
	
	public Integer getPayTaxation04() {
		return payTaxation04;
	} // ېŎxz04
	
	public Integer getPayTaxation05() {
		return payTaxation05;
	} // ېŎxz05
	
	public Integer getPayTaxation06() {
		return payTaxation06;
	} // ېŎxz06
	
	public Integer getPayTaxation07() {
		return payTaxation07;
	} // ېŎxz07
	
	public Integer getPayTaxation08() {
		return payTaxation08;
	} // ېŎxz08
	
	public Integer getPayTaxation09() {
		return payTaxation09;
	} // ېŎxz09
	
	public Integer getPayTaxation10() {
		return payTaxation10;
	} // ېŎxz10
	
	public Integer getPayTaxation11() {
		return payTaxation11;
	} // ېŎxz11
	
	public Integer getPayTaxation12() {
		return payTaxation12;
	} // ېŎxz12
	
	public Integer getPaySocInsDeduction01() {
		return paySocInsDeduction01;
	} // Љی01
	
	public Integer getPaySocInsDeduction02() {
		return paySocInsDeduction02;
	} // Љی02
	
	public Integer getPaySocInsDeduction03() {
		return paySocInsDeduction03;
	} // Љی03
	
	public Integer getPaySocInsDeduction04() {
		return paySocInsDeduction04;
	} // Љی04
	
	public Integer getPaySocInsDeduction05() {
		return paySocInsDeduction05;
	} // Љی05
	
	public Integer getPaySocInsDeduction06() {
		return paySocInsDeduction06;
	} // Љی06
	
	public Integer getPaySocInsDeduction07() {
		return paySocInsDeduction07;
	} // Љی07
	
	public Integer getPaySocInsDeduction08() {
		return paySocInsDeduction08;
	} // Љی08
	
	public Integer getPaySocInsDeduction09() {
		return paySocInsDeduction09;
	} // Љی09
	
	public Integer getPaySocInsDeduction10() {
		return paySocInsDeduction10;
	} // Љی10
	
	public Integer getPaySocInsDeduction11() {
		return paySocInsDeduction11;
	} // Љی11
	
	public Integer getPaySocInsDeduction12() {
		return paySocInsDeduction12;
	} // Љی12
	
	public Integer getPayPayInsDeduction01() {
		return payPayInsDeduction01;
	} // ЉیT̋^̋z01
	
	public Integer getPayPayInsDeduction02() {
		return payPayInsDeduction02;
	} // ЉیT̋^̋z02
	
	public Integer getPayPayInsDeduction03() {
		return payPayInsDeduction03;
	} // ЉیT̋^̋z03
	
	public Integer getPayPayInsDeduction04() {
		return payPayInsDeduction04;
	} // ЉیT̋^̋z04
	
	public Integer getPayPayInsDeduction05() {
		return payPayInsDeduction05;
	} // ЉیT̋^̋z05
	
	public Integer getPayPayInsDeduction06() {
		return payPayInsDeduction06;
	} // ЉیT̋^̋z06
	
	public Integer getPayPayInsDeduction07() {
		return payPayInsDeduction07;
	} // ЉیT̋^̋z07
	
	public Integer getPayPayInsDeduction08() {
		return payPayInsDeduction08;
	} // ЉیT̋^̋z08
	
	public Integer getPayPayInsDeduction09() {
		return payPayInsDeduction09;
	} // ЉیT̋^̋z09
	
	public Integer getPayPayInsDeduction10() {
		return payPayInsDeduction10;
	} // ЉیT̋^̋z10
	
	public Integer getPayPayInsDeduction11() {
		return payPayInsDeduction11;
	} // ЉیT̋^̋z11
	
	public Integer getPayPayInsDeduction12() {
		return payPayInsDeduction12;
	} // ЉیT̋^̋z12
	
	public Integer getPayDependentCount01() {
		return payDependentCount01;
	} // }{e(^)01
	
	public Integer getPayDependentCount02() {
		return payDependentCount02;
	} // }{e(^)02
	
	public Integer getPayDependentCount03() {
		return payDependentCount03;
	} // }{e(^)03
	
	public Integer getPayDependentCount04() {
		return payDependentCount04;
	} // }{e(^)04
	
	public Integer getPayDependentCount05() {
		return payDependentCount05;
	} // }{e(^)05
	
	public Integer getPayDependentCount06() {
		return payDependentCount06;
	} // }{e(^)06
	
	public Integer getPayDependentCount07() {
		return payDependentCount07;
	} // }{e(^)07
	
	public Integer getPayDependentCount08() {
		return payDependentCount08;
	} // }{e(^)08
	
	public Integer getPayDependentCount09() {
		return payDependentCount09;
	} // }{e(^)09
	
	public Integer getPayDependentCount10() {
		return payDependentCount10;
	} // }{e(^)10
	
	public Integer getPayDependentCount11() {
		return payDependentCount11;
	} // }{e(^)11
	
	public Integer getPayDependentCount12() {
		return payDependentCount12;
	} // }{e(^)12
	
	public Integer getPayIncomeTax01() {
		return payIncomeTax01;
	} // 01 
	
	public Integer getPayIncomeTax02() {
		return payIncomeTax02;
	} // 02
	
	public Integer getPayIncomeTax03() {
		return payIncomeTax03;
	} // 03
	
	public Integer getPayIncomeTax04() {
		return payIncomeTax04;
	} // 04
	
	public Integer getPayIncomeTax05() {
		return payIncomeTax05;
	} // 05
	
	public Integer getPayIncomeTax06() {
		return payIncomeTax06;
	} // 06
	
	public Integer getPayIncomeTax07() {
		return payIncomeTax07;
	} // 07
	
	public Integer getPayIncomeTax08() {
		return payIncomeTax08;
	} // 08
	
	public Integer getPayIncomeTax09() {
		return payIncomeTax09;
	} // 09
	
	public Integer getPayIncomeTax10() {
		return payIncomeTax10;
	} // 10
	
	public Integer getPayIncomeTax11() {
		return payIncomeTax11;
	} // 11
	
	public Integer getPayIncomeTax12() {
		return payIncomeTax12;
	} // 12
	
	public Integer getPayAdjCalcGap01() {
		return payAdjCalcGap01;
	} // Nɂߕs01
	
	public Integer getPayAdjCalcGap02() {
		return payAdjCalcGap02;
	} // Nɂߕs02
	
	public Integer getPayAdjCalcGap03() {
		return payAdjCalcGap03;
	} // Nɂߕs03
	
	public Integer getPayAdjCalcGap04() {
		return payAdjCalcGap04;
	} // Nɂߕs04
	
	public Integer getPayAdjCalcGap05() {
		return payAdjCalcGap05;
	} // Nɂߕs05
	
	public Integer getPayAdjCalcGap06() {
		return payAdjCalcGap06;
	} // Nɂߕs06
	
	public Integer getPayAdjCalcGap07() {
		return payAdjCalcGap07;
	} // Nɂߕs07
	
	public Integer getPayAdjCalcGap08() {
		return payAdjCalcGap08;
	} // Nɂߕs08
	
	public Integer getPayAdjCalcGap09() {
		return payAdjCalcGap09;
	} // Nɂߕs09
	
	public Integer getPayAdjCalcGap10() {
		return payAdjCalcGap10;
	} // Nɂߕs10
	
	public Integer getPayAdjCalcGap11() {
		return payAdjCalcGap11;
	} // Nɂߕs11
	
	public Integer getPayAdjCalcGap12() {
		return payAdjCalcGap12;
	} // Nɂߕs12
	
	public Integer getPayVariousDeduction01() {
		return payVariousDeduction01;
	} // T01
	
	public Integer getPayVariousDeduction02() {
		return payVariousDeduction02;
	} // T02
	
	public Integer getPayVariousDeduction03() {
		return payVariousDeduction03;
	} // T03
	
	public Integer getPayVariousDeduction04() {
		return payVariousDeduction04;
	} // T04
	
	public Integer getPayVariousDeduction05() {
		return payVariousDeduction05;
	} // T05
	
	public Integer getPayVariousDeduction06() {
		return payVariousDeduction06;
	} // T06
	
	public Integer getPayVariousDeduction07() {
		return payVariousDeduction07;
	} // T07
	
	public Integer getPayVariousDeduction08() {
		return payVariousDeduction08;
	} // T08
	
	public Integer getPayVariousDeduction09() {
		return payVariousDeduction09;
	} // T09
	
	public Integer getPayVariousDeduction10() {
		return payVariousDeduction10;
	} // T10
	
	public Integer getPayVariousDeduction11() {
		return payVariousDeduction11;
	} // T11
	
	public Integer getPayVariousDeduction12() {
		return payVariousDeduction12;
	} // T12
	
	public Integer getPayPaymentTotal01() {
		return payPaymentTotal01;
	} // xz01
	
	public Integer getPayPaymentTotal02() {
		return payPaymentTotal02;
	} // xz02
	
	public Integer getPayPaymentTotal03() {
		return payPaymentTotal03;
	} // xz03
	
	public Integer getPayPaymentTotal04() {
		return payPaymentTotal04;
	} // xz04
	
	public Integer getPayPaymentTotal05() {
		return payPaymentTotal05;
	} // xz05
	
	public Integer getPayPaymentTotal06() {
		return payPaymentTotal06;
	} // xz06
	
	public Integer getPayPaymentTotal07() {
		return payPaymentTotal07;
	} // xz07
	
	public Integer getPayPaymentTotal08() {
		return payPaymentTotal08;
	} // xz08
	
	public Integer getPayPaymentTotal09() {
		return payPaymentTotal09;
	} // xz09
	
	public Integer getPayPaymentTotal10() {
		return payPaymentTotal10;
	} // xz10
	
	public Integer getPayPaymentTotal11() {
		return payPaymentTotal11;
	} // xz11
	
	public Integer getPayPaymentTotal12() {
		return payPaymentTotal12;
	} // xz12
	
	public Integer getPayPaymentTax01() {
		return payPaymentTax01;
	} // Ŋz01
	
	public Integer getPayPaymentTax02() {
		return payPaymentTax02;
	} // Ŋz02
	
	public Integer getPayPaymentTax03() {
		return payPaymentTax03;
	} // Ŋz03
	
	public Integer getPayPaymentTax04() {
		return payPaymentTax04;
	} // Ŋz04
	
	public Integer getPayPaymentTax05() {
		return payPaymentTax05;
	} // Ŋz05
	
	public Integer getPayPaymentTax06() {
		return payPaymentTax06;
	} // Ŋz06
	
	public Integer getPayPaymentTax07() {
		return payPaymentTax07;
	} // Ŋz07
	
	public Integer getPayPaymentTax08() {
		return payPaymentTax08;
	} // Ŋz08
	
	public Integer getPayPaymentTax09() {
		return payPaymentTax09;
	} // Ŋz09
	
	public Integer getPayPaymentTax10() {
		return payPaymentTax10;
	} // Ŋz10
	
	public Integer getPayPaymentTax11() {
		return payPaymentTax11;
	} // Ŋz11
	
	public Integer getPayPaymentTax12() {
		return payPaymentTax12;
	} // Ŋz12
	
	public String getBonusMonth01() {
		return bonusMonth01;
	} // x(ܗ^)01
	
	public String getBonusMonth02() {
		return bonusMonth02;
	} // x(ܗ^)02
	
	public String getBonusMonth03() {
		return bonusMonth03;
	} // x(ܗ^)03
	
	public String getBonusMonth04() {
		return bonusMonth04;
	} // x(ܗ^)04
	
	public String getBonusMonth05() {
		return bonusMonth05;
	} // x(ܗ^)05
	
	public String getBonusMonth06() {
		return bonusMonth06;
	} // x(ܗ^)06
	
	public String getBonusPayDay01() {
		return bonusPayDay01;
	} // x(ܗ^)01
	
	public String getBonusPayDay02() {
		return bonusPayDay02;
	} // x(ܗ^)02
	
	public String getBonusPayDay03() {
		return bonusPayDay03;
	} // x(ܗ^)03
	
	public String getBonusPayDay04() {
		return bonusPayDay04;
	} // x(ܗ^)04
	
	public String getBonusPayDay05() {
		return bonusPayDay05;
	} // x(ܗ^)05
	
	public String getBonusPayDay06() {
		return bonusPayDay06;
	} // x(ܗ^)06
	
	public Integer getBonTotalAllowance01() {
		return bonTotalAllowance01;
	} // xz(ܗ^01)
	
	public Integer getBonTotalAllowance02() {
		return bonTotalAllowance02;
	} // xz(ܗ^02)
	
	public Integer getBonTotalAllowance03() {
		return bonTotalAllowance03;
	} // xz(ܗ^03)
	
	public Integer getBonTotalAllowance04() {
		return bonTotalAllowance04;
	} // xz(ܗ^04)
	
	public Integer getBonTotalAllowance05() {
		return bonTotalAllowance05;
	} // xz(ܗ^05)
	
	public Integer getBonTotalAllowance06() {
		return bonTotalAllowance06;
	} // xz(ܗ^06)
	
	public Integer getBonTaxFree01() {
		return bonTaxFree01;
	} // ېŊz(ܗ^)01
	
	public Integer getBonTaxFree02() {
		return bonTaxFree02;
	} // ېŊz(ܗ^)02
	
	public Integer getBonTaxFree03() {
		return bonTaxFree03;
	} // ېŊz(ܗ^)03
	
	public Integer getBonTaxFree04() {
		return bonTaxFree04;
	} // ېŊz(ܗ^)04
	
	public Integer getBonTaxFree05() {
		return bonTaxFree05;
	} // ېŊz(ܗ^)05
	
	public Integer getBonTaxFree06() {
		return bonTaxFree06;
	} // ېŊz(ܗ^)06
	
	public Integer getBonTaxation01() {
		return bonTaxation01;
	} // ېŎxz(ܗ^)01
	
	public Integer getBonTaxation02() {
		return bonTaxation02;
	} // ېŎxz(ܗ^)02
	
	public Integer getBonTaxation03() {
		return bonTaxation03;
	} // ېŎxz(ܗ^)03
	
	public Integer getBonTaxation04() {
		return bonTaxation04;
	} // ېŎxz(ܗ^)04
	
	public Integer getBonTaxation05() {
		return bonTaxation05;
	} // ېŎxz(ܗ^)05
	
	public Integer getBonTaxation06() {
		return bonTaxation06;
	} // ېŎxz(ܗ^)06
	
	public Integer getBonSocInsDeduction01() {
		return bonSocInsDeduction01;
	} // Љی(ܗ^)01
	
	public Integer getBonSocInsDeduction02() {
		return bonSocInsDeduction02;
	} // Љی(ܗ^)02
	
	public Integer getBonSocInsDeduction03() {
		return bonSocInsDeduction03;
	} // Љی(ܗ^)03
	
	public Integer getBonSocInsDeduction04() {
		return bonSocInsDeduction04;
	} // Љی(ܗ^)04
	
	public Integer getBonSocInsDeduction05() {
		return bonSocInsDeduction05;
	} // Љی(ܗ^)05
	
	public Integer getBonSocInsDeduction06() {
		return bonSocInsDeduction06;
	} // Љی(ܗ^)06
	
	public Integer getBonPayInsDeduction01() {
		return bonPayInsDeduction01;
	} // ЉیT̋^̋z(ܗ^)01
	
	public Integer getBonPayInsDeduction02() {
		return bonPayInsDeduction02;
	} // ЉیT̋^̋z(ܗ^)02
	
	public Integer getBonPayInsDeduction03() {
		return bonPayInsDeduction03;
	} // ЉیT̋^̋z(ܗ^)03
	
	public Integer getBonPayInsDeduction04() {
		return bonPayInsDeduction04;
	} // ЉیT̋^̋z(ܗ^)04
	
	public Integer getBonPayInsDeduction05() {
		return bonPayInsDeduction05;
	} // ЉیT̋^̋z(ܗ^)05
	
	public Integer getBonPayInsDeduction06() {
		return bonPayInsDeduction06;
	} // ЉیT̋^̋z(ܗ^)06
	
	public Integer getBonDependentCount01() {
		return bonDependentCount01;
	} // }{e(ܗ^)01
	
	public Integer getBonDependentCount02() {
		return bonDependentCount02;
	} // }{e(ܗ^)02
	
	public Integer getBonDependentCount03() {
		return bonDependentCount03;
	} // }{e(ܗ^)03
	
	public Integer getBonDependentCount04() {
		return bonDependentCount04;
	} // }{e(ܗ^)04
	
	public Integer getBonDependentCount05() {
		return bonDependentCount05;
	} // }{e(ܗ^)05
	
	public Integer getBonDependentCount06() {
		return bonDependentCount06;
	} // }{e(ܗ^)06
	
	public Integer getBonIncomeTax01() {
		return bonIncomeTax01;
	} // (ܗ^)01
	
	public Integer getBonIncomeTax02() {
		return bonIncomeTax02;
	} // (ܗ^)02
	
	public Integer getBonIncomeTax03() {
		return bonIncomeTax03;
	} // (ܗ^)03
	
	public Integer getBonIncomeTax04() {
		return bonIncomeTax04;
	} // (ܗ^)04
	
	public Integer getBonIncomeTax05() {
		return bonIncomeTax05;
	} // (ܗ^)05
	
	public Integer getBonIncomeTax06() {
		return bonIncomeTax06;
	} // (ܗ^)06
	
	public Float getBonIncomeTaxRate01() {
		return bonIncomeTaxRate01;
	} //ŗ(ܗ^)01
	
	public Float getBonIncomeTaxRate02() {
		return bonIncomeTaxRate02;
	} //ŗ(ܗ^)02
	
	public Float getBonIncomeTaxRate03() {
		return bonIncomeTaxRate03;
	} //ŗ(ܗ^)03
	
	public Float getBonIncomeTaxRate04() {
		return bonIncomeTaxRate04;
	} //ŗ(ܗ^)04
	
	public Float getBonIncomeTaxRate05() {
		return bonIncomeTaxRate05;
	} //ŗ(ܗ^)05
	
	public Float getBonIncomeTaxRate06() {
		return bonIncomeTaxRate06;
	} //ŗ(ܗ^)06
	
	public Integer getBonAdjCalcGap01() {
		return bonAdjCalcGap01;
	} // Nɂߕs(ܗ^)01
	
	public Integer getBonAdjCalcGap02() {
		return bonAdjCalcGap02;
	} // Nɂߕs(ܗ^)02
	
	public Integer getBonAdjCalcGap03() {
		return bonAdjCalcGap03;
	} // Nɂߕs(ܗ^)03
	
	public Integer getBonAdjCalcGap04() {
		return bonAdjCalcGap04;
	} // Nɂߕs(ܗ^)04
	
	public Integer getBonAdjCalcGap05() {
		return bonAdjCalcGap05;
	} // Nɂߕs(ܗ^)05
	
	public Integer getBonAdjCalcGap06() {
		return bonAdjCalcGap06;
	} // Nɂߕs(ܗ^)06
	
	public Integer getBonVariousDeduction01() {
		return bonVariousDeduction01;
	} // T(ܗ^)01
	
	public Integer getBonVariousDeduction02() {
		return bonVariousDeduction02;
	} // T(ܗ^)02
	
	public Integer getBonVariousDeduction03() {
		return bonVariousDeduction03;
	} // T(ܗ^)03
	
	public Integer getBonVariousDeduction04() {
		return bonVariousDeduction04;
	} // T(ܗ^)04
	
	public Integer getBonVariousDeduction05() {
		return bonVariousDeduction05;
	} // T(ܗ^)05
	
	public Integer getBonVariousDeduction06() {
		return bonVariousDeduction06;
	} // T(ܗ^)06
	
	public Integer getBonPaymentTotal01() {
		return bonPaymentTotal01;
	} // xz(ܗ^)01
	
	public Integer getBonPaymentTotal02() {
		return bonPaymentTotal02;
	} // xz(ܗ^)02
	
	public Integer getBonPaymentTotal03() {
		return bonPaymentTotal03;
	} // xz(ܗ^)03
	
	public Integer getBonPaymentTotal04() {
		return bonPaymentTotal04;
	} // xz(ܗ^)04
	
	public Integer getBonPaymentTotal05() {
		return bonPaymentTotal05;
	} // xz(ܗ^)05
	
	public Integer getBonPaymentTotal06() {
		return bonPaymentTotal06;
	} // xz(ܗ^)06
	
	public Integer getBonPaymentTax01() {
		return bonPaymentTax01;
	} // Ŋz01
	
	public Integer getBonPaymentTax02() {
		return bonPaymentTax02;
	} // Ŋz02
	
	public Integer getBonPaymentTax03() {
		return bonPaymentTax03;
	} // Ŋz03
	
	public Integer getBonPaymentTax04() {
		return bonPaymentTax04;
	} // Ŋz04
	
	public Integer getBonPaymentTax05() {
		return bonPaymentTax05;
	} // Ŋz05
	
	public Integer getBonPaymentTax06() {
		return bonPaymentTax06;
	} // Ŋz06
	
	public Integer getTotalAllowance() {
		return totalAllowance;
	} // xzv
	
	public Integer getTaxFree() {
		return taxFree;
	} // ېŊzv
	
	public Integer getTaxation() {
		return taxation;
	} // ېŊzv
	
	public Integer getSocInsDeduction() {
		return socInsDeduction;
	} // Љیv 
	
	public Integer getTotalPayInsDeduction() {
		return totalPayInsDeduction;
	} // ЉیT̋^̋zv
	
	public Integer getIncomeTax() {
		return incomeTax;
	} // ōv
	
	public Integer getVariousDeduction() {
		return variousDeduction;
	} // Tv
	
	public Integer getPaymentTotal() {
		return paymentTotal;
	} // xzv
	
	public Integer getMidwayType() {
		return midwayType;
	} // rЋ敪
	
	public Integer getFormerIncome() {
		return formerIncome;
	} // OΖz
	
	public Integer getFormerInsurance() {
		return formerInsurance;
	} // OΖЉیz
	
	public Integer getFormerTax() {
		return formerTax;
	} // OΖ揊Ŋz
	
	public Integer getPaymentAllowance() {
		return paymentAllowance;
	} // ^A蓖z
	
	public Integer getPaymentIncomeTax() {
		return paymentIncomeTax;
	} //^A蓖Ŋz
	
	public Integer getBonusAllowance() {
		return bonusAllowance;
	} // ܗ^z
	
	public Integer getBonusIncomeTax() {
		return bonusIncomeTax;
	} // ܗ^Ŋz
	
	public Integer getMidwayAdjustIncome() {
		return midwayAdjustIncome;
	} // rAz
	
	public Integer getMidwayAdjustTax() {
		return midwayAdjustTax;
	} // rAŊz
	
	public Integer getAdjTotalAllowance() {
		return adjTotalAllowance;
	} // xzv
	
	public Integer getAdjTotalIncome() {
		return adjTotalIncome;
	} // Ŋzv
	
	public Integer getAfterDeductIncome() {
		return afterDeductIncome;
	} // ^T̋^̋z
	
	public Integer getPayInsDeduction() {
		return payInsDeduction;
	} // Љی^̍T
	
	public Integer getSocialInsDeduction() {
		return socialInsDeduction;
	} // ЉیTz
	
	public Integer getMutualAidDeduction() {
		return mutualAidDeduction;
	} // K͊Ƌϓ|Tz
	
	public Integer getLifeInsDeduction() {
		return lifeInsDeduction;
	} // یTz
	
	public Integer getDamageInsDeduction() {
		return damageInsDeduction;
	} // QیTz
	
	public Integer getSpouseSpDeduction() {
		return spouseSpDeduction;
	} // zғʍTz
	
	public Integer getDependentsDeduction() {
		return dependentsDeduction;
	} // zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	
	public Integer getIncomeDeductSum() {
		return incomeDeductSum;
	} // Tzv
	
	public Integer getFinalIncomeTax() {
		return finalIncomeTax;
	} // NŊz
	
	public Integer getHouseLoanDeduction() {
		return houseLoanDeduction;
	} // ZؓʍTz
	
	public Integer getTaxGap() {
		return taxGap;
	} // Ŋz擾
	
	public Integer getCalcTaxedIncome() {
		return calcTaxedIncome;
	} // ېŋ^z
	
	public Integer getSpouseSumIncome() {
		return spouseSumIncome;
	} // z҂̖{N̍vžϊz
	
	public Integer getGeneralLifeIns() {
		return generalLifeIns;
	} // ʂ̐ی
	
	public Integer getPrivatePension() {
		return privatePension;
	} // lNی
	
	public Integer getEarthquakeIns() {
		return earthquakeIns;
	} // nkی
	
	public Integer getLongTermDamageIns() {
		return longTermDamageIns;
	} // Qی
	
	public Integer getAllowanceAdjustment() {
		return allowanceAdjustment;
	} // xz
	
	public Integer getTaxFreeAdjustment() {
		return taxFreeAdjustment;
	} // ېŒz
	
	public Integer getTaxIncAdjustment() {
		return taxIncAdjustment;
	} // Œz
	
	public String getWithholdSlipNotes() {
		return withholdSlipNotes;
	} // 򒥎[Ev
	
	public Integer getCalcIncomeTax() {
		return calcIncomeTax;
	} // ZoNŊz
	
	public Integer getAdjustedIncomeTax() {
		return adjustedIncomeTax;
	} // NNŊz
	
	public Integer getDeductedIncomeTax() {
		return deductedIncomeTax;
	} // N藦TzŊz
	
	public Integer getSocInsAdjustment() {
		return socInsAdjustment;
	} // Љیz
	
	public String getIncomeTaxType() {
		return incomeTaxType;
	} // ېŋ敪 
	
	public String getAdjustmentType() {
		return adjustmentType;
	} // N敪 
	
	public String getSpHandicap() {
		return spHandicap;
	} // ʏQ 
	
	public String getGeHandicap() {
		return geHandicap;
	} // ʏQ
	
	public String getGeWidow() {
		return geWidow;
	} // ʉǕw
	
	public String getSpWidow() {
		return spWidow;
	} // ʉǕw
	
	public String getWidow() {
		return widow;
	} // Ǖv
	
	public String getStudentGeneral() {
		return studentGeneral;
	} // ΘJw
	
	public String getLwSpHandiEl() {
		return lwSpHandiEl;
	} // ʏQҘVl
	
	public String getLwSpHandicap() {
		return lwSpHandicap;
	} // ʏQ
	
	public String getSpouseEl() {
		return spouseEl;
	} // Vlz
	
	public String getSpouseGe() {
		return spouseGe;
	} // ʔz(̑)
	
	public String getGeneralDependent() {
		return generalDependent;
	} // ʕ}{e
	
	public String getSpecificDependent() {
		return specificDependent;
	} // }{e
	
	public String getElderlyDependent() {
		return elderlyDependent;
	} // Vl}{e
	
	public String getLiveWithEldRel() {
		return liveWithEldRel;
	} // Ve
	
	public String getLiveWithHandiGe() {
		return liveWithHandiGe;
	} // 
	
	public String getLiveWithHandiSp() {
		return liveWithHandiSp;
	} // 
	
	public String getLiveWithHandiEl() {
		return liveWithHandiEl;
	} // Vl
	
	public String getLiveWithHandiEr() {
		return liveWithHandiEr;
	} // Ve
	
	public String getGeneralHandicap() {
		return generalHandicap;
	} // ʏQ
	
	public String getSpecificHandicap() {
		return specificHandicap;
	} // ʏQ
	
	public String getTotallHandicap() {
		return totallHandicap;
	} // QҌv
	
	public String getTotallDeduction() {
		return totallDeduction;
	} // TΏێҐ
	
	public String getConsortFlg() {
		return consortFlg;
	} // zҗL\
	
	public String getCompanyName() {
		return companyName;
	} // Ж
	
	public Integer getTotalPayTotalAllowance() {
		return totalPayTotalAllowance;
	} //^xzv
	
	public Integer getTotalPayTaxFree() {
		return totalPayTaxFree;
	} //^ېŊzv
	
	public Integer getTotalPayTaxation() {
		return totalPayTaxation;
	} //^ېŎxzv
	
	public Integer getTotalPayIncomeTax() {
		return totalPayIncomeTax;
	} //^ōv
	
	public Integer getTotalPaySocInsDeduction() {
		return totalPaySocInsDeduction;
	} //^Љیv
	
	public Integer getTotalPayPayInsDeduction() {
		return totalPayPayInsDeduction;
	} //^ЉیT̋^̋zv
	
	public Integer getTotalPayVariousDeduction() {
		return totalPayVariousDeduction;
	} //^Tv
	
	public Integer getTotalPayPaymentTotal() {
		return totalPayPaymentTotal;
	} //^xzv
	
	public Integer getTotalPayAdjCalcGap() {
		return totalPayAdjCalcGap;
	} //^Nɂߕsv
	
	public Integer getTotalBonTotalAllowance() {
		return totalBonTotalAllowance;
	} //ܗ^xzv
	
	public Integer getTotalBonTaxFree() {
		return totalBonTaxFree;
	} //ܗ^ېŊzv
	
	public Integer getTotalBonTaxation() {
		return totalBonTaxation;
	} //ܗ^ېŎxzv
	
	public Integer getTotalBonIncomeTax() {
		return totalBonIncomeTax;
	} //ܗ^ōv
	
	public Integer getTotalBonSocInsDeduction() {
		return totalBonSocInsDeduction;
	} //ܗ^Љیv
	
	public Integer getTotalBonPayInsDeduction() {
		return totalBonPayInsDeduction;
	} //ܗ^ЉیT̏ܗ^̋zv
	
	public Integer getTotalBonVariousDeduction() {
		return totalBonVariousDeduction;
	} //ܗ^Tv
	
	public Integer getTotalBonPaymentTotal() {
		return totalBonPaymentTotal;
	} //ܗ^xzv
	
	public Integer getTotalBonAdjCalcGap() {
		return totalBonAdjCalcGap;
	} //ܗ^Nɂߕsv
	
	public String getMonthType01() {
		return monthType01;
	} //敪01
	
	public String getMonthType02() {
		return monthType02;
	} //敪02
	
	public String getMonthType03() {
		return monthType03;
	} //敪03
	
	public String getMonthType04() {
		return monthType04;
	} //敪04
	
	public String getMonthType05() {
		return monthType05;
	} //敪05
	
	public String getMonthType06() {
		return monthType06;
	} //敪06
	
	public String getMonthType07() {
		return monthType07;
	} //敪07
	
	public String getMonthType08() {
		return monthType08;
	} //敪08
	
	public String getMonthType09() {
		return monthType09;
	} //敪09
	
	public String getMonthType10() {
		return monthType10;
	} //敪10
	
	public String getMonthType11() {
		return monthType11;
	} //敪11
	
	public String getMonthType12() {
		return monthType12;
	} //敪12
	
	public String getStrMidwayType() {
		return strMidwayType;
	} // rЋ敪
	
}
