/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.CmBranchDto;

/**
 * @author koike
 *
 */
public class CmBranchDao extends PayrollDao {
	
	// e[uyуL[
	/**
	 * xX}X^
	 */
	public static final String	TABLE			= "CM_BRANCH";
	/**
	 * sR[h
	 */
	public static final String	KEY_1			= "BANK_CODE";
	/**
	 * xXR[h
	 */
	public static final String	KEY_2			= "BRANCH_CODE";
	/**
	 * sR[h
	 */
	public static final String	COL_BANK_CODE	= "BANK_CODE";
	/**
	 * xXR[h
	 */
	public static final String	COL_BRANCH_CODE	= "BRANCH_CODE";
	/**
	 * xX
	 */
	public static final String	COL_BRANCH_NAME	= "BRANCH_NAME";
	/**
	 * xXtKi
	 */
	public static final String	COL_BRANCH_KANA	= "BRANCH_KANA";
	

	/**
	 * RXgN^
	 */
	public CmBranchDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<CmBranchDto> mappingAll() throws SQLException {
		List<CmBranchDto> all = new ArrayList<CmBranchDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CmBranchDto CM_BRANCHR[h
	 * @throws SQLException SQLOꍇ
	 */
	private CmBranchDto mapping() throws SQLException {
		CmBranchDto dto = new CmBranchDto();
		dto.setBankCode(rs.getString(COL_BANK_CODE)); // sR[h
		dto.setBranchCode(rs.getString(COL_BRANCH_CODE)); // xXR[h
		dto.setBranchName(rs.getString(COL_BRANCH_NAME)); // xX
		dto.setBranchKana(rs.getString(COL_BRANCH_KANA)); // xXtKi
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * L[ɂf[^̎擾B<br>
	 * @param bankCode sR[h
	 * @param branchCode xXR[h
	 * @return ɈvxX}X^̃R[h(v郌R[hꍇNULL)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public CmBranchDto findForKey(String bankCode, String branchCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, bankCode);
			setParam(index++, branchCode);
			executeQuery();
			CmBranchDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param bankCode sR[h(L[)
	 * @param branchCode xXR[h(L[)
	 * @return (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public CmBranchDto findForUpdate(String bankCode, String branchCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, bankCode);
			setParam(index++, branchCode);
			executeQuery();
			CmBranchDto cmBranchDto = null;
			if (rs.next()) {
				cmBranchDto = mapping();
			}
			return cmBranchDto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<CmBranchDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CmBranchDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public int insert(CmBranchDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @param needLog 
	 * @return XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public int update(CmBranchDto dto, boolean needLog) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getBankCode());
			setParam(index++, dto.getBranchCode());
			executeUpdate(needLog);
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * sR[hɂzf[^擾
	 * @return CmBranchDto (DTO)
	 * @throws SQLException SQLOꍇ
	 */
	public List<CmBranchDto> findForEmployeeList() throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT " + " * " + " FROM " + "CM_BANK " + "left join ");
			sb.append(TABLE + " ");
			sb.append("on");
			sb.append(" CM_BANK." + COL_BANK_CODE + " = ");
			sb.append(TABLE + "." + COL_BANK_CODE);
			prepareStatement(sb.toString());
			executeQuery();
			List<CmBranchDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param bankCode @@ @	sR[h
	 * @param bankKana			sJi
	 * @param branchCode @@  xXR[h
	 * @param branchKana @@  xXJi
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException 
	 */
	public List<CmBranchDto> findForCondition(String bankCode, String bankKana, String branchCode, String branchKana)
			throws SQLException, IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append("* ");
		sb.append("FROM ");
		sb.append("CM_BANK ");
		sb.append("left join ");
		sb.append(TABLE);
		sb.append(" on ");
		sb.append("CM_BANK." + COL_BANK_CODE + " = ");
		sb.append(TABLE + ".");
		sb.append(COL_BANK_CODE);
		if (bankCode != null && !bankCode.equals("") || bankKana != null && !bankKana.equals("") || branchCode != null
				&& !branchCode.equals("") || branchKana != null && !branchKana.equals("")) {
			sb.append(" WHERE ");
		}
		if (bankCode != null && !bankCode.equals("")) {
			sb.append("CM_BANK." + COL_BANK_CODE + " like ? ");
			if (bankKana != null && !bankKana.equals("") || branchCode != null && !branchCode.equals("")
					|| branchKana != null && !branchKana.equals("")) {
				sb.append(" AND ");
			}
		}
		if (bankKana != null && !bankKana.equals("")) {
			sb.append("CM_BANK.BANK_KANA" + " like ? ");
			if (branchCode != null && !branchCode.equals("") || branchKana != null && !branchKana.equals("")) {
				sb.append(" AND ");
			}
		}
		if (branchCode != null && !branchCode.equals("")) {
			sb.append(TABLE + "." + COL_BRANCH_CODE + " like ? ");
			if (branchKana != null && !branchKana.equals("")) {
				sb.append(" AND ");
			}
		}
		if (branchKana != null && !branchKana.equals("")) {
			sb.append(TABLE + "." + COL_BRANCH_KANA + " like ? ");
		}
		try {
			prepareStatement(sb.toString() + " " + getOrderBy() + CmBankDao.TABLE + "." + KEY_1 + " , " + TABLE + "."
					+ KEY_2);
			if (bankCode != null && !bankCode.equals("")) {
				setParam(index++, bankCode + "%");
			}
			if (bankKana != null && !bankKana.equals("")) {
				setParam(index++, "%" + bankKana + "%");
			}
			if (branchCode != null && !branchCode.equals("")) {
				setParam(index++, "%" + branchCode + "%");
			}
			if (branchKana != null && !branchKana.equals("")) {
				setParam(index++, "%" + branchKana + "%");
			}
			executeQuery();
			List<CmBranchDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(CmBranchDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getBankCode()); // sR[h
		setParam(index++, dto.getBranchCode()); // xXR[h
		setParam(index++, dto.getBranchName()); // xX
		setParam(index++, dto.getBranchKana()); // xXtKi
		setCommonParams(isInsert);
	}
	
}
