/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.CdAdjustmentDto;

public class CdAdjustmentDao extends PayrollDao {
	
	// e[uyуL[
	public static final String	TABLE						= "CD_ADJUSTMENT";
	public static final String	KEY_1						= "K_CODE";				// ЈR[h
	public static final String	KEY_2						= "ADJUST_YEAR";			// N
																						
	// 
	public static final String	COL_K_CODE					= "K_CODE";				// ЈR[h
	public static final String	COL_ADJUST_YEAR				= "ADJUST_YEAR";			// N
	public static final String	COL_ADJUST_STATUS			= "ADJUST_STATUS";			// NvZ
	public static final String	COL_GENERAL_LIFE_INS		= "GENERAL_LIFE_INS";		// ʂ̐ی
	public static final String	COL_PRIVATE_PENSION			= "PRIVATE_PENSION";		// lNی
	public static final String	COL_LIFE_INS_DEDUCTION		= "LIFE_INS_DEDUCTION";	// یTz
	public static final String	COL_EARTHQUAKE_INS			= "EARTHQUAKE_INS";		// nkی
	public static final String	COL_LONG_TERM_DAMAGE_INS	= "LONG_TERM_DAMAGE_INS";	// Qی
	public static final String	COL_DAMAGE_INS_DEDUCTION	= "DAMAGE_INS_DEDUCTION";	// QیTz
	public static final String	COL_SOCIAL_INS_DEDUCTION	= "SOCIAL_INS_DEDUCTION";	// ЉیTz
	public static final String	COL_MUTUAL_AID_DEDUCTION	= "MUTUAL_AID_DEDUCTION";	// K͊Ƌϓ|Tz
	public static final String	COL_SPOUSE_SUM_INCOME		= "SPOUSE_SUM_INCOME";		// z҂̖{N̍vžϊz
	public static final String	COL_SPOUSE_SP_DEDUCTION		= "SPOUSE_SP_DEDUCTION";	// zғʍTz
	public static final String	COL_HOUSE_LOAN_DEDUCTION	= "HOUSE_LOAN_DEDUCTION";	// ZؓʍTz
	public static final String	COL_ALLOWANCE_ADJUSTMENT	= "ALLOWANCE_ADJUSTMENT";	// xz
	public static final String	COL_TAX_FREE_ADJUSTMENT		= "TAX_FREE_ADJUSTMENT";	// ېŒz
	public static final String	COL_SOC_INS_ADJUSTMENT		= "SOC_INS_ADJUSTMENT";	// Љیz
	public static final String	COL_TAX_INC_ADJUSTMENT		= "TAX_INC_ADJUSTMENT";	// Œz
	public static final String	COL_WITHHOLD_SLIP_NOTES		= "WITHHOLD_SLIP_NOTES";	// 򒥎[Ev
	public static final String	COL_PAYMENT_ALLOWANCE		= "PAYMENT_ALLOWANCE";		// ^A蓖z
	public static final String	COL_PAYMENT_INCOME_TAX		= "PAYMENT_INCOME_TAX";	// ^A蓖Ŋz
	public static final String	COL_BONUS_ALLOWANCE			= "BONUS_ALLOWANCE";		// ܗ^z
	public static final String	COL_BONUS_INCOME_TAX		= "BONUS_INCOME_TAX";		// ܗ^Ŋz
	public static final String	COL_MIDWAY_ADJUST_INCOME	= "MIDWAY_ADJUST_INCOME";	// rAz
	public static final String	COL_MIDWAY_ADJUST_TAX		= "MIDWAY_ADJUST_TAX";		// rAŊz
	public static final String	COL_AFTER_DEDUCT_INCOME		= "AFTER_DEDUCT_INCOME";	// ^T̋^̋z
	public static final String	COL_PAY_INS_DEDUCTION		= "PAY_INS_DEDUCTION";		// Љی^̍T
	public static final String	COL_DEPENDENTS_DEDUCTION	= "DEPENDENTS_DEDUCTION";	// zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	public static final String	COL_CALC_TAXED_INCOME		= "CALC_TAXED_INCOME";		// ېŋ^z
	public static final String	COL_CALC_INCOME_TAX			= "CALC_INCOME_TAX";		// ZoNŊz
	public static final String	COL_ADJUSTED_INCOME_TAX		= "ADJUSTED_INCOME_TAX";	// NNŊz
	public static final String	COL_DEDUCTED_INCOME_TAX		= "DEDUCTED_INCOME_TAX";	// N藦TzŊz
	public static final String	COL_FINAL_INCOME_TAX		= "FINAL_INCOME_TAX";		// NŊz
	public static final String	COL_DEAD_RETIREMENT			= "DEAD_RETIREMENT";		// SސE
	public static final String	COL_SELF_DISASTER			= "SELF_DISASTER";			// ЊQ
	public static final String	COL_FOREIGNER				= "FOREIGNER";				// Ol
																						
	
	/**
	 * RXgN^
	 */
	public CdAdjustmentDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CdAdjustmentDto> mappingAll() throws SQLException {
		List<CdAdjustmentDto> all = new ArrayList<CdAdjustmentDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CdAdjustmentDto UD_PAYMENTR[h
	 * @throws SQLException
	 */
	private CdAdjustmentDto mapping() throws SQLException {
		CdAdjustmentDto dto = new CdAdjustmentDto();
		dto.setKCode(rs.getString(COL_K_CODE)); // ЈR[h
		dto.setAdjustYear(rs.getInt(COL_ADJUST_YEAR)); // N
		dto.setAdjustStatus(rs.getString(COL_ADJUST_STATUS)); // NvZ
		dto.setGeneralLifeIns(rs.getInt(COL_GENERAL_LIFE_INS)); // ʂ̐ی
		dto.setPrivatePension(rs.getInt(COL_PRIVATE_PENSION)); // lNی
		dto.setLifeInsDeduction(rs.getInt(COL_LIFE_INS_DEDUCTION)); // یTz
		dto.setEarthquakeIns(rs.getInt(COL_EARTHQUAKE_INS)); // nkی
		dto.setLongTermDamageIns(rs.getInt(COL_LONG_TERM_DAMAGE_INS)); // Qی
		dto.setDamageInsDeduction(rs.getInt(COL_DAMAGE_INS_DEDUCTION)); // QیTz
		dto.setSocialInsDeduction(rs.getInt(COL_SOCIAL_INS_DEDUCTION)); // ЉیTz
		dto.setMutualAidDeduction(rs.getInt(COL_MUTUAL_AID_DEDUCTION)); // K͊Ƌϓ|Tz
		dto.setSpouseSumIncome(rs.getInt(COL_SPOUSE_SUM_INCOME)); // z҂̖{N̍vžϊz
		dto.setSpouseSpDeduction(rs.getInt(COL_SPOUSE_SP_DEDUCTION)); // zғʍTz
		dto.setHouseLoanDeduction(rs.getInt(COL_HOUSE_LOAN_DEDUCTION)); // ZؓʍTz
		dto.setAllowanceAdjustment(rs.getInt(COL_ALLOWANCE_ADJUSTMENT)); // xz
		dto.setTaxFreeAdjustment(rs.getInt(COL_TAX_FREE_ADJUSTMENT)); // ېŒz
		dto.setSocInsAdjustment(rs.getInt(COL_SOC_INS_ADJUSTMENT)); // Љیz
		dto.setTaxIncAdjustment(rs.getInt(COL_TAX_INC_ADJUSTMENT)); // Œz
		dto.setWithholdSlipNotes(rs.getString(COL_WITHHOLD_SLIP_NOTES)); // 򒥎[Ev
		dto.setPaymentAllowance(rs.getInt(COL_PAYMENT_ALLOWANCE)); // ^A蓖z
		dto.setPaymentIncomeTax(rs.getInt(COL_PAYMENT_INCOME_TAX)); // ^A蓖Ŋz
		dto.setBonusAllowance(rs.getInt(COL_BONUS_ALLOWANCE)); // ܗ^z
		dto.setBonusIncomeTax(rs.getInt(COL_BONUS_INCOME_TAX)); // ܗ^Ŋz
		dto.setMidwayAdjustIncome(rs.getInt(COL_MIDWAY_ADJUST_INCOME)); // rAz
		dto.setMidwayAdjustTax(rs.getInt(COL_MIDWAY_ADJUST_TAX)); // rAŊz
		dto.setAfterDeductIncome(rs.getInt(COL_AFTER_DEDUCT_INCOME)); // ^T̋^̋z
		dto.setPayInsDeduction(rs.getInt(COL_PAY_INS_DEDUCTION)); // Љی^̍T
		dto.setDependentsDeduction(rs.getInt(COL_DEPENDENTS_DEDUCTION)); // zҍTzA}{TzAbTzyяQғ̍Tz̍vz
		dto.setCalcTaxedIncome(rs.getInt(COL_CALC_TAXED_INCOME)); // ېŋ^z
		dto.setCalcIncomeTax(rs.getInt(COL_CALC_INCOME_TAX)); // ZoNŊz
		dto.setAdjustedIncomeTax(rs.getInt(COL_ADJUSTED_INCOME_TAX)); // NNŊz
		dto.setDeductedIncomeTax(rs.getInt(COL_DEDUCTED_INCOME_TAX)); // N藦TzŊz
		dto.setFinalIncomeTax(rs.getInt(COL_FINAL_INCOME_TAX)); // NŊz
		dto.setDeadRetirement(rs.getString(COL_DEAD_RETIREMENT)); // SސE
		dto.setSelfDisaster(rs.getString(COL_SELF_DISASTER)); // ЊQ
		dto.setForeigner(rs.getString(COL_FOREIGNER)); // Ol
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CdAdjustmentDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CdAdjustmentDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode      ЈR[h(L[)
	 * @param adjustYear N    (L[)
	 * @return CdAdjustmentDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CdAdjustmentDto findForKey(String kCode, int adjustYear) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, adjustYear);
			executeQuery();
			CdAdjustmentDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kCode      ЈR[h(L[)
	 * @param adjustYear N    (L[)
	 * @return CdAdjustmentDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CdAdjustmentDto findForUpdate(String kCode, int adjustYear) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			setParam(index++, adjustYear);
			executeQuery();
			CdAdjustmentDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode              ЈR[h(L[)
	 * @param kName              Ј(L[)
	 * @param kKana              ض(L[)
	 * @param adjustYear         N(L[)
	 * @param adjustStatus       NXe[^X(L[)
	 * @param finalIncomeTaxFrom NŊzFrom
	 * @param finalIncomeTaxTo   NŊzTo
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CdAdjustmentDto> findForCondition(String kCode, String kName, String kKana, int adjustYear,
			String adjustStatus, String finalIncomeTaxFrom, String finalIncomeTaxTo) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " IN (" + MKihonPayrollDao.getSelectForSubQuery() + ") ");
		if (adjustYear != 0) {
			sb.append("AND ");
			sb.append(COL_ADJUST_YEAR + " = ? ");
		}
		if (adjustStatus != null && !adjustStatus.equals("")) {
			sb.append("AND ");
			sb.append(COL_ADJUST_STATUS + " = ? ");
		}
		if (finalIncomeTaxFrom != null && !finalIncomeTaxFrom.equals("")) {
			sb.append("AND ");
			sb.append(COL_FINAL_INCOME_TAX + " >= ? ");
		}
		if (finalIncomeTaxTo != null && !finalIncomeTaxTo.equals("")) {
			sb.append("AND ");
			sb.append(COL_FINAL_INCOME_TAX + " <= ? ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode + "%");
			setParam(index++, "%" + kName + "%");
			setParam(index++, "%" + kKana + "%");
			if (adjustYear != 0) {
				setParam(index++, adjustYear);
			}
			if (adjustStatus != null && !adjustStatus.equals("")) {
				setParam(index++, adjustStatus);
			}
			if (finalIncomeTaxFrom != null && !finalIncomeTaxFrom.equals("")) {
				setParam(index++, Integer.parseInt(finalIncomeTaxFrom));
			}
			if (finalIncomeTaxTo != null && !finalIncomeTaxTo.equals("")) {
				setParam(index++, Integer.parseInt(finalIncomeTaxTo));
			}
			executeQuery();
			List<CdAdjustmentDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * N擾
	 * @param adjustYear N(L[)
	 * @return N
	 * @throws SQLException 
	 */
	public List<Integer> findAdjustYear() throws SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT DISTINCT " + COL_ADJUST_YEAR + " ");
		sb.append("FROM " + TABLE + " ");
		sb.append("ORDER BY ");
		sb.append(COL_ADJUST_YEAR + " ");
		try {
			prepareStatement(sb.toString());
			executeQuery();
			List<Integer> list = new ArrayList<Integer>();
			while (rs.next()) {
				list.add(new Integer(rs.getInt(COL_ADJUST_YEAR)));
			}
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CdAdjustmentDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @param needLog Oo͗v
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CdAdjustmentDto dto, boolean needLog) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate(needLog);
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CdAdjustmentDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getAdjustYear());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(CdAdjustmentDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getAdjustYear());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Ñf[^폜
	 * @param adjustYear N
	 * @param startDate JnN
	 * @param lastDate IN
	 * @return@폜()
	 * @throws SQLException
	 * @throws MospException
	 * @throws IllegalAccessException
	 */
	public int deleteAdjustYear(int adjustYear, Date startDate, Date lastDate) throws SQLException,
			IllegalAccessException {
		try {
			MKihonPayrollDao mKihonPayrollDao = new MKihonPayrollDao();
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE ");
			sb.append("FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_ADJUST_YEAR + " ");
			sb.append("= ? ");
			sb.append(" AND ");
			sb.append(COL_K_CODE + " ");
			sb.append(" IN ");
			sb.append(" ( ");
			sb.append(mKihonPayrollDao.getDeleteAdjustData());
			sb.append(" ) ");
			prepareStatement(sb.toString());
			setParam(index++, adjustYear);
			setParam(index++, DateUtil.convDateToInteger(lastDate));
			setParam(index++, DateUtil.convDateToInteger(lastDate));
			setParam(index++, DateUtil.convDateToInteger(lastDate));
			setParam(index++, DateUtil.convDateToInteger(startDate));
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^폜
	 * @param kCode 폜ΏێЈR[h
	 * @return int 폜()
	 * @throws SQLException
	 */
	public int deleteForEmployee(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^SQL擾
	 * @return f[^擾SQL
	 * @throws IllegalAccessException 
	 */
	public String getTableForDate() throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append("(");
		sb.append(getSelectStatement(getClass()));
		sb.append("FROM ");
		sb.append(TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_ADJUST_YEAR + " = ? ");
		sb.append(") " + TABLE + " ");
		return sb.toString();
	}
	
	/**
	 * ɂf[^擾B<br>
	 * wNɂmς݃f[^𒊏oB<br>
	 * kCodenullɂƁAЈR[hɂwsȂB<br>
	 * 򒥎f[^o͎ɗpB
	 * @param adjustYear vZN
	 * @param kCode    ЈR[h
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CdAdjustmentDto> findForWithholdVote(int adjustYear, String kCode) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		if (kCode != null) {
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
		}
		sb.append(COL_ADJUST_YEAR + " = ? ");
		sb.append("AND ");
		sb.append(COL_ADJUST_STATUS + " IN ('" + PayrollConst.ADJU_STATUS_FIX + "','" + PayrollConst.ADJU_STATUS_OOT
				+ "')");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			if (kCode != null) {
				setParam(index++, kCode);
			}
			setParam(index++, adjustYear);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(CdAdjustmentDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode()); // ЈR[h
		setParam(index++, dto.getAdjustYear()); // N
		setParam(index++, dto.getAdjustStatus()); // NvZ
		setParam(index++, dto.getGeneralLifeIns()); // ʂ̐ی
		setParam(index++, dto.getPrivatePension()); // lNی
		setParam(index++, dto.getLifeInsDeduction()); // یTz
		setParam(index++, dto.getEarthquakeIns()); // nkی
		setParam(index++, dto.getLongTermDamageIns()); // Qی
		setParam(index++, dto.getDamageInsDeduction()); // QیTz
		setParam(index++, dto.getSocialInsDeduction()); // ЉیTz
		setParam(index++, dto.getMutualAidDeduction()); // K͊Ƌϓ|Tz
		setParam(index++, dto.getSpouseSumIncome()); // z҂̖{N̍vžϊz
		setParam(index++, dto.getSpouseSpDeduction()); // zғʍTz
		setParam(index++, dto.getHouseLoanDeduction()); // ZؓʍTz
		setParam(index++, dto.getAllowanceAdjustment()); // xz
		setParam(index++, dto.getTaxFreeAdjustment()); // ېŒz
		setParam(index++, dto.getSocInsAdjustment()); // Љیz
		setParam(index++, dto.getTaxIncAdjustment()); // Œz
		setParam(index++, dto.getWithholdSlipNotes()); // 򒥎[Ev
		setParam(index++, dto.getPaymentAllowance()); // ^A蓖z
		setParam(index++, dto.getPaymentIncomeTax()); // ^A蓖Ŋz
		setParam(index++, dto.getBonusAllowance()); // ܗ^z
		setParam(index++, dto.getBonusIncomeTax()); // ܗ^Ŋz
		setParam(index++, dto.getMidwayAdjustIncome()); // rAz
		setParam(index++, dto.getMidwayAdjustTax()); // rAŊz
		setParam(index++, dto.getAfterDeductIncome()); // ^T̋^̋z
		setParam(index++, dto.getPayInsDeduction()); // Љی^̍T
		setParam(index++, dto.getDependentsDeduction()); // zҍTzA}{TzAbTzyяQғ̍Tz̍vz
		setParam(index++, dto.getCalcTaxedIncome()); // ېŋ^z
		setParam(index++, dto.getCalcIncomeTax()); // ZoNŊz
		setParam(index++, dto.getAdjustedIncomeTax()); // NNŊz
		setParam(index++, dto.getDeductedIncomeTax()); // N藦TzŊz
		setParam(index++, dto.getFinalIncomeTax()); // NŊz
		setParam(index++, dto.getDeadRetirement()); // SސE
		setParam(index++, dto.getSelfDisaster()); // ЊQ
		setParam(index++, dto.getForeigner()); // Ol
		
		setCommonParams(isInsert);
	}
	
}
