/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.BonusConst;
import jp.mosp.payroll.bonus.dto.PsDetailDto;

public class PsDetailDao extends PayrollDao {
	
	// e[uyуL[
	public static final String	TABLE						= "US_DETAIL";
	public static final String	KEY_1						= "EMPLOYMENT_TYPE";
	public static final String	KEY_2						= "POSITION_CODE";
	public static final String	KEY_3						= "DETAIL_CODE";
	
	// 
	public static final String	COL_EMPLOYMENT_TYPE			= "EMPLOYMENT_TYPE";		// ٗp敪
	public static final String	COL_POSITION_CODE			= "POSITION_CODE";			// EʃR[h
	public static final String	COL_DETAIL_CODE				= "DETAIL_CODE";			// ׃R[h
	public static final String	COL_DETAIL_NAME				= "DETAIL_NAME";			// ז
	public static final String	COL_DETAIL_DISPLAY			= "DETAIL_DISPLAY";		// ו\@
	public static final String	COL_TAX_OBJECT_TYPE			= "TAX_OBJECT_TYPE";		// ېőΏۋ敪
	public static final String	COL_TAX_FREE_UPPER_LIMIT	= "TAX_FREE_UPPER_LIMIT";	// ېŏz
	public static final String	COL_SOC_INS_OBJECT_TYPE		= "SOC_INS_OBJECT_TYPE";	// ЉیΏۋ敪
																						
	
	/**
	 * RXgN^
	 */
	public PsDetailDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return PsDetailDto UhBasisR[h
	 * @throws SQLException
	 */
	private PsDetailDto mapping() throws SQLException {
		PsDetailDto dto = new PsDetailDto();
		dto.setEmploymentType(rs.getString(COL_EMPLOYMENT_TYPE)); // ٗp敪
		dto.setPositonCode(rs.getString(COL_POSITION_CODE)); // EʃR[h
		dto.setDetailCode(rs.getString(COL_DETAIL_CODE)); // ׃R[h
		dto.setDetailName(rs.getString(COL_DETAIL_NAME)); // ז
		dto.setDetailDisplay(rs.getString(COL_DETAIL_DISPLAY)); // ו\@
		dto.setTaxObjectType(rs.getString(COL_TAX_OBJECT_TYPE)); // ېőΏۋ敪
		dto.setTaxFreeUpperLimit(rs.getInt(COL_TAX_FREE_UPPER_LIMIT)); // ېŏz
		dto.setSocInsObjectType(rs.getString(COL_SOC_INS_OBJECT_TYPE)); // ЉیΏۋ敪
		
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<PsDetailDto> mappingAll() throws SQLException {
		List<PsDetailDto> all = new ArrayList<PsDetailDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTOMapMap)
	 * @return Map }bv
	 * @throws SQLException
	 */
	private Map<String, Map<String, PsDetailDto>> mappingAllMap() throws SQLException {
		Map<String, Map<String, PsDetailDto>> map = new HashMap<String, Map<String, PsDetailDto>>();
		Map<String, PsDetailDto> subMap = new HashMap<String, PsDetailDto>();
		String current = null;
		while (rs.next()) {
			// DTO擾
			PsDetailDto dto = mapping();
			// L[ݒ
			String key = dto.getEmploymentType() + BonusConst.KEY_SEPARATOR + dto.getPositionCode();
			// 񔻒
			if (current == null) {
				current = key;
			}
			// L[ςꍇ
			if (!key.equals(current)) {
				map.put(current, subMap);
				current = key;
				subMap = new HashMap<String, PsDetailDto>();
			}
			subMap.put(dto.getDetailCode(), dto);
		}
		if (current != null) {
			map.put(current, subMap);
		}
		return map;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PsDetailDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<PsDetailDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Sf[^擾
	 * @return Map (DTOMapMap)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public Map<String, Map<String, PsDetailDto>> findAllAsMap() throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAllMap();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ܗ^׃f[^擾
	 * @return Map (DTOMapMap)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public Map<String, Map<String, PsDetailDto>> findBonusAsMap() throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DETAIL_CODE + " like ? ");
			sb.append("AND ");
			sb.append(COL_DETAIL_CODE + " IS NOT NULL ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, BonusConst.BONUS_DETAIL + "%");
			executeQuery();
			return mappingAllMap();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param employmentType ٗp敪(L[)
	 * @param positionCode   EʃR[h(L[)
	 * @param detailCode     ׋敪(L[)
	 * @return PsDetailDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PsDetailDto findForKey(String employmentType, String positionCode, String detailCode) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, employmentType);
			setParam(index++, positionCode);
			setParam(index++, detailCode);
			executeQuery();
			PsDetailDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param employmentType   ٗp敪
	 * @param detailCode       ׋敪
	 * @param taxObjectType    ېőΏۋ敪
	 * @param SocInsObjectType ЉیΏۋ敪
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PsDetailDto> findForCondition(String employmentType, String positionCode, String detailCode,
			String taxObjectType, String socInsObjectType) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		if (!employmentType.equals("") || !positionCode.equals("") || !detailCode.equals("")
				|| !taxObjectType.equals("") || !socInsObjectType.equals("")) {
			sb.append(" WHERE ");
		}
		if (!employmentType.equals("")) {
			sb.append(COL_EMPLOYMENT_TYPE);
			sb.append(" = ?  ");
			if (!positionCode.equals("") || !detailCode.equals("") || !taxObjectType.equals("")
					|| !socInsObjectType.equals("")) {
				sb.append(" AND  ");
			}
		}
		if (!positionCode.equals("")) {
			sb.append(COL_POSITION_CODE);
			sb.append(" = ?  ");
			if (!detailCode.equals("") || !taxObjectType.equals("") || !socInsObjectType.equals("")) {
				sb.append(" AND  ");
			}
		}
		if (!detailCode.equals("")) {
			sb.append(COL_DETAIL_CODE);
			sb.append("  = ?  ");
			if (!taxObjectType.equals("") || !socInsObjectType.equals("")) {
				sb.append(" AND  ");
			}
		}
		if (!taxObjectType.equals("")) {
			sb.append(COL_TAX_OBJECT_TYPE);
			sb.append("  = ?  ");
			if (!socInsObjectType.equals("")) {
				sb.append(" AND  ");
			}
		}
		if (!socInsObjectType.equals("")) {
			sb.append(COL_SOC_INS_OBJECT_TYPE);
			sb.append("  = ?  ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			if (!employmentType.equals("")) {
				setParam(index++, employmentType);
			}
			if (!positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			if (!detailCode.equals("")) {
				setParam(index++, detailCode);
			}
			if (!taxObjectType.equals("")) {
				setParam(index++, taxObjectType);
			}
			if (!socInsObjectType.equals("")) {
				setParam(index++, socInsObjectType);
			}
			executeQuery();
			List<PsDetailDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ٗp敪ɂf[^擾
	 * @param employmentType ٗp敪(L[)
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PsDetailDto> findForEmployeeAll(String employmentType) throws SQLException, NoSuchFieldException,
			IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_EMPLOYMENT_TYPE + " = ? ");
			sb.append("AND ");
			sb.append(COL_DETAIL_CODE + " IS NOT NULL ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, employmentType);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param employmentType ٗp敪(L[)
	 * @param positionCode   EʃR[h(L[)
	 * @param detailCode     ׋敪(L[)
	 * @return PsDetailDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PsDetailDto findForUpdate(String employmentType, String positionCode, String detailCode)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, employmentType);
			setParam(index++, positionCode);
			setParam(index++, detailCode);
			executeQuery();
			PsDetailDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PsDetailDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(PsDetailDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getEmploymentType());
			setParam(index++, dto.getPositionCode());
			setParam(index++, dto.getDetailCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(PsDetailDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getEmploymentType());
			setParam(index++, dto.getPositionCode());
			setParam(index++, dto.getDetailCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(PsDetailDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getEmploymentType()); // ٗp敪
		setParam(index++, dto.getPositionCode()); // EʃR[h
		setParam(index++, dto.getDetailCode()); // ׃R[h
		setParam(index++, dto.getDetailName()); // ז
		setParam(index++, dto.getDetailDisplay()); // ו\@
		setParam(index++, dto.getTaxObjectType()); // ېőΏۋ敪
		setParam(index++, dto.getTaxFreeUpperLimit()); // ېŏz
		setParam(index++, dto.getSocInsObjectType()); // ЉیΏۋ敪
		
		setCommonParams(isInsert);
	}
}
