/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.mospcommon.system.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.mospcommon.system.dto.CmLaborAgreementDto;

/**
 * CM_LABOR_AGREEMENT(Jg}X^)DAONX B
 */
public class CmLaborAgreementDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * CM_LABOR_AGREEMENT(Jg}X^)B
	 */
	public static final String	TABLE				= "CM_LABOR_AGREEMENT";
	
	/**
	 * KEY_1 = AGREE_CODE(R[h)B
	 */
	public static final String	KEY_1				= "AGREE_CODE";
	
	/**
	 * KEY_2 = AGREE_TYPE()B
	 */
	public static final String	KEY_2				= "AGREE_TYPE";
	
	// 
	/**
	 * AGREE_CODE(R[h)B
	 */
	public static final String	COL_AGREE_CODE		= "AGREE_CODE";
	/**
	 * AGREE_NAME(薼)B
	 */
	public static final String	COL_AGREE_TYPE		= "AGREE_TYPE";
	/**
	 * OVER_TIME_CODE(ԊOR[h)B
	 */
	public static final String	COL_OVER_TIME_CODE	= "OVER_TIME_CODE";
	/**
	 * WORK_ON_CODE(xoR[h)B
	 */
	public static final String	COL_WORK_ON_CODE	= "WORK_ON_CODE";
	/**
	 * DELETE_FLAG(폜tO)B
	 */
	public static final String	COL_DELETE_FLAG		= "DELETE_FLAG";
	

	/**
	 * RXgN^B
	 */
	public CmLaborAgreementDao() {
		super();
		INSERT_DATE = "INSERT_DATE";
		INSERT_USER = "INSERT_USER";
		UPDATE_DATE = "UPDATE_DATE";
		UPDATE_USER = "UPDATE_USER";
	}
	
	/**
	 * ʎ擾(DTOList)B
	 * @return ʃXg
	 * @throws SQLException 	SQLOꍇ
	 */
	private List<CmLaborAgreementDto> mappingAll() throws SQLException {
		List<CmLaborAgreementDto> all = new ArrayList<CmLaborAgreementDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)B
	 * @return CM_LABOR_AGREEMENTR[h
	 * @throws SQLException 	SQLOꍇ
	 */
	private CmLaborAgreementDto mapping() throws SQLException {
		CmLaborAgreementDto dto = new CmLaborAgreementDto();
		dto.setAgreeCode(rs.getString(COL_AGREE_CODE));
		dto.setAgreeType(rs.getString(COL_AGREE_TYPE));
		dto.setOverTimeCode(rs.getString(COL_OVER_TIME_CODE));
		dto.setWorkOnCode(rs.getString(COL_WORK_ON_CODE));
		dto.setDeleteFlag(rs.getInt(COL_DELETE_FLAG));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾B
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmLaborAgreementDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾B
	 * @param agreeCode R[h
	 * @param agreeType 
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmLaborAgreementDto findForKey(String agreeCode, String agreeType) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, agreeCode);
			setParam(index++, agreeType);
			executeQuery();
			CmLaborAgreementDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾B
	 * @param agreeCode R[h
	 * @param agreeType 
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmLaborAgreementDto findForUpdate(String agreeCode, String agreeType) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, agreeCode);
			setParam(index++, agreeType);
			executeQuery();
			CmLaborAgreementDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param agreeCode R[h
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmLaborAgreementDto> findForCondition(String agreeCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_AGREE_CODE);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, agreeCode);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param agreeCode R[h
	 * @param agreeType 
	 * @param deleteFlag 폜tO
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<CmLaborAgreementDto> findForCondition(String agreeCode, String agreeType, String deleteFlag)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_AGREE_CODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_AGREE_TYPE);
		sb.append(" = ? ");
		if (!deleteFlag.equals("")) {
			sb.append("AND ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ? ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, agreeCode + "%");
			setParam(index++, agreeType);
			if (!deleteFlag.equals("")) {
				setParam(index++, Integer.parseInt(deleteFlag));
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param agreeCode ΏۃR[h
	 * @param agreeType Ώۋ
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public CmLaborAgreementDto findForAgreeType(String agreeCode, String agreeType) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = " + MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_AGREE_CODE);
			sb.append(" = ? ");
			sb.append(" AND ");
			sb.append(COL_AGREE_TYPE);
			sb.append(" = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, agreeCode);
			setParam(index++, agreeType);
			executeQuery();
			CmLaborAgreementDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}B
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(CmLaborAgreementDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XVB
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(CmLaborAgreementDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getAgreeCode());
			setParam(index++, dto.getAgreeType());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜B
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(CmLaborAgreementDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getAgreeCode());
			setParam(index++, dto.getAgreeType());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒB
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseF})
	 * @throws SQLException 	SQLOꍇ
	 */
	private void setParams(CmLaborAgreementDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getAgreeCode());
		setParam(index++, dto.getAgreeType());
		setParam(index++, dto.getOverTimeCode());
		setParam(index++, dto.getWorkOnCode());
		setParam(index++, dto.getDeleteFlag());
		setCommonParams(isInsert);
	}
	
}
