/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.kintai.workflow.dto.KintaiAppicationDto;

/**
 * @author yoshida
 *
 */
public class ManagerApprovalListVo extends MosPVo {
	
	private static final long	serialVersionUID	= -8091981681214432086L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF			= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON			= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_PLT_SECTION		= "pltSection";
	/**
	 * 
	 */
	public static final String	PRM_PLT_APPLICATION	= "pltApplication";
	/**
	 * 
	 */
	public static final String	PRM_PLT_STATUS		= "pltStatus";
	/**
	 * 
	 */
	public static final String	PRM_TXT_K_CODE		= "txtKCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_K_NAME		= "txtKName";
	/**
	 * 
	 */
	public static final String	PRM_PLT_YEAR		= "pltYear";
	/**
	 * 
	 */
	public static final String	PRM_PLT_MONTH		= "pltMonth";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DAY			= "pltDay";
	/**
	 * 
	 */
	public static final String	PRM_CKB_APPROVAL	= "ckbApproval";
	
	// tB[h	
	private String[][]			aryApplication;
	private String				pltSection;
	private String				pltApplication;
	private String				pltStatus;
	private String				txtKCode;
	private String				txtKName;
	private String				pltYear;
	private String				pltMonth;
	private String				pltDay;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_SECTION;
	/**
	 * 
	 */
	public String				NAM_APPLICATION;
	/**
	 * 
	 */
	public String				NAM_STATUS;
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_DATE;
	/**
	 * 
	 */
	public String				NAM_REMARKS;
	/**
	 * 
	 */
	public String				NAM_APPROVED;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltSection;
	/**
	 * 
	 */
	public String[][]			aryPltApplication;
	/**
	 * 
	 */
	public String[][]			aryPltStatus;
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	/**
	 * 
	 */
	public String[][]			aryPltDay;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_K_CODE			= "keyKCode";
	/**
	 * 
	 */
	public final String			KEY_K_NAME			= "keyKName";
	/**
	 * 
	 */
	public final String			KEY_SECTION			= "keySection";
	/**
	 * 
	 */
	public final String			KEY_DATE			= "keyDate";
	/**
	 * 
	 */
	public final String			KEY_APPLICATION		= "keyApplication";
	/**
	 * 
	 */
	public final String			KEY_STATUS			= "keyStatus";
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * RXgN^
	 */
	public ManagerApprovalListVo() {
		super();
		setViewPath(getClassName());
		aryApplication = new String[0][0];
		pltSection = "";
		pltApplication = "";
		pltStatus = "";
		txtKCode = "";
		txtKName = "";
		pltYear = "";
		pltMonth = "";
		pltDay = "";
		setFormerKey(KEY_K_CODE);
	}
	
	@Override
	public void setSubTitle() {
		subTitle = CommonConst.TTL_EMPLOYEE_KINTAI_APPLICATION;
		aryMenu = new String[][]{ { CMD_MENU_MAMAGE, CommonConst.NAM_TO_MENU }, MosPMenuConst.getMenuManagerApproval(), };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_SECTION = CommonConst.NAM_STATION;
		NAM_APPLICATION = CommonConst.NAM_APPLICATION + CommonConst.NAM_CATEGORY;
		NAM_STATUS = CommonConst.NAM_APPROVAL_STATE;
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_DATE = CommonConst.NAM_DATE;
		NAM_REMARKS = CommonConst.NAM_REMARKS;
		NAM_APPROVED = CommonConst.NAM_APPROVED;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltSection = request.getParameter(PRM_PLT_SECTION);
		pltApplication = request.getParameter(PRM_PLT_APPLICATION);
		pltStatus = request.getParameter(PRM_PLT_STATUS);
		txtKCode = request.getParameter(PRM_TXT_K_CODE);
		txtKName = request.getParameter(PRM_TXT_K_NAME);
		pltYear = request.getParameter(PRM_PLT_YEAR);
		pltMonth = request.getParameter(PRM_PLT_MONTH);
		pltDay = request.getParameter(PRM_PLT_DAY);
	}
	
	@Override
	public void setFields(List<?> listApplication) {
		// Xg̐ݒ
		list = listApplication;
		// f[^̎擾
		count = listApplication.size();
		// z̏
		aryApplication = new String[count][10];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listApplication.iterator();
		while (it.hasNext()) {
			KintaiAppicationDto dto = (KintaiAppicationDto)it.next();
			// IR}h
			aryApplication[i][0] = escapeHTML(dto.getCmd());
			// IL[
			aryApplication[i][1] = escapeHTML(dto.getKey());
			// ЈR[h
			aryApplication[i][2] = escapeHTML(dto.getKCode());
			// Ј
			aryApplication[i][3] = escapeHTML(dto.getSimei());
			// 
			aryApplication[i][4] = escapeHTML(dto.getSName());
			// t
			aryApplication[i][5] = escapeHTML(DateUtil.convDateToFormatDateJP(dto.getDate()));
			// \
			aryApplication[i][6] = escapeHTML(dto.getApprication());
			// F
			aryApplication[i][7] = escapeHTML(dto.getStatus());
			// l
			aryApplication[i][8] = escapeHTML(dto.getRemarks());
			// `FbN{bNX
			aryApplication[i][9] = escapeHTML(dto.getCkbValue());
			i++;
		}
	}
	
	// ANZT\bh
	/**
	 * @return txtKCode
	 */
	public String getEscTxtKCode() {
		return escapeHTML(txtKCode);
	}
	
	/**
	 * @return txtKName
	 */
	public String getEscTxtKName() {
		return escapeHTML(txtKName);
	}
	
	/**
	 * @return aryApplication
	 */
	public String[][] getEscAryApplication() {
		return aryApplication.clone();
	}
	
	/**
	 * @return pltSection
	 */
	public String getPltSection() {
		return pltSection;
	}
	
	/**
	 * @return pltApplication
	 */
	public String getPltApplication() {
		return pltApplication;
	}
	
	/**
	 * @return pltStatus
	 */
	public String getPltStatus() {
		return pltStatus;
	}
	
	/**
	 * @return txtKCode
	 */
	public String getTxtKCode() {
		return txtKCode;
	}
	
	/**
	 * @return txtKName
	 */
	public String getTxtKName() {
		return txtKName;
	}
	
	/**
	 * @return pltYear
	 */
	public String getPltYear() {
		return pltYear;
	}
	
	/**
	 * @return pltMonth
	 */
	public String getPltMonth() {
		return pltMonth;
	}
	
	/**
	 * @return pltDay
	 */
	public String getPltDay() {
		return pltDay;
	}
	
	/**
	 * @return searchmode
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @param pltSection Zbg pltSection
	 */
	public void setPltSection(String pltSection) {
		this.pltSection = pltSection;
	}
	
	/**
	 * @param pltApplication Zbg pltApplication
	 */
	public void setPltApplication(String pltApplication) {
		this.pltApplication = pltApplication;
	}
	
	/**
	 * @param pltStatus Zbg pltStatus
	 */
	public void setPltStatus(String pltStatus) {
		this.pltStatus = pltStatus;
	}
	
	/**
	 * @param txtKCode Zbg txtKCode
	 */
	public void setTxtKCode(String txtKCode) {
		this.txtKCode = txtKCode;
	}
	
	/**
	 * @param txtKName Zbg txtKName
	 */
	public void setTxtKName(String txtKName) {
		this.txtKName = txtKName;
	}
	
	/**
	 * @param pltYear Zbg pltYear
	 */
	public void setPltYear(String pltYear) {
		this.pltYear = pltYear;
	}
	
	/**
	 * @param pltMonth Zbg pltMonth
	 */
	public void setPltMonth(String pltMonth) {
		this.pltMonth = pltMonth;
	}
	
	/**
	 * @param pltDay Zbg pltDay
	 */
	public void setPltDay(String pltDay) {
		this.pltDay = pltDay;
	}
	
	/**
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
}
