/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

/**
 * KT_HOLIDAY_REQUEST(xɐ\e[u)DTONXB
 */
public class KtHolidayRequestDto extends BaseDto {
	
	private static final long	serialVersionUID	= -176133596945053676L;
	
	// tB[h
	private int					voucher				= 0;
	private long				workflow			= 0;
	private String				kcode				= "";
	private Date				holidaydate			= null;
	private int					starttime			= 0;
	private int					endtime				= 0;
	private String				reason				= "";
	private String				holidaytype			= "";
	private String				occurdate1			= "";
	private int					usetime1			= 0;
	private String				occurdate2			= "";
	private int					usetime2			= 0;
	private String				substitutedate		= "";
	private String				causecomment		= "";
	private int					deleteflag			= 0;
	

	/**
	 * RXgN^B
	 */
	public KtHolidayRequestDto() {
		super();
	}
	
	// ANZT\bh
	/**
	 * @return voucher 	xɐ\`[ԍB
	 */
	public int getVoucher() {
		return voucher;
	}
	
	/**
	 * @return workflow 	[Nt[ԍB
	 */
	public long getWorkflow() {
		return workflow;
	}
	
	/**
	 * @return kcode 	ЈR[hB
	 */
	public String getKCode() {
		return kcode;
	}
	
	/**
	 * @return holidaydate 	xɓB
	 */
	public Date getHolidayDate() {
		return (Date)holidaydate.clone();
	}
	
	/**
	 * @return starttime 	xɊJnԁB
	 */
	public int getStartTime() {
		return starttime;
	}
	
	/**
	 * @return endtime 	xɏIԁB
	 */
	public int getEndTime() {
		return endtime;
	}
	
	/**
	 * @return reason 	xɗRB
	 */
	public String getReason() {
		return reason;
	}
	
	/**
	 * @return holidaytype 	L敪B
	 */
	public String getHolidayType() {
		return holidaytype;
	}
	
	/**
	 * @return occurdate1 	N1B
	 */
	public String getOccurDate1() {
		return occurdate1;
	}
	
	/**
	 * @return usetime1 	p1B
	 */
	public int getUseTime1() {
		return usetime1;
	}
	
	/**
	 * @return occurdate2 	N2B
	 */
	public String getOccurDate2() {
		return occurdate2;
	}
	
	/**
	 * @return usetime2 	p2B
	 */
	public int getUseTime2() {
		return usetime2;
	}
	
	/**
	 * @return substitutedate 	[B
	 */
	public String getSubstituteDate() {
		return substitutedate;
	}
	
	/**
	 * @return causecomment 	RB
	 */
	public String getCauseComment() {
		return causecomment;
	}
	
	/**
	 * @return deleteflag 	폜tOB
	 */
	public int getDeleteFlag() {
		return deleteflag;
	}
	
	/**
	 * @param voucher 	Zbgxɐ\`[ԍB
	 */
	public void setVoucher(int voucher) {
		this.voucher = voucher;
	}
	
	/**
	 * @param workflow 	Zbg郏[Nt[ԍB
	 */
	public void setWorkflow(long workflow) {
		this.workflow = workflow;
	}
	
	/**
	 * @param kcode 	ZbgЈR[hB
	 */
	public void setKCode(String kcode) {
		this.kcode = kcode;
	}
	
	/**
	 * @param holidaydate 	ZbgxɓB
	 */
	public void setHolidayDate(Date holidaydate) {
		this.holidaydate = (Date)holidaydate.clone();
	}
	
	/**
	 * @param starttime 	ZbgxɊJnԁB
	 */
	public void setStartTime(int starttime) {
		this.starttime = starttime;
	}
	
	/**
	 * @param endtime 	ZbgxɏIԁB
	 */
	public void setEndTime(int endtime) {
		this.endtime = endtime;
	}
	
	/**
	 * @param reason 	ZbgxɗRB
	 */
	public void setReason(String reason) {
		this.reason = reason;
	}
	
	/**
	 * @param holidaytype 	ZbgL敪B
	 */
	public void setHolidayType(String holidaytype) {
		this.holidaytype = holidaytype;
	}
	
	/**
	 * @param occurdate1 	Zbg锭N1B
	 */
	public void setOccurDate1(String occurdate1) {
		this.occurdate1 = occurdate1;
	}
	
	/**
	 * @param usetime1 	Zbg闘p1B
	 */
	public void setUseTime1(int usetime1) {
		this.usetime1 = usetime1;
	}
	
	/**
	 * @param occurdate2 	Zbg锭N2B
	 */
	public void setOccurDate2(String occurdate2) {
		this.occurdate2 = occurdate2;
	}
	
	/**
	 * @param usetime2 	Zbg闘p2B
	 */
	public void setUseTime2(int usetime2) {
		this.usetime2 = usetime2;
	}
	
	/**
	 * @param substitutedate 	Zbg[B
	 */
	public void setSubstituteDate(String substitutedate) {
		this.substitutedate = substitutedate;
	}
	
	/**
	 * @param causecomment 	Zbg鎖RB
	 */
	public void setCauseComment(String causecomment) {
		this.causecomment = causecomment;
	}
	
	/**
	 * @param deleteflag 	Zbg폜tOB
	 */
	public void setDeleteFlag(int deleteflag) {
		this.deleteflag = deleteflag;
	}
	
}
