/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.dao.CtWorkflowDao;
import jp.mosp.kintai.workflow.dto.KtHolidayRequestDto;

/**
 * KT_HOLIDAY_REQUEST(xɐ\e[u)DAONX B
 */
public class KtHolidayRequestDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * KT_HOLIDAY_REQUEST(xɐ\e[u)B
	 */
	public static final String	TABLE				= "KT_HOLIDAY_REQUEST";
	
	/**
	 * KEY_1 = VOUCHER(xɐ\`[ԍ)B
	 */
	public static final String	KEY_1				= "VOUCHER";
	
	// 
	/**
	 * VOUCHER(xɐ\`[ԍ)B
	 */
	public static final String	COL_VOUCHER			= "VOUCHER";
	/**
	 * WORKFLOW([Nt[ԍ)B
	 */
	public static final String	COL_WORKFLOW		= "WORKFLOW";
	/**
	 * K_CODE(ЈR[h)B
	 */
	public static final String	COL_K_CODE			= "K_CODE";
	/**
	 * HOLIDAY_DATE(xɓ)B
	 */
	public static final String	COL_HOLIDAY_DATE	= "HOLIDAY_DATE";
	/**
	 * START_TIME(xɊJn)B
	 */
	public static final String	COL_START_TIME		= "START_TIME";
	/**
	 * END_TIME(xɏI)B
	 */
	public static final String	COL_END_TIME		= "END_TIME";
	/**
	 * REASON(xɗR)B
	 */
	public static final String	COL_REASON			= "REASON";
	/**
	 * HOLIDAY_TYPE(L敪)B
	 */
	public static final String	COL_HOLIDAY_TYPE	= "HOLIDAY_TYPE";
	/**
	 * OCCUR_DATE_1(N1)B
	 */
	public static final String	COL_OCCUR_DATE_1	= "OCCUR_DATE_1";
	/**
	 * USE_HOUR_1(p1)B
	 */
	public static final String	COL_USE_TIME_1		= "USE_TIME_1";
	/**
	 * OCCUR_DATE_2(N2)B
	 */
	public static final String	COL_OCCUR_DATE_2	= "OCCUR_DATE_2";
	/**
	 * USE_HOUR_2(p2)B
	 */
	public static final String	COL_USE_TIME_2		= "USE_TIME_2";
	/**
	 * SUBSTITUTE_DATE([)B
	 */
	public static final String	COL_SUBSTITUTE_DATE	= "SUBSTITUTE_DATE";
	/**
	 * CAUSE_COMMENT(R)B
	 */
	public static final String	COL_CAUSE_COMMENT	= "CAUSE_COMMENT";
	/**
	 * DELETE_FLAG(폜tO)B
	 */
	public static final String	COL_DELETE_FLAG		= "DELETE_FLAG";
	

	/**
	 * RXgN^B
	 */
	public KtHolidayRequestDao() {
		super();
		INSERT_DATE = "INSERT_DATE";
		INSERT_USER = "INSERT_USER";
		UPDATE_DATE = "UPDATE_DATE";
		UPDATE_USER = "UPDATE_USER";
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<KtHolidayRequestDto> mappingAll() throws SQLException {
		List<KtHolidayRequestDto> all = new ArrayList<KtHolidayRequestDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CtHolidayRequestDto CT_HOLIDAY_REQUESTR[h
	 * @throws SQLException SQLOꍇ
	 */
	private KtHolidayRequestDto mapping() throws SQLException {
		KtHolidayRequestDto dto = new KtHolidayRequestDto();
		dto.setVoucher(rs.getInt(COL_VOUCHER));
		dto.setWorkflow(rs.getLong(COL_WORKFLOW));
		dto.setKCode(rs.getString(COL_K_CODE));
		dto.setHolidayDate(rs.getDate(COL_HOLIDAY_DATE));
		dto.setStartTime(rs.getInt(COL_START_TIME));
		dto.setEndTime(rs.getInt(COL_END_TIME));
		dto.setReason(rs.getString(COL_REASON));
		dto.setHolidayType(rs.getString(COL_HOLIDAY_TYPE));
		dto.setOccurDate1(rs.getString(COL_OCCUR_DATE_1));
		dto.setUseTime1(rs.getInt(COL_USE_TIME_1));
		dto.setOccurDate2(rs.getString(COL_OCCUR_DATE_2));
		dto.setUseTime2(rs.getInt(COL_USE_TIME_2));
		dto.setSubstituteDate(rs.getString(COL_SUBSTITUTE_DATE));
		dto.setCauseComment(rs.getString(COL_CAUSE_COMMENT));
		dto.setDeleteFlag(rs.getInt(COL_DELETE_FLAG));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<KtHolidayRequestDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param voucher xɐ\`[ԍ
	 * @return CtHolidayRequestDto (DTO)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public KtHolidayRequestDto findForKey(int voucher) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, voucher);
			executeQuery();
			KtHolidayRequestDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param voucher xɐ\`[ԍ
	 * @return CtHolidayRequestDto (DTO)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public KtHolidayRequestDto findForUpdate(int voucher) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, voucher);
			executeQuery();
			KtHolidayRequestDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param voucher xɐ\`[ԍ
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<KtHolidayRequestDto> findForCondition(int voucher) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_VOUCHER);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, voucher);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode ΏێЈR[h
	 * @param startDate ΏۊJnN
	 * @param endDate ΏۏIN
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<KtHolidayRequestDto> findForCondition(String kCode, Date startDate, Date endDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_K_CODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_HOLIDAY_DATE);
		sb.append(" >= ? ");
		sb.append(" AND ");
		sb.append(COL_HOLIDAY_DATE);
		sb.append(" <= ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, startDate);
			setParam(index++, endDate);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode ΏێЈR[h
	 * @param startDate ΏۊJnN
	 * @param endDate ΏۏIN
	 * @param layer FKw
	 * @param status F
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<KtHolidayRequestDto> findForCondition(String kCode, Date startDate, Date endDate, int layer,
			String status) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_K_CODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_HOLIDAY_DATE);
		sb.append(" >= ? ");
		sb.append(" AND ");
		sb.append(COL_HOLIDAY_DATE);
		sb.append(" <= ? ");
		if (status.length() != 0) {
			sb.append(" AND ");
			sb.append(COL_WORKFLOW);
			sb.append(" IN (");
			sb.append(CtWorkflowDao.getSubQueryWorkflowStatus());
			sb.append(") ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, startDate);
			setParam(index++, endDate);
			if (status.length() != 0) {
				setParam(index++, layer);
				setParam(index++, status);
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode ΏێЈR[h
	 * @param reason xɗR
	 * @param startDate ΏۊJnN
	 * @param endDate ΏۏIN
	 * @param layer FKw
	 * @param status F
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<KtHolidayRequestDto> findForCondition(String kCode, String reason, Date startDate, Date endDate,
			int layer, String status) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_K_CODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_REASON);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_HOLIDAY_DATE);
		sb.append(" >= ? ");
		sb.append(" AND ");
		sb.append(COL_HOLIDAY_DATE);
		sb.append(" <= ? ");
		if (status.length() != 0) {
			sb.append(" AND ");
			sb.append(COL_WORKFLOW);
			sb.append(" IN (");
			sb.append(CtWorkflowDao.getSubQueryWorkflowStatus());
			sb.append(") ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, reason);
			setParam(index++, startDate);
			setParam(index++, endDate);
			if (status.length() != 0) {
				setParam(index++, layer);
				setParam(index++, status);
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode ΏێЈR[h
	 * @param targetDate Ώ۔N
	 * @param reason ΏۋxɗR
	 * @param holidayType ΏۋxɎރR[h
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<KtHolidayRequestDto> findForCondition(String kCode, String reason, String holidayType, Date targetDate)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_K_CODE);
		sb.append(" = ? ");
		if (reason.length() != 0) {
			sb.append(" AND ");
			sb.append(COL_REASON);
			sb.append(" = ? ");
		}
		if (holidayType.length() != 0) {
			sb.append(" AND ");
			sb.append(COL_HOLIDAY_TYPE);
			sb.append(" = ? ");
		}
		sb.append(" AND ");
		sb.append(COL_HOLIDAY_DATE);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			if (reason.length() != 0) {
				setParam(index++, reason);
			}
			if (holidayType.length() != 0) {
				setParam(index++, holidayType);
			}
			setParam(index++, targetDate);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode ΏێЈR[h
	 * @param startDate ΏۊJnN
	 * @param endDate ΏۏIN
	 * @param reason ΏۋxɗR
	 * @param holidayType ΏۋxɎރR[h
	 * @param layer FKw
	 * @param status F
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<KtHolidayRequestDto> findForCondition(String kCode, Date startDate, Date endDate, String reason,
			String holidayType, int layer, String status) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_K_CODE);
		sb.append(" = ? ");
		if (reason.length() != 0) {
			sb.append(" AND ");
			sb.append(COL_REASON);
			sb.append(" = ? ");
		}
		if (holidayType.length() != 0) {
			sb.append(" AND ");
			sb.append(COL_HOLIDAY_TYPE);
			sb.append(" = ? ");
		}
		sb.append(" AND ");
		sb.append(COL_HOLIDAY_DATE);
		sb.append(" >= ? ");
		sb.append(" AND ");
		sb.append(COL_HOLIDAY_DATE);
		sb.append(" <= ? ");
		if (status.length() != 0) {
			sb.append(" AND ");
			sb.append(COL_WORKFLOW);
			sb.append(" IN (");
			sb.append(CtWorkflowDao.getSubQueryWorkflowStatus());
			sb.append(") ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			if (reason.length() != 0) {
				setParam(index++, reason);
			}
			if (holidayType.length() != 0) {
				setParam(index++, holidayType);
			}
			setParam(index++, startDate);
			setParam(index++, endDate);
			if (status.length() != 0) {
				setParam(index++, layer);
				setParam(index++, status);
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode ΏێЈR[h
	 * @param holidaydate Ώ۔N
	 * @return CtHolidayRequestDto (DTO)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public KtHolidayRequestDto findForHolidayDate(String kCode, Date holidaydate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = " + MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_K_CODE);
			sb.append(" = ? ");
			sb.append(" AND ");
			sb.append(COL_HOLIDAY_DATE);
			sb.append(" = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, holidaydate);
			executeQuery();
			KtHolidayRequestDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode ΏێЈR[h
	 * @param reason xɗR
	 * @param yearMonth 擾N
	 * @param layer FKw
	 * @param status F
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<KtHolidayRequestDto> findForOccur(String kCode, String reason, String yearMonth, int layer,
			String status) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_K_CODE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_REASON);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append("(");
		sb.append(COL_OCCUR_DATE_1);
		sb.append(" = ?");
		sb.append(" OR ");
		sb.append(COL_OCCUR_DATE_2);
		sb.append(" = ?");
		sb.append(")");
		if (status.length() != 0) {
			sb.append(" AND ");
			sb.append(COL_WORKFLOW);
			sb.append(" IN (");
			sb.append(CtWorkflowDao.getSubQueryWorkflowStatus());
			sb.append(") ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, reason);
			setParam(index++, yearMonth);
			setParam(index++, yearMonth);
			if (status.length() != 0) {
				setParam(index++, layer);
				setParam(index++, status);
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * maxl擾
	 * @return String@őA
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public String findForMax() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			String maxVaoucher = "";
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT MAX(");
			sb.append(COL_VOUCHER);
			sb.append(") FROM ");
			sb.append(TABLE);
			prepareStatement(sb.toString());
			executeQuery();
			if (rs.next()) {
				maxVaoucher = String.valueOf(rs.getInt(1));
			}
			return maxVaoucher;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException  	MosPOꍇ
	 */
	public int insert(KtHolidayRequestDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException  	MosPOꍇ
	 */
	public int update(KtHolidayRequestDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getVoucher());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException  	MosPOꍇ
	 */
	public int delete(KtHolidayRequestDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getVoucher());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(KtHolidayRequestDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getVoucher());
		setParam(index++, dto.getWorkflow());
		setParam(index++, dto.getKCode());
		setParam(index++, dto.getHolidayDate());
		setParam(index++, dto.getStartTime());
		setParam(index++, dto.getEndTime());
		setParam(index++, dto.getReason());
		setParam(index++, dto.getHolidayType());
		setParam(index++, dto.getOccurDate1());
		setParam(index++, dto.getUseTime1());
		setParam(index++, dto.getOccurDate2());
		setParam(index++, dto.getUseTime2());
		setParam(index++, dto.getSubstituteDate());
		setParam(index++, dto.getCauseComment());
		setParam(index++, dto.getDeleteFlag());
		setCommonParams(isInsert);
	}
	
}
