/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.HumanBasisDtoInterface;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.workflow.vo.EmployeeApprovalListVo;

/**
 * @author yoshida
 *
 */
public class EmployeeApprovalListAction extends MosPWorkflowAction {
	
	// R}h
	private static final String	CMD_APPROVAL_LIST_SHOW		= "K2110";
	private static final String	CMD_APPROVAL_LIST_RE_SEARCH	= "K2112";
	private static final String	CMD_APPROVAL_LIST_SORT		= "K2113";
	

	/**
	 * RXgN^
	 */
	public EmployeeApprovalListAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_APPROVAL_LIST_SHOW)) {
			// 
			search();
		} else if (cmd.equals(CMD_APPROVAL_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_APPROVAL_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new EmployeeApprovalListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// MANAGERmF
		confirmManagerAuth();
		EmployeeApprovalListVo vo = (EmployeeApprovalListVo)getVo();
		// [U[擾
		getInfo(user.getUserId());
		// v_E擾
		vo.arySectionAll = getSectionArrayAll();
		vo.aryPositionAll = getPositionArray();
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(getCalcMonth()));
		vo.aryPltMonth = StringUtil.getMonthArray();
		// Ώ۔N擾
		vo.setParams(request);
		if (StringUtil.isNull(vo.getPltSelectYear())) {
			vo.setPltSelectYear(String.valueOf(MospUtility.getYear(getCalcMonth())));
			vo.setPltSelectMonth(String.valueOf(MospUtility.getMonth(getCalcMonth())));
		}
		// l{ݒ
		setLabelBasisInfo(userBasis);
	}
	
	@Override
	protected void search() throws Exception {
		EmployeeApprovalListVo vo = (EmployeeApprovalListVo)getVo();
		serachEmployeeList();
		vo.setFormerKey(vo.KEY_K_CODE);
		vo.setIsAscending(true);
		vo.initListInfo();
		sortList();
	}
	
	@Override
	protected void research() throws Exception {
		EmployeeApprovalListVo vo = (EmployeeApprovalListVo)getVo();
		serachEmployeeList();
		vo.setPageButton();
		sortList();
	}
	
	/**
	 * ЈXg
	 * @throws Exception	Oꍇ
	 */
	private void serachEmployeeList() throws Exception {
		EmployeeApprovalListVo vo = (EmployeeApprovalListVo)getVo();
		// VOݒ
		vo.setFields(getApprovalEmployeeList(DateUtil
			.getFirstDateOfMonth(vo.getPltSelectYear(), vo.getPltSelectMonth())));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryKCode().length == 0) {
			addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		EmployeeApprovalListVo vo = (EmployeeApprovalListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_K_CODE)) {
			comp = new CompKCode();
		} else if (key.equals(vo.KEY_K_NAME)) {
			comp = new CompKName();
		} else if (key.equals(vo.KEY_SECTION)) {
			comp = new CompSection();
		} else if (key.equals(vo.KEY_POSITION)) {
			comp = new CompPosition();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * ЈR[hɂrNX
	 */
	protected static class CompKCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 1321988381196408314L;
		

		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getKCode().compareTo(dto2.getKCode());
		}
	}
	
	/**
	 * ЈɂrNX
	 */
	protected static class CompKName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -2913545521784316945L;
		

		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getSimei().compareTo(dto2.getSimei());
		}
	}
	
	/**
	 * ɂrNX
	 */
	protected static class CompSection implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 3158913862750258976L;
		

		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			return dto1.getSCode().compareTo(dto2.getSCode());
		}
	}
	
	/**
	 * EʂɂrNX
	 */
	protected static class CompPosition implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 3947836481650506034L;
		

		public int compare(Object obj1, Object obj2) {
			HumanBasisDtoInterface dto1 = (HumanBasisDtoInterface)obj1;
			HumanBasisDtoInterface dto2 = (HumanBasisDtoInterface)obj2;
			//EꍇAŔr
			if (dto1.getYCode().equals(dto2.getYCode())) {
				return dto1.getTokyu().compareTo(dto2.getTokyu());
			} else {
				return dto1.getYCode().compareTo(dto2.getYCode());
			}
		}
	}
	
}
