/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.kintai.workflow.dto.AmUnitDto;
import jp.mosp.kintai.workflow.vo.ApprovalUnitListVo;

/**
 * @author yoshida
 *
 */
public class ApprovalUnitListAction extends MosPWorkflowAction {
	
	// R}h
	private static final String	CMD_UNIT_LIST_SHOW		= "S2810";
	private static final String	CMD_UNIT_LIST_SEARCH	= "S2811";
	private static final String	CMD_UNIT_LIST_RE_SEARCH	= "S2812";
	private static final String	CMD_UNIT_LIST_SORT		= "S2813";
	

	/**
	 * RXgN^
	 */
	public ApprovalUnitListAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_UNIT_LIST_SHOW)) {
			show();
		} else if (cmd.equals(CMD_UNIT_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_UNIT_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_UNIT_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ApprovalUnitListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		ApprovalUnitListVo vo = (ApprovalUnitListVo)getVo();
		// l{擾
		vo.aryPltUser = part().human().getBasisArrayAll();
	}
	
	@Override
	protected void show() throws Exception {
		ApprovalUnitListVo vo = (ApprovalUnitListVo)getVo();
		// lɃZbg
		vo.setSearchmode(ApprovalUnitListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		ApprovalUnitListVo vo = (ApprovalUnitListVo)getVo();
		vo.setParams(request);
		searchUnitList();
		vo.setFormerKey(vo.KEY_UNIT_CODE);
		vo.setIsAscending(true);
		vo.initListInfo();
	}
	
	@Override
	protected void research() throws Exception {
		ApprovalUnitListVo vo = (ApprovalUnitListVo)getVo();
		if (vo.getSearchmode() == ApprovalUnitListVo.SEARCH_ON) {
			removeSessionDto();
			searchUnitList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * jbgXg
	 * @throws Exception 	Oꍇ
	 */
	private void searchUnitList() throws Exception {
		ApprovalUnitListVo vo = (ApprovalUnitListVo)getVo();
		// 
		vo.setFields(unitDao().findForCondition(vo.getTxtUnitCode(), vo.getTxtKCode(), vo.getTxtKName()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryUnit().length == 0) {
			addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
		// [hݒ
		vo.setSearchmode(ApprovalUnitListVo.SEARCH_ON);
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		ApprovalUnitListVo vo = (ApprovalUnitListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_UNIT_CODE)) {
			comp = new CompUnitCode();
		} else if (key.equals(vo.KEY_MAIN)) {
			comp = new CompMain();
		} else if (key.equals(vo.KEY_AGENT)) {
			comp = new CompAgent();
		} else if (key.equals(vo.KEY_START_DATE)) {
			comp = new CompStartDate();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * jbgR[hɂrNX
	 */
	protected static class CompUnitCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 8882101817659803340L;
		

		public int compare(Object obj1, Object obj2) {
			AmUnitDto dto1 = (AmUnitDto)obj1;
			AmUnitDto dto2 = (AmUnitDto)obj2;
			return dto1.getUnitCode().compareTo(dto2.getUnitCode());
		}
	}
	
	/**
	 * F҂ɂrNX
	 */
	protected static class CompMain implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -1958254792298208211L;
		

		public int compare(Object obj1, Object obj2) {
			AmUnitDto dto1 = (AmUnitDto)obj1;
			AmUnitDto dto2 = (AmUnitDto)obj2;
			return dto1.getMain().compareTo(dto2.getMain());
		}
	}
	
	/**
	 * 㗝ɂrNX
	 */
	protected static class CompAgent implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 1656557705586257941L;
		

		public int compare(Object obj1, Object obj2) {
			AmUnitDto dto1 = (AmUnitDto)obj1;
			AmUnitDto dto2 = (AmUnitDto)obj2;
			return dto1.getAgent().compareTo(dto2.getAgent());
		}
	}
	
	/**
	 * JnɂrNX
	 */
	protected static class CompStartDate implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 3154045096780718675L;
		

		public int compare(Object obj1, Object obj2) {
			AmUnitDto dto1 = (AmUnitDto)obj1;
			AmUnitDto dto2 = (AmUnitDto)obj2;
			return dto1.getStartDate().compareTo(dto2.getStartDate());
		}
	}
	
}
