/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.workflow.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.workflow.vo.ApplicationMenuVo;

/**
 * @author yoshida
 *
 */
public class ApplicationMenuAction extends KintaiCommonAction {
	
	/**
	 * RXgN^
	 */
	public ApplicationMenuAction() {
		super();
	}
	
	public void action() throws Exception {
		// VȌ
		prepareVo(false);
		// 
		init();
		// j[{^ݒ
		show();
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ApplicationMenuVo();
	}
	
	@Override
	protected void init() throws Exception {
		// ۑf[^
		initStoredData();
	}
	
	@Override
	protected void show() throws Exception {
		ApplicationMenuVo vo = (ApplicationMenuVo)getVo();
		String[][] aryApplication = new String[0][0];
		if (isAttendanceApprovalFunction()) {
			aryApplication = StringUtil.combineArray(MosPMenuConst.getApplicationCmdArray(),
					getMosPCodeArray(CommonConst.TID_APPLICATION_MENU));
		}
		// ֋xɈӌmF
		if (part().mospcode().useSubstituteHolidayFunction()
				&& VariousUtil.isNotNull(part().subHoliday().getCloseDate(user.getKCode(), DateUtil.getSystemDate()))) {
			aryApplication = StringUtil.combineArray(aryApplication, StringUtil.convArrayDimension(MosPMenuConst
				.getMenuSubHolidayAttitude()));
		}
		// j[{^ꗗ
		vo.setFields(aryApplication);
	}
	
}
