/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MCodeDto;
import jp.mosp.common.utils.StringUtil;

/**
 * @author yoshida
 *
 */
public class YukyuInformationCardVo extends MosPVo {
	
	private static final long	serialVersionUID		= 8784848856294588759L;
	
	// p[^[
	/**
	 * 
	 */
	public static final String	PRM_PLT_CF_MONTH		= "pltCFMonth";
	/**
	 * 
	 */
	public static final String	PRM_TXT_CF_DAYS			= "txtCFDays";
	/**
	 * 
	 */
	public static final String	PRM_PLT_CF_KBN			= "pltCFKbn";
	/**
	 * 
	 */
	public static final String	PRM_PLT_SUPPLY_MODEL	= "pltSupplyModel";
	/**
	 * 
	 */
	public static final String	PRM_TXT_STANDARD		= "txtStandard";
	/**
	 * 
	 */
	public static final String	PRM_TXT_DAYS			= "txtDays";
	/**
	 * 
	 */
	public static final String	PRM_TXT_INFO			= "txtInfo";
	
	// tB[h
	private String				pltCFMonth;
	private String				txtCFDays;
	private String				pltCFKbn;
	private String				pltSupplyModel;
	private String[]			aryTxtStandard;
	private String[]			aryTxtDays;
	private String[]			aryTxtInfo;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltCFKbn;
	/**
	 * 
	 */
	public String[][]			aryPltCFMonth;
	/**
	 * 
	 */
	public String[][]			aryPltSupplyModel;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_PROCESS_SET_UP;
	/**
	 * 
	 */
	public String				NAM_SUPPLY_CONDITION;
	/**
	 * 
	 */
	public String				NAM_CF_MONTH;
	/**
	 * 
	 */
	public String				NAM_CF_DAYS;
	/**
	 * 
	 */
	public String				NAM_CF_KBN;
	/**
	 * 
	 */
	public String				NAM_SUPPLY_MODEL;
	/**
	 * 
	 */
	public String				NAM_STANDARD;
	/**
	 * 
	 */
	public String				NAM_DAYS;
	/**
	 * 
	 */
	public String				NAM_INFO;
	/**
	 * 
	 */
	public int					LEN_CF_MONTH;
	/**
	 * 
	 */
	public int					LEN_CF_DAYS;
	/**
	 * 
	 */
	public int					LEN_STANDARD;
	/**
	 * 
	 */
	public int					LEN_DAYS;
	/**
	 * 
	 */
	public int					LEN_INFO;
	

	/**
	 * RXgN^
	 */
	public YukyuInformationCardVo() {
		super();
		setViewPath(getClassName());
		pltCFMonth = "";
		txtCFDays = "";
		pltCFKbn = "";
		pltSupplyModel = "";
		aryTxtStandard = new String[0];
		aryTxtDays = new String[0];
		aryTxtInfo = new String[0];
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_PAID_HOLIDAY_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_SYSTEM2, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_PROCESS_SET_UP = CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_PROCESS + CommonConst.NAM_SET_UP;
		NAM_SUPPLY_CONDITION = CommonConst.NAM_PAID_HOLIDAY + CommonConst.NAM_SUPPLY + CommonConst.NAM_CONDITION;
		NAM_CF_MONTH = CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_PROCESS + CommonConst.NAM_MONTH;
		NAM_CF_DAYS = CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_NUMBER_OF_DAYS;
		NAM_CF_KBN = CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_COMMON_TYPE;
		NAM_SUPPLY_MODEL = "x@";
		NAM_STANDARD = CommonConst.NAM_SUPPLY + CommonConst.NAM_CONDITION;
		NAM_DAYS = CommonConst.NAM_SUPPLY + CommonConst.NAM_NUMBER_OF_DAYS;
		NAM_INFO = CommonConst.NAM_EXPLANATION;
		LEN_CF_MONTH = CommonConst.LEN_MONTH_DAY;
		LEN_CF_DAYS = CommonConst.LEN_MONTH_DAY;
		LEN_STANDARD = 2;
		LEN_DAYS = CommonConst.LEN_MONTH_DAY;
		LEN_INFO = 7;
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		aryTxtStandard = StringUtil.getBlankArrayOneDimension(20);
		aryTxtDays = StringUtil.getBlankArrayOneDimension(20);
		aryTxtInfo = StringUtil.getBlankArrayOneDimension(20);
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		pltCFMonth = request.getParameter(PRM_PLT_CF_MONTH);
		txtCFDays = request.getParameter(PRM_TXT_CF_DAYS);
		pltCFKbn = request.getParameter(PRM_PLT_CF_KBN);
		pltSupplyModel = request.getParameter(PRM_PLT_SUPPLY_MODEL);
		aryTxtStandard = request.getParameterValues(PRM_TXT_STANDARD);
		aryTxtDays = request.getParameterValues(PRM_TXT_DAYS);
		aryTxtInfo = request.getParameterValues(PRM_TXT_INFO);
	}
	
	/**
	 * tB[hݒ
	 * @param listYukyuInfo Lx񃊃Xg
	 */
	@Override
	public void setFields(List<?> listYukyuInfo) {
		// z̏
		aryTxtStandard = StringUtil.getBlankArrayOneDimension(20);
		aryTxtDays = StringUtil.getBlankArrayOneDimension(20);
		aryTxtInfo = StringUtil.getBlankArrayOneDimension(20);
		//f[^̐ݒ		
		int i = 0;
		Iterator<?> it = listYukyuInfo.iterator();
		while (it.hasNext()) {
			MCodeDto dto = (MCodeDto)it.next();
			aryTxtStandard[i] = escapeHTML(dto.getTCode());
			aryTxtDays[i] = escapeHTML(dto.getTChange());
			aryTxtInfo[i] = escapeHTML(dto.getTName());
			i++;
		}
	}
	
	/**
	 * tB[h̑ÓmFiLxɏj
	 * @throws MospException 	MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtCFDays, NAM_CF_DAYS, PRM_TXT_CF_DAYS);
		checkRequired(pltCFKbn, NAM_CF_KBN, PRM_PLT_CF_KBN);
		// 񒷊mF
		checkLength(txtCFDays, LEN_CF_DAYS, NAM_CF_DAYS, PRM_TXT_CF_DAYS);
		// ^CvmF(p)
		checkNumber(txtCFDays, NAM_CF_DAYS, PRM_TXT_CF_DAYS);
		for (int i = 0; i < aryTxtStandard.length; i++) {
			if (StringUtil.isNotNull(aryTxtStandard[i])) {
				// ^CvmF(p)
				checkNumber(aryTxtStandard[i], NAM_STANDARD, i, PRM_TXT_STANDARD);
				checkLength(aryTxtStandard[i], LEN_STANDARD, NAM_STANDARD, i, PRM_TXT_STANDARD);
			} else {
				if (StringUtil.isNotNull(aryTxtDays[i])) {
					// K{mF
					checkRequired(aryTxtStandard[i], NAM_STANDARD, i, PRM_TXT_STANDARD);
					checkRequired(aryTxtInfo[i], NAM_INFO, i, PRM_TXT_INFO);
					// ^CvmF(p)
					checkNumber(aryTxtStandard[i], NAM_STANDARD, i, PRM_TXT_STANDARD);
					checkNumber(aryTxtDays[i], NAM_DAYS, i, PRM_TXT_DAYS);
					// 񒷊mF
					checkLength(aryTxtStandard[i], LEN_STANDARD, NAM_STANDARD, i, PRM_TXT_STANDARD);
					checkLength(aryTxtDays[i], LEN_DAYS, NAM_DAYS, i, PRM_TXT_DAYS);
					checkLength(aryTxtInfo[i], LEN_INFO, NAM_INFO, i, PRM_TXT_INFO);
				}
				if (StringUtil.isNotNull(aryTxtInfo[i])) {
					// K{mF
					checkRequired(aryTxtStandard[i], NAM_STANDARD, i, PRM_TXT_STANDARD);
					checkRequired(aryTxtDays[i], NAM_DAYS, i, PRM_TXT_DAYS);
					// ^CvmF(p)
					checkNumber(aryTxtStandard[i], NAM_STANDARD, i, PRM_TXT_STANDARD);
					checkNumber(aryTxtDays[i], NAM_DAYS, i, PRM_TXT_DAYS);
					// 񒷊mF
					checkLength(aryTxtStandard[i], LEN_STANDARD, NAM_STANDARD, i, PRM_TXT_STANDARD);
					checkLength(aryTxtDays[i], LEN_DAYS, NAM_DAYS, i, PRM_TXT_DAYS);
					checkLength(aryTxtInfo[i], LEN_INFO, NAM_INFO, i, PRM_TXT_INFO);
				}
			}
		} // ÓmFI
		endValidation();
	}
	
	// ANZT\bh
	
	/**
	 * @return txtCFDays
	 */
	public String getEscTxtCFDays() {
		return escapeHTML(txtCFDays);
	}
	
	/**
	 * @return pltCFMonth
	 */
	public String getPltCFMonth() {
		return pltCFMonth;
	}
	
	/**
	 * @return txtCFDays
	 */
	public String getTxtCFDays() {
		return txtCFDays;
	}
	
	/**
	 * @return pltCFKbn
	 */
	public String getPltCFKbn() {
		return pltCFKbn;
	}
	
	/**
	 * @return pltSupplyModel
	 */
	public String getPltSupplyModel() {
		return pltSupplyModel;
	}
	
	/**
	 * @return aryTxtStandard
	 */
	public String[] getAryTxtStandard() {
		return aryTxtStandard.clone();
	}
	
	/**
	 * @return aryTxtDays
	 */
	public String[] getAryTxtDays() {
		return aryTxtDays.clone();
	}
	
	/**
	 * @return aryTxtInfo
	 */
	public String[] getAryTxtInfo() {
		return aryTxtInfo.clone();
	}
	
	/**
	 * @param pltCFMonth Zbg pltCFMonth
	 */
	public void setPltCFMonth(String pltCFMonth) {
		this.pltCFMonth = pltCFMonth;
	}
	
	/**
	 * @param txtCFDays Zbg txtCFDays
	 */
	public void setTxtCFDays(String txtCFDays) {
		this.txtCFDays = txtCFDays;
	}
	
	/**
	 * @param pltCFKbn Zbg pltCFKbn
	 */
	public void setPltCFKbn(String pltCFKbn) {
		this.pltCFKbn = pltCFKbn;
	}
	
	/**
	 * @param pltSupplyModel Zbg pltSupplyModel
	 */
	public void setPltSupplyModel(String pltSupplyModel) {
		this.pltSupplyModel = pltSupplyModel;
	}
	
}
