/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.kintai.common.dto.MSyozokuDto;

/**
 * @author yoshida
 *
 */
public class SyozokuMasterListVo extends MosPVo {
	
	private static final long	serialVersionUID	= 4493692660345609747L;
	
	//萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF			= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON			= 1;
	
	// p[^[
	/**
	 * 
	 */
	public static final String	PRM_TXT_S_CODE		= "txtSCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_S_NAME		= "txtSName";
	
	// tB[h
	private String[]			arySCode;
	private String[]			arySName;
	private String				txtSCode;
	private String				txtSName;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_S_CODE;
	/**
	 * 
	 */
	public String				NAM_S_NAME;
	/**
	 * 
	 */
	public int					LEN_S_CODE;
	/**
	 * 
	 */
	public int					LEN_S_NAME;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_S_CODE			= "keySCode";
	/**
	 * 
	 */
	public final String			KEY_S_NAME			= "keySName";
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * 
	 */
	public SyozokuMasterListVo() {
		super();
		setViewPath(getClassName());
		arySCode = new String[0];
		arySName = new String[0];
		txtSCode = "";
		txtSName = "";
		setFormerKey(KEY_S_CODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_UNIT_MASTER;
		aryMenu = new String[][]{ { CMD_MENU_SYSTEM2, CommonConst.NAM_TO_MENU } };
	}
	
	@Override
	protected void setFieldsName() {
		NAM_S_CODE = CommonConst.NAM_STATION + CommonConst.NAM_COMMON_CODE;
		NAM_S_NAME = CommonConst.NAM_COMMON_MEISYO;
		LEN_S_CODE = 6;
		LEN_S_NAME = 20;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtSCode = request.getParameter(PRM_TXT_S_CODE);
		txtSName = request.getParameter(PRM_TXT_S_NAME);
	}
	
	@Override
	public void setFields(List<?> syozokuList) {
		// Xg̐ݒ
		list = syozokuList;
		// f[^̎擾
		count = syozokuList.size();
		// z̏
		arySCode = new String[count];
		arySName = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = syozokuList.iterator();
		while (it.hasNext()) {
			MSyozokuDto dto = (MSyozokuDto)it.next();
			arySCode[i] = escapeHTML(dto.getSCode());
			arySName[i] = escapeHTML(dto.getSName());
			i++;
		}
	}
	
	// ANZT\bh
	/**
	 * @return txtSCode
	 */
	public String getEscTxtSCode() {
		return escapeHTML(txtSCode);
	}
	
	/**
	 * @return txtSName
	 */
	public String getEscTxtSName() {
		return escapeHTML(txtSName);
	}
	
	/**
	 * @return arySCode
	 */
	public String[] getArySCode() {
		return arySCode.clone();
	}
	
	/**
	 * @return arySName
	 */
	public String[] getArySName() {
		return arySName.clone();
	}
	
	/**
	 * @return txtSCode
	 */
	public String getTxtSCode() {
		return txtSCode;
	}
	
	/**
	 * @return txtSName
	 */
	public String getTxtSName() {
		return txtSName;
	}
	
	/**
	 * @return searchmode
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
	/**
	 * @param txtSCode Zbg txtSCode
	 */
	public void setTxtSCode(String txtSCode) {
		this.txtSCode = txtSCode;
	}
	
	/**
	 * @param txtSName Zbg txtSName
	 */
	public void setTxtSName(String txtSName) {
		this.txtSName = txtSName;
	}
	
	/**
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
}
