/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.common.dto.MKaisyaDto;
import jp.mosp.kintai.system.vo.KaisyaMasterListVo;

/**
 * @author yoshida
 *
 */
public class KaisyaMasterListAction extends KintaiCommonAction {
	
	private static final String	CMD_KAISYA_MASTER_LIST_SHOW			= "S2010";
	private static final String	CMD_KAISYA_MASTER_LIST_SEARCH		= "S2011";
	private static final String	CMD_KAISYA_MASTER_LIST_RE_SEARCH	= "S2012";
	private static final String	CMD_KAISYA_MASTER_LIST_SORT			= "S2013";
	

	/**
	 * RXgN^
	 */
	public KaisyaMasterListAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_KAISYA_MASTER_LIST_SHOW)) {
			show();
		} else if (cmd.equals(CMD_KAISYA_MASTER_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_KAISYA_MASTER_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_KAISYA_MASTER_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new KaisyaMasterListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmSystemAuth();
	}
	
	@Override
	protected void show() throws Exception {
		KaisyaMasterListVo vo = (KaisyaMasterListVo)getVo();
		// lɃZbg	
		vo.setSearchmode(KaisyaMasterListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		KaisyaMasterListVo vo = (KaisyaMasterListVo)getVo();
		vo.setParams(request);
		searchCompanyList();
		vo.setFormerKey(vo.KEY_JCODE);
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(KaisyaMasterListVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		KaisyaMasterListVo vo = (KaisyaMasterListVo)getVo();
		if (vo.getSearchmode() == KaisyaMasterListVo.SEARCH_ON) {
			removeSessionDto();
			searchCompanyList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * ƏXg
	 * @throws Exception 	Oꍇ
	 */
	private void searchCompanyList() throws Exception {
		KaisyaMasterListVo vo = (KaisyaMasterListVo)getVo();
		vo.setFields(part().office().getMKaisyaDao().findForCondition(vo.getTxtJCode(), vo.getTxtKaiMei()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryJCode().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		KaisyaMasterListVo vo = (KaisyaMasterListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_JCODE)) {
			comp = new CompJCode();
		} else if (key.equals(vo.KEY_KAIMEI)) {
			comp = new CompKaiMei();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * ƏR[hɂrNX
	 */
	protected static class CompJCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 4221017842550886498L;
		

		public int compare(Object obj1, Object obj2) {
			MKaisyaDto dto1 = (MKaisyaDto)obj1;
			MKaisyaDto dto2 = (MKaisyaDto)obj2;
			return dto1.getId().compareTo(dto2.getId());
		}
	}
	
	/**
	 * Ə̂ɂrNX
	 */
	protected static class CompKaiMei implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -8838582673151573558L;
		

		public int compare(Object obj1, Object obj2) {
			MKaisyaDto dto1 = (MKaisyaDto)obj1;
			MKaisyaDto dto2 = (MKaisyaDto)obj2;
			return dto1.getKaiMei().compareTo(dto2.getKaiMei());
		}
	}
	
}
