/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.system.action;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.LogUtility;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.MosPUserDao;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.system.vo.AccountMasterListVo;

/**
 * @author yoshida
 *
 */
public class AccountMasterListAction extends KintaiCommonAction {
	
	// R}h
	private static final String	CMD_ACCOUNT_MASTER_LIST_SHOW		= "S2400";
	private static final String	CMD_ACCOUNT_MASTER_LIST_SEARCH		= "S2401";
	/**
	 * 
	 */
	public static final String	CMD_ACCOUNT_MASTER_LIST_RE_SEARCH	= "S2402";
	private static final String	CMD_ACCOUNT_MASTER_LIST_SORT		= "S2403";
	private static final String	CMD_ACCOUNT_MASTER_LIST_PASS_INIT	= "S2404";
	

	/**
	 * RXgN^
	 */
	public AccountMasterListAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_ACCOUNT_MASTER_LIST_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_ACCOUNT_MASTER_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_ACCOUNT_MASTER_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_ACCOUNT_MASTER_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else if (cmd.equals(CMD_ACCOUNT_MASTER_LIST_PASS_INIT)) {
			// pX[h
			initPassword();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AccountMasterListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// [hݒ
		setMode();
		/*						
		 *  	2009/01/09	k.taniai	j[AWΉ
		 */
		AccountMasterListVo vo = (AccountMasterListVo)getVo();
		vo.aryPltAuthority = StringUtil.combineArray(getCodeArray(CommonConst.TID_AUTHORITY), getArrangeAuthArray());
	}
	
	@Override
	protected void show() throws Exception {
		AccountMasterListVo vo = (AccountMasterListVo)getVo();
		vo.setPltDelete(MospConst.DELETE_FLAG_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		AccountMasterListVo vo = (AccountMasterListVo)getVo();
		vo.setParams(request);
		searchUserList();
		vo.setFormerKey(vo.KEY_USER_ID);
		vo.setIsAscending(true);
		vo.initListInfo();
	}
	
	@Override
	protected void research() throws Exception {
		AccountMasterListVo vo = (AccountMasterListVo)getVo();
		removeSessionDto();
		searchUserList();
		vo.setPageButton();
		sortList();
	}
	
	/**
	 * [U[Xg
	 * @throws Exception Oꍇ
	 */
	private void searchUserList() throws Exception {
		AccountMasterListVo vo = (AccountMasterListVo)getVo();
		// 
		vo.setFields(part().mospuser().getMosPUserDao().findForCondition(vo.getTxtUserId(), vo.getTxtUserName(),
				vo.getPltAuthority(), vo.getPltDelete()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryUserId().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	/**
	 * pX[h
	 * @throws Exception Oꍇ
	 */
	private void initPassword() throws Exception {
		AccountMasterListVo vo = (AccountMasterListVo)getVo();
		// Ώۃ[U[ID
		String userId = key1;
		// 
		MosPUserDao dao = part().mospuser().getMosPUserDao();
		// f[^̏
		CmUserDto dto = dao.findForUpdate(userId);
		// ݊mF
		chkExist(dto);
		// l̐ݒ
		dto.setPassword(MospUtility.getDigest(MospUtility.getDigest(userId)));
		// f[^̍XV
		dao.update(dto, false);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(getMessage(CommonConst.MSG_INITIALIZE_PASSOWRD, getKName(dto.getKCode())));
		// OɃpX[hbZ[WcB
		LogUtility.log(request, 4, MospConst.LOG_SECURE, getMessage(CommonConst.MSG_INITIALIZE_PASSOWRD, userId));
	}
	
	/**
	 * [hݒ
	 * @throws Exception Oꍇ
	 */
	private void setMode() throws Exception {
		AccountMasterListVo vo = (AccountMasterListVo)getVo();
		// 
		List<CmUserDto> listHuman = part().mospuser().getMosPUserDao().findAllMosPUser();
		// HUMANmF
		boolean hasAuth = false;
		String[][] aryHuman = getConfArray(CommonConst.CONF_ID_HUMAN);
		for (CmUserDto dto : listHuman) {
			for (String[] ary : aryHuman) {
				if (ary[0].equals(dto.getAuthority())) {
					hasAuth = true;
					break;
				}
			}
		}
		if (hasAuth) {
			vo.setMode(AccountMasterListVo.MODE_VIEW);
		} else {
			vo.setMode(AccountMasterListVo.MODE_INSERT);
		}
	}
	
	@Override
	protected void sortList(String key) throws MospException {
		AccountMasterListVo vo = (AccountMasterListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws MospException {
		AccountMasterListVo vo = (AccountMasterListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		AccountMasterListVo vo = (AccountMasterListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_USER_ID)) {
			comp = new CompUserId();
		} else if (key.equals(vo.KEY_USER_NAME)) {
			comp = new CompUserName();
		} else if (key.equals(vo.KEY_AUTHORITY)) {
			comp = new CompMospAuthority();
		} else if (key.equals(vo.KEY_DELETE)) {
			comp = new CompDeleteFlag();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * [U[IDɂrNX
	 */
	protected static class CompUserId implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -4583472093732229895L;
		

		public int compare(Object obj1, Object obj2) {
			CmUserDto dto1 = (CmUserDto)obj1;
			CmUserDto dto2 = (CmUserDto)obj2;
			return dto1.getUserId().compareTo(dto2.getUserId());
		}
	}
	
	/**
	 * [U[ɂrNX
	 */
	protected static class CompUserName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -8592798017682994795L;
		

		public int compare(Object obj1, Object obj2) {
			CmUserDto dto1 = (CmUserDto)obj1;
			CmUserDto dto2 = (CmUserDto)obj2;
			return dto1.getUserName().compareTo(dto2.getUserName());
		}
	}
	
	/**
	 * MosPpɂrNX
	 */
	protected static class CompMospAuthority implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -5352768820840940232L;
		

		public int compare(Object obj1, Object obj2) {
			CmUserDto dto1 = (CmUserDto)obj1;
			CmUserDto dto2 = (CmUserDto)obj2;
			return dto1.getAuthority().compareTo(dto2.getAuthority());
		}
	}
	
	/**
	 * 폜tOɂrNX
	 */
	protected static class CompDeleteFlag implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -6928899434272685923L;
		

		public int compare(Object obj1, Object obj2) {
			CmUserDto dto1 = (CmUserDto)obj1;
			CmUserDto dto2 = (CmUserDto)obj2;
			return dto2.getDeleteFlag() - dto1.getDeleteFlag();
		}
	}
	
}
