/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.kintai.schedule.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.utils.StringUtil;

/**
 * @author yoshida
 *
 */
public abstract class MosPScheduleVo extends MosPVo {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID		= -2408663613804781264L;
	
	// p[^
	/**
	 * pltYear
	 */
	public static final String	PRM_PLT_YEAR			= "pltYear";
	/**
	 * pltMonth
	 */
	public static final String	PRM_PLT_MONTH			= "pltMonth";
	/**
	 * hidSelectKCode
	 */
	public static final String	PRM_HID_SELECT_K_CODE	= "hidSelectKCode";
	
	// tB[h
	private String				selectKCode;
	
	private String				pltYear;
	private String				pltMonth;
	
	// Tu^Cgj[R}h
	private String				cmdMenuButton;
	private String				cmdListButton;
	private String				namListButton;
	

	/**
	 * 
	 */
	public MosPScheduleVo() {
		super();
		pltYear = "";
		pltMonth = "";
		selectKCode = "";
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		selectKCode = request.getParameter(PRM_HID_SELECT_K_CODE);
		pltYear = request.getParameter(PRM_PLT_YEAR);
		pltMonth = request.getParameter(PRM_PLT_MONTH);
	}
	
	/**
	 * @param addListButton {^ttO
	 * 
	 */
	public void setAryMenu(boolean addListButton) {
		aryMenu = new String[][]{ { getCmdMenuButton(), CommonConst.NAM_TO_MENU }, };
		if (addListButton) {
			aryMenu = StringUtil.addArrayLastRowValue(aryMenu, getCmdListButton(), getNamListButton());
		}
	}
	
	/**
	 * @return selectKCode
	 */
	public String getEscSelectKCode() {
		return escapeHTML(selectKCode);
	}
	
	/**
	 * @return pltYear
	 */
	public String getEscPltYear() {
		return escapeHTML(pltYear);
	}
	
	/**
	 * @return pltMonth
	 */
	public String getEscPltMonth() {
		return escapeHTML(pltMonth);
	}
	
	/**
	 * @return selectKCode
	 */
	public String getSelectKCode() {
		return selectKCode;
	}
	
	/**
	 * @return pltYear
	 */
	public String getPltYear() {
		return pltYear;
	}
	
	/**
	 * @return pltMonth
	 */
	public String getPltMonth() {
		return pltMonth;
	}
	
	/**
	 * @return cmdMenuButton
	 */
	public String getCmdMenuButton() {
		return cmdMenuButton;
	}
	
	/**
	 * @return cmdListButton
	 */
	public String getCmdListButton() {
		return cmdListButton;
	}
	
	/**
	 * @return namListButton
	 */
	public String getNamListButton() {
		return namListButton;
	}
	
	/**
	 * @param selectKCode Zbg selectKCode
	 */
	public void setSelectKCode(String selectKCode) {
		this.selectKCode = selectKCode;
	}
	
	/**
	 * @param pltYear Zbg pltYear
	 */
	public void setPltYear(String pltYear) {
		this.pltYear = pltYear;
	}
	
	/**
	 * @param pltMonth Zbg pltMonth
	 */
	public void setPltMonth(String pltMonth) {
		this.pltMonth = pltMonth;
	}
	
	/**
	 * @param cmdMenuButton Zbg cmdMenuButton
	 */
	public void setCmdMenuButton(String cmdMenuButton) {
		this.cmdMenuButton = cmdMenuButton;
	}
	
	/**
	 * @param cmdListButton Zbg cmdListButton
	 */
	public void setCmdListButton(String cmdListButton) {
		this.cmdListButton = cmdListButton;
	}
	
	/**
	 * @param namListButton Zbg namListButton
	 */
	public void setNamListButton(String namListButton) {
		this.namListButton = namListButton;
	}
	
}
