/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.schedule.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.KintaiCommonAction;
import jp.mosp.kintai.schedule.dto.CmRotationDto;
import jp.mosp.kintai.schedule.vo.ScheduleRotationListVo;

/**
 * @author yoshida
 *
 */
public class ScheduleRotationListAction extends KintaiCommonAction {
	
	//R}h
	private static final String	CMD_ROTATION_LIST_SHOW		= "K1210";	// \
	private static final String	CMD_ROTATION_LIST_SEARCH	= "K1211";	// 
	private static final String	CMD_ROTATION_LIST_RE_SEARCH	= "K1212";	// Č
	private static final String	CMD_ROTATION_LIST_SORT		= "K1213";	// \[g
																		
	
	/**
	 * RXgN^
	 */
	public ScheduleRotationListAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_ROTATION_LIST_SHOW)) {
			show();
		} else if (cmd.equals(CMD_ROTATION_LIST_SEARCH)) {
			search();
		} else if (cmd.equals(CMD_ROTATION_LIST_RE_SEARCH)) {
			research();
		} else if (cmd.equals(CMD_ROTATION_LIST_SORT)) {
			//\[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ScheduleRotationListVo();
	}
	
	@Override
	protected void init() throws Exception {
		ScheduleRotationListVo vo = (ScheduleRotationListVo)getVo();
		// R[h敪v_EXg쐬
		//vo.aryPltWorkType = getWorkTypeArrayAllWithWeekHoliday();
		vo.aryPltWorkType = part().worktype().getWorkTypeArrayAllWithHoliday();
		vo.aryPltHoliday = VariousUtil.getApplicableFlagArray();
		// [U[擾
		getInfo(user.getUserId());
	}
	
	@Override
	protected void show() {
		ScheduleRotationListVo vo = (ScheduleRotationListVo)getVo();
		// lɃZbg
		vo.setSearchmode(ScheduleRotationListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		ScheduleRotationListVo vo = (ScheduleRotationListVo)getVo();
		// 
		vo.setParams(request);
		searchFmRotationList();
		vo.setFormerKey(vo.KEY_RT_CODE);
		vo.setIsAscending(true);
		vo.initListInfo();
		//ɃZbg
		vo.setSearchmode(ScheduleRotationListVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		ScheduleRotationListVo vo = (ScheduleRotationListVo)getVo();
		// Č
		if (vo.getSearchmode() == ScheduleRotationListVo.SEARCH_ON) {
			removeSessionDto();
			searchFmRotationList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * ֔ԃp^[Xg
	 * @throws Exception	Oꍇ
	 */
	private void searchFmRotationList() throws Exception {
		ScheduleRotationListVo vo = (ScheduleRotationListVo)getVo();
		// 
		vo.setFields(part().rotation().getCmRotationDao().findForCondition(userBasis.getKCode(), vo.getTxtRTCode(),
				vo.getTxtRTName()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryRTCode().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected void sortList(String key) throws MospException {
		ScheduleRotationListVo vo = (ScheduleRotationListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws MospException {
		ScheduleRotationListVo vo = (ScheduleRotationListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		ScheduleRotationListVo vo = (ScheduleRotationListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_RT_CODE)) {
			comp = new CompFmRotationCode();
		} else if (key.equals(vo.KEY_RT_NAME)) {
			comp = new CompFmRotationName();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * ̂ɂrNX
	 */
	protected static class CompFmRotationName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -4433257333577061313L;
		

		public int compare(Object obj1, Object obj2) {
			CmRotationDto dto1 = (CmRotationDto)obj1;
			CmRotationDto dto2 = (CmRotationDto)obj2;
			return dto1.getRtName().compareTo(dto2.getRtName());
		}
	}
	
	/**
	 * R[hɂrNX
	 */
	protected static class CompFmRotationCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 4002773790452263008L;
		

		public int compare(Object obj1, Object obj2) {
			CmRotationDto dto1 = (CmRotationDto)obj1;
			CmRotationDto dto2 = (CmRotationDto)obj2;
			return dto1.getRtCode().compareTo(dto2.getRtCode());
		}
	}
	
}
