/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.report.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.report.dao.CmOutPutDao;
import jp.mosp.kintai.report.dto.CmOutPutDto;
import jp.mosp.kintai.report.vo.OutPutMasterListVo;

/**
 * @author yoshida
 *
 */
public class OutPutMasterListAction extends MosPAction {
	
	// R}h
	private static final String	CMD_CODE_LIST_SHOW		= "S1220";	// \
	private static final String	CMD_CODE_LIST_SEARCH	= "S1221";	// 
	private static final String	CMD_CODE_LIST_RE_SEARCH	= "S1222";	// Č
	private static final String	CMD_CODE_LIST_SORT		= "S1223";	// \[g
																	
	
	/**
	 * RXgN^
	 */
	public OutPutMasterListAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_CODE_LIST_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_CODE_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_CODE_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_CODE_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new OutPutMasterListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// vZǗmF
		confirmCalculateAuth();
		OutPutMasterListVo vo = (OutPutMasterListVo)getVo();
		// ͈̓v_EXg쐬
		vo.aryPltScope = getOutputScopeArray();
	}
	
	@Override
	protected void show() throws Exception {
		OutPutMasterListVo vo = (OutPutMasterListVo)getVo();
		// lɃZbg
		vo.setSearchmode(OutPutMasterListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		OutPutMasterListVo vo = (OutPutMasterListVo)getVo();
		vo.setParams(request);
		searchCodeList();
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(OutPutMasterListVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		OutPutMasterListVo vo = (OutPutMasterListVo)getVo();
		if (vo.getSearchmode() == OutPutMasterListVo.SEARCH_ON) {
			removeSessionDto();
			searchCodeList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * R[hXg
	 * @throws Exception 	Oꍇ
	 */
	private void searchCodeList() throws Exception {
		OutPutMasterListVo vo = (OutPutMasterListVo)getVo();
		// 
		CmOutPutDao dao = new CmOutPutDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setFields(dao.findForSearch(vo.getTxtCode(), vo.getTxtName(), vo.getPltScope()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getAryOutPutMaster().length == 0) {
			addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		OutPutMasterListVo vo = (OutPutMasterListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_CODE)) {
			comp = new CompCode();
		} else if (key.equals(vo.KEY_NAME)) {
			comp = new CompName();
		} else if (key.equals(vo.KEY_SCOPE)) {
			comp = new CompScope();
		} else if (key.equals(vo.KEY_INDEX)) {
			comp = new CompIndex();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * R}hNo.ɂrNX
	 */
	protected static class CompCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 2092325382735270514L;
		

		public int compare(Object obj1, Object obj2) {
			CmOutPutDto dto1 = (CmOutPutDto)obj1;
			CmOutPutDto dto2 = (CmOutPutDto)obj2;
			return dto1.getCode().compareTo(dto2.getCode());
		}
	}
	
	/**
	 * {^̂ɂrNX
	 */
	protected static class CompName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 1566211673543838675L;
		

		public int compare(Object obj1, Object obj2) {
			CmOutPutDto dto1 = (CmOutPutDto)obj1;
			CmOutPutDto dto2 = (CmOutPutDto)obj2;
			return dto1.getName().compareTo(dto2.getName());
		}
	}
	
	/**
	 * ͈͂ɂrNX
	 */
	protected static class CompScope implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -6641642982714466781L;
		

		public int compare(Object obj1, Object obj2) {
			CmOutPutDto dto1 = (CmOutPutDto)obj1;
			CmOutPutDto dto2 = (CmOutPutDto)obj2;
			return dto1.getScope().compareTo(dto2.getScope());
		}
	}
	
	/**
	 * \ɂrNX
	 */
	protected static class CompIndex implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 2867298555927778701L;
		

		public int compare(Object obj1, Object obj2) {
			CmOutPutDto dto1 = (CmOutPutDto)obj1;
			CmOutPutDto dto2 = (CmOutPutDto)obj2;
			return String.valueOf(dto1.getViewIndex()).compareTo(String.valueOf(dto2.getViewIndex()));
		}
	}
	
}
