/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.report.action;

import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.PoiUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.kintai.common.action.AttendanceTotalAction;
import jp.mosp.kintai.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.payroll.vo.AttendanceExportCardVo;
import jp.mosp.kintai.report.dao.AttendanceManagementDao;
import jp.mosp.kintai.report.dto.AttendanceManagementDto;

import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;

/**
 * @author yoshida
 *
 */
public class AttendanceManagementAction extends AttendanceTotalAction {
	
	private int								row							= 0;			//Row(s) 0`
	private int								pageno						= 0;			//y[W
	private static final int				END_PAGE_L					= 50;			//1y[W̍ŏIs
	private int								gyol						= 2;			//ׂ̉s
	private int								titlel						= 3;			//1y[W̃^Cgʒu
	private int								firstl						= 8;			//1y[W̖׊Jnʒu
	private int								endl;										//ŏIʒugetLastRow()Ŏ擾
	private static final int				LAST_L						= 46;			//1y[W̖׍ŏIs(vs͊܂܂Ȃ)
	private static final int				TOTAL_L						= 48;			//1y[W̍vs	
	private String							file1						= "";
	private int								printcnt					= 0;
	
	// GNZEZԍ
	private static final int[]				CC							= { 12, 19, 26, 33, 40, 47, 54, 61, 68, 75, 82,
		89, 96, 103, 110, 117, 124										};
	
	private String							simei						= "";
	
	private double							snissu						= 0;
	private int								kinmuji						= 0;
	private int								kyukeiji					= 0;
	private double							yukyu						= 0;
	private double							tokukyu						= 0;
	private double							kekkin						= 0;
	private double							skekkin						= 0;
	private int								tisokai						= 0;
	private int								tijikan						= 0;
	private int								zajikan						= 0;
	private int								ksjikan						= 0;
	private int								snjikan						= 0;
	private int								kaikin						= 0;
	private int								syokujikaisu				= 0;
	private int								cyokukaisu1					= 0;
	private int								cyokukaisu2					= 0;
	private int								cyokukaisu3					= 0;
	private int								hokakaisu1					= 0;
	private int								hokakaisu2					= 0;
	private int								hokakaisu3					= 0;
	private int								hokakaisu4					= 0;
	private int								hokakaisu5					= 0;
	private int								monthlyOverTime				= 0;
	private int								monthlyWeekHoliday			= 0;
	private double							substituteHoliday			= 0;
	private double							daikyu						= 0;
	private double							furikae						= 0;
	private double							riyuu6						= 0;
	private double							riyuu7						= 0;
	private double							riyuu8						= 0;
	private double							riyuu9						= 0;
	
	/**
	 * CX^XϐFxɎ
	 */
	private double							holidayTime					= 0;
	
	private double							totalSNissu					= 0;
	private int								totalKinmuJi				= 0;
	private int								totalKyukeiJi				= 0;
	private double							totalYukyu					= 0;
	private double							totalTokukyu				= 0;
	private double							totalKekkin					= 0;
	private double							totalSKekkin				= 0;
	private int								totalTisoKai				= 0;
	private int								totalTiJikan				= 0;
	private int								totalZaJikan				= 0;
	private int								totalKsJikan				= 0;
	private int								totalSnJikan				= 0;
	private int								totalKaikin					= 0;
	private int								totalSyokujiKaisu			= 0;
	private int								totalCyokuKaisu1			= 0;
	private int								totalCyokuKaisu2			= 0;
	private int								totalCyokuKaisu3			= 0;
	private int								totalHokaKaisu1				= 0;
	private int								totalHokaKaisu2				= 0;
	private int								totalHokaKaisu3				= 0;
	private int								totalHokaKaisu4				= 0;
	private int								totalHokaKaisu5				= 0;
	private int								totalMonthlyOverTime		= 0;
	private int								totalMonthlyWeekHoliday		= 0;
	private double							totalSubstituteHoliday		= 0;
	private double							totalDaikyu					= 0;
	private double							totalFurikae				= 0;
	private double							totalRiyuu6					= 0;
	private double							totalRiyuu7					= 0;
	private double							totalRiyuu8					= 0;
	private double							totalRiyuu9					= 0;
	
	/**
	 * CX^XϐFxɎ(v)
	 */
	private double							totalHolidayTime			= 0;
	
	private String							sectionName					= "";
	
	/**
	 * e[u؂ւt
	 */
	private static final String				SW_DATE						= "2010/04/01";
	
	/**
	 * ږFH蓖B
	 */
	private String							NAM_SYOKUJI;
	/**
	 * ږFFΎ蓖B
	 */
	//private String							NAM_KAIKIN;
	/**
	 * ږF1蓖B
	 */
	private String							NAM_CYOKU1;
	/**
	 * ږF2蓖B
	 */
	private String							NAM_CYOKU2;
	/**
	 * ږF3蓖B
	 */
	private String							NAM_CYOKU3;
	/**
	 * ږF̑1蓖B
	 */
	private String							NAM_HOKAK1;
	/**
	 * ږF̑2蓖B
	 */
	private String							NAM_HOKAK2;
	/**
	 * ږF̑3蓖B
	 */
	private String							NAM_HOKAK3;
	/**
	 * ږF̑4蓖B
	 */
	private String							NAM_HOKAK4;
	/**
	 * ږF̑5蓖B
	 */
	private String							NAM_HOKAK5;
	/**
	 * ږFLxɁB
	 */
	private String							NAM_PAID_HOLIDAY;
	/**
	 * ږFʋxɁB
	 */
	private String							NAM_PARTICULAR_HOLIDAY;
	/**
	 * ږF΁B
	 */
	private String							NAM_ABSENCE;
	/**
	 * ږFaxɁB 
	 */
	private String							NAM_MEDICAL;
	/**
	 * ږFxɗR5
	 */
	private String							NAM_HOLIDAY_REASON_5;
	/**
	 * ږFxɗR6
	 */
	private String							NAM_HOLIDAY_REASON_6;
	/**
	 * ږFxɗR7
	 */
	private String							NAM_HOLIDAY_REASON_7;
	/**
	 * ږFxɗR8
	 */
	private String							NAM_HOLIDAY_REASON_8;
	/**
	 * ږFxɗR9
	 */
	private String							NAM_HOLIDAY_REASON_9;
	/**
	 * ږFxɗR10
	 */
	private String							NAM_HOLIDAY_REASON_10;
	
	/**
	 * Ώ۔N
	 */
	private Date							targetDate;
	private List<AttendanceManagementDto>	managementList;
	private int								listSize;
	private static final int				CELL_K_NAME					= 1;
	private static final int				CELL_YEAR					= 6;
	private static final int				CELL_MONTH					= 12;
	private static final int				CELL_SECTION				= 107;
	
	/**
	 * 萔FXLSőo̓y[WB
	 */
	private static final int				OUTPUT_TOTAL_PAGE			= 35;
	
	/**
	 * 萔FXLS1y[W̍sB
	 */
	private static final int				ONE_PAGE					= 50;
	
	/**
	 * 萔Fwb_[(i)JnsB
	 */
	private static final int				HEADER_UPPER				= 5;
	
	/**
	 * 萔Fwb_[(i)JnsB
	 */
	private static final int				HEADER_LOWER				= 6;
	
	/**
	 * 萔Fwb_[1y[W̍sZB
	 */
	private static final int				HEADER_ADD_ROW				= 50;
	
	/**
	 * CX^XϐFΑӈꗗ̍őo͒ltOB
	 */
	private boolean							overListMax					= false;
	
	// OpenDocumentp
	private static final int				PAGE_END_ROW				= 50;			// 1y[W̏Iʒu
	private static final int				TITLE_ROW					= 3;			// ^CgJnʒu
	private static final int				DETAIL_ROW					= 7;			// 1y[W̖׊Jnʒu
	private static final int				TOTAL_ROW					= 47;			// 1y[W̍vJnʒu
	private static final int				LEN_EMPLOYEE				= 20;			// 1y[W̍ől
																						
	/**
	 * 萔FODSőo̓y[W
	 */
	private static final int				OUTPUT_ODS_TOTAL_PAGE		= 24;
	
	/**
	 * bZ[WFΑӈꗗ\MAX
	 */
	private static final int				CNT_KINTAI_LIST_MAX			= 500;
	/**
	 * bZ[WFΑӈꗗ\͈
	 */
	private static final String				EXTENT_KINTAI_LIST_PRINT	= "$A$1:$EH$";
	private PoiUtility						poi;
	private Sheet							sheet;
	

	/**
	 * RXgN^
	 */
	public AttendanceManagementAction() {
		super();
		setNeedProcSeq(false);
		final int endline = 50;
		endl = endline;
		listSize = 0;
		poi = null;
		sheet = null;
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// [o
		export();
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new AttendanceExportCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		getConnection();
	}
	
	/**
	 * [o
	 * @throws Exception  	Oꍇ
	 */
	private void export() throws Exception {
		AttendanceExportCardVo vo = (AttendanceExportCardVo)getVo();
		// p[^擾
		vo.setParams(request);
		// \
		targetDate = DateUtil.getYearMonth(vo.getPltYear(), vo.getPltMonth());
		// ݒ
		if (StringUtil.isNull(vo.getPltSection())) {
			sectionName = CommonConst.NAM_ALL_SECTION;
		} else {
			sectionName = getSectionName(vo.getPltSection());
		}
		// 
		setManagementList(targetDate, vo.getPltSection());
		// [ݒ
		StringBuffer fileName = new StringBuffer();
		fileName.append(DateUtil.convDateToStringYearMonth(targetDate));
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		fileName.append(vo.getPltSection());
		fileName.append(CommonConst.FILE_NAME_SEPARATOR);
		// [쐬
		if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_KINTAI_USE_ODF))) {
			// ODS
			request.setAttribute(MospConst.ATT_FILE_OBJECT, makeSpreadSheet());
			// t@C
			fileName.append(CommonConst.FILE_SAMP_M_KINTAIKANRI_ODS);
		} else {
			// XLS
			request.setAttribute(MospConst.ATT_FILE_OBJECT, makeWorkbook().getWorkbook());
			// t@C
			fileName.append(CommonConst.FILE_SAMP_M_KINTAIKANRI);
		}
		request.setAttribute(MospConst.ATT_FILE_NAME, fileName.toString());
	}
	
	/**
	 * ΑӊǗ擾
	 * @param  targetYearMonth Ώ۔N
	 * @param sectionCode R[h
	 * @throws Exception 	Oꍇ
	 */
	private void setManagementList(Date targetYearMonth, String sectionCode) throws Exception {
		AttendanceManagementDao dao = new AttendanceManagementDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		managementList = dao.findForCondition(DateUtil.convDateToStringYearMonthShort(targetYearMonth), sectionCode);
		if (managementList.size() == 0) {
			managementList = dao.findForConditionKdWork(DateUtil.convDateToStringYearMonthShort(targetYearMonth),
					sectionCode);
		}
		listSize = managementList.size();
	}
	
	/**
	 * ΑӊǗꗗ쐬
	 * @return PoiUtility CX^X
	 * @throws Exception    	Oꍇ
	 */
	private PoiUtility makeWorkbook() throws Exception {
		// [쐬
		poi = new PoiUtility();
		StringBuffer sb = new StringBuffer();
		sb.append(cfg.getProperty(MospConst.PPT_APP_DOCBASE));
		sb.append(CommonConst.TEMPLATE_M_KINTAIKANRI);
		poi.crtNewDocR(0, sb.toString());
		// wb_[ݒ
		printTitle();
		// [o͘g폜sZo
		int cnt = listSize / LEN_EMPLOYEE;
		int start = cnt * ONE_PAGE;
		int end = OUTPUT_TOTAL_PAGE * ONE_PAGE;
		int print = 0;
		if (listSize > CNT_KINTAI_LIST_MAX) {
			start = 0;
			cnt = 0;
		}
		// s̍폜
		if (start != 0) {
			// 1y[Wȏ̃f[^o͂ꍇ
			// ŏIf[^p1y[Ẅ̗ZĂB
			start = start + ONE_PAGE;
			for (int i = start; i < end; i++) {
				poi.dltRow(i);
			}
			// ̏o̓y[W͈͂߂B
			print = start;
		} else {
			// 1y[Ŵ݂̃f[^o͂ꍇ
			start = start + ONE_PAGE;
			for (int i = start; i < end; i++) {
				poi.dltRow(i);
			}
			// 1y[W̏o̓y[W͈͂߂B
			print = ONE_PAGE;
		}
		if (listSize > CNT_KINTAI_LIST_MAX) {
			print = ONE_PAGE;
		}
		// ͈͂̍Đݒ
		poi.setPrintArea(0, EXTENT_KINTAI_LIST_PRINT + print);
		// wb_[ݒ
		setHeaderName();
		setHeadItem(cnt);
		if (listSize > CNT_KINTAI_LIST_MAX) {
			// f[^
			overListMax = true;
			printNothing();
			return poi;
		}
		int hourPaidHolidayUnit = part().mospcode().getHourPaidHolidayUnit();
		// f[^\
		for (AttendanceManagementDto dto : managementList) {
			simei = dto.getSimei();
			snissu = Double.valueOf(dto.getSNissu());
			kinmuji = Integer.valueOf(dto.getKinmuJi());
			kyukeiji = Integer.valueOf(dto.getKyukeiJi());
			yukyu = Double.valueOf(dto.getYukyu());
			tokukyu = Double.valueOf(dto.getTokuKyu());
			kekkin = Double.valueOf(dto.getKekkin());
			skekkin = Double.valueOf(dto.getSKekkin());
			tisokai = Integer.valueOf(dto.getTiSoKai());
			tijikan = Integer.valueOf(dto.getTiJikan());
			zajikan = Integer.valueOf(dto.getZaJikan());
			ksjikan = Integer.valueOf(dto.getKsJikan());
			snjikan = Integer.valueOf(dto.getSnJikan());
			kaikin = Integer.valueOf(dto.getKaikin());
			syokujikaisu = Integer.valueOf(dto.getSyokujiKaisu());
			cyokukaisu1 = Integer.valueOf(dto.getCyokuKaisu1());
			cyokukaisu2 = Integer.valueOf(dto.getCyokuKaisu2());
			cyokukaisu3 = Integer.valueOf(dto.getCyokuKaisu3());
			hokakaisu1 = Integer.valueOf(dto.getHokaKaisu1());
			hokakaisu2 = Integer.valueOf(dto.getHokaKaisu2());
			hokakaisu3 = Integer.valueOf(dto.getHokaKaisu3());
			hokakaisu4 = Integer.valueOf(dto.getHokaKaisu4());
			hokakaisu5 = Integer.parseInt(dto.getHokaKaisu5());
			if (targetDate.compareTo(MospUtility.getDate(SW_DATE)) >= 0) {
				monthlyOverTime = Integer.valueOf(dto.getMonthlyOverTime());
				monthlyWeekHoliday = Integer.valueOf(dto.getMonthlyWeekHoliday());
				substituteHoliday = Double.valueOf(dto.getSubstituteHoliday());
				daikyu = Double.valueOf(dto.getDaikyu());
				furikae = Double.valueOf(dto.getFurikae());
				riyuu6 = Double.valueOf(dto.getRiyuu6());
				riyuu7 = Double.valueOf(dto.getRiyuu7());
				riyuu8 = Double.valueOf(dto.getRiyuu8());
				riyuu9 = Double.valueOf(dto.getRiyuu9());
			}
			// Αӌꗗf[^擾(xɎԂ̎擾) 
			getAttendanceList(dto.getKCode(), targetDate);
			int totalNijikyu = 0;
			for (MSyukkinboDto syukkinboDto : attendanceList) {
				totalNijikyu += syukkinboDto.getNijiKyu();
			}
			holidayTime = totalNijikyu * hourPaidHolidayUnit;
			// ׈
			printDetail();
			// v
			addTotal();
		}
		if (printcnt > 0) {
			// v
			printTotal();
			printEnding();
		} else {
			// f[^
			printNothing();
		}
		return poi;
	}
	
	/**
	 * Vō쐬\bh
	 * @throws Exception   	Oꍇ
	 */
	private void chkNewPage() throws Exception {
		// I[v
		if (pageno == 0) {
			// PageĐ
			crtNewDoc();
			// ^Cg
			printTitle();
		}
		if (row >= ((pageno - 1) * END_PAGE_L + (LAST_L - gyol))) {
			// I[o[t[͍ŏ̈̎A^Cg
			printTitle();
		}
		// s
		row += gyol;
	}
	
	/**
	 * Vō쐬\bh
	 * @throws Exception   	Oꍇ
	 */
	private void crtNewDoc() throws Exception {
		poi.crtNewDocR(0, file1);
		// ŏIs擾
		endl = poi.getLastRow();
	}
	
	/**
	 * [I
	 * @throws Exception   	Oꍇ
	 */
	private void printEnding() throws Exception {
		// W
		// I̍ŏ̍s
		row = pageno * END_PAGE_L;
		boolean syori = true;
		// cs폜
		for (; row <= endl; row++) {
			if (syori) {
				poi.dltRow(row);
			}
		}
	}
	
	/**
	 * ΑӊǗꗗ쐬
	 * @return SpreadSheetCX^X
	 * @throws Exception    	Oꍇ
	 */
	private SpreadSheet makeSpreadSheet() throws Exception {
		// ev[gt@C
		StringBuffer sb = new StringBuffer();
		sb.append(cfg.getProperty(MospConst.PPT_APP_DOCBASE));
		sb.append(CommonConst.TEMPLATE_M_KINTAIKANRI_ODS);
		int cnt = 0;
		// [쐬
		SpreadSheet ss = SpreadSheet.createFromFile(new File(sb.toString()));
		// V[g
		sheet = ss.getSheet(0);
		if (listSize <= CNT_KINTAI_LIST_MAX) {
			// [o͘g̃Rs[
			cnt = listSize / LEN_EMPLOYEE;
			if (cnt > OUTPUT_ODS_TOTAL_PAGE) {
				cnt = OUTPUT_ODS_TOTAL_PAGE;
			}
			sheet.duplicateRows(0, PAGE_END_ROW, cnt);
			// wb_[ݒ
			setHeaderName();
			setHeadItem(cnt);
			if (listSize == 0) {
				// f[^
				printNothing();
				return ss;
			}
		} else {
			// wb_[ݒ
			setHeaderName();
			setHeadItem(cnt);
			// f[^
			overListMax = true;
			printNothing();
			return ss;
		}
		// l
		pageno = 0;
		// ^Cg
		printTitle();
		// f[^\
		Iterator<AttendanceManagementDto> it = managementList.iterator();
		int count = 0;
		int hourPaidHolidayUnit = part().mospcode().getHourPaidHolidayUnit();
		while (it.hasNext()) {
			AttendanceManagementDto dto = it.next();
			// 
			sheet.getCellAt(CELL_K_NAME, row).setValue(dto.getSimei());
			snissu = Double.valueOf(dto.getSNissu());
			kinmuji = Integer.valueOf(dto.getKinmuJi());
			kyukeiji = Integer.valueOf(dto.getKyukeiJi());
			yukyu = Double.valueOf(dto.getYukyu());
			tokukyu = Double.valueOf(dto.getTokuKyu());
			kekkin = Double.valueOf(dto.getKekkin());
			skekkin = Double.valueOf(dto.getSKekkin());
			tisokai = Integer.valueOf(dto.getTiSoKai());
			tijikan = Integer.valueOf(dto.getTiJikan());
			zajikan = Integer.valueOf(dto.getZaJikan());
			ksjikan = Integer.valueOf(dto.getKsJikan());
			snjikan = Integer.valueOf(dto.getSnJikan());
			kaikin = Integer.valueOf(dto.getKaikin());
			syokujikaisu = Integer.valueOf(dto.getSyokujiKaisu());
			cyokukaisu1 = Integer.valueOf(dto.getCyokuKaisu1());
			cyokukaisu2 = Integer.valueOf(dto.getCyokuKaisu2());
			cyokukaisu3 = Integer.valueOf(dto.getCyokuKaisu3());
			hokakaisu1 = Integer.valueOf(dto.getHokaKaisu1());
			hokakaisu2 = Integer.valueOf(dto.getHokaKaisu2());
			hokakaisu3 = Integer.valueOf(dto.getHokaKaisu3());
			hokakaisu4 = Integer.valueOf(dto.getHokaKaisu4());
			hokakaisu5 = Integer.parseInt(dto.getHokaKaisu5());
			if (targetDate.compareTo(MospUtility.getDate(SW_DATE)) >= 0) {
				monthlyOverTime = Integer.valueOf(dto.getMonthlyOverTime());
				monthlyWeekHoliday = Integer.valueOf(dto.getMonthlyWeekHoliday());
				substituteHoliday = Double.valueOf(dto.getSubstituteHoliday());
				daikyu = Double.valueOf(dto.getDaikyu());
				furikae = Double.valueOf(dto.getFurikae());
				riyuu6 = Double.valueOf(dto.getRiyuu6());
				riyuu7 = Double.valueOf(dto.getRiyuu7());
				riyuu8 = Double.valueOf(dto.getRiyuu8());
				riyuu9 = Double.valueOf(dto.getRiyuu9());
			}
			// Αӌꗗf[^擾(xɎԂ̎擾) 
			int totalNijikyu = 0;
			getAttendanceList(dto.getKCode(), targetDate);
			for (MSyukkinboDto syukkinboDto : attendanceList) {
				totalNijikyu = totalNijikyu + syukkinboDto.getNijiKyu();
			}
			holidayTime = totalNijikyu * hourPaidHolidayUnit;
			// ڍ׈
			printDetail();
			// v
			addTotal();
			// ̐l
			row += 2;
			count++;
			// Ō̈l
			if (!it.hasNext()) {
				// vsֈړ
				row = pageno * PAGE_END_ROW + TOTAL_ROW;
				// v
				printTotal();
			}
			if (count == LEN_EMPLOYEE) {
				// 
				count = 0;
				// y[W֑J
				addPageNo();
			}
		}
		return ss;
	}
	
	/**
	 * y[Wֈړ
	 * @throws Exception  	Oꍇ
	 */
	private void addPageNo() throws Exception {
		// y[WZ
		pageno++;
		// y[W̐擪sֈړ
		row = pageno * PAGE_END_ROW;
		// ^Cgݒ
		printTitle();
	}
	
	/**
	 * wb_ږ̎擾\bh
	 * @throws Exception   	Oꍇ
	 */
	private void setHeaderName() throws Exception {
		NAM_PAID_HOLIDAY = getTChangeOrTName(CommonConst.TID_LEAVE_REASON, CommonConst.CODE_HOLIDAY_REASON_PAID, 4);
		NAM_PARTICULAR_HOLIDAY = getTChangeOrTName(CommonConst.TID_LEAVE_REASON,
				CommonConst.CODE_HOLIDAY_REASON_PARTICULAR, 4);
		NAM_ABSENCE = getTChangeOrTName(CommonConst.TID_LEAVE_REASON, CommonConst.CODE_HOLIDAY_REASON_ABSENCE, 2);
		NAM_MEDICAL = getTChangeOrTName(CommonConst.TID_LEAVE_REASON, CommonConst.CODE_HOLIDAY_REASON_MEDICAL, 4);
		NAM_HOLIDAY_REASON_5 = getTChangeOrTName(CommonConst.TID_LEAVE_REASON,
				CommonConst.CODE_HOLIDAY_REASON_COMPENSATION, 2);
		NAM_HOLIDAY_REASON_6 = getTChangeOrTName(CommonConst.TID_LEAVE_REASON,
				CommonConst.CODE_HOLIDAY_REASON_TRANSFER, 2);
		NAM_HOLIDAY_REASON_7 = getTChangeOrTName(CommonConst.TID_LEAVE_REASON, CommonConst.CODE_HOLIDAY_REASON_6, 4);
		NAM_HOLIDAY_REASON_8 = getTChangeOrTName(CommonConst.TID_LEAVE_REASON, CommonConst.CODE_HOLIDAY_REASON_7, 4);
		NAM_HOLIDAY_REASON_9 = getTChangeOrTName(CommonConst.TID_LEAVE_REASON, CommonConst.CODE_HOLIDAY_REASON_8, 4);
		NAM_HOLIDAY_REASON_10 = getTChangeOrTName(CommonConst.TID_LEAVE_REASON, CommonConst.CODE_HOLIDAY_REASON_9, 3);
		//NAM_KAIKIN = getTChangeOrTName(CommonConst.TID_ALLOWANCE_NAME, CommonConst.CODE_KAIKIN, 0);
		NAM_SYOKUJI = getTChangeOrTName(CommonConst.TID_ALLOWANCE_NAME, CommonConst.CODE_SHOKUJI, 0);
		NAM_CYOKU1 = getTChangeOrTName(CommonConst.TID_ALLOWANCE_NAME, CommonConst.CODE_CHOKU1, 0);
		NAM_CYOKU2 = getTChangeOrTName(CommonConst.TID_ALLOWANCE_NAME, CommonConst.CODE_CHOKU2, 0);
		NAM_CYOKU3 = getTChangeOrTName(CommonConst.TID_ALLOWANCE_NAME, CommonConst.CODE_CHOKU3, 0);
		NAM_HOKAK1 = getTChangeOrTName(CommonConst.TID_ALLOWANCE_NAME, CommonConst.CODE_SONOTA1, 0);
		NAM_HOKAK2 = getTChangeOrTName(CommonConst.TID_ALLOWANCE_NAME, CommonConst.CODE_SONOTA2, 0);
		NAM_HOKAK3 = getTChangeOrTName(CommonConst.TID_ALLOWANCE_NAME, CommonConst.CODE_SONOTA3, 0);
		NAM_HOKAK4 = getTChangeOrTName(CommonConst.TID_ALLOWANCE_NAME, CommonConst.CODE_SONOTA4, 0);
		NAM_HOKAK5 = getTChangeOrTName(CommonConst.TID_ALLOWANCE_NAME, CommonConst.CODE_SONOTA5, 0);
	}
	
	/**
	 * ^Cg\bh
	 * @throws Exception   	Oꍇ
	 */
	private void printTitle() throws Exception {
		String targetYear = String.valueOf(MospUtility.getYear(targetDate));
		String targetMonth = String.valueOf(MospUtility.getMonth(targetDate));
		if (VariousUtil.isNotNull(poi)) {
			// y[W
			pageno++;
			//^CgʒuZo
			row = (pageno - 1) * END_PAGE_L + (titlel - 1);
			//^Cg,t
			row++;
			// N
			poi.prtItem(row, CELL_YEAR, targetYear);
			poi.prtItem(row, CELL_MONTH, targetMonth);
			// 
			poi.prtItem(row, CELL_SECTION, sectionName);
			// ׈ʒuZo
			row = (pageno - 1) * END_PAGE_L + (firstl - 1 - gyol);
		}
		if (VariousUtil.isNotNull(sheet)) {
			row = pageno * PAGE_END_ROW + TITLE_ROW;
			// N
			sheet.getCellAt(CELL_YEAR, row).setValue(targetYear);
			sheet.getCellAt(CELL_MONTH, row).setValue(targetMonth);
			// 
			sheet.getCellAt(CELL_SECTION, row).setValue(sectionName);
			// ׍sֈړ
			row = pageno * PAGE_END_ROW + DETAIL_ROW;
		}
	}
	
	/**
	 * ږݒ(XLSAODS)
	 * @param  cnt o̓y[W
	 * @throws Exception   	Oꍇ
	 */
	private void setHeadItem(int cnt) throws Exception {
		String setItemFlg = "";
		int rowUpper = 0;
		int rowLower = 0;
		if (cnt == 0) {
			rowUpper = HEADER_UPPER;
			rowLower = HEADER_LOWER;
			setItem(rowUpper, rowLower);
		} else {
			for (int i = 0; i <= cnt; i++) {
				if (setItemFlg.equals("")) {
					rowUpper = HEADER_UPPER;
					rowLower = HEADER_LOWER;
					setItem(rowUpper, rowLower);
					setItemFlg = "1";
				} else {
					rowUpper = rowUpper + HEADER_ADD_ROW;
					rowLower = rowLower + HEADER_ADD_ROW;
					setItem(rowUpper, rowLower);
				}
			}
		}
	}
	
	/**
	 * ږݒ菈
	 * @param  rowUpper ݒs(i)
	 * @param  rowLower ݒs(i)
	 * @throws Exception   	Oꍇ
	 */
	private void setItem(int rowUpper, int rowLower) throws Exception {
		// ږݒ(XLS)
		if (VariousUtil.isNotNull(poi)) {
			// iݒ
			poi.prtItem(rowUpper, CC[5], NAM_SYOKUJI);
			poi.prtItem(rowUpper, CC[6], NAM_CYOKU2);
			poi.prtItem(rowUpper, CC[7], NAM_HOKAK1);
			poi.prtItem(rowUpper, CC[8], NAM_HOKAK3);
			poi.prtItem(rowUpper, CC[9], NAM_HOKAK5);
			poi.prtItem(rowUpper, CC[11], NAM_PAID_HOLIDAY);
			poi.prtItem(rowUpper, CC[12], NAM_PARTICULAR_HOLIDAY);
			poi.prtItem(rowUpper, CC[13], NAM_HOLIDAY_REASON_5);
			poi.prtItem(rowUpper, CC[14], NAM_HOLIDAY_REASON_7);
			poi.prtItem(rowUpper, CC[15], NAM_HOLIDAY_REASON_9);
			// iݒ
			poi.prtItem(rowLower, CC[5], NAM_CYOKU1);
			poi.prtItem(rowLower, CC[6], NAM_CYOKU3);
			poi.prtItem(rowLower, CC[7], NAM_HOKAK2);
			poi.prtItem(rowLower, CC[8], NAM_HOKAK4);
			poi.prtItem(rowLower, CC[11], NAM_ABSENCE);
			poi.prtItem(rowLower, CC[12], NAM_MEDICAL);
			poi.prtItem(rowLower, CC[13], NAM_HOLIDAY_REASON_6);
			poi.prtItem(rowLower, CC[14], NAM_HOLIDAY_REASON_8);
			poi.prtItem(rowLower, CC[15], NAM_HOLIDAY_REASON_10);
		}
		// ږݒ(ODS)
		if (VariousUtil.isNotNull(sheet)) {
			// iݒ
			sheet.getCellAt(CC[5], rowUpper).setValue(NAM_SYOKUJI);
			sheet.getCellAt(CC[6], rowUpper).setValue(NAM_CYOKU2);
			sheet.getCellAt(CC[7], rowUpper).setValue(NAM_HOKAK1);
			sheet.getCellAt(CC[8], rowUpper).setValue(NAM_HOKAK3);
			sheet.getCellAt(CC[9], rowUpper).setValue(NAM_HOKAK5);
			sheet.getCellAt(CC[11], rowUpper).setValue(NAM_PAID_HOLIDAY);
			sheet.getCellAt(CC[12], rowUpper).setValue(NAM_PARTICULAR_HOLIDAY);
			sheet.getCellAt(CC[13], rowUpper).setValue(NAM_HOLIDAY_REASON_5);
			sheet.getCellAt(CC[14], rowUpper).setValue(NAM_HOLIDAY_REASON_7);
			sheet.getCellAt(CC[15], rowUpper).setValue(NAM_HOLIDAY_REASON_9);
			// iݒ
			sheet.getCellAt(CC[5], rowLower).setValue(NAM_CYOKU1);
			sheet.getCellAt(CC[6], rowLower).setValue(NAM_CYOKU3);
			sheet.getCellAt(CC[7], rowLower).setValue(NAM_HOKAK2);
			sheet.getCellAt(CC[8], rowLower).setValue(NAM_HOKAK4);
			sheet.getCellAt(CC[11], rowLower).setValue(NAM_ABSENCE);
			sheet.getCellAt(CC[12], rowLower).setValue(NAM_MEDICAL);
			sheet.getCellAt(CC[13], rowLower).setValue(NAM_HOLIDAY_REASON_6);
			sheet.getCellAt(CC[14], rowLower).setValue(NAM_HOLIDAY_REASON_8);
			sheet.getCellAt(CC[15], rowLower).setValue(NAM_HOLIDAY_REASON_10);
		}
	}
	
	/**
	 * ׈
	 * @throws Exception   	Oꍇ
	 */
	private void printDetail() throws Exception {
		if (VariousUtil.isNotNull(poi)) {
			// ŊmF
			chkNewPage();
			// 
			poi.prtItem(row, CELL_K_NAME, simei);
			// i
			poi.prtItem(row, CC[0], getZeroControl(String.valueOf(snissu)));
			poi.prtItem(row, CC[1], getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(kinmuji))));
			poi.prtItem(row, CC[2], getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(zajikan))));
			poi.prtItem(row, CC[3], getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(snjikan))));
			poi.prtItem(row, CC[4], getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(tijikan))));
			poi.prtItem(row, CC[5], getZeroControl(String.valueOf(syokujikaisu)));
			poi.prtItem(row, CC[6], getZeroControl(String.valueOf(cyokukaisu2)));
			poi.prtItem(row, CC[7], getZeroControl(String.valueOf(hokakaisu1)));
			poi.prtItem(row, CC[8], getZeroControl(String.valueOf(hokakaisu3)));
			poi.prtItem(row, CC[9], getZeroControl(String.valueOf(hokakaisu5)));
			poi.prtItem(row, CC[10], getZeroControl(String.valueOf(holidayTime)));
			poi.prtItem(row, CC[11], getZeroControl(String.valueOf(yukyu)));
			poi.prtItem(row, CC[12], getZeroControl(String.valueOf(tokukyu)));
			poi.prtItem(row, CC[13], getZeroControl(String.valueOf(daikyu)));
			poi.prtItem(row, CC[14], getZeroControl(String.valueOf(riyuu6)));
			poi.prtItem(row, CC[15], getZeroControl(String.valueOf(riyuu8)));
			// i
			poi.prtItem(row + 1, CC[0], "");
			poi.prtItem(row + 1, CC[1], getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(kyukeiji))));
			poi.prtItem(row + 1, CC[2], getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(ksjikan))));
			poi.prtItem(row + 1, CC[3], getZeroControl(getHourString(TimeUtil
				.convIntegerTimeToDoubleTime(monthlyOverTime + monthlyWeekHoliday))));
			poi.prtItem(row + 1, CC[4], getZeroControl(String.valueOf(tisokai)));
			poi.prtItem(row + 1, CC[5], getZeroControl(String.valueOf(cyokukaisu1)));
			poi.prtItem(row + 1, CC[6], getZeroControl(String.valueOf(cyokukaisu3)));
			poi.prtItem(row + 1, CC[7], getZeroControl(String.valueOf(hokakaisu2)));
			poi.prtItem(row + 1, CC[8], getZeroControl(String.valueOf(hokakaisu4)));
			poi.prtItem(row + 1, CC[9], getZeroControl(String.valueOf(kaikin)));
			poi.prtItem(row + 1, CC[10], getZeroControl(String.valueOf(substituteHoliday)));
			poi.prtItem(row + 1, CC[11], getZeroControl(String.valueOf(kekkin)));
			poi.prtItem(row + 1, CC[12], getZeroControl(String.valueOf(skekkin)));
			poi.prtItem(row + 1, CC[13], getZeroControl(String.valueOf(furikae)));
			poi.prtItem(row + 1, CC[14], getZeroControl(String.valueOf(riyuu7)));
			poi.prtItem(row + 1, CC[15], getZeroControl(String.valueOf(riyuu9)));
			// ׈
			printcnt++;
		}
		if (VariousUtil.isNotNull(sheet)) {
			// i
			int upper = row;
			sheet.getCellAt(CC[0], upper).setValue(getZeroControl(String.valueOf(snissu)));
			sheet.getCellAt(CC[1], upper).setValue(
					getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(kinmuji))));
			sheet.getCellAt(CC[2], upper).setValue(
					getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(zajikan))));
			sheet.getCellAt(CC[3], upper).setValue(
					getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(snjikan))));
			sheet.getCellAt(CC[4], upper).setValue(
					getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(tijikan))));
			sheet.getCellAt(CC[5], upper).setValue(getZeroControl(String.valueOf(syokujikaisu)));
			sheet.getCellAt(CC[6], upper).setValue(getZeroControl(String.valueOf(cyokukaisu2)));
			sheet.getCellAt(CC[7], upper).setValue(getZeroControl(String.valueOf(hokakaisu1)));
			sheet.getCellAt(CC[8], upper).setValue(getZeroControl(String.valueOf(hokakaisu3)));
			sheet.getCellAt(CC[9], upper).setValue(getZeroControl(String.valueOf(hokakaisu5)));
			sheet.getCellAt(CC[10], upper).setValue(getZeroControl(String.valueOf(holidayTime)));
			sheet.getCellAt(CC[11], upper).setValue(getZeroControl(String.valueOf(yukyu)));
			sheet.getCellAt(CC[12], upper).setValue(getZeroControl(String.valueOf(tokukyu)));
			sheet.getCellAt(CC[13], upper).setValue(getZeroControl(String.valueOf(daikyu)));
			sheet.getCellAt(CC[14], upper).setValue(getZeroControl(String.valueOf(riyuu6)));
			sheet.getCellAt(CC[15], upper).setValue(getZeroControl(String.valueOf(riyuu8)));
			// i
			int lower = row + 1;
			sheet.getCellAt(CC[0], lower).setValue("");
			sheet.getCellAt(CC[1], lower).setValue(
					getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(kyukeiji))));
			sheet.getCellAt(CC[2], lower).setValue(
					getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(ksjikan))));
			sheet.getCellAt(CC[3], lower).setValue(
					getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(monthlyOverTime
							+ monthlyWeekHoliday))));
			sheet.getCellAt(CC[4], lower).setValue(getZeroControl(String.valueOf(tisokai)));
			sheet.getCellAt(CC[5], lower).setValue(getZeroControl(String.valueOf(cyokukaisu1)));
			sheet.getCellAt(CC[6], lower).setValue(getZeroControl(String.valueOf(cyokukaisu3)));
			sheet.getCellAt(CC[7], lower).setValue(getZeroControl(String.valueOf(hokakaisu2)));
			sheet.getCellAt(CC[8], lower).setValue(getZeroControl(String.valueOf(hokakaisu4)));
			sheet.getCellAt(CC[9], lower).setValue(getZeroControl(String.valueOf(kaikin)));
			sheet.getCellAt(CC[10], lower).setValue(getZeroControl(String.valueOf(substituteHoliday)));
			sheet.getCellAt(CC[11], lower).setValue(getZeroControl(String.valueOf(kekkin)));
			sheet.getCellAt(CC[12], lower).setValue(getZeroControl(String.valueOf(skekkin)));
			sheet.getCellAt(CC[13], lower).setValue(getZeroControl(String.valueOf(furikae)));
			sheet.getCellAt(CC[14], lower).setValue(getZeroControl(String.valueOf(riyuu7)));
			sheet.getCellAt(CC[15], lower).setValue(getZeroControl(String.valueOf(riyuu9)));
		}
	}
	
	/**
	 * vʒuZo
	 * @throws Exception   	Oꍇ
	 */
	private void printTotal() throws Exception {
		if (VariousUtil.isNotNull(poi)) {
			row = (pageno - 1) * END_PAGE_L + (TOTAL_L - 1);
			// i
			poi.prtItem(row, CC[0], getZeroControl(String.valueOf(totalSNissu)));
			poi.prtItem(row, CC[1], getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalKinmuJi))));
			poi.prtItem(row, CC[2], getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalZaJikan))));
			poi.prtItem(row, CC[3], getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalSnJikan))));
			poi.prtItem(row, CC[4], getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalTiJikan))));
			poi.prtItem(row, CC[5], getZeroControl(String.valueOf(totalSyokujiKaisu)));
			poi.prtItem(row, CC[6], getZeroControl(String.valueOf(totalCyokuKaisu2)));
			poi.prtItem(row, CC[7], getZeroControl(String.valueOf(totalHokaKaisu1)));
			poi.prtItem(row, CC[8], getZeroControl(String.valueOf(totalHokaKaisu3)));
			poi.prtItem(row, CC[9], getZeroControl(String.valueOf(totalHokaKaisu5)));
			poi.prtItem(row, CC[10], getZeroControl(String.valueOf(totalHolidayTime)));
			poi.prtItem(row, CC[11], getZeroControl(String.valueOf(totalYukyu)));
			poi.prtItem(row, CC[12], getZeroControl(String.valueOf(totalTokukyu)));
			poi.prtItem(row, CC[13], getZeroControl(String.valueOf(totalDaikyu)));
			poi.prtItem(row, CC[14], getZeroControl(String.valueOf(totalRiyuu6)));
			poi.prtItem(row, CC[15], getZeroControl(String.valueOf(totalRiyuu8)));
			// i
			poi.prtItem(row + 1, CC[0], "");
			poi.prtItem(row + 1, CC[1], getZeroControl(getHourString(TimeUtil
				.convIntegerTimeToDoubleTime(totalKyukeiJi))));
			poi.prtItem(row + 1, CC[2],
					getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalKsJikan))));
			poi.prtItem(row + 1, CC[3], getZeroControl(getHourString(TimeUtil
				.convIntegerTimeToDoubleTime(totalMonthlyOverTime + totalMonthlyWeekHoliday))));
			poi.prtItem(row + 1, CC[4], getZeroControl(String.valueOf(totalTisoKai)));
			poi.prtItem(row + 1, CC[5], getZeroControl(String.valueOf(totalCyokuKaisu1)));
			poi.prtItem(row + 1, CC[6], getZeroControl(String.valueOf(totalCyokuKaisu3)));
			poi.prtItem(row + 1, CC[7], getZeroControl(String.valueOf(totalHokaKaisu2)));
			poi.prtItem(row + 1, CC[8], getZeroControl(String.valueOf(totalHokaKaisu4)));
			poi.prtItem(row + 1, CC[9], getZeroControl(String.valueOf(totalKaikin)));
			poi.prtItem(row + 1, CC[10], getZeroControl(String.valueOf(totalSubstituteHoliday)));
			poi.prtItem(row + 1, CC[11], getZeroControl(String.valueOf(totalKekkin)));
			poi.prtItem(row + 1, CC[12], getZeroControl(String.valueOf(totalSKekkin)));
			poi.prtItem(row + 1, CC[13], getZeroControl(String.valueOf(totalFurikae)));
			poi.prtItem(row + 1, CC[14], getZeroControl(String.valueOf(totalRiyuu7)));
			poi.prtItem(row + 1, CC[15], getZeroControl(String.valueOf(totalRiyuu9)));
			// ׈
			printcnt++;
		}
		if (VariousUtil.isNotNull(sheet)) {
			// i
			int upper = row;
			sheet.getCellAt(CC[0], upper).setValue(getZeroControl(String.valueOf(totalSNissu)));
			sheet.getCellAt(CC[1], upper).setValue(
					getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalKinmuJi))));
			sheet.getCellAt(CC[2], upper).setValue(
					getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalZaJikan))));
			sheet.getCellAt(CC[3], upper).setValue(
					getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalSnJikan))));
			sheet.getCellAt(CC[4], upper).setValue(
					getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalTiJikan))));
			sheet.getCellAt(CC[5], upper).setValue(getZeroControl(String.valueOf(totalSyokujiKaisu)));
			sheet.getCellAt(CC[6], upper).setValue(getZeroControl(String.valueOf(totalCyokuKaisu2)));
			sheet.getCellAt(CC[7], upper).setValue(getZeroControl(String.valueOf(totalHokaKaisu1)));
			sheet.getCellAt(CC[8], upper).setValue(getZeroControl(String.valueOf(totalHokaKaisu3)));
			sheet.getCellAt(CC[9], upper).setValue(getZeroControl(String.valueOf(totalHokaKaisu5)));
			sheet.getCellAt(CC[10], upper).setValue(getZeroControl(String.valueOf(totalHolidayTime)));
			sheet.getCellAt(CC[11], upper).setValue(getZeroControl(String.valueOf(totalYukyu)));
			sheet.getCellAt(CC[12], upper).setValue(getZeroControl(String.valueOf(totalTokukyu)));
			sheet.getCellAt(CC[13], upper).setValue(getZeroControl(String.valueOf(totalDaikyu)));
			sheet.getCellAt(CC[14], upper).setValue(getZeroControl(String.valueOf(totalRiyuu6)));
			sheet.getCellAt(CC[15], upper).setValue(getZeroControl(String.valueOf(totalRiyuu8)));
			// i
			int lower = row + 1;
			sheet.getCellAt(CC[0], lower).setValue("");
			sheet.getCellAt(CC[1], lower).setValue(
					getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalKyukeiJi))));
			sheet.getCellAt(CC[2], lower).setValue(
					getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalKsJikan))));
			sheet.getCellAt(CC[3], lower).setValue(
					getZeroControl(getHourString(TimeUtil.convIntegerTimeToDoubleTime(totalMonthlyOverTime
							+ totalMonthlyWeekHoliday))));
			sheet.getCellAt(CC[4], lower).setValue(getZeroControl(String.valueOf(totalTisoKai)));
			sheet.getCellAt(CC[5], lower).setValue(getZeroControl(String.valueOf(totalCyokuKaisu1)));
			sheet.getCellAt(CC[6], lower).setValue(getZeroControl(String.valueOf(totalCyokuKaisu3)));
			sheet.getCellAt(CC[7], lower).setValue(getZeroControl(String.valueOf(totalHokaKaisu2)));
			sheet.getCellAt(CC[8], lower).setValue(getZeroControl(String.valueOf(totalHokaKaisu4)));
			sheet.getCellAt(CC[9], lower).setValue(getZeroControl(String.valueOf(totalKaikin)));
			sheet.getCellAt(CC[10], lower).setValue(getZeroControl(String.valueOf(totalSubstituteHoliday)));
			sheet.getCellAt(CC[11], lower).setValue(getZeroControl(String.valueOf(totalKekkin)));
			sheet.getCellAt(CC[12], lower).setValue(getZeroControl(String.valueOf(totalSKekkin)));
			sheet.getCellAt(CC[13], lower).setValue(getZeroControl(String.valueOf(totalFurikae)));
			sheet.getCellAt(CC[14], lower).setValue(getZeroControl(String.valueOf(totalRiyuu7)));
			sheet.getCellAt(CC[15], lower).setValue(getZeroControl(String.valueOf(totalRiyuu9)));
		}
	}
	
	/**
	 * f[^\bh
	 * @throws Exception   	Oꍇ
	 */
	private void printNothing() throws Exception {
		// ŊmF
		if (VariousUtil.isNotNull(poi)) {
			chkNewPage();
			if (overListMax) {
				poi.prtItem(7, 1, CNT_KINTAI_LIST_MAX + CommonConst.MSG_KINTAI_LIST_SIZE_OVER);
			} else {
				poi.prtItem(7, 1, CommonConst.MSG_ATTENDANCE_REPORT_NO_DATA);
			}
		}
		if (VariousUtil.isNotNull(sheet)) {
			if (overListMax) {
				sheet.getCellAt(1, 7).setValue(CNT_KINTAI_LIST_MAX + CommonConst.MSG_KINTAI_LIST_SIZE_OVER);
			} else {
				sheet.getCellAt(1, 7).setValue(CommonConst.MSG_ATTENDANCE_REPORT_NO_DATA);
			}
		}
	}
	
	/**
	 * v
	 */
	private void addTotal() {
		totalSNissu += snissu;
		totalKinmuJi += kinmuji;
		totalKyukeiJi += kyukeiji;
		totalHolidayTime += holidayTime;
		totalYukyu += yukyu;
		totalTokukyu += tokukyu;
		totalKekkin += kekkin;
		totalSKekkin += skekkin;
		totalTisoKai += tisokai;
		totalTiJikan += tijikan;
		totalZaJikan += zajikan;
		totalKsJikan += ksjikan;
		totalSnJikan += snjikan;
		totalKaikin += kaikin;
		totalSyokujiKaisu += syokujikaisu;
		totalCyokuKaisu1 += cyokukaisu1;
		totalCyokuKaisu2 += cyokukaisu2;
		totalCyokuKaisu3 += cyokukaisu3;
		totalHokaKaisu1 += hokakaisu1;
		totalHokaKaisu2 += hokakaisu2;
		totalHokaKaisu3 += hokakaisu3;
		totalHokaKaisu4 += hokakaisu4;
		totalHokaKaisu5 += hokakaisu5;
		totalMonthlyOverTime += monthlyOverTime;
		totalMonthlyWeekHoliday += monthlyWeekHoliday;
		totalSubstituteHoliday += substituteHoliday;
		totalDaikyu += daikyu;
		totalFurikae += furikae;
		totalRiyuu6 += riyuu6;
		totalRiyuu7 += riyuu7;
		totalRiyuu8 += riyuu8;
		totalRiyuu9 += riyuu9;
	}
	
	/**
	 * [0\
	 * @param pmValue Ώە
	 * @return 㕶
	 */
	private String getZeroControl(String pmValue) {
		String retValue = "";
		if (pmValue.equals("0") || pmValue.equals("0.0") || pmValue.equals("0.00")) {
			if (StringUtil.isNotNull(cfg.getProperty(CommonConst.PPT_KINTAI_ZERO_CTRL))) {
				retValue = pmValue;
			} else {
				retValue = "";
			}
		} else {
			retValue = pmValue;
		}
		return retValue;
	}
	
}
