/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.dto;

import jp.mosp.common.common.BaseDto;

/**
 * M_KINTAIKINMU(ΑӋΖʏWv)DTONXB
 */
public class MKintaiKinmuDto extends BaseDto {
	
	private static final long	serialVersionUID	= 3115468966868261668L;
	
	// tB[h
	private String				kcode				= "";					//ЈR[h
	private String				sikyuym				= "";					//xN
	private String				kinmu				= "";					//Ζ`
	private double				snissu				= 0;					//oΓ
	private int					zajikan				= 0;					//ʎcƎ
	private int					szjikan				= 0;					//[cƎ
	private int					hsjikan				= 0;					//@xoΎ
	private int					tsjikan				= 0;					//ʏoΎ
	private int					syokuji				= 0;					//H蓖x
	private int					cyoku1				= 0;					//1蓖x
	private int					cyoku2				= 0;					//2蓖x
	private int					cyoku3				= 0;					//3蓖x
	private int					hoka1				= 0;					//̑x1
	private int					hoka2				= 0;					//̑x2
	private int					hoka3				= 0;					//̑x3
	private int					hoka4				= 0;					//̑x4
	private int					hoka5				= 0;					//̑x5
																			
	
	/**
	 * RXgN^
	 */
	public MKintaiKinmuDto() {
		super();
	}
	
	// ANZT\bh
	/**
	 * @return kcode 	ЈR[hB
	 */
	public String getKCode() {
		return kcode;
	}
	
	/**
	 * @return sikyuym 	xNB
	 */
	public String getSikyuYM() {
		return sikyuym;
	}
	
	/**
	 * @return kinmu 	Ζ`ԁB
	 */
	public String getKinmu() {
		return kinmu;
	}
	
	/**
	 * @return snissu 	oΓB
	 */
	public double getSNissu() {
		return snissu;
	}
	
	/**
	 * @return zajikan 	ʎcƎԁB
	 */
	public int getZaJikan() {
		return zajikan;
	}
	
	/**
	 * @return szjikan 	[cƎԁB
	 */
	public int getSZJikan() {
		return szjikan;
	}
	
	/**
	 * @return hsjikan 	@xoΎԁB
	 */
	public int getHSJikan() {
		return hsjikan;
	}
	
	/**
	 * @return tsjikan 	ʏoΎԁB
	 */
	public int getTSJikan() {
		return tsjikan;
	}
	
	/**
	 * @return syokuji 	H蓖xB
	 */
	public int getSyokuji() {
		return syokuji;
	}
	
	/**
	 * @return cyoku1 	1蓖xB
	 */
	public int getCyoku1() {
		return cyoku1;
	}
	
	/**
	 * @return cyoku2 	2蓖xB
	 */
	public int getCyoku2() {
		return cyoku2;
	}
	
	/**
	 * @return cyoku3 	3蓖xB
	 */
	public int getCyoku3() {
		return cyoku3;
	}
	
	/**
	 * @return hoka1 	̑x1B
	 */
	public int getHoka1() {
		return hoka1;
	}
	
	/**
	 * @return hoka2 	̑x2B
	 */
	public int getHoka2() {
		return hoka2;
	}
	
	/**
	 * @return hoka3 	̑x3B
	 */
	public int getHoka3() {
		return hoka3;
	}
	
	/**
	 * @return hoka4 	̑x4B
	 */
	public int getHoka4() {
		return hoka4;
	}
	
	/**
	 * @return hoka5 	̑x5B
	 */
	public int getHoka5() {
		return hoka5;
	}
	
	/**
	 * @param kcode 	ZbgЈR[hB
	 */
	public void setKCode(String kcode) {
		this.kcode = kcode;
	}
	
	/**
	 * @param sikyuym 	ZbgxNB
	 */
	public void setSikyuYM(String sikyuym) {
		this.sikyuym = sikyuym;
	}
	
	/**
	 * @param kinmu 	ZbgΖ`ԁB
	 */
	public void setKinmu(String kinmu) {
		this.kinmu = kinmu;
	}
	
	/**
	 * @param snissu 	ZbgoΓB
	 */
	public void setSNissu(double snissu) {
		this.snissu = snissu;
	}
	
	/**
	 * @param zajikan 	Zbg镁ʎcƎԁB
	 */
	public void setZaJikan(int zajikan) {
		this.zajikan = zajikan;
	}
	
	/**
	 * @param szjikan 	Zbg[cƎԁB
	 */
	public void setSZJikan(int szjikan) {
		this.szjikan = szjikan;
	}
	
	/**
	 * @param hsjikan 	Zbg@xoΎԁB
	 */
	public void setHSJikan(int hsjikan) {
		this.hsjikan = hsjikan;
	}
	
	/**
	 * @param tsjikan 	ZbgʏoΎԁB
	 */
	public void setTSJikan(int tsjikan) {
		this.tsjikan = tsjikan;
	}
	
	/**
	 * @param syokuji 	ZbgH蓖xB
	 */
	public void setSyokuji(int syokuji) {
		this.syokuji = syokuji;
	}
	
	/**
	 * @param cyoku1 	Zbg1蓖xB
	 */
	public void setCyoku1(int cyoku1) {
		this.cyoku1 = cyoku1;
	}
	
	/**
	 * @param cyoku2 	Zbg2蓖xB
	 */
	public void setCyoku2(int cyoku2) {
		this.cyoku2 = cyoku2;
	}
	
	/**
	 * @param cyoku3 	Zbg3蓖xB
	 */
	public void setCyoku3(int cyoku3) {
		this.cyoku3 = cyoku3;
	}
	
	/**
	 * @param hoka1 	Zbg邻̑x1B
	 */
	public void setHoka1(int hoka1) {
		this.hoka1 = hoka1;
	}
	
	/**
	 * @param hoka2 	Zbg邻̑x2B
	 */
	public void setHoka2(int hoka2) {
		this.hoka2 = hoka2;
	}
	
	/**
	 * @param hoka3 	Zbg邻̑x3B
	 */
	public void setHoka3(int hoka3) {
		this.hoka3 = hoka3;
	}
	
	/**
	 * @param hoka4 	Zbg邻̑x4B
	 */
	public void setHoka4(int hoka4) {
		this.hoka4 = hoka4;
	}
	
	/**
	 * @param hoka5 	Zbg邻̑x5B
	 */
	public void setHoka5(int hoka5) {
		this.hoka5 = hoka5;
	}
	
}
